/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.python.google.common.base.Preconditions;

@GwtCompatible
public final class Objects {
    private Objects() {
    }

    public static boolean equal(@Nullable Object a, @Nullable Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static ToStringHelper toStringHelper(Object self) {
        return new ToStringHelper(Objects.simpleName(self.getClass()));
    }

    public static ToStringHelper toStringHelper(Class<?> clazz) {
        return new ToStringHelper(Objects.simpleName(clazz));
    }

    public static ToStringHelper toStringHelper(String className) {
        return new ToStringHelper(className);
    }

    private static String simpleName(Class<?> clazz) {
        String name = clazz.getName();
        int start = (name = name.replaceAll("\\$[0-9]+", "\\$")).lastIndexOf(36);
        if (start == -1) {
            start = name.lastIndexOf(46);
        }
        return name.substring(start + 1);
    }

    public static <T> T firstNonNull(@Nullable T first, @Nullable T second) {
        return first != null ? first : Preconditions.checkNotNull(second);
    }

    public static final class ToStringHelper {
        private final String className;
        private final List<ValueHolder> valueHolders = new LinkedList<ValueHolder>();
        private boolean omitNullValues = false;

        private ToStringHelper(String className) {
            this.className = Preconditions.checkNotNull(className);
        }

        @Beta
        public ToStringHelper omitNullValues() {
            this.omitNullValues = true;
            return this;
        }

        public ToStringHelper add(String name, @Nullable Object value) {
            Preconditions.checkNotNull(name);
            this.addHolder((Object)value).builder.append(name).append('=').append(value);
            return this;
        }

        public ToStringHelper add(String name, boolean value) {
            this.checkNameAndAppend(name).append(value);
            return this;
        }

        public ToStringHelper add(String name, char value) {
            this.checkNameAndAppend(name).append(value);
            return this;
        }

        public ToStringHelper add(String name, double value) {
            this.checkNameAndAppend(name).append(value);
            return this;
        }

        public ToStringHelper add(String name, float value) {
            this.checkNameAndAppend(name).append(value);
            return this;
        }

        public ToStringHelper add(String name, int value) {
            this.checkNameAndAppend(name).append(value);
            return this;
        }

        public ToStringHelper add(String name, long value) {
            this.checkNameAndAppend(name).append(value);
            return this;
        }

        private StringBuilder checkNameAndAppend(String name) {
            Preconditions.checkNotNull(name);
            return this.addHolder().builder.append(name).append('=');
        }

        public ToStringHelper addValue(@Nullable Object value) {
            this.addHolder((Object)value).builder.append(value);
            return this;
        }

        public ToStringHelper addValue(boolean value) {
            this.addHolder().builder.append(value);
            return this;
        }

        public ToStringHelper addValue(char value) {
            this.addHolder().builder.append(value);
            return this;
        }

        public ToStringHelper addValue(double value) {
            this.addHolder().builder.append(value);
            return this;
        }

        public ToStringHelper addValue(float value) {
            this.addHolder().builder.append(value);
            return this;
        }

        public ToStringHelper addValue(int value) {
            this.addHolder().builder.append(value);
            return this;
        }

        public ToStringHelper addValue(long value) {
            this.addHolder().builder.append(value);
            return this;
        }

        public String toString() {
            boolean omitNullValuesSnapshot = this.omitNullValues;
            boolean needsSeparator = false;
            StringBuilder builder = new StringBuilder(32).append(this.className).append('{');
            for (ValueHolder valueHolder : this.valueHolders) {
                if (omitNullValuesSnapshot && valueHolder.isNull) continue;
                if (needsSeparator) {
                    builder.append(", ");
                } else {
                    needsSeparator = true;
                }
                StringBuilder sequence = valueHolder.builder;
                builder.append((CharSequence)sequence);
            }
            return builder.append('}').toString();
        }

        private ValueHolder addHolder() {
            ValueHolder valueHolder = new ValueHolder();
            this.valueHolders.add(valueHolder);
            return valueHolder;
        }

        private ValueHolder addHolder(@Nullable Object value) {
            ValueHolder valueHolder = this.addHolder();
            valueHolder.isNull = value == null;
            return valueHolder;
        }

        private static final class ValueHolder {
            final StringBuilder builder = new StringBuilder();
            boolean isNull;

            private ValueHolder() {
            }
        }
    }
}

