/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.util.internal.logging;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.python.netty.util.internal.StringUtil;
import org.python.netty.util.internal.logging.InternalLogLevel;
import org.python.netty.util.internal.logging.InternalLogger;
import org.python.netty.util.internal.logging.InternalLoggerFactory;

public abstract class AbstractInternalLogger
implements InternalLogger,
Serializable {
    private static final long serialVersionUID = -6382972526573193470L;
    private static final String EXCEPTION_MESSAGE = "Unexpected exception:";
    private final String name;

    protected AbstractInternalLogger(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isEnabled(InternalLogLevel level) {
        switch (level) {
            case TRACE: {
                return this.isTraceEnabled();
            }
            case DEBUG: {
                return this.isDebugEnabled();
            }
            case INFO: {
                return this.isInfoEnabled();
            }
            case WARN: {
                return this.isWarnEnabled();
            }
            case ERROR: {
                return this.isErrorEnabled();
            }
        }
        throw new Error();
    }

    @Override
    public void trace(Throwable t) {
        this.trace(EXCEPTION_MESSAGE, t);
    }

    @Override
    public void debug(Throwable t) {
        this.debug(EXCEPTION_MESSAGE, t);
    }

    @Override
    public void info(Throwable t) {
        this.info(EXCEPTION_MESSAGE, t);
    }

    @Override
    public void warn(Throwable t) {
        this.warn(EXCEPTION_MESSAGE, t);
    }

    @Override
    public void error(Throwable t) {
        this.error(EXCEPTION_MESSAGE, t);
    }

    @Override
    public void log(InternalLogLevel level, String msg2, Throwable cause) {
        switch (level) {
            case TRACE: {
                this.trace(msg2, cause);
                break;
            }
            case DEBUG: {
                this.debug(msg2, cause);
                break;
            }
            case INFO: {
                this.info(msg2, cause);
                break;
            }
            case WARN: {
                this.warn(msg2, cause);
                break;
            }
            case ERROR: {
                this.error(msg2, cause);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    @Override
    public void log(InternalLogLevel level, Throwable cause) {
        switch (level) {
            case TRACE: {
                this.trace(cause);
                break;
            }
            case DEBUG: {
                this.debug(cause);
                break;
            }
            case INFO: {
                this.info(cause);
                break;
            }
            case WARN: {
                this.warn(cause);
                break;
            }
            case ERROR: {
                this.error(cause);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    @Override
    public void log(InternalLogLevel level, String msg2) {
        switch (level) {
            case TRACE: {
                this.trace(msg2);
                break;
            }
            case DEBUG: {
                this.debug(msg2);
                break;
            }
            case INFO: {
                this.info(msg2);
                break;
            }
            case WARN: {
                this.warn(msg2);
                break;
            }
            case ERROR: {
                this.error(msg2);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    @Override
    public void log(InternalLogLevel level, String format, Object arg) {
        switch (level) {
            case TRACE: {
                this.trace(format, arg);
                break;
            }
            case DEBUG: {
                this.debug(format, arg);
                break;
            }
            case INFO: {
                this.info(format, arg);
                break;
            }
            case WARN: {
                this.warn(format, arg);
                break;
            }
            case ERROR: {
                this.error(format, arg);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    @Override
    public void log(InternalLogLevel level, String format, Object argA, Object argB) {
        switch (level) {
            case TRACE: {
                this.trace(format, argA, argB);
                break;
            }
            case DEBUG: {
                this.debug(format, argA, argB);
                break;
            }
            case INFO: {
                this.info(format, argA, argB);
                break;
            }
            case WARN: {
                this.warn(format, argA, argB);
                break;
            }
            case ERROR: {
                this.error(format, argA, argB);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    @Override
    public void log(InternalLogLevel level, String format, Object ... arguments2) {
        switch (level) {
            case TRACE: {
                this.trace(format, arguments2);
                break;
            }
            case DEBUG: {
                this.debug(format, arguments2);
                break;
            }
            case INFO: {
                this.info(format, arguments2);
                break;
            }
            case WARN: {
                this.warn(format, arguments2);
                break;
            }
            case ERROR: {
                this.error(format, arguments2);
                break;
            }
            default: {
                throw new Error();
            }
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        return InternalLoggerFactory.getInstance(this.name());
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '(' + this.name() + ')';
    }
}

