/*
 * Decompiled with CFR 0.152.
 */
package org.python.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.python.Version;
import org.python.core.CodeFlag;
import org.python.core.CompileMode;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyList;
import org.python.core.PyNullImporter;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PySystemState;
import org.python.core.imp;
import org.python.core.util.RelativeFile;
import org.python.modules._systemrestart;
import org.python.modules.posix.PosixModule;
import org.python.modules.thread.thread;
import org.python.util.CommandLineOptions;
import org.python.util.InteractiveConsole;

public class jython {
    private static final String PYTHON_CONSOLE_CLASS = "org.python.util.JLineConsole";
    private static final String COPYRIGHT = "Type \"help\", \"copyright\", \"credits\" or \"license\" for more information.";
    static final String usageHeader = "usage: jython [option] ... [-c cmd | -m mod | file | -] [arg] ...\n";
    private static final String usage = "usage: jython [option] ... [-c cmd | -m mod | file | -] [arg] ...\nOptions and arguments:\n-B       : don't write bytecode files on import\n-c cmd   : program passed in as string (terminates option list)\n-Dprop=v : Set the property `prop' to value `v'\n-E       : ignore environment variables (such as JYTHONPATH)\n-h       : print this help message and exit (also --help)\n-i       : inspect interactively after running script\n           and force prompts, even if stdin does not appear to be a terminal\n-jar jar : program read from __run__.py in jar file\n-m mod   : run library module as a script (terminates option list)\n-Q arg   : division options: -Qold (default), -Qwarn, -Qwarnall, -Qnew\n-s       : don't add user site directory to sys.path;\n-S       : don't imply 'import site' on initialization\n-u       : unbuffered binary stdout and stderr\n-v       : verbose (trace import statements)\n           can be supplied multiple times to increase verbosity\n-V       : print the Python version number and exit (also --version)\n-W arg   : warning control (arg is action:message:category:module:lineno)\n-3       : warn about Python 3.x incompatibilities that 2to3 cannot trivially fix\nfile     : program read from script file\n-        : program read from stdin (default; interactive mode if a tty)\narg ...  : arguments passed to program in sys.argv[1:]\n\nOther environment variables:\nJYTHONPATH: '" + File.pathSeparator + "'-separated list of directories prefixed to the default module\n            search path.  The result is sys.path.\nPYTHONIOENCODING: Encoding[:errors] used for stdin/stdout/stderr.";
    public static boolean shouldRestart;
    private static List<String> validWarnActions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runJar(String filename) {
        try {
            PyCode code;
            ZipFile zip = new ZipFile(filename);
            ZipEntry runit = zip.getEntry("__run__.py");
            if (runit == null) {
                throw Py.ValueError("jar file missing '__run__.py'");
            }
            PyStringMap locals = Py.newStringMap();
            int beginIndex = filename.lastIndexOf(File.separator);
            if (beginIndex != -1) {
                filename = filename.substring(beginIndex + 1);
            }
            locals.__setitem__("__name__", (PyObject)new PyString(filename));
            locals.__setitem__("zipfile", Py.java2py(zip));
            try (InputStream file = zip.getInputStream(runit);){
                code = Py.compile(file, "__run__", CompileMode.exec);
            }
            Py.runCode(code, locals, locals);
        }
        catch (IOException e) {
            throw Py.IOError(e);
        }
    }

    public static void main(String[] args) {
        do {
            shouldRestart = false;
            jython.run(args);
        } while (shouldRestart);
    }

    private static List<String> warnOptionsFromEnv() {
        ArrayList<String> opts = new ArrayList<String>();
        try {
            String envVar = System.getenv("PYTHONWARNINGS");
            if (envVar == null) {
                return opts;
            }
            for (String opt : envVar.split(",")) {
                if ((opt = opt.trim()).length() == 0) continue;
                opts.add(opt);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return opts;
    }

    private static void addWarnings(List<String> from, PyList to) {
        block0: for (String opt : from) {
            String action = opt.split(":")[0];
            for (String validWarnAction : validWarnActions) {
                if (!validWarnAction.startsWith(action)) continue;
                if (opt.contains(":")) {
                    to.append(Py.newString(validWarnAction + opt.substring(opt.indexOf(":"))));
                    continue block0;
                }
                to.append(Py.newString(validWarnAction));
                continue block0;
            }
            System.err.println(String.format("Invalid -W option ignored: invalid action: '%s'", action));
        }
    }

    private static void runModule(InteractiveConsole interp, String moduleName) {
        jython.runModule(interp, moduleName, false);
    }

    private static void runModule(InteractiveConsole interp, String moduleName, boolean set_argv0) {
        try {
            PyObject runpy = imp.importName("runpy", true);
            PyObject runmodule = runpy.__findattr__("_run_module_as_main");
            runmodule.__call__(Py.fileSystemEncode(moduleName), (PyObject)Py.newBoolean(set_argv0));
        }
        catch (Throwable t) {
            Py.printException(t);
            interp.cleanup();
            System.exit(-1);
        }
    }

    private static boolean runMainFromImporter(InteractiveConsole interp, String filename) {
        PyString argv0 = Py.fileSystemEncode(filename);
        PyObject importer2 = imp.getImporter(argv0);
        if (!(importer2 instanceof PyNullImporter)) {
            Py.getSystemState().path.insert(0, argv0);
            jython.runModule(interp, "__main__", true);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(String[] args) {
        CommandLineOptions opts = new CommandLineOptions();
        if (!opts.parse(args)) {
            if (opts.version) {
                System.err.println("Jython " + Version.PY_VERSION);
                System.exit(0);
            }
            if (opts.help) {
                System.err.println(usage);
            } else if (!opts.runCommand && !opts.runModule) {
                System.err.print(usageHeader);
                System.err.println("Try `jython -h' for more information.");
            }
            int exitcode = opts.help ? 0 : -1;
            System.exit(exitcode);
        }
        Properties preProperties = PySystemState.getBaseProperties();
        String pythonIoEncoding = jython.getenv("PYTHONIOENCODING");
        if (pythonIoEncoding != null) {
            String[] spec = jython.splitString(pythonIoEncoding, ':', 2);
            jython.addDefault(preProperties, "python.io.encoding", spec[0]);
            jython.addDefault(preProperties, "python.io.errors", spec[1]);
        }
        if (!opts.fixInteractive || opts.interactive) {
            opts.interactive = Py.isInteractive();
            if (opts.interactive) {
                jython.addDefault(preProperties, "python.console", PYTHON_CONSOLE_CLASS);
            }
        }
        PySystemState.initialize(preProperties, opts.properties, opts.argv);
        PySystemState systemState = Py.getSystemState();
        PyList warnoptions = new PyList();
        jython.addWarnings(opts.warnoptions, warnoptions);
        if (!Options.ignore_environment) {
            jython.addWarnings(jython.warnOptionsFromEnv(), warnoptions);
        }
        systemState.setWarnoptions(warnoptions);
        if (warnoptions.size() > 0) {
            imp.load("warnings");
        }
        if (!opts.interactive) {
            systemState.ps1 = systemState.ps2 = Py.EmptyString;
        }
        InteractiveConsole interp = new InteractiveConsole();
        if (opts.interactive && opts.notice && !opts.runModule) {
            System.err.println(InteractiveConsole.getDefaultBanner());
        }
        if (Py.importSiteIfSelected() && opts.interactive && opts.notice && !opts.runModule) {
            System.err.println(COPYRIGHT);
        }
        if (opts.division != null) {
            if ("old".equals(opts.division)) {
                Options.division_warning = 0;
            } else if ("warn".equals(opts.division)) {
                Options.division_warning = 1;
            } else if ("warnall".equals(opts.division)) {
                Options.division_warning = 2;
            } else if ("new".equals(opts.division)) {
                Options.Qnew = true;
                interp.cflags.setFlag(CodeFlag.CO_FUTURE_DIVISION);
            }
        }
        if (opts.filename != null) {
            String path;
            if (jython.runMainFromImporter(interp, opts.filename)) {
                interp.cleanup();
                return;
            }
            try {
                path = new File(opts.filename).getCanonicalFile().getParent();
            }
            catch (IOException ioe) {
                path = new File(opts.filename).getAbsoluteFile().getParent();
            }
            if (path == null) {
                path = "";
            }
            Py.getSystemState().path.insert(0, Py.fileSystemEncode(path));
            if (opts.jar) {
                try {
                    jython.runJar(opts.filename);
                }
                catch (Throwable t) {
                    Py.printException(t);
                    System.exit(-1);
                }
            } else if (opts.filename.equals("-")) {
                try {
                    interp.globals.__setitem__(new PyString("__file__"), (PyObject)new PyString("<stdin>"));
                    interp.execfile(System.in, "<stdin>");
                }
                catch (Throwable t) {
                    Py.printException(t);
                }
            } else {
                try {
                    FileInputStream file;
                    interp.globals.__setitem__(new PyString("__file__"), (PyObject)Py.fileSystemEncode(opts.filename));
                    try {
                        file = new FileInputStream(new RelativeFile(opts.filename));
                    }
                    catch (FileNotFoundException e) {
                        throw Py.IOError(e);
                    }
                    try {
                        boolean isInteractive = false;
                        try {
                            isInteractive = PosixModule.getPOSIX().isatty(file.getFD());
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                        if (isInteractive) {
                            opts.interactive = true;
                            interp.interact(null, new PyFile(file));
                            return;
                        }
                        interp.execfile(file, opts.filename);
                    }
                    finally {
                        file.close();
                    }
                }
                catch (Throwable t) {
                    if (t instanceof PyException && ((PyException)t).match(_systemrestart.SystemRestart)) {
                        shouldRestart = true;
                        jython.shutdownInterpreter();
                        interp.cleanup();
                        Py.setSystemState(new PySystemState());
                        return;
                    }
                    Py.printException(t);
                    interp.cleanup();
                    System.exit(-1);
                }
            }
        } else {
            Py.getSystemState().path.insert(0, Py.EmptyString);
            if (opts.command != null) {
                try {
                    interp.exec(opts.command);
                }
                catch (Throwable t) {
                    Py.printException(t);
                    System.exit(1);
                }
            }
            if (opts.moduleName != null) {
                jython.runModule(interp, opts.moduleName);
                interp.cleanup();
                return;
            }
        }
        if (opts.fixInteractive || opts.filename == null && opts.command == null) {
            String encoding = Py.getConsole().getEncoding();
            try {
                interp.cflags.encoding = encoding;
                if (!opts.interactive) {
                    interp._interact(null, null);
                } else {
                    interp.interact(null, null);
                }
            }
            catch (Throwable t) {
                Py.printException(t);
            }
        }
        interp.cleanup();
    }

    public static void shutdownInterpreter() {
        thread.interruptAllThreads();
        Py.getSystemState()._systemRestart = true;
        try {
            imp.load("socket").__findattr__("_closeActiveSockets").__call__();
        }
        catch (PyException pyException) {
            // empty catch block
        }
    }

    private static String[] splitString(String spec, char sep, int n) {
        String[] list = new String[n];
        int p = 0;
        int i = 0;
        int L = spec.length();
        while (p < L) {
            int c = spec.indexOf(sep, p);
            if (c < 0 || i >= n - 1) {
                c = L;
            }
            String s = spec.substring(p, c).trim();
            list[i++] = s.length() > 0 ? s : null;
            p = c + 1;
        }
        return list;
    }

    private static boolean addDefault(Properties registry, String key, String value) {
        if (value == null || registry.containsKey(key)) {
            return false;
        }
        registry.setProperty(key, value);
        return true;
    }

    private static String getenv(String varname) {
        if (!Options.ignore_environment) {
            try {
                return System.getenv(varname);
            }
            catch (SecurityException e) {
                Options.ignore_environment = true;
            }
        }
        return null;
    }

    static {
        validWarnActions = Arrays.asList("error", "ignore", "always", "default", "module", "once");
    }
}

