/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.commons.compress.compressors.lzma;

import java.io.IOException;
import java.io.InputStream;
import org.python.apache.commons.compress.compressors.CompressorInputStream;
import org.tukaani.xz.LZMAInputStream;

public class LZMACompressorInputStream
extends CompressorInputStream {
    private final InputStream in;

    public LZMACompressorInputStream(InputStream inputStream) throws IOException {
        this.in = new LZMAInputStream(inputStream);
    }

    @Override
    public int read() throws IOException {
        int ret = this.in.read();
        this.count(ret == -1 ? 0 : 1);
        return ret;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        int ret = this.in.read(buf, off, len);
        this.count(ret);
        return ret;
    }

    @Override
    public long skip(long n) throws IOException {
        return this.in.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public static boolean matches(byte[] signature, int length) {
        if (signature == null || length < 3) {
            return false;
        }
        if (signature[0] != 93) {
            return false;
        }
        if (signature[1] != 0) {
            return false;
        }
        return signature[2] == 0;
    }
}

