/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.handler.ssl;

import java.security.cert.Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.python.netty.buffer.ByteBufAllocator;
import org.python.netty.handler.ssl.ApplicationProtocolConfig;
import org.python.netty.handler.ssl.CipherSuiteFilter;
import org.python.netty.handler.ssl.ClientAuth;
import org.python.netty.handler.ssl.OpenSsl;
import org.python.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import org.python.netty.handler.ssl.OpenSslEngine;
import org.python.netty.handler.ssl.ReferenceCountedOpenSslContext;

public abstract class OpenSslContext
extends ReferenceCountedOpenSslContext {
    OpenSslContext(Iterable<String> ciphers, CipherSuiteFilter cipherFilter, ApplicationProtocolConfig apnCfg, long sessionCacheSize, long sessionTimeout, int mode, Certificate[] keyCertChain, ClientAuth clientAuth, boolean startTls) throws SSLException {
        super(ciphers, cipherFilter, apnCfg, sessionCacheSize, sessionTimeout, mode, keyCertChain, clientAuth, startTls, false);
    }

    OpenSslContext(Iterable<String> ciphers, CipherSuiteFilter cipherFilter, OpenSslApplicationProtocolNegotiator apn, long sessionCacheSize, long sessionTimeout, int mode, Certificate[] keyCertChain, ClientAuth clientAuth, boolean startTls) throws SSLException {
        super(ciphers, cipherFilter, apn, sessionCacheSize, sessionTimeout, mode, keyCertChain, clientAuth, startTls, false);
    }

    @Override
    final SSLEngine newEngine0(ByteBufAllocator alloc, String peerHost, int peerPort) {
        return new OpenSslEngine(this, alloc, peerHost, peerPort);
    }

    protected final void finalize() throws Throwable {
        super.finalize();
        OpenSsl.releaseIfNeeded(this);
    }
}

