/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.handler.codec.compression;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.zip.Checksum;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Exception;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.xxhash.XXHashFactory;
import org.python.netty.buffer.ByteBuf;
import org.python.netty.buffer.Unpooled;
import org.python.netty.channel.ChannelFuture;
import org.python.netty.channel.ChannelFutureListener;
import org.python.netty.channel.ChannelHandlerContext;
import org.python.netty.channel.ChannelPromise;
import org.python.netty.channel.ChannelPromiseNotifier;
import org.python.netty.handler.codec.MessageToByteEncoder;
import org.python.netty.handler.codec.compression.CompressionException;
import org.python.netty.util.concurrent.EventExecutor;

public class Lz4FrameEncoder
extends MessageToByteEncoder<ByteBuf> {
    private final int blockSize;
    private LZ4Compressor compressor;
    private Checksum checksum;
    private final int compressionLevel;
    private ByteBuf buffer;
    private int currentBlockLength;
    private final int compressedBlockSize;
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;

    public Lz4FrameEncoder() {
        this(false);
    }

    public Lz4FrameEncoder(boolean highCompressor) {
        this(LZ4Factory.fastestInstance(), highCompressor, 65536, XXHashFactory.fastestInstance().newStreamingHash32(-1756908916).asChecksum());
    }

    public Lz4FrameEncoder(LZ4Factory factory, boolean highCompressor, int blockSize, Checksum checksum) {
        if (factory == null) {
            throw new NullPointerException("factory");
        }
        if (checksum == null) {
            throw new NullPointerException("checksum");
        }
        this.compressor = highCompressor ? factory.highCompressor() : factory.fastCompressor();
        this.checksum = checksum;
        this.compressionLevel = Lz4FrameEncoder.compressionLevel(blockSize);
        this.blockSize = blockSize;
        this.currentBlockLength = 0;
        this.compressedBlockSize = 21 + this.compressor.maxCompressedLength(blockSize);
        this.finished = false;
    }

    private static int compressionLevel(int blockSize) {
        if (blockSize < 64 || blockSize > 0x2000000) {
            throw new IllegalArgumentException(String.format("blockSize: %d (expected: %d-%d)", blockSize, 64, 0x2000000));
        }
        int compressionLevel = 32 - Integer.numberOfLeadingZeros(blockSize - 1);
        compressionLevel = Math.max(0, compressionLevel - 10);
        return compressionLevel;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        if (this.finished) {
            out.writeBytes(in);
            return;
        }
        int length = in.readableBytes();
        ByteBuf buffer = this.buffer;
        int blockSize = buffer.capacity();
        while (this.currentBlockLength + length >= blockSize) {
            int tail = blockSize - this.currentBlockLength;
            in.getBytes(in.readerIndex(), buffer, this.currentBlockLength, tail);
            this.currentBlockLength = blockSize;
            this.flushBufferedData(out);
            in.skipBytes(tail);
            length -= tail;
        }
        in.readBytes(buffer, this.currentBlockLength, length);
        this.currentBlockLength += length;
    }

    private void flushBufferedData(ByteBuf out) {
        int blockType;
        int compressedLength;
        int currentBlockLength = this.currentBlockLength;
        if (currentBlockLength == 0) {
            return;
        }
        this.checksum.reset();
        this.checksum.update(this.buffer.array(), this.buffer.arrayOffset(), currentBlockLength);
        int check = (int)this.checksum.getValue();
        out.ensureWritable(this.compressedBlockSize);
        int idx = out.writerIndex();
        try {
            ByteBuffer outNioBuffer = out.internalNioBuffer(idx + 21, out.writableBytes() - 21);
            int pos = outNioBuffer.position();
            this.compressor.compress(this.buffer.internalNioBuffer(0, currentBlockLength), outNioBuffer);
            compressedLength = outNioBuffer.position() - pos;
        }
        catch (LZ4Exception e) {
            throw new CompressionException(e);
        }
        if (compressedLength >= currentBlockLength) {
            blockType = 16;
            compressedLength = currentBlockLength;
            out.setBytes(idx + 21, this.buffer, 0, currentBlockLength);
        } else {
            blockType = 32;
        }
        out.setLong(idx, 5501767354678207339L);
        out.setByte(idx + 8, (byte)(blockType | this.compressionLevel));
        out.setIntLE(idx + 9, compressedLength);
        out.setIntLE(idx + 13, currentBlockLength);
        out.setIntLE(idx + 17, check);
        out.writerIndex(idx + 21 + compressedLength);
        this.currentBlockLength = currentBlockLength = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture finishEncode(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (this.finished) {
            promise.setSuccess();
            return promise;
        }
        this.finished = true;
        try {
            ByteBuf footer = ctx.alloc().heapBuffer(this.compressor.maxCompressedLength(this.currentBlockLength) + 21);
            this.flushBufferedData(footer);
            int idx = footer.writerIndex();
            footer.setLong(idx, 5501767354678207339L);
            footer.setByte(idx + 8, (byte)(0x10 | this.compressionLevel));
            footer.setInt(idx + 9, 0);
            footer.setInt(idx + 13, 0);
            footer.setInt(idx + 17, 0);
            footer.writerIndex(idx + 21);
            ChannelFuture channelFuture = ctx.writeAndFlush(footer, promise);
            return channelFuture;
        }
        finally {
            this.cleanup();
        }
    }

    private void cleanup() {
        this.compressor = null;
        this.checksum = null;
        if (this.buffer != null) {
            this.buffer.release();
            this.buffer = null;
        }
    }

    public boolean isClosed() {
        return this.finished;
    }

    public ChannelFuture close() {
        return this.close(this.ctx().newPromise());
    }

    public ChannelFuture close(final ChannelPromise promise) {
        ChannelHandlerContext ctx = this.ctx();
        EventExecutor executor = ctx.executor();
        if (executor.inEventLoop()) {
            return this.finishEncode(ctx, promise);
        }
        executor.execute(new Runnable(){

            @Override
            public void run() {
                ChannelFuture f = Lz4FrameEncoder.this.finishEncode(Lz4FrameEncoder.this.ctx(), promise);
                f.addListener(new ChannelPromiseNotifier(promise));
            }
        });
        return promise;
    }

    @Override
    public void close(final ChannelHandlerContext ctx, final ChannelPromise promise) throws Exception {
        ChannelFuture f = this.finishEncode(ctx, ctx.newPromise());
        f.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture f) throws Exception {
                ctx.close(promise);
            }
        });
        if (!f.isDone()) {
            ctx.executor().schedule(new Runnable(){

                @Override
                public void run() {
                    ctx.close(promise);
                }
            }, 10L, TimeUnit.SECONDS);
        }
    }

    private ChannelHandlerContext ctx() {
        ChannelHandlerContext ctx = this.ctx;
        if (ctx == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return ctx;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
        this.buffer = Unpooled.wrappedBuffer(new byte[this.blockSize]);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        this.cleanup();
    }
}

