/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl;

import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeMap;
import org.python.icu.impl.CurrencyData;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.impl.UResource;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;

public class ICUCurrencyDisplayInfoProvider
implements CurrencyData.CurrencyDisplayInfoProvider {
    @Override
    public CurrencyData.CurrencyDisplayInfo getInstance(ULocale locale, boolean withFallback) {
        ICUResourceBundle rb;
        if (withFallback) {
            rb = ICUResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt58b/curr", locale, ICUResourceBundle.OpenType.LOCALE_DEFAULT_ROOT);
        } else {
            try {
                rb = ICUResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt58b/curr", locale, ICUResourceBundle.OpenType.LOCALE_ONLY);
            }
            catch (MissingResourceException e) {
                return null;
            }
        }
        return new ICUCurrencyDisplayInfo(rb, withFallback);
    }

    @Override
    public boolean hasData() {
        return true;
    }

    static class ICUCurrencyDisplayInfo
    extends CurrencyData.CurrencyDisplayInfo {
        private final boolean fallback;
        private final ICUResourceBundle rb;
        private final ICUResourceBundle currencies;
        private final ICUResourceBundle plurals;
        private SoftReference<Map<String, String>> _symbolMapRef;
        private SoftReference<Map<String, String>> _nameMapRef;

        public ICUCurrencyDisplayInfo(ICUResourceBundle rb, boolean fallback) {
            this.fallback = fallback;
            this.rb = rb;
            this.currencies = rb.findTopLevel("Currencies");
            this.plurals = rb.findTopLevel("CurrencyPlurals");
        }

        @Override
        public ULocale getULocale() {
            return this.rb.getULocale();
        }

        @Override
        public String getName(String isoCode) {
            return this.getName(isoCode, false);
        }

        @Override
        public String getSymbol(String isoCode) {
            return this.getName(isoCode, true);
        }

        private String getName(String isoCode, boolean symbolName) {
            ICUResourceBundle result;
            if (this.currencies != null && (result = this.currencies.findWithFallback(isoCode)) != null) {
                if (!this.fallback && !this.rb.isRoot() && result.isRoot()) {
                    return null;
                }
                return result.getString(symbolName ? 0 : 1);
            }
            return this.fallback ? isoCode : null;
        }

        @Override
        public String getPluralName(String isoCode, String pluralKey) {
            ICUResourceBundle pluralsBundle;
            if (this.plurals != null && (pluralsBundle = this.plurals.findWithFallback(isoCode)) != null) {
                String pluralName = pluralsBundle.findStringWithFallback(pluralKey);
                if (pluralName == null) {
                    if (!this.fallback) {
                        return null;
                    }
                    pluralName = pluralsBundle.findStringWithFallback("other");
                    if (pluralName == null) {
                        return this.getName(isoCode);
                    }
                }
                return pluralName;
            }
            return this.fallback ? this.getName(isoCode) : null;
        }

        @Override
        public Map<String, String> symbolMap() {
            Map<String, String> map;
            Map<String, String> map2 = map = this._symbolMapRef == null ? null : this._symbolMapRef.get();
            if (map == null) {
                map = this._createSymbolMap();
                this._symbolMapRef = new SoftReference<Map<String, String>>(map);
            }
            return map;
        }

        @Override
        public Map<String, String> nameMap() {
            Map<String, String> map;
            Map<String, String> map2 = map = this._nameMapRef == null ? null : this._nameMapRef.get();
            if (map == null) {
                map = this._createNameMap();
                this._nameMapRef = new SoftReference<Map<String, String>>(map);
            }
            return map;
        }

        @Override
        public Map<String, String> getUnitPatterns() {
            HashMap<String, String> result = new HashMap<String, String>();
            for (ULocale locale = this.rb.getULocale(); locale != null; locale = locale.getFallback()) {
                ICUResourceBundle cr;
                ICUResourceBundle r = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt58b/curr", locale);
                if (r == null || (cr = r.findWithFallback("CurrencyUnitPatterns")) == null) continue;
                int size = cr.getSize();
                for (int index = 0; index < size; ++index) {
                    ICUResourceBundle b = (ICUResourceBundle)cr.get(index);
                    String key = b.getKey();
                    if (result.containsKey(key)) continue;
                    result.put(key, b.getString());
                }
            }
            return Collections.unmodifiableMap(result);
        }

        @Override
        public CurrencyData.CurrencyFormatInfo getFormatInfo(String isoCode) {
            ICUResourceBundle crb = this.currencies.findWithFallback(isoCode);
            if (crb != null && crb.getSize() > 2 && (crb = crb.at(2)) != null) {
                String pattern = crb.getString(0);
                String separator = crb.getString(1);
                String groupingSeparator = crb.getString(2);
                return new CurrencyData.CurrencyFormatInfo(pattern, separator, groupingSeparator);
            }
            return null;
        }

        @Override
        public CurrencyData.CurrencySpacingInfo getSpacingInfo() {
            SpacingInfoSink sink = new SpacingInfoSink();
            this.rb.getAllItemsWithFallback("currencySpacing", sink);
            return sink.getSpacingInfo(this.fallback);
        }

        private Map<String, String> _createSymbolMap() {
            HashMap<String, String> result = new HashMap<String, String>();
            for (ULocale locale = this.rb.getULocale(); locale != null; locale = locale.getFallback()) {
                ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt58b/curr", locale);
                ICUResourceBundle curr = bundle.findTopLevel("Currencies");
                if (curr == null) continue;
                for (int i = 0; i < curr.getSize(); ++i) {
                    ICUResourceBundle item = curr.at(i);
                    String isoCode = item.getKey();
                    if (result.containsKey(isoCode)) continue;
                    result.put(isoCode, isoCode);
                    String symbol = item.getString(0);
                    result.put(symbol, isoCode);
                }
            }
            return Collections.unmodifiableMap(result);
        }

        private Map<String, String> _createNameMap() {
            TreeMap<String, String> result = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            HashSet<String> visited = new HashSet<String>();
            HashMap visitedPlurals = new HashMap();
            for (ULocale locale = this.rb.getULocale(); locale != null; locale = locale.getFallback()) {
                ICUResourceBundle plurals;
                ICUResourceBundle bundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt58b/curr", locale);
                ICUResourceBundle curr = bundle.findTopLevel("Currencies");
                if (curr != null) {
                    for (int i = 0; i < curr.getSize(); ++i) {
                        ICUResourceBundle item = curr.at(i);
                        String isoCode = item.getKey();
                        if (visited.contains(isoCode)) continue;
                        visited.add(isoCode);
                        String name = item.getString(1);
                        result.put(name, isoCode);
                    }
                }
                if ((plurals = bundle.findTopLevel("CurrencyPlurals")) == null) continue;
                for (int i = 0; i < plurals.getSize(); ++i) {
                    ICUResourceBundle item = plurals.at(i);
                    String isoCode = item.getKey();
                    HashSet<String> pluralSet = (HashSet<String>)visitedPlurals.get(isoCode);
                    if (pluralSet == null) {
                        pluralSet = new HashSet<String>();
                        visitedPlurals.put(isoCode, pluralSet);
                    }
                    for (int j = 0; j < item.getSize(); ++j) {
                        ICUResourceBundle plural = item.at(j);
                        String pluralType = plural.getKey();
                        if (pluralSet.contains(pluralType)) continue;
                        String pluralName = plural.getString();
                        result.put(pluralName, isoCode);
                        pluralSet.add(pluralType);
                    }
                }
            }
            return Collections.unmodifiableMap(result);
        }

        private final class SpacingInfoSink
        extends UResource.Sink {
            CurrencyData.CurrencySpacingInfo spacingInfo = new CurrencyData.CurrencySpacingInfo();
            boolean hasBeforeCurrency = false;
            boolean hasAfterCurrency = false;

            private SpacingInfoSink() {
            }

            @Override
            public void put(UResource.Key key, UResource.Value value, boolean noFallback) {
                UResource.Table spacingTypesTable = value.getTable();
                int i = 0;
                while (spacingTypesTable.getKeyAndValue(i, key, value)) {
                    block6: {
                        CurrencyData.CurrencySpacingInfo.SpacingType type;
                        block5: {
                            block4: {
                                if (!key.contentEquals("beforeCurrency")) break block4;
                                type = CurrencyData.CurrencySpacingInfo.SpacingType.BEFORE;
                                this.hasBeforeCurrency = true;
                                break block5;
                            }
                            if (!key.contentEquals("afterCurrency")) break block6;
                            type = CurrencyData.CurrencySpacingInfo.SpacingType.AFTER;
                            this.hasAfterCurrency = true;
                        }
                        UResource.Table patternsTable = value.getTable();
                        int j = 0;
                        while (patternsTable.getKeyAndValue(j, key, value)) {
                            block10: {
                                CurrencyData.CurrencySpacingInfo.SpacingPattern pattern;
                                block8: {
                                    block9: {
                                        block7: {
                                            if (!key.contentEquals("currencyMatch")) break block7;
                                            pattern = CurrencyData.CurrencySpacingInfo.SpacingPattern.CURRENCY_MATCH;
                                            break block8;
                                        }
                                        if (!key.contentEquals("surroundingMatch")) break block9;
                                        pattern = CurrencyData.CurrencySpacingInfo.SpacingPattern.SURROUNDING_MATCH;
                                        break block8;
                                    }
                                    if (!key.contentEquals("insertBetween")) break block10;
                                    pattern = CurrencyData.CurrencySpacingInfo.SpacingPattern.INSERT_BETWEEN;
                                }
                                this.spacingInfo.setSymbolIfNull(type, pattern, value.getString());
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }

            CurrencyData.CurrencySpacingInfo getSpacingInfo(boolean fallback) {
                if (this.hasBeforeCurrency && this.hasAfterCurrency) {
                    return this.spacingInfo;
                }
                if (fallback) {
                    return CurrencyData.CurrencySpacingInfo.DEFAULT;
                }
                return null;
            }
        }
    }
}

