/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import org.python.core.Py;
import org.python.modules.jffi.AllocatedDirectMemory;
import org.python.modules.jffi.BoundedNativeMemory;

class AllocatedNativeMemory
extends BoundedNativeMemory
implements AllocatedDirectMemory {
    private volatile boolean released = false;
    private volatile boolean autorelease = true;
    private final long storage;

    static final AllocatedNativeMemory allocate(int size, boolean clear) {
        return AllocatedNativeMemory.allocateAligned(size, 1, clear);
    }

    static final AllocatedNativeMemory allocateAligned(int size, int align, boolean clear) {
        long memory = IO.allocateMemory(size + align - 1, clear);
        if (memory == 0L) {
            throw Py.RuntimeError("failed to allocate " + size + " bytes");
        }
        return new AllocatedNativeMemory(memory, size, align);
    }

    private AllocatedNativeMemory(long address, int size, int align) {
        super((address - 1L & (long)(~(align - 1))) + (long)align, size);
        this.storage = address;
    }

    public void free() {
        if (!this.released) {
            IO.freeMemory(this.storage);
            this.released = true;
        }
    }

    public void setAutoRelease(boolean release) {
        this.autorelease = release;
    }

    protected void finalize() throws Throwable {
        try {
            if (!this.released && this.autorelease) {
                IO.freeMemory(this.storage);
                this.released = true;
            }
        }
        finally {
            super.finalize();
        }
    }
}

