/*
 * Decompiled with CFR 0.152.
 */
package org.python.jsr223;

import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyException;
import org.python.core.PyModule;
import org.python.core.PyObject;
import org.python.core.PyTraceback;
import org.python.core.__builtin__;
import org.python.jsr223.PyScriptEngineScope;
import org.python.util.PythonInterpreter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyScriptEngine
extends AbstractScriptEngine
implements Compilable,
Invocable {
    private final PythonInterpreter interp;
    private final ScriptEngineFactory factory;
    private final PyModule module;

    PyScriptEngine(ScriptEngineFactory factory) {
        this.factory = factory;
        this.interp = new PythonInterpreter(new PyScriptEngineScope(this, this.context));
        this.module = (PyModule)Py.getSystemState().modules.__finditem__("__main__");
    }

    @Override
    public Object eval(String script, ScriptContext context) throws ScriptException {
        return this.eval(this.compileScript(script, context), context);
    }

    private Object eval(PyCode code, ScriptContext context) throws ScriptException {
        try {
            this.interp.setIn(context.getReader());
            this.interp.setOut(context.getWriter());
            this.interp.setErr(context.getErrorWriter());
            return this.interp.eval(code).__tojava__(Object.class);
        }
        catch (PyException pye) {
            throw PyScriptEngine.scriptException(pye);
        }
    }

    @Override
    public Object eval(Reader reader, ScriptContext context) throws ScriptException {
        return this.eval(this.compileScript(reader, context), context);
    }

    @Override
    public Bindings createBindings() {
        return new SimpleBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return new PyCompiledScript(this.compileScript(script, this.context));
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        return new PyCompiledScript(this.compileScript(reader, this.context));
    }

    private PyCode compileScript(String script, ScriptContext context) throws ScriptException {
        try {
            String filename = (String)context.getAttribute("javax.script.filename");
            if (filename == null) {
                return this.interp.compile(script);
            }
            return this.interp.compile(script, filename);
        }
        catch (PyException pye) {
            throw PyScriptEngine.scriptException(pye);
        }
    }

    private PyCode compileScript(Reader reader, ScriptContext context) throws ScriptException {
        try {
            String filename = (String)context.getAttribute("javax.script.filename");
            if (filename == null) {
                return this.interp.compile(reader);
            }
            return this.interp.compile(reader, filename);
        }
        catch (PyException pye) {
            throw PyScriptEngine.scriptException(pye);
        }
    }

    @Override
    public Object invokeMethod(Object thiz, String name, Object ... args) throws ScriptException, NoSuchMethodException {
        try {
            if (!(thiz instanceof PyObject)) {
                thiz = Py.java2py(thiz);
            }
            return ((PyObject)thiz).invoke(name, Py.javas2pys(args)).__tojava__(Object.class);
        }
        catch (PyException pye) {
            return PyScriptEngine.throwInvokeException(pye, name);
        }
    }

    @Override
    public Object invokeFunction(String name, Object ... args) throws ScriptException, NoSuchMethodException {
        try {
            PyObject function = this.interp.get(name);
            if (function == null) {
                throw new NoSuchMethodException(name);
            }
            return function.__call__(Py.javas2pys(args)).__tojava__(Object.class);
        }
        catch (PyException pye) {
            return PyScriptEngine.throwInvokeException(pye, name);
        }
    }

    @Override
    public <T> T getInterface(Class<T> clazz) {
        return this.getInterface(this.module, clazz);
    }

    @Override
    public <T> T getInterface(Object obj, Class<T> clazz) {
        if (obj == null) {
            throw new IllegalArgumentException("object expected");
        }
        if (clazz == null || !clazz.isInterface()) {
            throw new IllegalArgumentException("interface expected");
        }
        final PyObject thiz = Py.java2py(obj);
        Object proxy = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    PyObject result = thiz.invoke(method.getName(), Py.javas2pys(args));
                    return result.__tojava__(Object.class);
                }
                catch (PyException pye) {
                    return PyScriptEngine.throwInvokeException(pye, method.getName());
                }
            }
        });
        return (T)proxy;
    }

    private static Object throwInvokeException(PyException pye, String methodName) throws ScriptException, NoSuchMethodException {
        if (pye.match(Py.AttributeError)) {
            throw new NoSuchMethodException(methodName);
        }
        throw PyScriptEngine.scriptException(pye);
    }

    private static ScriptException scriptException(PyException pye) {
        ScriptException se = null;
        try {
            pye.normalize();
            PyObject type = pye.type;
            PyObject value = pye.value;
            PyTraceback tb = pye.traceback;
            if (__builtin__.isinstance(value, Py.SyntaxError)) {
                PyObject filename = value.__findattr__("filename");
                PyObject lineno = value.__findattr__("lineno");
                PyObject offset = value.__findattr__("offset");
                value = value.__findattr__("msg");
                se = new ScriptException(Py.formatException(type, value), filename == null ? "<script>" : filename.toString(), lineno == null ? 0 : lineno.asInt(), offset == null ? 0 : offset.asInt());
            } else if (tb != null) {
                String filename = tb.tb_frame == null || tb.tb_frame.f_code == null ? null : tb.tb_frame.f_code.co_filename;
                se = new ScriptException(Py.formatException(type, value), filename, tb.tb_lineno);
            } else {
                se = new ScriptException(Py.formatException(type, value));
            }
            se.initCause(pye);
            return se;
        }
        catch (Exception ee) {
            se = new ScriptException(pye);
            return se;
        }
    }

    private class PyCompiledScript
    extends CompiledScript {
        private PyCode code;

        PyCompiledScript(PyCode code) {
            this.code = code;
        }

        public ScriptEngine getEngine() {
            return PyScriptEngine.this;
        }

        public Object eval(ScriptContext ctx) throws ScriptException {
            return PyScriptEngine.this.eval(this.code, ctx);
        }
    }
}

