/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql;

import com.ziclix.python.sql.DBApiType;
import com.ziclix.python.sql.DateFactory;
import com.ziclix.python.sql.JavaDateFactory;
import com.ziclix.python.sql.zxJDBCFunc;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import org.python.core.ClassDictInit;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;

public class zxJDBC
extends PyObject
implements ClassDictInit {
    public static PyObject Error = Py.None;
    public static PyObject Warning = Py.None;
    public static PyObject InterfaceError = Py.None;
    public static PyObject DatabaseError = Py.None;
    public static PyObject InternalError = Py.None;
    public static PyObject OperationalError = Py.None;
    public static PyObject ProgrammingError = Py.None;
    public static PyObject IntegrityError = Py.None;
    public static PyObject DataError = Py.None;
    public static PyObject NotSupportedError = Py.None;
    private static ResourceBundle resourceBundle = null;
    public static DateFactory datefactory = new JavaDateFactory();

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("apilevel", (PyObject)new PyString("2.0"));
        dict.__setitem__("threadsafety", (PyObject)new PyInteger(1));
        dict.__setitem__("paramstyle", (PyObject)new PyString("qmark"));
        dict.__setitem__("__version__", Py.newString("$Revision$").__getslice__(Py.newInteger(11), Py.newInteger(-2), null));
        dict.__setitem__("Date", (PyObject)new zxJDBCFunc("Date", 1, 3, 3, "construct a Date from year, month, day"));
        dict.__setitem__("Time", (PyObject)new zxJDBCFunc("Time", 2, 3, 3, "construct a Date from hour, minute, second"));
        dict.__setitem__("Timestamp", (PyObject)new zxJDBCFunc("Timestamp", 3, 6, 6, "construct a Timestamp from year, month, day, hour, minute, second"));
        dict.__setitem__("DateFromTicks", (PyObject)new zxJDBCFunc("DateFromTicks", 4, 1, 1, "construct a Date from seconds since the epoch"));
        dict.__setitem__("TimeFromTicks", (PyObject)new zxJDBCFunc("TimeFromTicks", 5, 1, 1, "construct a Time from seconds since the epoch"));
        dict.__setitem__("TimestampFromTicks", (PyObject)new zxJDBCFunc("TimestampFromTicks", 6, 1, 1, "construct a Timestamp from seconds since the epoch"));
        dict.__setitem__("Binary", (PyObject)new zxJDBCFunc("Binary", 7, 1, 1, "construct an object capable of holding binary data"));
        zxJDBC._addSqlTypes(dict);
        zxJDBC._addConnectors(dict);
        zxJDBC._buildExceptions(dict);
        dict.__setitem__("initModule", null);
        dict.__setitem__("toString", null);
        dict.__setitem__("getPyClass", null);
        dict.__setitem__("classDictInit", null);
        dict.__setitem__("_addSqlTypes", null);
        dict.__setitem__("_addConnectors", null);
        dict.__setitem__("_buildExceptions", null);
        dict.__setitem__("buildClass", null);
        dict.__setitem__("createExceptionMessage", null);
        dict.__setitem__("resourceBundle", null);
        dict.__setitem__("getString", null);
        dict.__setitem__("makeException", null);
    }

    protected static void _addSqlTypes(PyObject dict) throws PyException {
        PyDictionary sqltype = new PyDictionary();
        dict.__setitem__("sqltype", (PyObject)sqltype);
        try {
            PyInteger value;
            PyString name;
            Field f;
            int i;
            Class<?> c = Class.forName("java.sql.Types");
            Field[] fields = c.getFields();
            for (i = 0; i < fields.length; ++i) {
                f = fields[i];
                name = Py.newString(f.getName());
                value = new DBApiType(f.getInt(c));
                dict.__setitem__(name, (PyObject)value);
                sqltype.__setitem__(value, (PyObject)name);
            }
            c = Class.forName("java.sql.ResultSet");
            fields = c.getFields();
            for (i = 0; i < fields.length; ++i) {
                f = fields[i];
                name = Py.newString(f.getName());
                value = Py.newInteger(f.getInt(c));
                dict.__setitem__(name, (PyObject)value);
            }
        }
        catch (Throwable t) {
            throw zxJDBC.makeException(t);
        }
        dict.__setitem__("ROWID", dict.__getitem__(Py.newString("OTHER")));
        dict.__setitem__("NUMBER", dict.__getitem__(Py.newString("NUMERIC")));
        dict.__setitem__("STRING", dict.__getitem__(Py.newString("VARCHAR")));
        dict.__setitem__("DATETIME", dict.__getitem__(Py.newString("TIMESTAMP")));
    }

    protected static void _addConnectors(PyObject dict) throws PyException {
        PyObject connector = Py.None;
        Properties props = new Properties();
        props.put("connect", "com.ziclix.python.sql.connect.Connect");
        props.put("lookup", "com.ziclix.python.sql.connect.Lookup");
        props.put("connectx", "com.ziclix.python.sql.connect.Connectx");
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = ((String)names.nextElement()).trim();
            String className = props.getProperty(name).trim();
            try {
                connector = (PyObject)Class.forName(className).newInstance();
                dict.__setitem__(name, connector);
                Py.writeComment("zxJDBC", "loaded connector [" + className + "] as [" + name + "]");
            }
            catch (Throwable t) {
                Py.writeComment("zxJDBC", "failed to load connector [" + name + "] using class [" + className + "]");
            }
        }
    }

    protected static void _buildExceptions(PyObject dict) {
        Error = zxJDBC.buildClass("Error", Py.StandardError);
        Warning = zxJDBC.buildClass("Warning", Py.StandardError);
        InterfaceError = zxJDBC.buildClass("InterfaceError", Error);
        DatabaseError = zxJDBC.buildClass("DatabaseError", Error);
        InternalError = zxJDBC.buildClass("InternalError", DatabaseError);
        OperationalError = zxJDBC.buildClass("OperationalError", DatabaseError);
        ProgrammingError = zxJDBC.buildClass("ProgrammingError", DatabaseError);
        IntegrityError = zxJDBC.buildClass("IntegrityError", DatabaseError);
        DataError = zxJDBC.buildClass("DataError", DatabaseError);
        NotSupportedError = zxJDBC.buildClass("NotSupportedError", DatabaseError);
    }

    public static String getString(String key) {
        int i = 0;
        ArrayList<String> lines = null;
        String resource = null;
        try {
            while (true) {
                resource = resourceBundle.getString(key + "." + i++);
                if (lines == null) {
                    lines = new ArrayList<String>();
                }
                lines.add(resource);
            }
        }
        catch (MissingResourceException e) {
            if (lines == null || lines.size() == 0) {
                try {
                    resource = resourceBundle.getString(key);
                }
                catch (MissingResourceException e2) {
                    return key;
                }
            } else {
                String sep = System.getProperty("line.separator");
                StringBuffer sb = new StringBuffer();
                for (i = 0; i < lines.size() - 1; ++i) {
                    sb.append(lines.get(i)).append(sep);
                }
                sb.append(lines.get(lines.size() - 1));
                resource = sb.toString();
            }
            return resource;
        }
    }

    public static String getString(String key, Object[] values) {
        String format = zxJDBC.getString(key);
        return MessageFormat.format(format, values);
    }

    public static PyException makeException(String msg) {
        return zxJDBC.makeException(Error, msg);
    }

    public static PyException makeException(PyObject type, String msg) {
        return Py.makeException(type, Py.newString(msg == null ? "" : msg));
    }

    public static PyException makeException(Throwable throwable) {
        String state;
        PyObject type = Error;
        if (throwable instanceof SQLException && (state = ((SQLException)throwable).getSQLState()) != null && state.length() == 5) {
            if (state.startsWith("23")) {
                type = IntegrityError;
            } else if (state.equals("40002")) {
                type = IntegrityError;
            }
        }
        return zxJDBC.makeException(type, throwable);
    }

    public static PyException makeException(PyObject type, Throwable t) {
        return zxJDBC.makeException(type, t, -1);
    }

    public static PyException makeException(PyObject type, Throwable t, int rowIndex) {
        if (Options.showJavaExceptions) {
            CharArrayWriter buf = new CharArrayWriter();
            PrintWriter writer = new PrintWriter(buf);
            writer.println("Java Traceback:");
            if (t instanceof PyException) {
                ((PyException)t).super__printStackTrace(writer);
            } else {
                t.printStackTrace(writer);
            }
            Py.stderr.print(buf.toString());
        }
        if (t instanceof PyException) {
            return (PyException)t;
        }
        if (t instanceof SQLException) {
            SQLException sqlException = (SQLException)t;
            StringBuffer buffer = new StringBuffer();
            do {
                buffer.append(sqlException.getMessage());
                buffer.append(" [SQLCode: " + sqlException.getErrorCode() + "]");
                if (sqlException.getSQLState() != null) {
                    buffer.append(", [SQLState: " + sqlException.getSQLState() + "]");
                }
                if (rowIndex >= 0) {
                    buffer.append(", [Row number: " + rowIndex + "]");
                }
                if ((sqlException = sqlException.getNextException()) == null) continue;
                buffer.append(System.getProperty("line.separator"));
            } while (sqlException != null);
            return zxJDBC.makeException(type, buffer.toString());
        }
        return zxJDBC.makeException(type, t.getMessage());
    }

    protected static PyObject buildClass(String classname, PyObject superclass) {
        PyStringMap dict = new PyStringMap();
        ((PyObject)dict).__setitem__("__doc__", (PyObject)Py.newString(zxJDBC.getString(classname)));
        ((PyObject)dict).__setitem__("__module__", (PyObject)Py.newString("zxJDBC"));
        return Py.makeClass(classname, superclass, (PyObject)dict);
    }

    static {
        try {
            resourceBundle = ResourceBundle.getBundle("com.ziclix.python.sql.resource.zxJDBCMessages");
        }
        catch (MissingResourceException e) {
            throw new RuntimeException("missing zxjdbc resource bundle");
        }
    }
}

