/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyStaticMethod$PyExposer;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="staticmethod", doc="staticmethod(function) -> method\n\nConvert a function to be a static method.\n\nA static method does not receive an implicit first argument.\nTo declare a static method, use this idiom:\n\n     class C:\n     def f(arg1, arg2, ...): ...\n     f = staticmethod(f)\n\nIt can be called either on the class (e.g. C.f()) or on an instance\n(e.g. C().f()).  The instance is ignored except for its class.\n\nStatic methods in Python are similar to those found in Java or C++.\nFor a more advanced concept, see the classmethod builtin.")
public class PyStaticMethod
extends PyObject {
    public static final PyType TYPE;
    protected PyObject callable;

    public PyStaticMethod(PyObject callable) {
        super(TYPE);
        this.callable = callable;
    }

    @ExposedNew
    static final PyObject staticmethod_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        if (keywords.length != 0) {
            throw Py.TypeError("staticmethod does not accept keyword arguments");
        }
        if (args.length != 1) {
            throw Py.TypeError("staticmethod expected 1 argument, got " + args.length);
        }
        return new PyStaticMethod(args[0]);
    }

    @Override
    public PyObject __get__(PyObject obj, PyObject type) {
        return this.staticmethod___get__(obj, type);
    }

    final PyObject staticmethod___get__(PyObject obj, PyObject type) {
        return this.callable;
    }

    static {
        PyType.addBuilder(PyStaticMethod.class, new PyStaticMethod$PyExposer());
        TYPE = PyType.fromClass(PyStaticMethod.class);
    }
}

