/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.sre;

import java.util.ArrayList;
import org.python.core.ArgParser;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyBuffer;
import org.python.core.PyCallIter;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.imp;
import org.python.core.util.StringUtil;
import org.python.modules.sre.MatchObject;
import org.python.modules.sre.SRE_STATE;
import org.python.modules.sre.ScannerObject;

public class PatternObject
extends PyObject {
    int[] code;
    public PyString pattern;
    public int groups;
    public PyObject groupindex;
    public int flags;
    PyObject indexgroup;
    public int codesize;

    public PatternObject(PyString pattern, int flags, int[] code, int groups, PyObject groupindex, PyObject indexgroup) {
        if (pattern != null) {
            this.pattern = pattern;
        }
        this.flags = flags;
        this.code = code;
        this.codesize = code.length;
        this.groups = groups;
        this.groupindex = groupindex;
        this.indexgroup = indexgroup;
    }

    public MatchObject match(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("search", args, kws, "pattern", "pos", "endpos");
        PyString string = PatternObject.extractPyString(ap, 0);
        int start = ap.getInt(1, 0);
        int end = ap.getInt(2, string.__len__());
        SRE_STATE state = new SRE_STATE(string, start, end, this.flags);
        state.ptr = state.start;
        int status = state.SRE_MATCH(this.code, 0, 1);
        return this._pattern_new_match(state, string, status);
    }

    public MatchObject search(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("search", args, kws, "pattern", "pos", "endpos");
        PyString string = PatternObject.extractPyString(ap, 0);
        int start = ap.getInt(1, 0);
        int end = ap.getInt(2, string.__len__());
        SRE_STATE state = new SRE_STATE(string, start, end, this.flags);
        int status = state.SRE_SEARCH(this.code, 0);
        return this._pattern_new_match(state, string, status);
    }

    public PyObject sub(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("sub", args, kws, "repl", "string", "count");
        PyObject template = ap.getPyObject(0);
        int count2 = ap.getInt(2, 0);
        return this.subx(template, PatternObject.extractPyString(ap, 1), count2, false);
    }

    public PyObject subn(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("subn", args, kws, "repl", "string", "count");
        PyObject template = ap.getPyObject(0);
        int count2 = ap.getInt(2, 0);
        return this.subx(template, PatternObject.extractPyString(ap, 1), count2, true);
    }

    private PyObject subx(PyObject template, PyString instring, int count2, boolean subn) {
        PyString string = instring;
        PyObject filter = null;
        boolean filter_is_callable = false;
        if (template.isCallable()) {
            filter = template;
            filter_is_callable = true;
        } else {
            boolean literal = false;
            if (template instanceof PyString) {
                boolean bl = literal = template.toString().indexOf(92) < 0;
            }
            if (literal) {
                filter = template;
                filter_is_callable = false;
            } else {
                filter = this.call("re", "_subx", new PyObject[]{this, template});
                filter_is_callable = filter.isCallable();
            }
        }
        SRE_STATE state = new SRE_STATE(string, 0, Integer.MAX_VALUE, this.flags);
        PyList list = new PyList();
        int n = 0;
        int i = 0;
        while (count2 == 0 || n < count2) {
            state.state_reset();
            state.ptr = state.start;
            int status = state.SRE_SEARCH(this.code, 0);
            if (status <= 0) {
                if (status == 0) break;
                this._error(status);
            }
            int b = state.start;
            int e = state.ptr;
            if (i < b) {
                list.append(string.__getslice__(Py.newInteger(i), Py.newInteger(b)));
            }
            if (i != b || i != e || n <= 0) {
                PyObject pyObject;
                if (filter_is_callable) {
                    MatchObject matchObject = this._pattern_new_match(state, instring, 1);
                    PyObject match = filter.__call__(matchObject);
                } else {
                    pyObject = filter;
                }
                if (pyObject != Py.None) {
                    list.append(pyObject);
                }
                i = e;
                ++n;
            }
            if (state.ptr == state.start) {
                state.start = state.ptr + 1;
                continue;
            }
            state.start = state.ptr;
        }
        if (i < state.endpos) {
            list.append(string.__getslice__(Py.newInteger(i), Py.newInteger(state.endpos)));
        }
        PyObject outstring = this.join_list(list, string);
        if (subn) {
            return new PyTuple(outstring, Py.newInteger(n));
        }
        return outstring;
    }

    private PyObject join_list(PyList list, PyString string) {
        PyObject joiner = string.__getslice__(Py.Zero, Py.Zero);
        if (list.size() == 0) {
            return joiner;
        }
        return joiner.__getattr__("join").__call__(list);
    }

    public PyObject split(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("split", args, kws, "source", "maxsplit");
        PyString string = PatternObject.extractPyString(ap, 0);
        int maxsplit = ap.getInt(1, 0);
        SRE_STATE state = new SRE_STATE(string, 0, Integer.MAX_VALUE, this.flags);
        PyList list = new PyList();
        int n = 0;
        int last = state.start;
        while (maxsplit == 0 || n < maxsplit) {
            state.state_reset();
            state.ptr = state.start;
            int status = state.SRE_SEARCH(this.code, 0);
            if (status <= 0) {
                if (status == 0) break;
                this._error(status);
            }
            if (state.start == state.ptr) {
                if (last == state.end) break;
                state.start = state.ptr + 1;
                continue;
            }
            PyObject item = string.__getslice__(Py.newInteger(last), Py.newInteger(state.start));
            list.append(item);
            for (int i = 0; i < this.groups; ++i) {
                String s = state.getslice(i + 1, string.toString(), false);
                if (s != null) {
                    list.append(string.createInstance(s));
                    continue;
                }
                list.append(Py.None);
            }
            ++n;
            last = state.start = state.ptr;
        }
        list.append(string.__getslice__(Py.newInteger(last), Py.newInteger(state.endpos)));
        return list;
    }

    private PyObject call(String module, String function, PyObject[] args) {
        PyObject sre = imp.importName(module, true);
        return sre.invoke(function, args);
    }

    public PyObject findall(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("findall", args, kws, "source", "pos", "endpos");
        PyString string = PatternObject.extractPyString(ap, 0);
        int start = ap.getInt(1, 0);
        int end = ap.getInt(2, Integer.MAX_VALUE);
        SRE_STATE state = new SRE_STATE(string, start, end, this.flags);
        ArrayList<PyObject> list = new ArrayList<PyObject>();
        while (state.start <= state.end) {
            state.state_reset();
            state.ptr = state.start;
            int status = state.SRE_SEARCH(this.code, 0);
            if (status > 0) {
                PyObject item;
                switch (this.groups) {
                    case 0: {
                        item = string.__getslice__(Py.newInteger(state.start), Py.newInteger(state.ptr));
                        break;
                    }
                    case 1: {
                        item = string.createInstance(state.getslice(1, string.toString(), true));
                        break;
                    }
                    default: {
                        PyObject[] t = new PyObject[this.groups];
                        for (int i = 0; i < this.groups; ++i) {
                            t[i] = string.createInstance(state.getslice(i + 1, string.toString(), true));
                        }
                        item = new PyTuple(t);
                    }
                }
                list.add(item);
                if (state.ptr == state.start) {
                    state.start = state.ptr + 1;
                    continue;
                }
                state.start = state.ptr;
                continue;
            }
            if (status == 0) break;
            this._error(status);
        }
        return new PyList(list);
    }

    public PyObject finditer(PyObject[] args, String[] kws) {
        ScannerObject scanner = this.scanner(args, kws);
        PyObject search = scanner.__findattr__("search");
        return new PyCallIter(search, Py.None);
    }

    public ScannerObject scanner(PyObject[] args, String[] kws) {
        ArgParser ap = new ArgParser("scanner", args, kws, "pattern", "pos", "endpos");
        PyString string = PatternObject.extractPyString(ap, 0);
        ScannerObject self = new ScannerObject();
        self.state = new SRE_STATE(string, ap.getInt(1, 0), ap.getInt(2, Integer.MAX_VALUE), this.flags);
        self.pattern = this;
        self.string = string;
        return self;
    }

    private void _error(int status) {
        if (status == -3) {
            throw Py.RuntimeError("maximum recursion limit exceeded");
        }
        throw Py.RuntimeError("internal error in regular expression engine");
    }

    /*
     * WARNING - void declaration
     */
    MatchObject _pattern_new_match(SRE_STATE state, PyString string, int status) {
        if (status > 0) {
            MatchObject match = new MatchObject();
            match.pattern = this;
            match.string = string;
            match.regs = null;
            match.groups = this.groups + 1;
            int base = state.beginning;
            match.mark = new int[match.groups * 2];
            match.mark[0] = state.start - base;
            match.mark[1] = state.ptr - base;
            int n = 0;
            int j = 0;
            while (j < this.groups) {
                void i;
                if (i + true <= state.lastmark && state.mark[i] != -1 && state.mark[i + true] != -1) {
                    match.mark[i + 2] = state.mark[i] - base;
                    match.mark[i + 3] = state.mark[i + true] - base;
                } else {
                    match.mark[i + 3] = -1;
                    match.mark[i + 2] = -1;
                }
                ++j;
                i += 2;
            }
            match.pos = state.pos;
            match.endpos = state.endpos;
            match.lastindex = state.lastindex;
            return match;
        }
        if (status == 0) {
            return null;
        }
        this._error(status);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PyString extractPyString(ArgParser ap, int pos) {
        PyObject obj = ap.getPyObject(pos);
        if (obj instanceof PyString) {
            return (PyString)obj;
        }
        if (obj instanceof BufferProtocol) {
            PyBuffer buf = null;
            try {
                buf = ((BufferProtocol)((Object)obj)).getBuffer(0);
                String s = StringUtil.fromBytes(buf);
                PyString pyString = new PyString(s);
                return pyString;
            }
            catch (Exception exception) {
            }
            finally {
                if (buf != null) {
                    buf.release();
                }
            }
        } else if (obj instanceof PyArray) {
            return new PyString(obj.toString());
        }
        throw Py.TypeError("expected string or buffer, but got " + obj.getType());
    }
}

