/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jnr.ffi.CallingConvention;
import jnr.ffi.Library;
import jnr.ffi.LibraryOption;
import jnr.ffi.Memory;
import jnr.ffi.NativeLong;
import jnr.ffi.Platform;
import jnr.ffi.Pointer;
import jnr.ffi.Runtime;
import jnr.ffi.Struct;
import jnr.ffi.annotations.Direct;
import jnr.netdb.Protocol;
import jnr.netdb.ProtocolsDB;
import jnr.netdb.StringUtil;

abstract class NativeProtocolsDB
implements ProtocolsDB {
    NativeProtocolsDB() {
    }

    public static final NativeProtocolsDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private static final NativeProtocolsDB load() {
        try {
            LibProto libnames;
            Object lib;
            Platform.OS os2 = Platform.getNativePlatform().getOS();
            if (!(os2.equals((Object)Platform.OS.DARWIN) || os2.equals((Object)Platform.OS.WINDOWS) && Platform.getNativePlatform().getCPU() == Platform.CPU.I386 || os2.equals((Object)Platform.OS.LINUX) || os2.equals((Object)Platform.OS.SOLARIS) || os2.equals((Object)Platform.OS.FREEBSD) || os2.equals((Object)Platform.OS.NETBSD))) {
                return null;
            }
            if (os2.equals((Object)Platform.OS.WINDOWS)) {
                HashMap<LibraryOption, CallingConvention> hashMap = new HashMap<LibraryOption, CallingConvention>();
                hashMap.put(LibraryOption.CallingConvention, CallingConvention.STDCALL);
                LibProto options = Library.loadLibrary(LibProto.class, hashMap, "Ws2_32");
            } else {
                String[] stringArray;
                if (os2.equals((Object)Platform.OS.SOLARIS)) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = "socket";
                    stringArray2[1] = "nsl";
                    stringArray = stringArray2;
                    stringArray2[2] = "c";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "c";
                }
                lib = stringArray;
                libnames = os2.equals((Object)Platform.OS.LINUX) ? (LibProto)Library.loadLibrary(LinuxLibProto.class, (String[])lib) : Library.loadLibrary(LibProto.class, (String[])lib);
            }
            lib = os2.equals((Object)Platform.OS.LINUX) ? new LinuxNativeProtocolsDB((LinuxLibProto)libnames) : new DefaultNativeProtocolsDB(libnames);
            lib.getProtocolByName("ip");
            lib.getProtocolByNumber(0);
            return lib;
        }
        catch (Throwable t) {
            Logger.getLogger(NativeProtocolsDB.class.getName()).log(Level.WARNING, "Failed to load native protocols db", t);
            return null;
        }
    }

    static Protocol protocolFromNative(UnixProtoent p) {
        if (p == null) {
            return null;
        }
        List emptyAliases = Collections.emptyList();
        Pointer ptr = p.aliases.get();
        List<String> aliases = ptr != null ? StringUtil.getNullTerminatedStringArray(ptr) : emptyAliases;
        return new Protocol(p.name.get(), (short)p.proto.get(), aliases);
    }

    static /* synthetic */ NativeProtocolsDB access$000() {
        return NativeProtocolsDB.load();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LinuxNativeProtocolsDB
    extends NativeProtocolsDB {
        private static final int BUFLEN = 4096;
        private final Runtime runtime;
        private final Pointer buf;
        private final LinuxLibProto lib;

        LinuxNativeProtocolsDB(LinuxLibProto lib) {
            this.lib = lib;
            this.runtime = Library.getRuntime(lib);
            this.buf = Memory.allocateDirect(this.runtime, 4096);
        }

        @Override
        public synchronized Protocol getProtocolByName(String name) {
            UnixProtoent protoent = new UnixProtoent(this.runtime);
            Pointer result = Memory.allocateDirect(this.runtime, this.runtime.addressSize());
            if (this.lib.getprotobyname_r(name, protoent, this.buf, new NativeLong(4096), result) == 0) {
                return result.getPointer(0L) != null ? LinuxNativeProtocolsDB.protocolFromNative(protoent) : null;
            }
            throw new RuntimeException("getprotobyname_r failed");
        }

        @Override
        public synchronized Protocol getProtocolByNumber(Integer number) {
            UnixProtoent protoent = new UnixProtoent(this.runtime);
            Pointer result = Memory.allocateDirect(this.runtime, this.runtime.addressSize());
            if (this.lib.getprotobynumber_r(number, protoent, this.buf, new NativeLong(4096), result) == 0) {
                return result.getPointer(0L) != null ? LinuxNativeProtocolsDB.protocolFromNative(protoent) : null;
            }
            throw new RuntimeException("getprotobynumber_r failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized Collection<Protocol> getAllProtocols() {
            UnixProtoent p = new UnixProtoent(this.runtime);
            ArrayList<Protocol> allProtocols = new ArrayList<Protocol>();
            Pointer result = Memory.allocateDirect(this.runtime, this.runtime.addressSize());
            NativeLong buflen = new NativeLong(4096);
            this.lib.setprotoent(0);
            try {
                while (this.lib.getprotoent_r(p, this.buf, buflen, result) == 0 && result.getPointer(0L) != null) {
                    allProtocols.add(LinuxNativeProtocolsDB.protocolFromNative(p));
                }
            }
            finally {
                this.lib.endprotoent();
            }
            return allProtocols;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DefaultNativeProtocolsDB
    extends NativeProtocolsDB {
        private final LibProto lib;

        DefaultNativeProtocolsDB(LibProto lib) {
            this.lib = lib;
        }

        @Override
        public synchronized Protocol getProtocolByName(String name) {
            return DefaultNativeProtocolsDB.protocolFromNative(this.lib.getprotobyname(name));
        }

        @Override
        public synchronized Protocol getProtocolByNumber(Integer proto) {
            return DefaultNativeProtocolsDB.protocolFromNative(this.lib.getprotobynumber(proto));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public synchronized Collection<Protocol> getAllProtocols() {
            void p;
            ArrayList arrayList = new ArrayList();
            this.lib.setprotoent(0);
            try {
                UnixProtoent allProtocols;
                while ((allProtocols = this.lib.getprotoent()) != null) {
                    p.add(DefaultNativeProtocolsDB.protocolFromNative(allProtocols));
                }
            }
            finally {
                this.lib.endprotoent();
            }
            return p;
        }
    }

    public static interface LinuxLibProto
    extends LibProto {
        public int getprotobyname_r(String var1, @Direct UnixProtoent var2, Pointer var3, NativeLong var4, Pointer var5);

        public int getprotobynumber_r(int var1, @Direct UnixProtoent var2, Pointer var3, NativeLong var4, Pointer var5);

        public int getprotoent_r(@Direct UnixProtoent var1, Pointer var2, NativeLong var3, Pointer var4);
    }

    public static interface LibProto {
        public UnixProtoent getprotobyname(String var1);

        public UnixProtoent getprotobynumber(int var1);

        public UnixProtoent getprotoent();

        public void setprotoent(int var1);

        public void endprotoent();
    }

    public static class UnixProtoent
    extends Struct {
        public final Struct.String name = new Struct.UTF8StringRef();
        public final Struct.Pointer aliases = new Struct.Pointer();
        public final Struct.Signed32 proto = new Struct.Signed32();

        public UnixProtoent(Runtime runtime) {
            super(runtime);
        }
    }

    private static final class SingletonHolder {
        public static final NativeProtocolsDB INSTANCE = NativeProtocolsDB.access$000();

        private SingletonHolder() {
        }
    }
}

