/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Function;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.Platform;
import org.python.modules.jffi.AbstractNumericMethodGenerator;
import org.python.modules.jffi.JITSignature;
import org.python.modules.jffi.NativeType;

final class FastNumericMethodGenerator
extends AbstractNumericMethodGenerator {
    private static final int MAX_PARAMETERS = FastNumericMethodGenerator.getMaximumFastNumericParameters();
    private static final String[] signatures = FastNumericMethodGenerator.buildSignatures(Long.TYPE, MAX_PARAMETERS);
    private static final String[] methodNames = new String[]{"invokeVrN", "invokeNrN", "invokeNNrN", "invokeNNNrN", "invokeNNNNrN", "invokeNNNNNrN", "invokeNNNNNNrN"};

    FastNumericMethodGenerator() {
    }

    @Override
    String getInvokerMethodName(JITSignature signature) {
        int parameterCount = signature.getParameterCount();
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= methodNames.length) {
            return methodNames[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-long parameter count: " + parameterCount);
    }

    @Override
    String getInvokerSignature(int parameterCount) {
        if (parameterCount <= MAX_PARAMETERS && parameterCount <= signatures.length) {
            return signatures[parameterCount];
        }
        throw new IllegalArgumentException("invalid fast-long parameter count: " + parameterCount);
    }

    @Override
    final Class getInvokerIntType() {
        return Long.TYPE;
    }

    @Override
    public boolean isSupported(JITSignature signature) {
        int parameterCount = signature.getParameterCount();
        if (!signature.getCallingConvention().equals((Object)CallingConvention.DEFAULT) || parameterCount > MAX_PARAMETERS) {
            return false;
        }
        Platform platform2 = Platform.getPlatform();
        if (platform2.getOS().equals((Object)Platform.OS.WINDOWS)) {
            return false;
        }
        if (!platform2.getCPU().equals((Object)Platform.CPU.I386) && !platform2.getCPU().equals((Object)Platform.CPU.X86_64)) {
            return false;
        }
        for (int i = 0; i < parameterCount; ++i) {
            if (FastNumericMethodGenerator.isFastNumericParameter(platform2, signature.getParameterType(i))) continue;
            return false;
        }
        return FastNumericMethodGenerator.isFastNumericResult(platform2, signature.getResultType());
    }

    static final int getMaximumFastNumericParameters() {
        try {
            Invoker.class.getDeclaredMethod("invokeNNNNNNrN", Function.class, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE);
            return 6;
        }
        catch (Throwable t) {
            return -1;
        }
    }

    private static boolean isFastNumericType(Platform platform2, NativeType type) {
        switch (type) {
            case BOOL: 
            case BYTE: 
            case UBYTE: 
            case SHORT: 
            case USHORT: 
            case INT: 
            case UINT: 
            case LONG: 
            case ULONG: 
            case LONGLONG: 
            case ULONGLONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    static boolean isFastNumericResult(Platform platform2, NativeType type) {
        switch (type) {
            case VOID: 
            case POINTER: 
            case STRING: {
                return true;
            }
        }
        return FastNumericMethodGenerator.isFastNumericType(platform2, type);
    }

    static boolean isFastNumericParameter(Platform platform2, NativeType type) {
        switch (type) {
            case POINTER: 
            case BUFFER_IN: 
            case BUFFER_OUT: 
            case BUFFER_INOUT: {
                return true;
            }
        }
        return FastNumericMethodGenerator.isFastNumericType(platform2, type);
    }
}

