/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.packagecache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.python.core.Options;
import org.python.core.packagecache.PackageManager;
import org.python.util.Generic;

public abstract class CachedJarsPackageManager
extends PackageManager {
    protected static Logger logger = Logger.getLogger("org.python.import");
    private boolean indexModified;
    private Map<String, JarXEntry> index;
    private File cachedir;

    protected void message(String msg2, Object ... params) {
    }

    protected void warning(String msg2, Object ... params) {
    }

    protected void comment(String msg2, Object ... params) {
    }

    protected void debug(String msg2, Object ... params) {
    }

    protected boolean filterByName(String name, boolean pkg) {
        return name.indexOf(36) != -1;
    }

    protected boolean filterByAccess(String name, int acc) {
        return (acc & 1) != 1;
    }

    private void addZipEntry(Map<String, ClassList> zipPackages, ZipEntry entry, ZipInputStream zip) throws IOException {
        String name = entry.getName();
        if (name.endsWith(".class")) {
            String className;
            char sep = '/';
            int slash = name.lastIndexOf(sep);
            if (slash == -1 && (slash = name.lastIndexOf(92)) >= 0) {
                sep = '\\';
            }
            if (!this.filterByName(className = name.substring(slash + 1, name.length() - 6), false)) {
                int access;
                String packageName = slash == -1 ? "" : name.substring(0, slash).replace(sep, '.');
                ClassList classes = zipPackages.get(packageName);
                if (classes == null) {
                    classes = new ClassList();
                    zipPackages.put(packageName, classes);
                }
                if ((access = CachedJarsPackageManager.checkAccess(zip)) != -1 && !this.filterByAccess(name, access)) {
                    classes.accessible.add(className);
                } else {
                    classes.inaccessible.add(className);
                }
            }
        }
    }

    private Map<String, String> getZipPackages(InputStream jarin) throws IOException {
        ZipEntry entry;
        Map<String, ClassList> zipPackages = Generic.map();
        ZipInputStream zip = new ZipInputStream(jarin);
        while ((entry = zip.getNextEntry()) != null) {
            this.addZipEntry(zipPackages, entry, zip);
            zip.closeEntry();
        }
        Map<String, String> transformed = Generic.map();
        for (Map.Entry kv : zipPackages.entrySet()) {
            transformed.put((String)kv.getKey(), ((ClassList)kv.getValue()).toString());
        }
        return transformed;
    }

    public void addJarToPackages(URL jarurl) {
        this.addJarToPackages(jarurl, null, false);
    }

    public void addJarToPackages(URL jarurl, boolean cache) {
        this.addJarToPackages(jarurl, null, cache);
    }

    public void addJarToPackages(File jarfile) {
        this.addJarToPackages(null, jarfile, false);
    }

    public void addJarToPackages(File jarfile, boolean cache) {
        this.addJarToPackages(null, jarfile, cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addJarToPackages(URL jarurl, File jarfile, boolean writeCache) {
        try {
            boolean readCache = this.index != null;
            writeCache &= readCache;
            URLConnection jarconn = null;
            boolean localfile = true;
            if (jarfile == null) {
                jarconn = jarurl.openConnection();
                if (jarconn.getURL().getProtocol().equals("file")) {
                    String jarfilename = jarurl.getFile();
                    jarfilename = jarfilename.replace('/', File.separatorChar);
                    jarfile = new File(jarfilename);
                } else {
                    localfile = false;
                }
            }
            if (localfile && !jarfile.exists()) {
                return;
            }
            Map<String, String> zipPackages = null;
            long mtime = 0L;
            String jarcanon = null;
            JarXEntry entry = null;
            boolean brandNew = false;
            if (readCache) {
                if (localfile) {
                    mtime = jarfile.lastModified();
                    jarcanon = jarfile.getCanonicalPath();
                } else {
                    mtime = jarconn.getLastModified();
                    jarcanon = jarurl.toString();
                }
                entry = this.index.get(jarcanon);
                if (writeCache && (entry == null || !new File(entry.cachefile).exists())) {
                    String jarname;
                    this.comment("processing new jar ''{0}''", jarcanon);
                    if (localfile) {
                        jarname = jarfile.getName();
                    } else {
                        jarname = jarurl.getFile();
                        int slash = jarname.lastIndexOf(47);
                        if (slash != -1) {
                            jarname = jarname.substring(slash + 1);
                        }
                    }
                    jarname = jarname.substring(0, jarname.length() - 4);
                    entry = new JarXEntry(jarname);
                    this.index.put(jarcanon, entry);
                    brandNew = true;
                }
                if (entry != null && mtime != 0L && entry.mtime == mtime) {
                    zipPackages = this.readCacheFile(entry, jarcanon);
                }
            }
            if (zipPackages == null) {
                if (writeCache) {
                    this.indexModified = true;
                    if (entry.mtime != 0L) {
                        this.comment("processing modified jar ''{0}''", jarcanon);
                    }
                    entry.mtime = mtime;
                }
                try (InputStream jarin = null;){
                    jarin = jarconn == null ? new BufferedInputStream(new FileInputStream(jarfile)) : jarconn.getInputStream();
                    zipPackages = this.getZipPackages(jarin);
                }
                if (writeCache) {
                    this.writeCacheFile(entry, jarcanon, zipPackages, brandNew);
                }
            }
            this.addPackages(zipPackages, jarcanon);
        }
        catch (IOException ioe) {
            this.warning("skipping bad jar ''{0}''", (jarfile != null ? jarfile : jarurl).toString());
        }
    }

    private void addPackages(Map<String, String> packageToClasses, String jarfile) {
        for (Map.Entry<String, String> entry : packageToClasses.entrySet()) {
            String pkg = entry.getKey();
            String classes = entry.getValue();
            int idx = classes.indexOf(64);
            if (idx >= 0 && Options.respectJavaAccessibility) {
                classes = classes.substring(0, idx);
            }
            this.makeJavaPackage(pkg, classes, jarfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> readCacheFile(JarXEntry entry, String jarcanon) {
        String cachefile = entry.cachefile;
        long mtime = entry.mtime;
        this.debug("reading cache of ''{0}''", jarcanon);
        DataInputStream istream = null;
        try {
            istream = this.inOpenCacheFile(cachefile);
            String old_jarcanon = istream.readUTF();
            long old_mtime = istream.readLong();
            if (!old_jarcanon.equals(jarcanon) || old_mtime != mtime) {
                this.comment("invalid cache file: {0} for new:{1}({3}), old:{2}({4})", cachefile, jarcanon, old_jarcanon, mtime, old_mtime);
                this.deleteCacheFile(cachefile);
                Map<String, String> map = null;
                return map;
            }
            Map<String, String> packs = Generic.map();
            try {
                while (true) {
                    String packageName = istream.readUTF();
                    String classes = istream.readUTF();
                    if (packs.containsKey(packageName)) {
                        classes = packs.get(packageName) + classes;
                    }
                    packs.put(packageName, classes);
                }
            }
            catch (EOFException eOFException) {
                Map<String, String> map = packs;
                return map;
            }
        }
        catch (IOException ioe) {
            Map<String, String> map = null;
            return map;
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCacheFile(JarXEntry entry, String jarcanon, Map<String, String> zipPackages, boolean brandNew) {
        DataOutputStream ostream = null;
        try {
            ostream = this.outCreateCacheFile(entry, brandNew);
            ostream.writeUTF(jarcanon);
            ostream.writeLong(entry.mtime);
            this.comment("rewriting cache for ''{0}''", jarcanon);
            for (Map.Entry<String, String> kv : zipPackages.entrySet()) {
                String classes = kv.getValue();
                for (String part : CachedJarsPackageManager.splitString(classes, 65535)) {
                    ostream.writeUTF(kv.getKey());
                    ostream.writeUTF(part);
                }
            }
        }
        catch (IOException ioe) {
            this.warning("failed to write cache for ''{0}'' ({1})", jarcanon, ioe.getMessage());
        }
        finally {
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void addModuleToPackages(Path modulePath) {
        try {
            this.comment("reading packages from ''{0}''", modulePath);
            Map<String, String> packages = this.getModularPackages(modulePath);
            this.addPackages(packages, modulePath.toUri().toString());
        }
        catch (IOException ioe) {
            this.warning("skipping bad module ''{0}'' ({1})", modulePath, ioe.getMessage());
        }
    }

    private Map<String, String> getModularPackages(Path modulePath) throws IOException {
        final int M = modulePath.getNameCount();
        final Map modPackages = Generic.map();
        SimpleFileVisitor<Path> visitor2 = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String className;
                int n = file.getNameCount();
                String fileName = file.getFileName().toString();
                if (fileName.endsWith(".class") && n > M + 1 && !CachedJarsPackageManager.this.filterByName(className = fileName.substring(0, fileName.length() - 6), false)) {
                    String packageName = file.subpath(M, n - 1).toString().replace('/', '.');
                    ClassList classes = (ClassList)modPackages.get(packageName);
                    if (classes == null) {
                        classes = new ClassList();
                        modPackages.put(packageName, classes);
                    }
                    try (InputStream c = Files.newInputStream(file, StandardOpenOption.READ);){
                        int access = PackageManager.checkAccess(c);
                        if (access != -1 && !CachedJarsPackageManager.this.filterByAccess(fileName, access)) {
                            classes.accessible.add(className);
                        } else {
                            classes.inaccessible.add(className);
                        }
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        };
        Files.walkFileTree(modulePath, (FileVisitor<? super Path>)visitor2);
        Map<String, String> transformed = Generic.map();
        for (Map.Entry kv : modPackages.entrySet()) {
            transformed.put((String)kv.getKey(), ((ClassList)kv.getValue()).toString());
        }
        return transformed;
    }

    protected static String[] splitString(String str, int maxLength) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len <= maxLength) {
            return new String[]{str};
        }
        int chunkCount = (int)Math.ceil((float)len / (float)maxLength);
        String[] chunks = new String[chunkCount];
        for (int i = 0; i < chunkCount; ++i) {
            chunks[i] = str.substring(i * maxLength, Math.min(i * maxLength + maxLength, len));
        }
        return chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initCache() {
        this.indexModified = false;
        this.index = Generic.map();
        DataInputStream istream = null;
        try {
            istream = this.inOpenIndex();
            if (istream == null) {
                return;
            }
            try {
                while (true) {
                    String jarcanon2 = istream.readUTF();
                    String cachefile = istream.readUTF();
                    long mtime = istream.readLong();
                    this.index.put(jarcanon2, new JarXEntry(cachefile, mtime));
                }
            }
            catch (EOFException jarcanon2) {
                if (istream != null) {
                    try {
                        istream.close();
                    }
                    catch (IOException jarcanon2) {}
                }
            }
        }
        catch (IOException ioe) {
            this.warning("invalid index file", new Object[0]);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCache() {
        if (this.index == null || !this.indexModified) {
            return;
        }
        this.indexModified = false;
        this.comment("writing modified index file", new Object[0]);
        DataOutputStream ostream = null;
        try {
            ostream = this.outOpenIndex();
            for (Map.Entry<String, JarXEntry> entry : this.index.entrySet()) {
                String jarcanon = entry.getKey();
                JarXEntry xentry = entry.getValue();
                ostream.writeUTF(jarcanon);
                ostream.writeUTF(xentry.cachefile);
                ostream.writeLong(xentry.mtime);
            }
        }
        catch (IOException ioe) {
            this.warning("failed to write index file ({0})", ioe.getMessage());
        }
        finally {
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected DataInputStream inOpenIndex() throws IOException {
        File indexFile = new File(this.cachedir, "packages.idx");
        if (!indexFile.exists()) {
            return null;
        }
        FileInputStream istream = new FileInputStream(indexFile);
        return new DataInputStream(new BufferedInputStream(istream));
    }

    protected DataOutputStream outOpenIndex() throws IOException {
        File indexFile = new File(this.cachedir, "packages.idx");
        FileOutputStream ostream = new FileOutputStream(indexFile);
        return new DataOutputStream(new BufferedOutputStream(ostream));
    }

    protected DataInputStream inOpenCacheFile(String cachefile) throws IOException {
        return new DataInputStream(new BufferedInputStream(new FileInputStream(cachefile)));
    }

    protected void deleteCacheFile(String cachefile) {
        new File(cachefile).delete();
    }

    protected DataOutputStream outCreateCacheFile(JarXEntry entry, boolean create) throws IOException {
        File file;
        if (create) {
            String jarname = entry.cachefile;
            file = new File(this.cachedir, jarname + ".pkc");
            int index = 1;
            while (file.exists()) {
                file = new File(this.cachedir, jarname + "$" + index + ".pkc");
                ++index;
            }
            entry.cachefile = file.getCanonicalPath();
        } else {
            file = new File(entry.cachefile);
        }
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
    }

    protected boolean useCacheDir(File aCachedir1) {
        if (aCachedir1 == null) {
            return false;
        }
        try {
            if (!aCachedir1.isDirectory() && !aCachedir1.mkdirs()) {
                this.warning("failed to create cache dir ''{0}''", aCachedir1);
                return false;
            }
        }
        catch (AccessControlException ace) {
            this.warning("Not permitted to access cache ''{0}'' ({1})", aCachedir1, ace.getMessage());
            return false;
        }
        this.cachedir = aCachedir1;
        return true;
    }

    public static class JarXEntry {
        public String cachefile;
        public long mtime;

        public JarXEntry(String cachefile) {
            this.cachefile = cachefile;
        }

        public JarXEntry(String cachefile, long mtime) {
            this.cachefile = cachefile;
            this.mtime = mtime;
        }
    }

    private static class ClassList {
        List<String> accessible = new ArrayList<String>();
        List<String> inaccessible = new ArrayList<String>();

        private ClassList() {
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            ClassList.appendList(buf, this.accessible);
            if (this.inaccessible.size() > 0) {
                buf.append('@');
                ClassList.appendList(buf, this.inaccessible);
            }
            return buf.toString();
        }

        private static void appendList(StringBuilder buf, List<String> names) {
            if (names.size() > 0) {
                for (String n : names) {
                    buf.append(n).append(',');
                }
                buf.deleteCharAt(buf.length() - 1);
            }
        }
    }
}

