/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import jnr.constants.platform.Errno;
import jnr.posix.util.Platform;
import org.python.core.Py;
import org.python.core.PyString;
import org.python.core.io.RawIOBase;
import org.python.core.util.RelativeFile;
import org.python.modules.posix.PosixModule;

public class FileIO
extends RawIOBase {
    private FileChannel fileChannel;
    private RandomAccessFile file;
    private FileOutputStream fileOutputStream;
    private boolean reading;
    private boolean writing;
    private boolean appending;
    private boolean plus;
    private boolean emulateAppend;

    public FileIO(String name, String mode) {
        this(Py.newString(name), mode);
    }

    public FileIO(PyString name, String mode) {
        this.parseMode(mode);
        RelativeFile absPath = new RelativeFile(name.toString());
        try {
            if (this.appending && !this.reading && !this.plus) {
                this.fromFileOutputStream(absPath);
            } else {
                this.fromRandomAccessFile(absPath);
                this.emulateAppend = this.appending;
            }
        }
        catch (FileNotFoundException fnfe) {
            if (absPath.isDirectory()) {
                throw Py.IOError(Errno.EISDIR, name);
            }
            if (this.writing && !absPath.canWrite() || fnfe.getMessage().endsWith("(Permission denied)")) {
                throw Py.IOError(Errno.EACCES, name);
            }
            throw Py.IOError(Errno.ENOENT, name);
        }
        this.initPosition();
    }

    public FileIO(FileChannel fileChannel, String mode) {
        this.parseMode(mode);
        this.fileChannel = fileChannel;
        this.initPosition();
    }

    private void parseMode(String mode) {
        boolean rwa = false;
        block6: for (int i = 0; i < mode.length(); ++i) {
            switch (mode.charAt(i)) {
                case 'r': {
                    if (this.plus || rwa) {
                        this.badMode();
                    }
                    rwa = true;
                    this.reading = true;
                    continue block6;
                }
                case 'w': {
                    if (this.plus || rwa) {
                        this.badMode();
                    }
                    rwa = true;
                    this.writing = true;
                    continue block6;
                }
                case 'a': {
                    if (this.plus || rwa) {
                        this.badMode();
                    }
                    rwa = true;
                    this.writing = true;
                    this.appending = true;
                    continue block6;
                }
                case '+': {
                    if (this.plus || !rwa) {
                        this.badMode();
                    }
                    this.plus = true;
                    this.writing = true;
                    continue block6;
                }
                default: {
                    throw Py.ValueError("invalid mode: '" + mode + "'");
                }
            }
        }
        if (!rwa) {
            this.badMode();
        }
    }

    private void fromRandomAccessFile(File absPath) throws FileNotFoundException {
        String rafMode = "r" + (this.writing ? "w" : "");
        if (this.plus && this.reading && !absPath.isFile()) {
            this.writing = false;
            throw new FileNotFoundException("");
        }
        this.file = new RandomAccessFile(absPath, rafMode);
        this.fileChannel = this.file.getChannel();
    }

    private void fromFileOutputStream(File absPath) throws FileNotFoundException {
        this.fileOutputStream = new FileOutputStream(absPath, true);
        this.fileChannel = this.fileOutputStream.getChannel();
    }

    private void badMode() {
        throw Py.ValueError("Must have exactly one of read/write/append mode");
    }

    private void initPosition() {
        if (this.appending) {
            this.seek(0L, 2);
        } else if (this.writing && !this.reading) {
            try {
                this.fileChannel.truncate(0L);
            }
            catch (IOException ioe) {
                if (Platform.IS_WINDOWS || (Platform.IS_SOLARIS || Platform.IS_LINUX) && Errno.EINVAL.description().equals(ioe.getMessage())) {
                    return;
                }
                throw Py.IOError(ioe);
            }
        }
    }

    @Override
    public boolean isatty() {
        this.checkClosed();
        if (this.file == null || this.fileOutputStream == null) {
            return false;
        }
        try {
            return PosixModule.getPOSIX().isatty(this.file != null ? this.file.getFD() : this.fileOutputStream.getFD());
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public int readinto(ByteBuffer buf) {
        this.checkClosed();
        this.checkReadable();
        try {
            int n = this.fileChannel.read(buf);
            return n > 0 ? n : 0;
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    @Override
    public long readinto(ByteBuffer[] bufs) {
        this.checkClosed();
        this.checkReadable();
        try {
            long n = this.fileChannel.read(bufs);
            return n > 0L ? n : 0L;
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
    }

    @Override
    public ByteBuffer readall() {
        long toRead;
        this.checkClosed();
        this.checkReadable();
        try {
            toRead = Math.max(0L, this.fileChannel.size() - this.fileChannel.position());
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        if (toRead > Integer.MAX_VALUE) {
            throw Py.OverflowError("requested number of bytes is more than a Python string can hold");
        }
        ByteBuffer all = ByteBuffer.allocate((int)toRead);
        this.readinto(all);
        all.flip();
        return all;
    }

    @Override
    public int write(ByteBuffer buf) {
        this.checkClosed();
        this.checkWritable();
        try {
            return !this.emulateAppend ? this.fileChannel.write(buf) : this.fileChannel.write(buf, this.fileChannel.position());
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    @Override
    public long write(ByteBuffer[] bufs) {
        this.checkClosed();
        this.checkWritable();
        try {
            return !this.emulateAppend ? this.fileChannel.write(bufs) : this.writeAppend(bufs);
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    private long writeAppend(ByteBuffer[] bufs) throws IOException {
        long count2 = 0L;
        for (ByteBuffer byteBuffer : bufs) {
            if (!byteBuffer.hasRemaining()) continue;
            int buf = this.fileChannel.write(byteBuffer, this.fileChannel.position());
            if (buf == 0) break;
            count2 += (long)buf;
        }
        return count2;
    }

    @Override
    public long seek(long pos, int whence) {
        this.checkClosed();
        try {
            switch (whence) {
                case 0: {
                    break;
                }
                case 1: {
                    pos += this.fileChannel.position();
                    break;
                }
                case 2: {
                    pos += this.fileChannel.size();
                    break;
                }
                default: {
                    throw Py.IOError(Errno.EINVAL);
                }
            }
            this.fileChannel.position(pos);
            return pos;
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    @Override
    public long tell() {
        this.checkClosed();
        try {
            return this.fileChannel.position();
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
    }

    @Override
    public long truncate(long size) {
        this.checkClosed();
        this.checkWritable();
        try {
            long oldPosition = this.fileChannel.position();
            this.fileChannel.truncate(size);
            this.fileChannel.position(oldPosition);
        }
        catch (IOException iOException) {
            throw Py.IOError(iOException);
        }
        return size;
    }

    @Override
    public void close() {
        if (this.closed()) {
            return;
        }
        try {
            this.fileChannel.close();
        }
        catch (IOException ioe) {
            throw Py.IOError(ioe);
        }
        super.close();
    }

    @Override
    public OutputStream asOutputStream() {
        return this.writing ? Channels.newOutputStream(this.fileChannel) : super.asOutputStream();
    }

    @Override
    public InputStream asInputStream() {
        return this.readable() ? Channels.newInputStream(this.fileChannel) : super.asInputStream();
    }

    @Override
    public boolean readable() {
        return this.reading || this.plus;
    }

    @Override
    public boolean writable() {
        return this.writing;
    }

    @Override
    public FileChannel getChannel() {
        return this.fileChannel;
    }
}

