/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.io;

import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import org.python.core.Py;
import org.python.core.io.IOBase;

public abstract class RawIOBase
extends IOBase {
    public ByteBuffer read(int size) {
        if (size < 0) {
            return this.readall();
        }
        ByteBuffer buf = ByteBuffer.allocate(size);
        this.readinto(buf);
        buf.flip();
        return buf;
    }

    public ByteBuffer readall() {
        long allCount = 0L;
        int readCount = 0;
        ByteBuffer all = ByteBuffer.allocate(8192);
        ByteBuffer readBuffer = ByteBuffer.allocate(8192);
        while ((readCount = this.readinto(readBuffer)) > 0) {
            if (all.remaining() < readCount) {
                ByteBuffer old = all;
                all = ByteBuffer.allocate(Math.max(old.capacity() * 2, old.position() + readCount));
                old.flip();
                all.put(old);
            }
            readBuffer.flip();
            all.put(readBuffer);
            readBuffer.clear();
        }
        if (allCount > Integer.MAX_VALUE) {
            throw Py.OverflowError("requested number of bytes is more than a Python string can hold");
        }
        all.flip();
        return all;
    }

    public int readinto(ByteBuffer buf) {
        this.unsupported("readinto");
        return -1;
    }

    public long readinto(ByteBuffer[] bufs) {
        long count = 0L;
        for (ByteBuffer byteBuffer : bufs) {
            if (!byteBuffer.hasRemaining()) continue;
            int buf = this.readinto(byteBuffer);
            if (buf == 0) break;
            count += (long)buf;
        }
        return count;
    }

    public int write(ByteBuffer buf) {
        this.unsupported("write");
        return -1;
    }

    public long write(ByteBuffer[] bufs) {
        long count = 0L;
        for (ByteBuffer byteBuffer : bufs) {
            if (!byteBuffer.hasRemaining()) continue;
            int buf = this.write(byteBuffer);
            if (buf == 0) break;
            count += (long)buf;
        }
        return count;
    }

    public RawIOBase fileno() {
        this.checkClosed();
        return this;
    }

    public abstract Channel getChannel();
}

