/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.maven;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.tools.ant.taskdefs.Java;
import org.jruby.maven.AbstractJRubyMojo;

public class RakeMojo
extends AbstractJRubyMojo {
    private String rakefile = null;
    private File outputDirectory;
    private String script = null;
    private String args = null;

    public void execute() throws MojoExecutionException {
        this.outputDirectory.mkdirs();
        this.ensureGem("rake");
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.add("-S");
        allArgs.add("rake");
        if (this.script != null) {
            File scriptFile = new File(this.outputDirectory, "rake_script.rb");
            try {
                FileWriter writer = new FileWriter(scriptFile);
                writer.write(this.script);
                writer.close();
            }
            catch (IOException io) {
                throw new MojoExecutionException("error writing temporary script");
            }
            allArgs.add("-f");
            allArgs.add(scriptFile.getPath());
        } else if (this.rakefile != null) {
            allArgs.add("-f");
            allArgs.add(this.rakefile);
        }
        if (this.args != null) {
            allArgs.addAll(Arrays.asList(this.args.split("\\s+")));
        }
        Java jruby = this.jruby(allArgs.toArray(new String[allArgs.size()]));
        jruby.execute();
    }
}

