/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractJRubyMojo
extends AbstractMojo {
    protected boolean shouldFork = true;
    protected MavenProject mavenProject;
    protected File launchDirectory;
    protected String jrubyHome;
    protected String jrubyLaunchMemory = "384m";
    private List compileClasspathElements;
    private List pluginArtifacts;

    protected Java jruby(String[] args) throws MojoExecutionException {
        Commandline.Argument arg;
        this.launchDirectory.mkdirs();
        Project project = null;
        try {
            project = this.getProject();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("error resolving dependencies", (Exception)((Object)e));
        }
        Java java = new Java();
        java.setProject(project);
        java.setClassname("org.jruby.Main");
        java.setFailonerror(true);
        if (this.shouldFork) {
            java.setFork(true);
            java.setDir(this.launchDirectory);
            arg = java.createJvmarg();
            arg.setValue("-Xmx" + this.jrubyLaunchMemory);
            Environment.Variable classpath = new Environment.Variable();
            Path p = new Path(java.getProject());
            p.add((Path)project.getReference("maven.plugin.classpath"));
            p.add((Path)project.getReference("maven.compile.classpath"));
            classpath.setKey("JRUBY_PARENT_CLASSPATH");
            classpath.setValue(p.toString());
            java.addEnv(classpath);
        }
        if (this.jrubyHome != null) {
            Environment.Variable v = new Environment.Variable();
            v.setKey("jruby.home");
            v.setValue(this.jrubyHome);
            java.addSysproperty(v);
        }
        Path p = java.createClasspath();
        p.add((Path)project.getReference("maven.plugin.classpath"));
        p.add((Path)project.getReference("maven.compile.classpath"));
        this.getLog().debug((CharSequence)("java classpath: " + p.toString()));
        for (int i = 0; i < args.length; ++i) {
            arg = java.createArg();
            arg.setValue(args[i]);
        }
        return java;
    }

    protected void ensureGems(String[] gemNames) throws MojoExecutionException {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-S");
        args.add("maybe_install_gems");
        for (int i = 0; i < gemNames.length; ++i) {
            args.add(gemNames[i]);
        }
        Java jruby = this.jruby(args.toArray(new String[args.size()]));
        jruby.execute();
    }

    protected void ensureGem(String gemName) throws MojoExecutionException {
        this.ensureGems(new String[]{gemName});
    }

    protected Project getProject() throws DependencyResolutionRequiredException {
        Project project = new Project();
        project.setBaseDir(this.mavenProject.getBasedir());
        project.addBuildListener((BuildListener)new LogAdapter());
        this.addReference(project, "maven.compile.classpath", this.compileClasspathElements);
        this.addReference(project, "maven.plugin.classpath", this.pluginArtifacts);
        return project;
    }

    protected void addReference(Project project, String reference, List artifacts) throws DependencyResolutionRequiredException {
        ArrayList<String> list = new ArrayList<String>(artifacts.size());
        for (Object elem : artifacts) {
            String path;
            if (elem instanceof Artifact) {
                Artifact a = (Artifact)elem;
                File file = a.getFile();
                if (file == null) {
                    throw new DependencyResolutionRequiredException(a);
                }
                path = file.getPath();
            } else {
                path = elem.toString();
            }
            list.add(path);
        }
        Path p = new Path(project);
        p.setPath(StringUtils.join(list.iterator(), (String)File.pathSeparator));
        project.addReference(reference, (Object)p);
    }

    public class LogAdapter
    implements BuildListener {
        public void buildStarted(BuildEvent event) {
            this.log(event);
        }

        public void buildFinished(BuildEvent event) {
            this.log(event);
        }

        public void targetStarted(BuildEvent event) {
            this.log(event);
        }

        public void targetFinished(BuildEvent event) {
            this.log(event);
        }

        public void taskStarted(BuildEvent event) {
            this.log(event);
        }

        public void taskFinished(BuildEvent event) {
            this.log(event);
        }

        public void messageLogged(BuildEvent event) {
            this.log(event);
        }

        private void log(BuildEvent event) {
            int priority = event.getPriority();
            Log log = AbstractJRubyMojo.this.getLog();
            switch (priority) {
                case 0: {
                    log.error((CharSequence)event.getMessage());
                    break;
                }
                case 1: {
                    log.warn((CharSequence)event.getMessage());
                    break;
                }
                case 2: {
                    log.info((CharSequence)event.getMessage());
                    break;
                }
                case 3: {
                    log.debug((CharSequence)event.getMessage());
                    break;
                }
                case 4: {
                    log.debug((CharSequence)event.getMessage());
                    break;
                }
                default: {
                    log.info((CharSequence)event.getMessage());
                }
            }
        }
    }
}

