package org.jruby.parser;

public class Ruby19YyTables {
   private static short[] combine(short[] t1, short[] t2, 
                                  short[] t3, short[] t4) {
      short[] t = new short[t1.length + t2.length + t3.length + t4.length];
      int index = 0;
      System.arraycopy(t1, 0, t, index, t1.length);
      index += t1.length;
      System.arraycopy(t2, 0, t, index, t2.length);
      index += t2.length;
      System.arraycopy(t3, 0, t, index, t3.length);
      index += t3.length;
      System.arraycopy(t4, 0, t, index, t4.length);
      return t;
   }

   public static final short[] yyTable() {
      return combine(yyTable1(), yyTable2(), yyTable3(), yyTable4());
   }

   public static final short[] yyCheck() {
      return combine(yyCheck1(), yyCheck2(), yyCheck3(), yyCheck4());
   }
   private static final short[] yyTable1() {
      return new short[] {

          198,  198,  269,   92,  272,  301,  612,  252,  252,  600, 
          511,  252,  412,  370,  271,  211,  624,  266,  432,  213, 
          513,  198,  225,  225,  225,  100,  197,  666,  565,  289, 
          292,   14,  118,  118,  548,  211,  548,  288,  465,  213, 
          548,  466,  118,  630,  318,  535,  198,  508,  287,  291, 
            8,  536,  555,  561,  599,  568,  569,  513,  381,  285, 
            8,  321,  373,  507,  374,  573,  268,  233,  352,  513, 
          233,  783,  307,  663,  621,  231,  234,  118,  594,  233, 
           14,  508,  788,  375,  511,  548,  233,  265,  635,  548, 
          237,   79,   79,   71,   70,  777,  508,  318,  555,  561, 
           80,  299,  443,  488,  752,  548,  548,  275,  488,    8, 
          790,  798,  594,  494,  345,  456,  232,   83,  338,  232, 
          343,  118,  481,  809,  378,  319,  486,   83,  232,  813, 
          848,  320,  268,  261,   69,  232,  346,  685,  341,  662, 
          344,  548,  339,  594,   69,   68,  548,  494,  233,  342, 
          910,   80,  488,  697,  548,  308,  548,  264,   90,  488, 
           72,  642,  494,  594,  368,  402,  462,   78,  692,  444, 
          445,  265,  340,  462,  268,  543,  548,  237,  319,   76, 
          722,  320,  766,  767,  400,  768,  401,  278,  279,  700, 
          511,  585,   90,  543,  642,  845,  385,  232,  413,  258, 
          461,  693,  580,  264,  308,  548,  686,  464,  488,   90, 
          548,   72,  865,  727,  402,  469,  910,  607,   78,  274, 
           84,   84,  119,  119,  733,  548,   84,  227,  227,  227, 
           76,  750,  242,  227,  227,   73,   81,  227,  611,  526, 
          414,  783,   74,  677,  788,   79,  494,  500,  848,   59, 
           60,  225,  225,  252,  489,  252,  252,  280,  283,  490, 
          788,  494,  500,   84,  227,  438,  332,  297,  894,  227, 
          427,   16,  728,  641,  379,  427,  641,  790,  380,  312, 
          440,   15,  442,   14,   14,   14,   73,   81,  314,   14, 
           14,  363,   14,   74,  749,  511,   79,  347,  364,  237, 
          667,  349,  350,  417,  418,  392,  396,   53,  756,  330, 
          331,  297,  393,  237,  358,  513,  488,  922,  365,  570, 
           16,  574,  819,  118,  403,  584,  587,  403,  366,  227, 
           15,   84,  382,  598,  367,  764,  802,  371,  225,  225, 
          225,  225,  508,  523,  524,  943,  330,  331,  731,  395, 
          627,  513,   69,  372,  252,  563,  513,  579,  267,  548, 
          409,  579,   14,  438,  548,  475,  476,  352,  548,   80, 
          399,  548,  478,   63,   63,  114,  114,  114,  508,   63, 
          252,  563,  842,   14,  513,  241,  797,  579,  548,  438, 
          518,  519,  520,  521,  469,  508,  589,  118,  610,  613, 
          252,  563,  759,  601,  625,  762,  753,  535,  494,  438, 
          640,  508,    8,  536,  252,  563,   63,  573,  522,  402, 
          296,  582,  402,  438,   71,   70,  557,   90,  526,   72, 
          548,   80,  383,  647,  488,   84,   78,  548,  275,  488, 
          198,  879,  889,  656,  494,  345,  563,  887,   76,  338, 
           92,  343,  557,  673,  211,   77,  227,  227,  213,  368, 
          648,  591,  267,   79,  296,  252,  563,  346,  282,  341, 
          397,  344,  557,  339,  438,   90,  526,  494,  548,  227, 
          342,  227,  227,  526,   63,  227,  557,  227,  526,   90, 
          614,   72,   84,  402,  283,  368,  629,  629,   78,   84, 
          913,  469,  118,  340,   73,   81,   77,   75,  683,  526, 
           76,   74,  368,  297,   79,  696,  696,  557,  832,  511, 
          376,  377,  526,   16,   16,   16,  699,  548,  368,   16, 
           16,  410,   16,   15,   15,   15,  282,  557,   79,   15, 
           15,  712,   15,  227,  227,  227,  227,   84,  227,  227, 
          918,  704,  696,  411,  441,  416,  706,  710,   75,  773, 
          494,  500,  488,  414,  713,  715,   73,   81,  419,  706, 
          706,  458,  423,   74,  594,  712,   79,  763,  401,  401, 
          227,  283,  895,  227,  401,  227,   84,  297,   63,  227, 
          227,  940,   84,  735,  428,  706,  431,  712,  101,  198, 
          198,  548,   16,  743,  611,  225,  227,   84,  227,  118, 
          738,  712,   15,  742,  211,  886,  613,  427,  213,   84, 
          362,  703,   84,   16,  613,  734,  227,  709,  673,  774, 
           84,  488,  455,   15,  703,  703,  449,   89,  712,  332, 
          227,  548,  548,  469,  453,   63,  454,  101,  457,  225, 
          548,  467,   63,  310,  311,  805,  807,  726,  548,  468, 
          703,  810,  460,  709,  474,  227,  296,   84,  484,  725, 
          488,   89,  290,  574,   88,   88,  120,  120,  683,  278, 
           88,  583,  732,  714,  716,  118,  243,  516,   89,  611, 
          530,  227,  297,  447,  683,  616,  626,  450,  644,  696, 
           63,  757,  650,  657,  282,  530,  668,  548,   88,  678, 
           98,  526,   96,  388,  669,  679,  682,   88,  392,  680, 
          643,  298,  408,  688,   77,  690,  645,  646,  701,  702, 
          673,  548,  673,  707,  708,  548,  720,  530,  719,   63, 
          296,  723,  729,  654,  736,   63,  655,  475,  476,  740, 
          746,  118,   98,  747,  478,  464,  225,  483,  548,  526, 
           63,   96,  748,  751,  118,  298,  526,  761,  876,  775, 
          548,  526,   63,  803,  814,   63,   75,  475,  476,  477, 
          548,  823,  422,   63,  478,   88,   77,  815,   91,   91, 
           93,  282,  526,  464,   91,  683,  825,  835,  836,  297, 
          244,   98,  843,  673,  896,  822,  548,  548,  834,   95, 
          227,   84,  103,  780,  846,  492,  493,  494,  495,  548, 
           63,  670,   84,  492,  493,  494,  495,  615,  837,   84, 
          853,   91,  850,  526,  852,  623,  629,  278,   75,  854, 
          613,  855,  857,  859,  670,  296,  492,  493,  494,  495, 
          673,  863,  673,  862,  227,  101,  272,  360,  548,  866, 
          868,  103,  408,   92,  361,  871,  870,  721,  872,  875, 
          881,  424,  425,  426,  890,  297,  252,  563,  891,  893, 
          673,  905,   84,  911,  102,  438,   96,   96,  730,   88, 
          118,  923,   96,  272,  712,  929,  912,   92,   91,   91, 
           89,  253,  259,   84,   84,  260,   89,  392,  925,  932, 
          548,  548,  548,   84,   92,   84,  278,  548,   84,  227, 
          227,  613,  473,  278,  563,  227,  530,  884,  527,   96, 
          939,  934,   91,  102,  936,  760,   93,  227,  475,  476, 
          480,  297,  388,   96,  527,  478,   88,  392,  557,   91, 
          386,  942,  296,   88,  829,  392,  953,  387,   84,  406, 
          535,  227,  392,  776,   63,  279,  407,  298,   89,   96, 
           93,   84,   84,   84,  530,   63,  475,  476,  482,  530, 
          548,  530,   63,  478,  537,  548,  526,   93,  392,  548, 
          548,  577,  464,  536,  541,  586,   92,   96,  278,  464, 
          548,   88,  537,   91,  530,  541,   40,  530,  537,   98, 
          548,  548,  548,  278,   97,  543,   40,  278,  824,  420, 
           84,  608,  526,  180,  548,  101,  421,  537,  296,  548, 
          464,  548,  227,  548,  739,   63,  323,  464,  577,   84, 
           88,  298,  121,  527,  103,  278,   88,  941,  100,  200, 
           84,  637,  639,  880,  787,  290,   63,   63,  907,  844, 
           91,   88,   88,   97,  849,   40,   63,   91,   63,  103, 
          526,   63,  180,   88,  278,  919,   88,  526,  324,  245, 
          903,  278,  526,  772,   88,  639,  527,  765,  290,  897, 
          649,    0,    0,  272,  296,  392,   88,  100,   84,  451, 
          272,   96,  227,  526,   84,   94,  452,  828,  784,  785, 
           84,   63,    0,   88,    0,   91,    0,    0,  800,    0, 
          801,   88,    0,  804,   63,   63,   63,    0,    0,  527, 
          272,    0,   92,  527,   99,   97,  392,  272,  258,    0, 
            0,  102,    0,  464,    0,    0,  298,  433,  258,  436, 
            0,    0,  279,  578,   91,  475,  476,  485,   96,  471, 
           91,    0,  478,  833,  882,   96,  472,   91,  530,  173, 
            0,  883,    0,   63,    0,   91,  839,  840,  841,  386, 
            0,  527,  258,   99,  392,    0,  930,   91,  527,    0, 
           91,  392,   63,  527,   92,    0,  717,  258,   91,    0, 
            0,    0,  279,   63,    0,   93,  332,    0,    0,  279, 
            0,    0,    0,   96,  527,  530,  530,  392,  173,  431, 
          431,  431,    0,  530,    0,  873,  431,    0,  526,   91, 
            0,  100,  527,  114,    0,   91,    0,  347,  421,  421, 
          421,  349,  350,  351,  352,  421,    0,   95,    0,  530, 
            0,   63,   96,  298,  278,  885,    0,   63,   96,    0, 
            0,  278,  758,   63,    0,   88,  527,   93,   40,   40, 
           40,   97,    0,   96,   40,   40,   88,   40,    0,    0, 
          527,   95,  278,   88,  392,   96,    0,  527,   96,  278, 
            0,    0,  527,  771,  527,    0,   96,    0,   95,   40, 
           40,   40,   40,   40,    0,  100,    0,    0,   91,  920, 
            0,    0,  278,  527,    0,  921,    0,    0,  527,  180, 
            0,  180,  180,  180,  180,    0,    0,    0,  272,  298, 
            0,   88,  392,   96,    0,    0,   88,  770,    0,  392, 
          102,  458,    0,    0,  818,    0,    0,   40,  458,    0, 
            0,    0,  180,  180,    0,  530,    0,   88,   88,    0, 
          180,  180,  180,  180,    0,  392,  527,   88,   40,   88, 
            0,    0,   88,  527,    0,    0,  838,    0,  527,   91, 
          464,  325,  326,  327,  328,  329,    0,  464,    0,  279, 
           91,   99,    0,   88,    0,  298,  279,   91,    0,  527, 
          258,  258,  258,    0,  530,  258,  258,  258,  830,  258, 
          251,  251,   88,    0,  251,    0,    0,    0,    0,  258, 
          258,    0,    0,    0,    0,   88,   88,   88,  258,  258, 
            0,  258,  258,  258,  258,  258,  275,  277,    0,    0, 
            0,  878,  251,  251,    0,  300,  302,    0,    0,    0, 
           91,    0,  530,    0,  535,  535,  535,    0,    0,  530, 
          535,  535,    0,  535,  526,  173,    0,  173,  173,  173, 
          173,   91,   91,    0,   88,    0,    0,   96,    0,  258, 
            0,   91,  258,   91,  258,  530,   91,  457,   96,    0, 
            0,    0,    0,   88,  457,   96,    0,    0,  173,  173, 
          258,    0,   94,    0,   88,  578,  173,  173,  173,  173, 
          786,    0,  789,    0,    0,  793,   95,  260,    0,    0, 
            0,    0,  831,    0,    0,    0,   91,  260,    0,    0, 
            0,    0,    0,  535,  120,    0,   94,    0,    0,   91, 
           91,   91,    0,   99,  530,    0,    0,    0,   96,    0, 
            0,    0,   88,   94,  535,    0,    0,    0,   88,    0, 
            0,  260,    0,    0,   88,  272,    0,    0,    0,   96, 
           96,    0,  272,    0,    0,    0,  260,    0,   95,   96, 
            0,   96,    0,  279,   96,  115,  115,    0,   91,    0, 
            0,    0,  530,    0,    0,  115,    0,    0,    0,  530, 
            0,    0,    0,  234,  526,    0,    0,   91,  536,  536, 
          536,    0,    0,  234,  536,  536,    0,  536,   91,    0, 
            0,    0,  115,  115,   96,  530,    0,    0,  115,  115, 
          115,  115,    0,    0,    0,    0,    0,   96,   96,   96, 
            0,    0,  251,  251,  251,  302,    0,  234,  670,    0, 
          492,  493,  494,  495,    0,    0,  251,    0,  251,  251, 
            0,  234,  234,    0,    0,    0,   91,  448,    0,    0, 
            0,    0,   91,    0,  115,    0,    0,    0,   91,  899, 
            0,  496,  689,  691,    0,    0,   96,  536,  906,    0, 
          908,  500,  501,  670,    0,  492,  493,  494,  495,    0, 
            0,    0,    0,    0,    0,   96,  268,    0,  536,    0, 
            0,    0,    0,    0,    0,    0,   96,    0,    0,    0, 
          670,    0,  492,  493,  494,  495,  671,  525,  526,  527, 
          528,  529,  530,  531,  532,  533,  534,  535,  536,  537, 
          538,  539,  540,  541,  542,  543,  544,  545,  546,  547, 
          548,  549,  550,  671,    0,    0,  948,  251,    0,  357, 
          571,  672,  575,    0,   96,    0,  251,  588,    0,  183, 
           96,   94,    0,    0,    0,    0,   96,    0,    0,  260, 
          260,  260,    0,  251,  260,  260,  260,    0,  260,    0, 
            0,  670,  251,  492,  493,  494,  495,    0,  260,  260, 
            0,    0,    0,  251,  571,  622,  588,  260,  260,  251, 
          260,  260,  260,  260,  260,    0,    0,  251,  183,    0, 
          279,    0,  251,  251,  671,    0,  251,  279,  115,  115, 
          115,  115,  847,   94,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  651,  652, 
          653,    0,    0,  115,    0,    0,  251,    0,  260,  251, 
            0,  260,    0,  260,    0,  234,  234,  234,  251,    0, 
          234,  234,  234,    0,  234,    0,  115,    0,    0,  260, 
            0,    0,    0,    0,  234,  234,    0,  682,    0,    0, 
            0,    0,    0,  234,  234,  192,  234,  234,  234,  234, 
          234,    0,    0,    0,    0,  192,    0,    0,  234,    0, 
            0,    0,    0,  115,  115,  115,  115,  115,  115,  115, 
          115,  115,  115,  115,  115,  115,  115,  115,  115,  115, 
          115,  115,  115,  115,  115,  115,  115,  115,  115,  237, 
            0,  234,    0,    0,  234,    0,    0,  234,    0,  234, 
          115,  851,    0,    0,  192,    0,    0,    0,    0,  856, 
          858,    0,  860,    0,  861,  234,  864,  251,  867,  869, 
            0,    0,    0,    0,    0,    0,    0,  234,  115,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          115,  115,  115,    0,    0,  115,    0,    0,    0,    0, 
          549,    0,    0,    0,    0,    0,    0,    0,  115,  115, 
          549,    0,  115,  332,  333,  334,  335,  336,  337,  338, 
          339,  340,  341,  342,    0,  343,  344,    0,    0,  345, 
          346,    0,    0,  251,  115,  115,  115,    0,    0,    0, 
            0,    0,  115,    0,  347,  115,  348,    0,  349,  350, 
          351,  352,  353,  354,  355,  115,  356,    0,    0,  549, 
            0,    0,    0,    0,  251,  183,    0,  183,  183,  183, 
          183,  924,  926,  927,  928,  168,    0,  931,    0,  933, 
          935,  937,  938,    0,    0,    0,    0,  459,    0,    0, 
            0,  150,    0,    0,  459,    0,  806,  808,  183,  183, 
            0,    0,  811,  812,    0,    0,  183,  183,  183,  183, 
            0,    0,    0,  816,  622,  251,    0,  951,    0,  820, 
          952,  954,  955,  956,  168,    0,    0,    0,    0,    0, 
          958,    0,    0,    0,  792,    0,  492,  493,  494,  495, 
          150,  806,  808,  811,    0,    0,    0,  251,    0,    0, 
            0,    0,    0,  115,    0,    0,    0,  192,  192,  192, 
            0,    0,  115,  192,  192,    0,  192,  496,    0,    0, 
            0,    0,    0,    0,    0,  498,  499,  500,  501,    0, 
          332,    0,    0,  452,    0,  192,  192,    0,  192,  192, 
          192,  192,    0,  452,    0,    0,  345,  346,  874,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  877, 
            0,  347,  251,  348,    0,  349,  350,  351,  352,  115, 
            0,  355,    0,  356,    0,    0,    0,  452,    0,    0, 
            0,  877,    0,    0,    0,    0,  192,    0,  115,    0, 
            0,  452,  452,    0,  452,    0,  452,    0,    0,  332, 
          115,    0,    0,    0,    0,    0,    0,  192,    0,    0, 
            0,    0,  549,  549,  549,  345,  346,  549,  549,  549, 
            0,  549,    0,    0,  452,    0,    0,    0,    0,  251, 
          347,  549,  549,    0,  349,  350,  351,  352,    0,  115, 
          549,  549,    0,  549,  549,  549,  549,  549,    0,  115, 
            0,  115,    0,    0,  115,  115,  455,    0,    0,    0, 
          491,    0,  492,  493,  494,  495,  455,  115,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  115,  115,  115, 
            0,    0,    0,  115,    0,    0,    0,    0,    0,    0, 
            0,  549,    0,  496,  549,    0,  549,    0,    0,    0, 
          455,  498,  499,  500,  501,    0,    0,    0,    0,    0, 
            0,    0,  549,    0,  455,  455,    0,  455,    0,  455, 
            0,  168,    0,  168,  168,  168,  168,    0,    0,    0, 
            0,    0,    0,    0,  115,    0,    0,  150,    0,  150, 
          150,  150,  150,  460,    0,    0,    0,  455,  115,    0, 
          460,    0,    0,    0,  168,  168,    0,    0,    0,  462, 
            0,    0,  168,  168,  168,  168,  462,  115,    0,    0, 
          150,  150,    0,    0,    0,    0,    0,    0,  150,  150, 
          150,  150,  151,    0,    0,    0,    0,    0,    0,    0, 
          523,  523,  523,  115,  523,  452,  452,  452,  523,  523, 
          452,  452,  452,  523,  452,  523,  523,  523,  523,  523, 
          523,  523,  452,  523,  452,  452,  523,  523,  523,  523, 
          523,  523,  523,  452,  452,  523,  452,  452,  452,  452, 
          452,  151,  523,    0,    0,  523,  523,  523,  452,  523, 
          523,  523,  523,  523,  523,  523,  523,  523,  523,  523, 
          452,  452,  452,  452,  452,  452,  452,  452,  452,  452, 
          452,  452,  452,  452,    0,    0,  452,  452,  452,  523, 
          452,  452,  523,  523,  452,  523,  523,  452,  523,  452, 
          523,  452,  523,  452,  523,  452,  452,  452,  452,  452, 
          452,  452,  523,  452,  523,  452,    0,  523,  523,  523, 
          523,  523,  523,    0,    0,  152,  523,  452,  523,  523, 
            0,  523,  523,  524,  524,  524,    0,  524,  455,  455, 
          455,  524,  524,  455,  455,  455,  524,  455,  524,  524, 
          524,  524,  524,  524,  524,  455,  524,  455,  455,  524, 
          524,  524,  524,  524,  524,  524,  455,  455,  524,  455, 
          455,  455,  455,  455,  152,  524,    0,    0,  524,  524, 
          524,  455,  524,  524,  524,  524,  524,  524,  524,  524, 
          524,  524,  524,  455,  455,  455,  455,  455,  455,  455, 
          455,  455,  455,  455,  455,  455,  455,    0,    0,  455, 
          455,  455,  524,  455,  455,  524,  524,  455,  524,  524, 
          455,  524,  455,  524,  455,  524,  455,  524,  455,  455, 
          455,  455,  455,  455,  455,  524,  455,  524,  455,    0, 
          524,  524,  524,  524,  524,  524,  526,    0,    0,  524, 
          455,  524,  524,    0,  524,  524,  526,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          491,    0,  492,  493,  494,  495,    0,    0,    0,    0, 
          526,    0,  491,    0,  492,  493,  494,  495,  151,    0, 
          151,  151,  151,  151,  526,  526,    0,   98,    0,  526, 
            0,    0,    0,  496,  497,    0,    0,    0,    0,    0, 
          461,  498,  499,  500,  501,  496,  602,  461,    0,    0, 
            0,  151,  151,  498,  499,  500,  501,  526,    0,  151, 
          151,  151,  151,    0,    0,    0,  552,  553,    0,    0, 
          554,    0,    0,    0,  167,  168,    0,  169,  170,  171, 
          172,  173,  174,  175,    0,    0,  176,  177,    0,  527, 
            0,  178,  179,  180,  181,    0,    0,    0,    0,  527, 
          264,    0,    0,    0,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,  192,  193,  194, 
          195,    0,    0,  196,  792,    0,  492,  493,  494,  495, 
            0,    0,    0,  527,    0,    0,    0,    0,    0,    0, 
            0,  152,    0,  152,  152,  152,  152,  527,  527,    0, 
          100,    0,  527,    0,    0,    0,    0,  496,    0,    0, 
            0,    0,  332,  463,    0,  498,  499,  500,  501,    0, 
          463,  332,    0,    0,  152,  152,  337,  338,  345,  346, 
          527,    0,  152,  152,  152,  152,    0,  345,  346,    0, 
            0,    0,    0,  347,    0,  348,  109,  349,  350,  351, 
          352,    0,  347,    0,  348,    0,  349,  350,  351,  352, 
          353,  354,  355,    0,  356,    0,    0,    0,    0,    0, 
            0,    0,    0,  526,  526,  526,    0,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  109,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,    0,  526,    0,    0,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,    0,    0,  526, 
          526,  526,  526,    0,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,    0, 
          526,  526,  526,  526,  526,  526,    0,    0,  110,  526, 
          526,  526,  526,    0,  526,  526,  527,  527,  527,    0, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,    0,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  110,  527,    0, 
            0,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
            0,    0,  527,  527,  527,  527,    0,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,    0,  527,  527,  527,  527,  527,  527,  530, 
            0,    0,  527,  527,  527,  527,    0,  527,  527,  530, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  109,    0,  109,  109,  109,  109,    0,    0, 
            0,    0,    0,  530,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  452,    0,    0,  530,  530,    0, 
           99,  452,  530,    0,    0,  109,  109,    0,    0,    0, 
            0,    0,    0,  109,  109,  109,  109,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          530,    0,  558,  559,    0,    0,  560,    0,    0,    0, 
          167,  168,    0,  169,  170,  171,  172,  173,  174,  175, 
            0,    0,  176,  177,    0,    0,    0,  178,  179,  180, 
          181,    0,  273,    0,    0,    0,  264,    0,    0,    0, 
            0,    0,  273,  183,  184,    0,  185,  186,  187,  188, 
          189,  190,  191,  192,  193,  194,  195,    0,    0,  196, 
            0,  332,  333,  334,  335,  336,  337,  338,  339,  340, 
          341,  342,    0,    0,    0,    0,  273,  345,  346,    0, 
            0,    0,    0,    0,  110,    0,  110,  110,  110,  110, 
          273,  273,  347,    0,  348,  273,  349,  350,  351,  352, 
          353,  354,  355,    0,  356,    0,  455,    0,    0,    0, 
            0,    0,    0,  455,    0,    0,    0,  110,  110,    0, 
            0,    0,    0,  273,    0,  110,  110,  110,  110,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  526,  526,  526,    0, 
          526,  530,  530,  530,  526,  526,  530,  530,  530,  526, 
          530,  526,  526,  526,  526,  526,  526,  526,    0,  530, 
          530,  530,  526,  526,  526,  526,  526,  526,  526,  530, 
          530,  526,  530,  530,  530,  530,  530,  268,  526,    0, 
            0,  526,  526,  526,  530,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  530,  530,  530,  530, 
          530,  530,  530,  530,  530,  530,  530,  530,  530,  530, 
            0,    0,  530,  530,  530,  526,    0,  530,  526,  526, 
          530,  526,  526,  530,  526,  530,  526,  530,  526,  530, 
          526,  530,  530,  530,  530,  530,  530,  530,  526,  530, 
          530,  530,    0,  526,  526,  526,  526,  526,  526,    0, 
            0,    0,  526,  530,  526,  526,    0,  526,  526,  525, 
          525,  525,    0,  525,  273,  273,  273,  525,  525,  273, 
          273,  273,  525,  273,  525,  525,  525,  525,  525,  525, 
          525,    0,  525,  273,  273,  525,  525,  525,  525,  525, 
          525,  525,  273,  273,  525,  273,  273,  273,  273,  273, 
            0,  525,    0,    0,  525,  525,  525,  273,  525,  525, 
          525,  525,  525,  525,  525,  525,  525,  525,  525,  273, 
          273,  273,  273,  273,  273,  273,  273,  273,  273,  273, 
          273,  273,  273,    0,    0,  273,  273,  273,  525,    0, 
          273,  525,  525,  273,  525,  525,  273,  525,  273,  525, 
          273,  525,  273,  525,  273,  273,  273,  273,  273,  273, 
          273,  525,  273,  525,  273,    0,  525,  525,  525,  525, 
          525,  525,  531,    0,    0,  525,  273,  525,  525,    0, 
          525,  525,  531,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  531,    0,    0,    0, 
            0,    0,    0,    0,    4,    5,    6,    0,    8,    0, 
          531,  531,    9,   10,    0,  531,    0,   11,    0,   12, 
           13,   14,  101,  102,   17,   18,    0,    0,    0,    0, 
          103,   20,   21,   22,   23,   24,   25,    0,    0,  106, 
            0,    0,    0,  531,    0,    0,   28,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,  247, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  532,    0,    0,    0,    0, 
            0,    0,    0,  223,    0,  532,  113,    0,    0,   46, 
           47,    0,   48,    0,  248,    0,  249,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  250,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,  532, 
           58,    0,   59,   60,    0,   61,   62,    0,  566,  553, 
            0,    0,  567,  532,  532,    0,  167,  168,  532,  169, 
          170,  171,  172,  173,  174,  175,    0,    0,  176,  177, 
            0,    0,    0,  178,  179,  180,  181,    0,    0,    0, 
            0,    0,  264,    0,    0,    0,  532,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,  192, 
          193,  194,  195,    0,    0,  196,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  528, 
          528,  528,    0,  528,  531,  531,  531,  528,  528,  531, 
          531,  531,  528,  531,  528,  528,  528,  528,  528,  528, 
          528,    0,  531,  531,  531,  528,  528,  528,  528,  528, 
          528,  528,  531,  531,  528,  531,  531,  531,  531,  531, 
            0,  528,  295,    0,  528,  528,  528,  531,  528,  528, 
          528,  528,  528,  528,  528,  528,  528,  528,  528,  531, 
          531,  531,  531,  531,  531,  531,  531,  531,  531,  531, 
          531,  531,  531,    0,    0,  531,  531,  531,  528,    0, 
          531,  528,  528,  531,  528,  528,  531,  528,  531,  528, 
          531,  528,  531,  528,  531,  531,  531,  531,  531,  531, 
          531,  528,  531,  531,  531,    0,  528,  528,  528,  528, 
          528,  528,    0,    0,    0,  528,  531,  528,  528,    0, 
          528,  528,  529,  529,  529,    0,  529,  532,  532,  532, 
          529,  529,  532,  532,  532,  529,  532,  529,  529,  529, 
          529,  529,  529,  529,    0,  532,  532,  532,  529,  529, 
          529,  529,  529,  529,  529,  532,  532,  529,  532,  532, 
          532,  532,  532,    0,  529,    0,    0,  529,  529,  529, 
          532,  529,  529,  529,  529,  529,  529,  529,  529,  529, 
          529,  529,  532,  532,  532,  532,  532,  532,  532,  532, 
          532,  532,  532,  532,  532,  532,    0,    0,  532,  532, 
          532,  529,    0,  532,  529,  529,  532,  529,  529,  532, 
          529,  532,  529,  532,  529,  532,  529,  532,  532,  532, 
          532,  532,  532,  532,  529,  532,  532,  532,    0,  529, 
          529,  529,  529,  529,  529,  278,    0,    0,  529,  532, 
          529,  529,    0,  529,  529,  278,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  101,  102,   17,   18,    0,    0,  278, 
            0,  103,  104,  105,   22,   23,   24,   25,    0,    0, 
          106,    0,    0,  278,  278,    0,  101,  107,  278,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,    0,    0,  110,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  278,    0,    0,    0, 
            0,    0,    0,    0,  294,    0,    0,  113,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  391,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,  391,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,  595,  559, 
            0,    0,  596,    0,    0,    0,  167,  168,    0,  169, 
          170,  171,  172,  173,  174,  175,    0,    0,  176,  177, 
            0,    0,  391,  178,  179,  180,  181,    0,    0,    0, 
            0,    0,  264,    0,    0,    0,    0,  391,    0,  183, 
          184,  391,  185,  186,  187,  188,  189,  190,  191,  192, 
          193,  194,  195,    0,    0,  196,  332,  333,  334,  335, 
          336,  337,  338,  339,    0,  341,  342,    0,    0,  391, 
            0,    0,  345,  346,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  347,    0,  348, 
            0,  349,  350,  351,  352,  353,  354,  355,    0,  356, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  527,  527,  527,    0,  527,  278,  278,  278, 
          527,  527,  278,  278,  278,  527,  278,  527,  527,  527, 
          527,  527,  527,  527,    0,    0,  278,  278,  527,  527, 
          527,  527,  527,  527,  527,  278,  278,  527,  278,  278, 
          278,  278,  278,  268,  527,    0,    0,  527,  527,  527, 
          278,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  278,  278,  278,  278,  278,  278,  278,  278, 
          278,  278,  278,  278,  278,  278,    0,    0,  278,  278, 
          278,  527,    0,  278,  527,  527,  278,  527,  527,  278, 
          527,  278,  527,  278,  527,  278,  527,  278,  278,  278, 
          278,  278,  278,  278,  527,  278,    0,  278,    0,  527, 
          527,  527,  527,  527,  527,    0,    0,    0,  527,  278, 
          527,  527,    0,  527,  527,  252,  252,  252,    0,  252, 
          391,  391,  391,  252,  252,  391,  391,  391,  252,  391, 
          252,  252,  252,  252,  252,  252,  252,    0,  391,  391, 
          391,  252,  252,  252,  252,  252,  252,  252,  391,  391, 
          252,  391,  391,  391,  391,  391,    0,  252,    0,    0, 
          252,  252,  252,  357,  252,  252,  252,  252,  252,  252, 
          252,  252,  252,  252,  252,  391,  391,  391,  391,  391, 
          391,  391,  391,  391,  391,  391,  391,  391,  391,    0, 
            0,  391,  391,  391,  252,    0,  391,  252,    0,  391, 
          252,  252,  391,  252,  391,  252,  391,  252,  391,  252, 
          391,  391,  391,  391,  391,  391,  391,  252,  391,  391, 
          391,    0,  252,  252,  252,  252,  252,  252,  548,    0, 
            0,  252,    0,  252,  252,    0,  252,  252,  548,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  548,    0,    0,    0,    0,    0,    0,    0, 
            4,    5,    6,    0,    8,    0,    0,  548,    9,   10, 
            0,  548,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,    0,    0,  548, 
            0,    0,   28,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  285,    0,    0,    0, 
      };
   }

   private static final short[] yyTable2() {
      return new short[] {

            0,    0,    0,    0,  223,    0,  285,  113,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,   51,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
          285,   58,  718,   59,   60,    0,   61,   62,    0,    0, 
            0,    0,    0,    0,    0,  285,    0,    0,    0,  285, 
            0,    0,  332,  333,  334,  335,  336,  337,  338,  339, 
          340,  341,  342,    0,  343,  344,    0,    0,  345,  346, 
            0,    0,    0,    0,    0,    0,    0,  285,    0,    0, 
            0,    0,    0,  347,    0,  348,    0,  349,  350,  351, 
          352,  353,  354,  355,    0,  356,    0,    0,    0,    0, 
            0,    0,    0,    0,  256,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  256,    0,    0,    0,    0,    0, 
          252,  252,  252,    0,  252,  548,  548,  548,  252,  252, 
          548,  548,  548,  252,  548,  252,  252,  252,  252,  252, 
          252,  252,    0,  548,  548,  548,  252,  252,  252,  252, 
          252,  252,  252,  548,  548,  252,  548,  548,  548,  548, 
          548,    0,  252,  256,  357,  252,  252,  252,    0,  252, 
          252,  252,  252,  252,  252,  252,  252,  252,  252,  252, 
          548,  548,  548,  548,  548,  548,  548,  548,  548,  548, 
          548,  548,  548,  548,    0,    0,  548,  548,  548,  252, 
            0,  548,  252,    0,  548,  252,  252,  548,  252,  548, 
          252,  548,  252,  548,  252,  548,  548,  548,  548,  548, 
          548,  548,  252,  548,  548,  548,    0,  252,  252,  252, 
          252,  252,  252,  357,    0,    0,  252,    0,  252,  252, 
            0,  252,  252,  252,  252,  252,    0,  252,  285,  285, 
          285,  252,  252,  285,  285,  285,  252,  285,  252,  252, 
          252,  252,  252,  252,  252,    0,    0,  285,  285,  252, 
          252,  252,  252,  252,  252,  252,  285,  285,  252,  285, 
          285,  285,  285,  285,    0,  252,    0,    0,  252,  252, 
          252,    0,  252,  252,  252,  252,  252,  252,  252,  252, 
          252,  252,  252,  285,  285,  285,  285,  285,  285,  285, 
          285,  285,  285,  285,  285,  285,  285,    0,    0,  285, 
          285,  285,  252,    0,  285,  252,    0,  285,  252,  252, 
          285,  252,  285,  252,  285,  252,  285,  252,  285,  285, 
          285,  285,  285,  285,  285,  252,  285,  526,  285,    0, 
          252,  252,  252,  252,  252,  252,    0,  526,    0,  252, 
            0,  252,  252,    0,  252,  252,  256,  256,  256,    0, 
            0,  256,  256,  256,    0,  256,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  256,  256,    0,    0,    0, 
            0,   90,    0,    0,  256,  256,    0,  256,  256,  256, 
          256,  256,    0,    0,    0,    0,  526,    0,   98,    0, 
          526,    0,    0,    0,    0,    0,    0,    0,  332,  333, 
          334,  335,  336,  337,  338,  339,  340,  341,  342,    0, 
          343,  344,    0,    0,  345,  346,    0,    0,  526,    0, 
            0,    0,    0,    0,    0,  256,    0,    0,  256,  347, 
          256,  348,    0,  349,  350,  351,  352,  353,  354,  355, 
            0,  356,    0,    0,    0,    0,  256,  724,    0,    0, 
          527,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          527,    0,    0,    0,    0,    0,    0,  332,  333,  334, 
          335,  336,  337,  338,  339,  340,  341,  342,    0,  343, 
          344,    0,    0,  345,  346,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   92,    0,    0,    0,  347,    0, 
          348,    0,  349,  350,  351,  352,  353,  354,  355,  527, 
          356,  100,    0,  527,    0,    0,    0,  617,  553,    0, 
            0,  618,    0,    0,    0,  167,  168,    0,  169,  170, 
          171,  172,  173,  174,  175,    0,    0,  176,  177,    0, 
            0,  527,  178,  179,  180,  181,    0,    0,    0,    0, 
            0,  264,    0,    0,    0,    0,    0,    0,  183,  184, 
            0,  185,  186,  187,  188,  189,  190,  191,  192,  193, 
          194,  195,    0,   49,  196,    0,    0,    0,    0,    0, 
            0,    0,    0,   49,  526,  526,  526,    0,  526,  526, 
          526,  526,  526,  526,    0,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,    0,  526,    0,    0, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,    0,  526,    0,    0,  526, 
          526,  526,   49,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,    0,    0, 
          526,  526,  526,  526,    0,    0,  526,  526,  526,  526, 
          526,    0,  526,    0,  526,  526,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  526,  526,  526, 
            0,  526,  526,  526,  526,  526,  526,    0,    0,    0, 
          526,    0,  526,  526,    0,  526,  526,  527,  527,  527, 
            0,  527,  527,  527,  527,  527,  527,    0,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,    0, 
          527,    0,    0,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,    0,  527, 
            0,    0,  527,  527,  527,    0,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,    0,    0,  527,  527,  527,  527,    0,    0,  527, 
          527,  527,  527,  527,    0,  527,    0,  527,  527,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          527,  527,  527,    0,  527,  527,  527,  527,  527,  527, 
          530,    0,    0,  527,    0,  527,  527,    0,  527,  527, 
          530,    0,    0,    0,    0,   49,   49,   49,    0,    0, 
           49,   49,   49,    0,   49,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   49,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   91,    0,   49,   49,   49,   49, 
           49,    0,    0,    0,    0,    0,    0,    0,    0,  530, 
            0,   99,    0,  530,  332,  333,  334,  335,  336,  337, 
          338,    0,    0,  341,  342,    0,    0,    0,    0,    0, 
          345,  346,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  530,    0,    0,   49,  347,    0,  348,    0,  349, 
          350,  351,  352,  353,  354,  355,    0,  356,    0,    4, 
            5,    6,    0,    8,    0,   49,    0,    9,   10,    0, 
            0,    0,   11,  278,   12,   13,   14,  101,  102,   17, 
           18,    0,    0,  278,    0,  103,  104,  105,   22,   23, 
           24,   25,    0,    0,  106,    0,    0,    0,    0,    0, 
            0,  107,    0,    0,   31,   32,   33,    0,  108,   35, 
           36,   37,  109,   39,    0,   40,    0,   93,  110,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  278,    0,  101,  111,  278,    0,  112,    0, 
            0,  113,    0,    0,   46,   47,    0,   48,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  278,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  548,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  548,  526,  526,  526, 
            0,  526,  530,  530,  530,  526,  526,    0,  530,  530, 
          526,  530,  526,  526,  526,  526,  526,  526,  526,    0, 
          530,    0,    0,  526,  526,  526,  526,  526,  526,  526, 
          530,  530,  526,  530,  530,  530,  530,  530,    0,  526, 
            0,    0,  526,  526,  526,  548,  526,  526,  526,  526, 
          526,  526,  526,  526,  526,  526,  526,  530,  530,  530, 
          530,  530,  530,  530,  530,  530,  530,  530,  530,  530, 
          530,    0,    0,  530,  530,  530,  526,    0,    0,  526, 
          526,  530,  526,  526,    0,  526,    0,  526,  530,  526, 
          530,  526,  530,  530,  530,  530,  530,  530,  530,  526, 
          530,  530,  530,    0,  526,  526,  526,  526,  526,  526, 
            0,    0,    0,  526,    0,  526,  526,    0,  526,  526, 
          527,  527,  527,    0,  527,  278,  278,  278,  527,  527, 
            0,  278,  278,  527,  278,  527,  527,  527,  527,  527, 
          527,  527,    0,    0,    0,    0,  527,  527,  527,  527, 
          527,  527,  527,  278,  278,  527,  278,  278,  278,  278, 
          278,    0,  527,    0,    0,  527,  527,  527,  581,  527, 
          527,  527,  527,  527,  527,  527,  527,  527,  527,  527, 
          278,  278,  278,  278,  278,  278,  278,  278,  278,  278, 
          278,  278,  278,  278,    0,    0,  278,  278,  278,  527, 
            0,    0,  527,  527,  278,  527,  527,    0,  527,    0, 
          527,  278,  527,  278,  527,  278,  278,  278,  278,  278, 
          278,  278,  527,  278,    0,  278,    0,  527,  527,  527, 
          527,  527,  527,    0,    0,    0,  527,    0,  527,  527, 
            0,  527,  527,  252,  252,  252,    0,  252,  548,  548, 
          548,  252,  252,  548,  548,  548,  252,  548,  252,  252, 
          252,  252,  252,  252,  252,    0,    0,  548,    0,  252, 
          252,  252,  252,  252,  252,  252,  548,  548,  252,  548, 
          548,  548,  548,  548,    0,  252,    0,    0,  252,  252, 
          252,    0,  252,  252,  252,  252,  252,  252,  252,  252, 
          252,  252,  252,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  392,  548,    0,    0,    0,    0,    0, 
            0,  548,  252,  392,    0,  252,    0,  548,  252,  252, 
            0,  252,    0,  252,    0,  252,    0,  252,    0,    0, 
            0,    0,    0,    0,    0,  252,    0,    0,  548,    0, 
          252,  252,  252,  252,  252,  252,    0,  392,    0,  252, 
            0,  252,  252,    0,  252,  252,    0,    0,    0,    0, 
            0,  392,  392,    0,   97,    0,  392,    0,    0,    0, 
            0,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  101, 
          102,   17,   18,    0,  392,    0,    0,  103,  104,  105, 
           22,   23,   24,   25,  391,    0,  106,    0,    0,    0, 
            0,    0,    0,  107,  391,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,    0,    0, 
          110,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  391,    0, 
          294,    0,    0,  113,    0,    0,   46,   47,    0,   48, 
            0,    0,  391,  391,    0,    0,    0,  391,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,    0,  391,    0,    0,    0,  778, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  791, 
            0,    0,  795,    0,    0,    0,    0,    0,  464,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  464,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  464,    0,    0,  392,  392,  392,    0,    0, 
          392,  392,  392,    0,  392,    0,  464,  464,    0,   96, 
            0,  464,    0,  392,  392,  392,    0,    0,    0,    0, 
            0,    0,    0,  392,  392,    0,  392,  392,  392,  392, 
          392,    0,    0,    0,    0,    0,    0,    0,  392,  464, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          392,  392,  392,  392,  392,  392,  392,  392,  392,  392, 
          392,  392,  392,  392,    0,    0,  392,  392,  392,    0, 
            0,  392,    0,    0,  392,    0,    0,  392,    0,  392, 
            0,  392,  548,  392,    0,  392,  392,  392,  392,  392, 
          392,  392,  548,  392,  392,  392,  391,  391,  391,    0, 
            0,  391,  391,  391,  898,  391,  900,  392,  901,    0, 
            0,    0,  904,    0,  391,  391,  391,  909,    0,    0, 
            0,    0,    0,    0,  391,  391,  548,  391,  391,  391, 
          391,  391,    0,    0,    0,    0,    0,    0,    0,  391, 
          548,  548,    0,    0,    0,  548,    0,    0,    0,    0, 
            0,  391,  391,  391,  391,  391,  391,  391,  391,  391, 
          391,  391,  391,  391,  391,    0,    0,  391,  391,  391, 
            0,    0,  391,  548,  944,  391,    0,    0,  391,    0, 
          391,  947,  391,  949,  391,  950,  391,  391,  391,  391, 
          391,  391,  391,    0,  391,  391,  391,    0,    0,    0, 
            0,    0,  957,    0,    0,    0,    0,    0,  391,    0, 
          464,  464,  464,    0,    0,  464,  464,  464,    0,  464, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  464, 
          464,    0,    0,    0,    0,    0,    0,    0,  464,  464, 
            0,  464,  464,  464,  464,  464,    0,    0,    0,    0, 
            0,    0,    0,  464,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  464,  464,  464,  464,  464, 
          464,  464,  464,  464,  464,  464,  464,  464,  464,    0, 
          272,  464,  464,  464,    0,  465,  464,    0,    0,  464, 
          272,    0,  464,    0,  464,    0,  464,    0,  464,    0, 
          464,  464,  464,  464,  464,  464,  464,    0,  464,    0, 
          464,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  464,    0,  272,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  272,  272, 
            0,  103,    0,  272,  548,  548,  548,    0,    0,  548, 
          548,  548,    0,  548,    0,    0,    0,    0,    0,    0, 
            0,    0,  548,  548,  548,    0,    0,    0,    0,    0, 
            0,  272,  548,  548,    0,  548,  548,  548,  548,  548, 
            0,    0,    0,    0,    0,    0,    0,  548,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  548, 
          548,  548,  548,  548,  548,  548,  548,  548,  548,  548, 
          548,  548,  548,    0,  279,  548,  548,  548,    0,    0, 
          548,    0,    0,  548,  279,    0,  548,    0,  548,    0, 
          548,    0,  548,    0,  548,  548,  548,  548,  548,  548, 
          548,    0,  548,  548,  548,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  548,    0,  279,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          619,  559,  279,  279,  620,  102,    0,  279,  167,  168, 
            0,  169,  170,  171,  172,  173,  174,  175,    0,    0, 
          176,  177,    0,    0,    0,  178,  179,  180,  181,    0, 
            0,    0,    0,    0,  264,  279,    0,    0,    0,    0, 
            0,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,  192,  193,  194,  195,    0,    0,  196,  412,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  412,    0, 
            0,    0,  272,  272,  272,    0,    0,  272,  272,  272, 
            0,  272,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  272,  272,    0,    0,    0,    0,    0,    0,    0, 
          272,  272,  412,  272,  272,  272,  272,  272,    0,    0, 
            0,    0,    0,    0,    0,  272,  412,  412,    0,    0, 
            0,  412,    0,    0,    0,    0,    0,  272,  272,  272, 
          272,  272,  272,  272,  272,  272,  272,  272,  272,  272, 
          272,    0,    0,  272,  272,  272,    0,    0,  272,  412, 
            0,  272,    0,    0,  272,    0,  272,    0,  272,  290, 
          272,    0,  272,  272,  272,  272,  272,  272,  272,  290, 
          272,    0,  272,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  272,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  290,    0,    0,  279,  279,  279,    0, 
            0,  279,  279,  279,    0,  279,    0,  290,  290,    0, 
            0,    0,  290,    0,    0,  279,  279,    0,    0,    0, 
            0,    0,    0,    0,  279,  279,    0,  279,  279,  279, 
          279,  279,    0,    0,    0,    0,    0,    0,    0,  279, 
          290,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  279,  279,  279,  279,  279,  279,  279,  279,  279, 
          279,  279,  279,  279,  279,    0,    0,  279,  279,  279, 
            0,    0,  279,    0,    0,  279,    0,    0,  279,    0, 
          279,    0,  279,    0,  279,    0,  279,  279,  279,  279, 
          279,  279,  279,  236,  279,    0,  279,    0,    0,    0, 
            0,    0,    0,  236,    0,    0,    0,    0,  279,    0, 
          412,  412,  412,    0,    0,  412,  412,  412,    0,  412, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  412, 
          412,    0,    0,    0,    0,    0,    0,  236,  412,  412, 
            0,  412,  412,  412,  412,  412,    0,    0,    0,    0, 
            0,  236,  236,  412,    0,    0,  236,    0,    0,    0, 
            0,    0,    0,    0,    0,  412,  412,  412,  412,  412, 
          412,  412,  412,  412,  412,  412,  412,  412,  412,    0, 
            0,  412,  412,  412,  322,    0,  412,    0,    0,  412, 
            0,    0,  412,    0,  412,    0,  412,  285,  412,    0, 
          412,  412,  412,  412,  412,  412,  412,  285,  412,    0, 
          412,  290,  290,  290,    0,    0,  290,  290,  290,    0, 
          290,    0,  412,    0,    0,    0,    0,    0,    0,    0, 
          290,  290,    0,    0,    0,    0,    0,    0,    0,  290, 
          290,  285,  290,  290,  290,  290,  290,    0,    0,    0, 
            0,    0,    0,    0,  290,  285,  285,    0,    0,    0, 
          285,    0,    0,    0,    0,    0,  290,  290,  290,  290, 
          290,  290,  290,  290,  290,  290,  290,  290,  290,  290, 
            0,    0,  290,  290,  290,    0,    0,  290,  285,    0, 
          290,    0,    0,  290,    0,  290,    0,  290,    0,  290, 
            0,  290,  290,  290,  290,  290,  290,  290,    0,  290, 
          450,  290,    0,    0,    0,    0,    0,    0,    0,    0, 
          450,    0,    0,  290,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  450,  236,  236,  236,    0,    0, 
          236,  236,  236,    0,  236,    0,    0,    0,  450,  450, 
            0,    0,    0,  450,  236,  236,    0,    0,    0,    0, 
            0,    0,    0,  236,  236,    0,  236,  236,  236,  236, 
          236,    0,    0,    0,    0,    0,    0,    0,  236,    0, 
            0,  450,    0,    0,    0,    0,    0,    0,    0,    0, 
          236,  236,  236,  236,  236,  236,  236,  236,  236,  236, 
          236,  322,  236,  236,    0,    0,  236,  236,  322,    0, 
            0,  236,    0,    0,  236,    0,    0,  236,    0,  236, 
            0,  236,  451,  236,    0,  236,  236,  236,  236,  236, 
          236,  236,  451,  236,    0,  236,    0,    0,    0,  285, 
          285,  285,    0,    0,  285,  285,  285,  236,  285,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  285,  285, 
            0,    0,    0,    0,    0,    0,  451,  285,  285,    0, 
          285,  285,  285,  285,  285,    0,    0,    0,    0,    0, 
          451,  451,  285,    0,    0,  451,    0,    0,    0,    0, 
            0,    0,    0,    0,  285,  285,  285,  285,  285,  285, 
          285,  285,  285,  285,  285,  285,  285,  285,    0,    0, 
          285,  285,  285,  451,    0,  285,    0,    0,  285,    0, 
            0,  285,    0,  285,    0,  285,    0,  285,    0,  285, 
          285,  285,  285,  285,  285,  285,    0,  285,  214,  285, 
            0,    0,    0,    0,    0,    0,    0,    0,  214,    0, 
            0,  285,  450,  450,  450,    0,    0,  450,  450,  450, 
            0,  450,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  450,  450,    0,    0,    0,    0,    0,    0,    0, 
          450,  450,  214,  450,  450,  450,  450,  450,    0,    0, 
            0,    0,    0,    0,    0,  450,  214,  214,    0,    0, 
            0,  214,    0,    0,    0,    0,    0,    0,  450,  450, 
          450,  450,  450,  450,  450,  450,  450,  450,  450,  450, 
          450,    0,    0,  450,  450,  450,    0,    0,  450,    0, 
            0,  450,    0,    0,  450,    0,  450,    0,  450,  210, 
          450,    0,  450,  450,  450,  450,  450,  450,  450,  210, 
          450,    0,  450,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  450,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  210,  451,  451,  451,    0,    0,  451, 
          451,  451,    0,  451,    0,    0,    0,  210,  210,    0, 
            0,    0,  210,  451,  451,    0,    0,    0,    0,    0, 
            0,    0,  451,  451,    0,  451,  451,  451,  451,  451, 
            0,    0,    0,    0,    0,    0,    0,  451,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          451,  451,  451,  451,  451,  451,  451,  451,  451,  451, 
          451,  451,  451,    0,  207,  451,  451,  451,    0,    0, 
          451,    0,    0,  451,  207,    0,  451,    0,  451,    0, 
          451,    0,  451,    0,  451,  451,  451,  451,  451,  451, 
          451,    0,  451,    0,  451,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  451,    0,  207,    0, 
          214,  214,  214,    0,    0,  214,  214,  214,    0,  214, 
            0,    0,  207,  207,    0,    0,    0,  207,    0,  214, 
          214,    0,    0,    0,    0,    0,    0,    0,  214,  214, 
            0,  214,  214,  214,  214,  214,    0,    0,    0,    0, 
            0,    0,    0,  214,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  214,  214,  214,  214, 
          214,  214,  214,  214,  214,  214,    0,  214,  214,    0, 
            0,  214,  214,    0,    0,    0,  214,    0,    0,  214, 
            0,    0,  214,    0,  214,    0,  214,  209,  214,    0, 
          214,  214,  214,  214,  214,  214,  214,  209,  214,    0, 
          214,  210,  210,  210,    0,    0,  210,  210,  210,    0, 
          210,    0,  214,    0,    0,    0,    0,    0,    0,    0, 
          210,  210,    0,    0,    0,    0,    0,    0,    0,  210, 
          210,  209,  210,  210,  210,  210,  210,    0,    0,    0, 
            0,    0,    0,    0,  210,  209,  209,    0,    0,    0, 
          209,    0,    0,    0,    0,    0,    0,  210,  210,  210, 
          210,  210,  210,  210,  210,  210,  210,    0,  210,  210, 
            0,    0,  210,  210,    0,    0,    0,  210,    0,    0, 
          210,    0,    0,  210,    0,  210,    0,  210,    0,  210, 
            0,  210,  210,  210,  210,  210,  210,  210,    0,  210, 
            0,  210,  208,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  208,  210,    0,    0,  207,  207,  207,    0, 
            0,  207,  207,  207,    0,  207,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  207,  207,    0,    0,    0, 
            0,    0,    0,    0,  207,  207,  208,  207,  207,  207, 
          207,  207,    0,    0,    0,    0,    0,    0,    0,  207, 
          208,  208,    0,    0,    0,  208,    0,    0,    0,    0, 
            0,    0,  207,  207,  207,  207,  207,  207,  207,  207, 
          207,  207,    0,  207,  207,    0,    0,  207,  207,    0, 
            0,    0,  207,    0,    0,  207,    0,    0,  207,    0, 
          207,    0,  207,  211,  207,    0,  207,  207,  207,  207, 
          207,  207,  207,  211,  207,    0,  207,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  207,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  211,    0,  209, 
          209,  209,    0,    0,  209,  209,  209,    0,  209,    0, 
            0,  211,  211,    0,    0,    0,  211,    0,  209,  209, 
            0,    0,    0,    0,    0,    0,    0,  209,  209,    0, 
          209,  209,  209,  209,  209,    0,    0,    0,    0,    0, 
            0,    0,  209,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  209,  209,  209,  209,  209, 
          209,  209,  209,  209,  209,    0,  209,  209,    0,  212, 
          209,  209,    0,    0,    0,  209,    0,    0,  209,  212, 
            0,  209,    0,  209,    0,  209,    0,  209,    0,  209, 
          209,  209,  209,  209,  209,  209,    0,  209,    0,  209, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  209,    0,  212,  208,  208,  208,    0,    0,  208, 
          208,  208,    0,  208,    0,    0,    0,  212,  212,    0, 
            0,    0,  212,  208,  208,    0,    0,    0,    0,    0, 
            0,    0,  208,  208,    0,  208,  208,  208,  208,  208, 
            0,    0,    0,    0,    0,    0,    0,  208,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          208,  208,  208,  208,  208,  208,  208,  208,  208,  208, 
            0,  208,  208,    0,    0,  208,  208,    0,    0,    0, 
          208,    0,    0,  208,    0,    0,  208,    0,  208,    0, 
          208,  205,  208,    0,  208,  208,  208,  208,  208,  208, 
          208,  205,  208,    0,  208,  211,  211,  211,    0,    0, 
          211,  211,  211,    0,  211,    0,  208,    0,    0,    0, 
            0,    0,    0,    0,  211,  211,    0,    0,    0,    0, 
            0,    0,    0,  211,  211,  205,  211,  211,  211,  211, 
          211,    0,    0,    0,    0,    0,    0,    0,  211,  205, 
          205,    0,    0,    0,  205,    0,    0,    0,    0,    0, 
            0,  211,  211,  211,  211,  211,  211,  211,  211,  211, 
          211,    0,  211,  211,    0,    0,  211,  211,    0,    0, 
            0,  211,    0,    0,  211,    0,    0,  211,    0,  211, 
            0,  211,    0,  211,    0,  211,  211,  211,  211,  211, 
          211,  211,    0,  211,  206,  211,    0,    0,    0,    0, 
            0,    0,    0,    0,  206,    0,    0,  211,    0,    0, 
            0,  212,  212,  212,    0,    0,  212,  212,  212,    0, 
          212,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          212,  212,    0,    0,    0,    0,    0,    0,  206,  212, 
          212,    0,  212,  212,  212,  212,  212,    0,    0,    0, 
            0,    0,  206,  206,  212,    0,    0,  206,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  212,  212,  212, 
          212,  212,  212,  212,  212,  212,  212,    0,  212,  212, 
            0,    0,  212,  212,    0,    0,    0,  212,    0,    0, 
          212,    0,    0,  212,    0,  212,    0,  212,  230,  212, 
            0,  212,  212,  212,  212,  212,  212,  212,  230,  212, 
            0,  212,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  212,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  230,  205,  205,  205,    0,    0,  205,  205, 
          205,    0,  205,    0,    0,    0,  230,  230,    0,    0, 
            0,  230,  205,  205,    0,    0,    0,    0,    0,    0, 
            0,  205,  205,    0,  205,  205,  205,  205,  205,    0, 
            0,    0,    0,    0,    0,    0,  205,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  205, 
          205,  205,  205,  205,  205,  205,  205,  205,  205,    0, 
          205,  205,    0,    0,  205,  205,    0,    0,    0,  205, 
          231,    0,  205,    0,    0,  205,    0,  205,    0,    0, 
          231,  205,    0,    0,    0,  205,  205,  205,  205,  205, 
            0,  205,    0,  205,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  205,  206,  206,  206,    0, 
            0,  206,  206,  206,  231,  206,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  206,  206,    0,  231,  231, 
            0,    0,    0,  231,  206,  206,    0,  206,  206,  206, 
          206,  206,    0,    0,    0,    0,    0,    0,    0,  206, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  206,  206,  206,  206,  206,  206,  206,  206, 
          206,  206,    0,  206,  206,    0,    0,  206,  206,    0, 
            0,    0,  206,    0,    0,  206,    0,    0,  206,    0, 
          206,    0,    0,  217,  206,    0,    0,    0,  206,  206, 
          206,  206,  206,  217,  206,    0,  206,    0,    0,    0, 
          230,  230,  230,    0,    0,  230,  230,  230,  206,  230, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  230, 
          230,    0,    0,    0,    0,    0,    0,  217,  230,  230, 
            0,  230,  230,  230,  230,  230,    0,    0,    0,    0, 
            0,  217,  217,  230,    0,    0,  217,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  230,  230,  230,  230, 
          230,  230,  230,  230,  230,  230,    0,  230,  230,    0, 
            0,  230,  230,    0,    0,    0,  230,    0,    0,  230, 
            0,    0,  230,    0,  230,    0,    0,    0,  230,    0, 
            0,    0,    0,    0,  230,  230,  230,    0,  230,    0, 
          230,  215,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  215,  230,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  231,  231,  231,    0,    0,  231,  231,  231, 
            0,  231,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  231,  231,    0,    0,  215,    0,    0,    0,    0, 
          231,  231,    0,  231,  231,  231,  231,  231,    0,  215, 
          215,    0,    0,    0,  215,  231,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  231,  231, 
          231,  231,  231,  231,  231,  231,  231,  231,    0,  231, 
          231,    0,    0,  231,  231,    0,    0,    0,  231,    0, 
            0,  231,    0,    0,  231,    0,  231,    0,    0,  216, 
          231,    0,    0,    0,    0,    0,  231,  231,  231,  216, 
          231,    0,  231,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  231,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  217,  217,  217,    0,    0, 
          217,  217,  217,  216,  217,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  217,  217,    0,  216,  216,    0, 
            0,    0,  216,  217,  217,    0,  217,  217,  217,  217, 
          217,    0,    0,    0,    0,    0,    0,    0,  217,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  217,  217,  217,  217,  217,  217,  217,  217,  217, 
          217,    0,  217,  217,    0,    0,    0,    0,  220,    0, 
            0,  217,    0,    0,  217,    0,    0,  217,  220,  217, 
            0,    0,    0,  217,    0,    0,    0,    0,    0,  217, 
          217,  217,    0,  217,    0,  217,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  217,    0,    0, 
            0,    0,  220,  215,  215,  215,    0,    0,  215,  215, 
          215,    0,  215,    0,    0,    0,  220,  220,    0,    0, 
            0,  220,  215,  215,    0,    0,    0,    0,    0,    0, 
            0,  215,  215,    0,  215,  215,  215,  215,  215,    0, 
            0,    0,    0,    0,    0,    0,  215,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  215, 
          215,  215,  215,  215,  215,  215,  215,  215,  215,    0, 
          215,  215,    0,    0,    0,    0,    0,    0,  222,  215, 
            0,    0,  215,    0,    0,  215,    0,  215,  222,    0, 
            0,    0,    0,    0,    0,    0,    0,  215,  215,  215, 
            0,  215,    0,  215,    0,    0,    0,    0,    0,    0, 
            0,  216,  216,  216,    0,  215,  216,  216,  216,    0, 
          216,    0,  222,    0,    0,    0,    0,    0,    0,    0, 
          216,  216,    0,    0,    0,    0,  222,  222,    0,  216, 
          216,  222,  216,  216,  216,  216,  216,    0,    0,    0, 
            0,    0,    0,    0,  216,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  216,  216,  216, 
          216,  216,  216,  216,  216,  216,  216,    0,  216,  216, 
            0,    0,    0,    0,    0,    0,    0,  216,    0,    0, 
          216,    0,    0,  216,    0,  216, 
      };
   }

   private static final short[] yyTable3() {
      return new short[] {

            0,    0,  221,    0,    0,    0,    0,    0,    0,  216, 
          216,  216,  221,  216,    0,  216,    0,    0,    0,    0, 
            0,    0,    0,    0,  220,  220,  220,  216,    0,  220, 
          220,  220,    0,  220,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  220,  220,    0,  221,    0,    0,    0, 
            0,    0,  220,  220,    0,  220,  220,  220,  220,  220, 
          221,  221,    0,    0,    0,  221,    0,  220,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          220,  220,  220,  220,  220,  220,  220,  220,  220,  220, 
            0,  220,  220,    0,    0,    0,    0,    0,    0,  219, 
          220,    0,    0,  220,    0,    0,  220,    0,  220,  219, 
            0,    0,    0,    0,    0,    0,    0,    0,  220,  220, 
            0,    0,    0,    0,  220,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  220,    0,    0,    0, 
            0,    0,    0,  219,  222,  222,  222,    0,    0,  222, 
          222,  222,    0,  222,    0,    0,    0,  219,  219,    0, 
            0,    0,  219,  222,  222,    0,    0,    0,    0,    0, 
            0,    0,  222,  222,    0,  222,  222,  222,  222,  222, 
            0,    0,    0,    0,    0,    0,    0,  222,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          222,  222,  222,  222,  222,  222,  222,  222,  222,  222, 
            0,  222,  222,    0,    0,    0,    0,  218,    0,    0, 
          222,    0,    0,  222,    0,    0,  222,  218,  222,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  222,  222, 
            0,    0,    0,    0,  222,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  222,    0,    0,    0, 
            0,  218,    0,    0,  221,  221,  221,    0,    0,  221, 
          221,  221,    0,  221,    0,  218,  218,    0,    0,    0, 
          218,    0,    0,  221,  221,    0,    0,    0,    0,    0, 
            0,    0,  221,  221,    0,  221,  221,  221,  221,  221, 
            0,    0,    0,    0,    0,    0,    0,  221,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          221,  221,  221,  221,  221,  221,  221,  221,  221,  221, 
            0,  221,  221,    0,    0,    0,    0,    0,    0,  223, 
          221,    0,    0,  221,    0,    0,  221,    0,  221,  223, 
            0,    0,    0,    0,    0,    0,    0,    0,  221,  221, 
            0,  219,  219,  219,  221,    0,  219,  219,  219,    0, 
          219,    0,    0,    0,    0,    0,  221,    0,    0,    0, 
          219,  219,    0,  223,    0,    0,    0,    0,    0,  219, 
          219,    0,  219,  219,  219,  219,  219,  223,  223,    0, 
            0,    0,  223,    0,  219,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  219,  219,  219, 
          219,  219,  219,  219,  219,  219,  219,    0,  219,  219, 
            0,    0,    0,    0,    0,    0,    0,  219,    0,    0, 
          219,    0,    0,  219,    0,  219,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  219,  219,  224,    0,    0, 
            0,  219,    0,    0,    0,    0,    0,  224,    0,    0, 
            0,    0,    0,  219,    0,    0,    0,    0,    0,  218, 
          218,  218,    0,    0,  218,  218,  218,    0,  218,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  218,  218, 
            0,  224,    0,    0,    0,    0,    0,  218,  218,    0, 
          218,  218,  218,  218,  218,  224,  224,    0,    0,    0, 
          224,    0,  218,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  218,  218,    0,    0,    0,  218,  218,    0,    0, 
            0,    0,    0,    0,  225,  218,    0,    0,  218,    0, 
            0,  218,    0,  218,  225,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  218, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  218,    0,    0,    0,    0,    0,    0,  225,    0, 
            0,  223,  223,  223,    0,    0,  223,  223,  223,    0, 
          223,    0,  225,  225,    0,    0,    0,  225,    0,    0, 
          223,  223,    0,    0,    0,    0,    0,    0,    0,  223, 
          223,    0,  223,  223,  223,  223,  223,    0,    0,    0, 
          232,    0,    0,    0,  223,    0,    0,    0,    0,    0, 
          232,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  223,  223,    0,    0,    0,  223,  223, 
            0,    0,    0,    0,    0,    0,    0,  223,    0,    0, 
          223,    0,    0,  223,  232,  223,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  232,  232, 
            0,  223,    0,  232,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  223,    0,    0,    0,    0,    0,  224, 
          224,  224,    0,    0,  224,  224,  224,    0,  224,    0, 
          226,    0,    0,    0,    0,    0,    0,    0,  224,  224, 
          226,    0,    0,    0,    0,    0,    0,  224,  224,    0, 
          224,  224,  224,  224,  224,    0,    0,    0,    0,    0, 
            0,    0,  224,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  226,    0,    0,    0,    0,    0, 
            0,  224,  224,    0,    0,    0,  224,  224,  226,  226, 
            0,    0,    0,  226,    0,  224,    0,    0,  224,    0, 
            0,  224,    0,  224,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  225,  225,  225,  224, 
            0,  225,  225,  225,    0,  225,    0,  227,    0,    0, 
            0,  224,    0,    0,    0,  225,  225,  227,    0,    0, 
            0,    0,    0,    0,  225,  225,    0,  225,  225,  225, 
          225,  225,    0,    0,    0,    0,    0,    0,    0,  225, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  227,    0,    0,    0,    0,    0,    0,  225,  225, 
            0,    0,    0,  225,  225,  227,  227,    0,    0,    0, 
          227,    0,  225,    0,    0,  225,    0,    0,  225,    0, 
          225,    0,  232,  232,  232,    0,    0,  232,  232,  232, 
            0,  232,    0,  233,    0,    0,  225,    0,    0,    0, 
            0,  232,  232,  233,    0,    0,    0,    0,  225,    0, 
          232,  232,    0,  232,  232,  232,  232,  232,    0,    0, 
            0,    0,    0,    0,    0,  232,    0,    0,    0,    0, 
            0,   38,    0,    0,    0,    0,    0,  233,    0,    0, 
            0,   38,    0,    0,  232,  232,    0,    0,    0,  232, 
          232,  233,  233,    0,    0,    0,  233,    0,  232,    0, 
            0,  232,    0,    0,  232,    0,  232,    0,    0,    0, 
            0,    0,  226,  226,  226,  258,    0,  226,  226,  226, 
            0,  226,  232,  203,    0,    0,    0,    0,    0,    0, 
           38,  226,  226,  203,  232,    0,    0,    0,    0,    0, 
          226,  226,    0,  226,  226,  226,  226,  226,    0,    0, 
            0,    0,    0,    0,    0,  226,    0,    0,    0,    0, 
            0,    0,    0,  204,    0,    0,    0,  203,    0,    0, 
            0,    0,    0,  204,  226,  226,    0,    0,    0,  226, 
          226,  203,  203,    0,    0,    0,  203,    0,  226,    0, 
            0,  226,    0,    0,  226,    0,  226,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  204,    0,  227, 
          227,  227,  226,    0,  227,  227,  227,    0,  227,    0, 
            0,  204,  204,    0,  226,    0,  204,    0,  227,  227, 
            0,    0,    0,    0,    0,    0,    0,  227,  227,    0, 
          227,  227,  227,  227,  227,    0,    0,    0,  202,    0, 
            0,    0,  227,    0,    0,    0,    0,    0,  202,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  227,  227,    0,    0,    0,  227,  227,    0,    0, 
            0,    0,    0,    0,    0,  227,    0,    0,  227,    0, 
            0,  227,  202,  227,    0,  233,  233,  233,    0,    0, 
          233,  233,  233,    0,  233,    0,  202,  202,    0,  227, 
            0,    0,    0,    0,  233,  233,    0,    0,    0,    0, 
            0,  227,    0,  233,  233,    0,  233,  233,  233,  233, 
          233,    0,    0,   38,   38,   38,    0,    0,  233,   38, 
           38,    0,   38,    0,  201,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  201,    0,    0,    0,  233,    0, 
            0,    0,  233,  233,   38,   38,   38,   38,   38,    0, 
            0,  233,    0,    0,  233,    0,    0,  233,    0,  233, 
            0,    0,    0,    0,    0,  203,  203,  203,  201,    0, 
          203,  203,  203,    0,  203,  233,    0,    0,    0,    0, 
            0,    0,  201,  201,  203,  203,    0,  233,    0,    0, 
            0,    0,   38,  203,  203,    0,  203,  203,  203,  203, 
          203,    0,    0,    0,    0,  204,  204,  204,  203,  197, 
          204,  204,  204,   38,  204,    0,    0,    0,    0,  197, 
            0,    0,    0,    0,  204,  204,    0,    0,    0,    0, 
            0,    0,    0,  204,  204,    0,  204,  204,  204,  204, 
          204,  203,    0,    0,  203,    0,    0,  203,  204,  203, 
            0,    0,    0,  197,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  203,    0,  197,  197,    0, 
          198,    0,    0,    0,    0,    0,    0,  203,    0,    0, 
          198,  204,    0,    0,  204,    0,    0,  204,    0,  204, 
          202,  202,  202,    0,    0,  202,  202,  202,    0,  202, 
            0,    0,    0,    0,    0,  204,    0,    0,    0,  202, 
          202,    0,    0,    0,  198,    0,    0,  204,  202,  202, 
            0,  202,  202,  202,  202,  202,    0,    0,  198,  198, 
            0,    0,    0,  202,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  202,  199,    0,  202, 
            0,    0,  202,    0,  202,    0,    0,  199,    0,    0, 
            0,    0,    0,    0,    0,    0,  201,  201,  201,    0, 
          202,  201,  201,  201,    0,  201,    0,    0,    0,    0, 
            0,    0,  202,    0,    0,  201,  201,    0,    0,    0, 
            0,  199,    0,    0,  201,  201,    0,  201,  201,  201, 
          201,  201,    0,    0,    0,  199,  199,    0,    0,  201, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  200,    0,    0,    0,    0,    0,    0, 
            0,    0,  201,  200,    0,  201,    0,    0,  201,    0, 
          201,  197,  197,  197,    0,    0,  197,  197,  197,    0, 
          197,    0,    0,    0,    0,    0,  201,    0,    0,    0, 
          197,  197,    0,    0,    0,    0,    0,  200,  201,  197, 
          197,    0,  197,  197,  197,  197,  197,    0,    0,    0, 
            0,  200,  200,    0,  197,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  198,  198,  198,    0,    0,  198,  198,  198, 
            0,  198,    0,    0,    0,    0,    0,  197,    0,    0, 
          197,  198,  198,  197,    0,  197,    0,    0,    0,    0, 
          198,  198,  193,  198,  198,  198,  198,  198,    0,    0, 
            0,  197,  193,    0,    0,  198,    0,    0,    0,    0, 
            0,    0,    0,  197,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  193,    0,  198,    0, 
            0,  198,    0,    0,  198,    0,  198,    0,    0,    0, 
          193,  193,    0,  195,    0,    0,    0,    0,    0,  199, 
          199,  199,  198,  195,  199,  199,  199,    0,  199,    0, 
            0,    0,    0,    0,  198,    0,    0,    0,  199,  199, 
            0,    0,    0,    0,    0,    0,    0,  199,  199,    0, 
          199,  199,  199,  199,  199,    0,    0,  195,    0,    0, 
            0,    0,  199,    0,    0,    0,    0,    0,    0,    0, 
            0,  195,  195,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  199,    0,    0,  199,  235, 
            0,  199,    0,  199,    0,  200,  200,  200,    0,  235, 
          200,  200,  200,    0,  200,    0,    0,    0,    0,  199, 
            0,    0,    0,    0,  200,  200,    0,    0,    0,    0, 
            0,  199,    0,  200,  200,    0,  200,  200,  200,  200, 
          200,    0,    0,  235,    0,    0,    0,    0,  200,    0, 
            0,    0,    0,    0,    0,    0,    0,  235,  235,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  200,    0,    0,  200,    0,    0,  200,    0,  200, 
            0,    0,    0,    0,    0,    0,  196,    0,    0,    0, 
            0,    0,    0,    0,    0,  200,  196,    0,    0,    0, 
            0,    0,    0,    0,  193,  193,  193,  200,    0,  193, 
          193,  193,    0,  193,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  193,  193,    0,    0,    0,    0,    0, 
          196,    0,  193,  193,    0,  193,  193,  193,  193,  193, 
            0,    0,    0,  264,  196,  196,    0,  193,    0,    0, 
            0,    0,    0,  264,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  195,  195,  195,    0,    0, 
          195,  195,  195,    0,  195,    0,    0,    0,    0,    0, 
          193,    0,    0,  193,  195,  195,  193,  259,  193,    0, 
            0,    0,    0,  195,  195,  237,  195,  195,  195,  195, 
          195,    0,  264,    0,  193,  237,    0,    0,  195,    0, 
            0,    0,    0,    0,    0,    0,  193,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  237, 
            0,  195,    0,    0,  195,    0,    0,  195,    0,  195, 
            0,  235,  235,  235,  237,    0,  235,  235,  235,    0, 
          235,    0,    0,    0,    0,  195,    0,    0,    0,    0, 
          235,  235,    0,    0,    0,    0,    0,  195,    0,  235, 
          235,  194,  235,  235,  235,  235,  235,    0,    0,    0, 
            0,  194,    0,    0,  235,    0,    0,  262,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  262,    0,    0, 
            0,    0,    0,    0,    0,    0,  192,    0,    0,    0, 
            0,    0,    0,    0,    0,  194,  192,  235,    0,    0, 
          235,    0,    0,  235,    0,  235,    0,    0,    0,  194, 
          194,  260,    0,    0,    0,    0,    0,    0,  196,  196, 
          196,  235,    0,  196,  196,  196,  262,  196,    0,    0, 
          192,    0,    0,  235,    0,    0,    0,  196,  196,    0, 
            0,    0,    0,    0,  192,  192,  196,  196,    0,  196, 
          196,  196,  196,  196,    0,    0,    0,    0,    0,    0, 
            0,  196,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  264,  264,  264,    0,    0, 
          264,  264,  264,    0,  264,    0,    0,    0,    0,    0, 
            0,  104,    0,    0,  196,    0,    0,  196,    0,    0, 
          196,    0,  196,    0,    0,    0,  264,  264,  264,  264, 
          264,    0,    0,    0,    0,    0,    0,    0,  196,    0, 
            0,    0,    0,    0,    0,    0,    0,  237,  237,  237, 
          196,    0,  237,  237,  237,    0,  237,    0,    0,    0, 
          104,    0,    0,    0,    0,    0,  237,  237,    0,    0, 
            0,  264,    0,    0,  264,  237,  237,    0,  237,  237, 
          237,  237,  237,    0,    0,    0,    0,    0,    0,    0, 
          237,    0,  452,    0,    0,  264,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  237,    0,    0,  237,    0,    0,  237, 
            0,  237,    0,  194,  194,  194,    0,  105,  194,  194, 
          194,    0,  194,    0,    0,    0,    0,  237,    0,  262, 
          262,  262,  194,  194,  262,  262,  262,    0,  262,  237, 
            0,  194,  194,    0,  194,  194,  194,  194,  192,  192, 
          192,    0,    0,  192,  192,  192,  194,  192,    0,    0, 
          262,  262,  262,  262,  262,    0,  105,  192,  192,    0, 
            0,    0,    0,    0,    0,    0,  192,  192,    0,  192, 
          192,  192,  192,    0,    0,    0,    0,    0,    0,  194, 
            0,  192,  194,    0,    0,  194,    0,  194,  455,    0, 
            0,    0,    0,    0,    0,  262,    0,    0,  262,    0, 
            0,    0,    0,  194,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  192,  194,    0,  192,    0,  262, 
          192,    0,  192,    0,    0,    0,    0,  104,  104,  104, 
          104,  104,  104,  104,  104,  104,  104,  104,  192,  104, 
          104,  104,    0,  104,  104,  104,  104,  104,  104,  104, 
          192,  523,    0,    0,  104,  104,  104,  104,  104,  104, 
          104,    0,    0,  104,    0,    0,    0,    0,    0,  104, 
          104,    0,  104,  104,  104,  104,    0,  104,  104,  104, 
          104,  104,  104,    0,  104,  104,  104,  104,  104,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  452, 
            0,    0,    0,    0,    0,    0,  452,  104,    0,    0, 
          104,  523,    0,  104,  104,    0,  104,    0,  104,    0, 
          530,    0,  104,    0,    0,    0,    0,  104,    0,    0, 
          104,    0,  523,    0,    0,  104,  104,  104,  104,  104, 
          104,    0,    0,    0,  104,    0,  104,  104,    0,  104, 
          104,    0,    0,  105,  105,  105,  105,  105,  105,  105, 
          105,  105,  105,  105,    0,  105,  105,  105,    0,  105, 
          105,  105,  105,  105,  105,  105,    0,  524,    0,    0, 
          105,  105,  105,  105,  105,  105,  105,    0,    0,  105, 
            0,    0,    0,    0,    0,  105,  105,    0,  105,  105, 
          105,  105,    0,  105,  105,  105,  105,  105,  105,    0, 
          105,  105,  105,  105,  105,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  455,    0,    0,    0,    0, 
            0,    0,  455,  105,    0,    0,  105,  524,    0,  105, 
          105,    0,  105,    0,  105,    0,  278,    0,  105,    0, 
            0,    0,    0,  105,    0,    0,  105,    0,  524,    0, 
            0,  105,  105,  105,  105,  105,  105,    0,    0,    0, 
          105,    0,  105,  105,    0,  105,  105,    0,    0,    0, 
            0,    0,    0,    0,    0,  104,  104,  104,  104,  104, 
          104,  104,  104,  104,  104,  104,    0,  105,  104,  104, 
            0,  104,  104,  104,  104,  104,  104,  104,    0,  530, 
            0,    0,  104,  104,  104,  104,  104,  104,  104,    0, 
            0,  104,    0,    0,    0,    0,    0,  104,  104,    0, 
          104,  104,  104,  104,    0,  104,  104,  104,  104,  104, 
          104,    0,  104,  104,  104,  104,  105,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  530,    0,    0, 
            0,    0,    0,    0,  530,  104,    0,    0,  104,  526, 
            0,  104,  104,    0,  104,    0,  104,    0,  279,    0, 
          104,    0,    0,    0,    0,  104,    0,    0,  104,    0, 
          530,    0,    0,  104,  104,  104,  104,  104,  104,    0, 
            0,    0,  104,    0,  104,  104,    0,  104,  104,    0, 
            0,  105,  105,  105,  105,  105,  105,  105,  105,  105, 
          105,  105,    0,  323,  105,  105,    0,  105,  105,  105, 
          105,  105,  105,  105,    0,    0,    0,    0,  105,  105, 
          105,  105,  105,  105,  105,    0,    0,  105,    0,    0, 
            0,    0,    0,  105,  105,    0,  105,  105,  105,  105, 
            0,  105,  105,  105,  105,  105,  105,    0,  105,  105, 
          105,  105,  323,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  278,    0,    0,    0,    0,    0,    0, 
          278,  105,    0,    0,  105,  527,    0,  105,  105,    0, 
          105,    0,  105,    0,    0,    0,  105,    0,    0,    0, 
            0,  105,    0,    0,  105,    0,    0,    0,    0,  105, 
          105,  105,  105,  105,  105,    0,    0,    0,  105,    0, 
          105,  105,    0,  105,  105,    0,    0,    0,    0,    0, 
            0,    0,    0,  105,  105,  105,  105,  105,  105,  105, 
          105,  105,  105,  105,    0,  548,  105,  105,    0,  105, 
          105,  105,  105,  105,  105,  105,    0,    0,    0,    0, 
          105,  105,  105,  105,  105,  105,  105,    0,    0,  105, 
            0,    0,    0,    0,    0,  105,  105,    0,  105,  105, 
          105,  105,    0,  105,  105,  105,  105,  105,  105,    0, 
          105,  105,  105,  105,  548,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  279,    0,    0,    0,    0, 
            0,    0,  279,  105,    0,    0,  105,    0,    0,  105, 
          105,    0,  105,    0,  105,    0,    0,    0,  105,    0, 
            0,    0,    0,  105,    0,    0,  105,    0,    0,    0, 
            0,  105,  105,  105,  105,  105,  105,    0,    0,    0, 
          105,    0,  105,  105,    0,  105,  105,    0,    0,  323, 
          323,  323,  323,  323,  323,  323,  323,  323,  323,  323, 
            0,  323,  323,  323,  323,  323,  323,  323,  323,  323, 
          323,  323,  548,    0,    0,    0,  323,  323,  323,  323, 
          323,  323,  323,    0,    0,  323,    0,    0,    0,    0, 
            0,  323,  323,    0,  323,  323,  323,  323,    0,  323, 
          323,  323,  323,  323,  323,    0,  323,  323,  323,  323, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  548,    0,    0,    0,    0,    0,    0,    0,  323, 
            0,    0,  323,    0,    0,  323,  323,    0,  323,    0, 
          323,    0,    0,    0,  323,    0,    0,    0,    0,    0, 
            0,    0,  323,    0,    0,    0,    0,  323,  323,  323, 
          323,  323,  323,    0,    0,    0,  323,    0,  323,  323, 
            0,  323,  323,    0,    0,    0,    0,    0,    0,    0, 
            0,  548,  548,  548,  548,  548,  548,    0,    0,  548, 
          548,  548,    0,    0,    0,  548,  233,  548,  548,  548, 
          548,  548,  548,  548,    0,    0,    0,    0,  548,  548, 
          548,  548,  548,  548,  548,    0,    0,  548,    0,    0, 
            0,    0,    0,  548,  548,    0,  548,  548,  548,  548, 
            0,  548,  548,  548,  548,  548,  548,    0,  548,  548, 
          548,  548,    0,    0,    0,  232,    0,   22,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   22,    0,    0, 
            0,  548,    0,    0,  548,    0,    0,  548,  548,    0, 
          548,    0,  548,    0,    0,    0,  548,    0,    0,    0, 
            0,    0,    0,    0,  548,    0,    0,    0,    0,  548, 
          548,  548,  548,  548,  548,    0,    0,    0,  548,    0, 
          548,  548,    0,  548,  548,    0,   22,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  548,  548, 
          548,  548,  548,  548,    0,    0,    0,  548,  548,    0, 
            0,    0,  548,    0,  548,  548,  548,  548,  548,  548, 
          548,    0,    0,    0,    0,  548,  548,  548,  548,  548, 
          548,  548,    0,    0,  548,    0,    0,    0,    0,    0, 
          548,  548,    0,  548,  548,  548,  548,    0,  548,  548, 
          548,  548,  548,  548,    0,  548,  548,  548,  548,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  548,    0, 
            0,  548,    0,    0,  548,  548,    0,  548,    0,  548, 
            0,    0,    0,  548,    0,    0,    0,    0,    0,    0, 
            0,  548,    0,  392,  548,    0,  548,  548,  548,  548, 
          548,  548,    0,  392,    0,  548,    0,  548,  548,    0, 
          548,  548,    0,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,   89,    0,   19, 
           20,   21,   22,   23,   24,   25,    0,    0,   26,    0, 
            0,    0,  392,    0,   97,   28,  392,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,   22, 
           22,   22,    0,    0,  392,   22,   22,    0,   22,    0, 
            0,    0,  223,    0,  318,  113,    0,    0,   46,   47, 
            0,   48,    0,    0,  318,    0,    0,   50,    0,    0, 
           22,   22,   22,   22,   22,   51,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    0,    0,  318,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  318,    0,    0,    0,  318,   22,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   22, 
            0,    0,    0,    0,    0,  318,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
          319,   12,   13,   14,  101,  102,   17,   18,    0,    0, 
          319,    0,  103,  104,  105,   22,   23,   24,   25,    0, 
            0,  106,    0,    0,    0,    0,    0,    0,  107,    0, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,    0,  319,  110,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  392,  392,  392,    0,  319, 
            0,  392,  392,  319,  392,  240,    0,    0,   45,    0, 
            0,   46,   47,  392,   48,    0,   49,    0,    0,    0, 
            0,    0,    0,  392,  392,    0,  392,  392,  392,  392, 
          392,  319,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    0, 
          392,  392,  392,  392,  392,  392,  392,  392,  392,  392, 
          392,  392,  392,  392,    0,    0,  392,  392,  392,    0, 
            0,    0,    0,    0,  392,    0,    0,    0,    0,    0, 
            0,  392,  282,  392,    0,  392,  392,  392,  392,  392, 
          392,  392,  282,  392,  392,  392,  318,  318,  318,    0, 
            0,  318,  318,  318,    0,  318,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  318,    0,    0,    0,    0, 
            0,    0,    0,    0,  318,  318,  282,  318,  318,  318, 
          318,  318,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  282,    0,    0,    0,  282,    0,    0,    0,    0, 
            0,  318,  318,  318,  318,  318,  318,  318,  318,  318, 
          318,  318,  318,  318,  318,    0,    0,  318,  318,  318, 
            0,    0,    0,  282,    0,  318,    0,    0,    0,    0, 
            0,    0,  318,    0,  318,  464,  318,  318,  318,  318, 
          318,  318,  318,    0,  318,  464,  318,    0,    0,    0, 
            0,    0,  319,  319,  319,    0,    0,  319,  319,  319, 
            0,  319,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  319,    0,    0,    0,    0,    0,    0,    0,   88, 
          319,  319,    0,  319,  319,  319,  319,  319,    0,    0, 
            0,    0,    0,    0,  464,    0,   96,    0,  464,    0, 
            0,    0,    0,    0,    0,    0,    0,  319,  319,  319, 
          319,  319,  319,  319,  319,  319,  319,  319,  319,  319, 
          319,    0,    0,  319,  319,  319,  464,    0,    0,    0, 
            0,  319,    0,    0,    0,    0,    0,    0,  319,    0, 
          319,    0,  319,  319,  319,  319,  319,  319,  319,  272, 
          319,    0,  319,    0,    0,    0,    0,    0,    0,  272, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   95,  282,  282,  282,    0,    0,  282, 
          282,  282,    0,  282,    0,    0,    0,    0,  272,    0, 
          103,    0,  272,  282,    0,    0,    0,    0,    0,    0, 
            0,    0,  282,  282,    0,  282,  282,  282,  282,  282, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          272,    0,    0,    0,    0,    0,    0,    0,    0,  282, 
          282,  282,  282,  282,  282,  282,  282,  282,  282,  282, 
          282,  282,  282,    0,    0,  282,  282,  282,    0,    0, 
            0,    0,    0,  282,    0,    0,    0,    0,    0,    0, 
          282,    0,  282,  279,  282,  282,  282,  282,  282,  282, 
          282,    0,  282,  279,  282,    0,    0,  464,  464,  464, 
            0,    0,    0,  464,  464,    0,  464,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  464,  464,   94,  464,  464, 
          464,  464,  464,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  279,    0,  102,    0,  279,    0,    0,    0, 
            0,    0,  464,  464,  464,  464,  464,  464,  464,  464, 
          464,  464,  464,  464,  464,  464,    0,    0,  464,  464, 
          464,    0,  465,    0,  279,    0,  464,    0,    0,    0, 
            0,    0,    0,  464,    0,  464,    0,  464,  464,  464, 
          464,  464,  464,  464,   60,  464,    0,  464,    0,    0, 
            0,    0,    0,    0,   60,    0,    0,    0,    0,    0, 
            0,  272,  272,  272,    0,    0,    0,  272,  272,    0, 
          272,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   62,    0,  272, 
          272,    0,  272,  272,  272,  272,  272,   62,    0,    0, 
            0,    0,    0,   60,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  272,  272,  272,  272, 
          272,  272,  272,  272,  272,  272,  272,  272,  272,  272, 
            0,    0,  272,  272,  272,    0,    0,    0,    0,    0, 
          272,    0,    0,    0,    0,    0,   62,  272,   64,  272, 
            0,  272,  272,  272,  272,  272,  272,  272,   64,  272, 
            0,  272,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   48,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,   48,  279,  279,  279,    0,    0, 
            0,  279,  279,    0,  279,    0,    0,   64,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  279,  279,    0,  279,  279,  279,  279, 
          279,    0,    0,    0,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,   48,    0,    0,    0,   50,    0,    0, 
          279,  279,  279,  279,  279,  279,  279,  279,  279,  279, 
          279,  279,  279,  279,    0,    0,  279,  279,  279,    0, 
            0,    0,    0,    0,  279,    0,    0,    0,    0,    0, 
            0,  279,    0,  279,    0,  279,  279,  279,  279,  279, 
          279,  279,    0,  279,   55,  279,   50,    0,    0,    0, 
            0,    0,    0,    0,   55,    0,   60,   60,   60,    0, 
            0,   60,   60,   60,    0,   60,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   60,   60,    0,    0,    0, 
            0,    0,    0,    0,   60,   60,    0,   60,   60,   60, 
           60,   60,    0,    0,    0,    0,    0,    0,    0,   62, 
           62,   62,    0,   55,   62,   62,   62,    0,   62,    0, 
            0,    0,    0,    0,    0,  263,    0,    0,   62,   62, 
            0,    0,    0,    0,    0,  263,    0,   62,   62,    0, 
           62,   62,   62,   62,   62,   60,    0,    0,   60,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   60,    0,    0,  261, 
           64,   64,   64,    0,    0,   64,   64,   64,    0,   64, 
            0,    0,    0,    0,  263,    0,    0,    0,   62,   64, 
           64,   62,    0,    0,    0,    0,    0,    0,   64,   64, 
            0,   64,   64,   64,   64,   64,   48,   48,   48,   62, 
            0,   48,   48,   48,    0,   48,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   48,    0,    0,  416,    0, 
            0,    0,    0,    0,   48,   48,    0,   48,   48,   48, 
           48,   48,    0,    0,    0,    0,    0,    0,    0,   64, 
            0,    0,   64,    0,    0,    0,    0,    0,    0,   50, 
           50,   50,    0,    0,   50,   50, 
      };
   }

   private static final short[] yyTable4() {
      return new short[] {

           50,    0,   50,    0,   64,    0,    0,    0,    0,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,   48, 
            0,   50,   50,    0,   50,   50,   50,   50,   50,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           48,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
           55,   55,   55,    0,    0,   55,   55,   55,    0,   55, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   55, 
            0,    0,   50,    0,    0,    0,    0,    0,   55,   55, 
            0,   55,   55,   55,   55,   55,  416,    0,    0,    0, 
          631,  553,    0,   50,  632,    0,    0,    0,  167,  168, 
            0,  169,  170,  171,  172,  173,  174,  175,    0,    0, 
          176,  177,    0,    0,    0,  178,  179,  180,  181,    0, 
            0,  263,  263,  263,  264,    0,  263,  263,  263,   55, 
          263,  183,  184,    0,  185,  186,  187,  188,  189,  190, 
          191,  192,  193,  194,  195,    0,    0,  196,    0,    0, 
           55,    0,  263,  263,  263,  263,  263,    0,    0,    0, 
            4,    5,    6,    7,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,   15,   16, 
           17,   18,    0,    0,    0,    0,   19,   20,   21,   22, 
           23,   24,   25,    0,    0,   26,    0,  263,    0,    0, 
          263,   27,   28,   29,   30,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,  263,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   44, 
            0,    0,   45,    0,    0,   46,   47,    0,   48,    0, 
           49,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,   51,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,    0,    4,    5,    6,    7,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,   15,   16,   17,   18,    0,    0,    0,    0, 
           19,   20,   21,   22,   23,   24,   25,    0,    0,   26, 
            0,    0,    0,    0,    0,   27,   28,    0,   30,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,    0, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,   44,    0,    0,   45,    0,    0,   46, 
           47,    0,   48,    0,   49,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,   51,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    3,    4,    5, 
            6,    7,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,   15,   16,   17,   18, 
            0,    0,    0,    0,   19,   20,   21,   22,   23,   24, 
           25,    0,    0,   26,    0,    0,    0,    0,    0,   27, 
           28,   29,   30,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,   44,    0,    0, 
           45,    0,    0,   46,   47,    0,   48,    0,   49,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
           51,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,  217,    4,    5,    6,    7,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,    0,   30,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   44,    0,    0,   45,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,  217,    4,    5,    6,    7, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,   15,   16,   17,   18,    0,    0, 
            0,    0,   19,   20,   21,   22,   23,   24,   25,    0, 
            0,   26,    0,    0,    0,    0,    0,   27,   28,    0, 
           30,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   44,    0,    0,  281,    0, 
            0,   46,   47,    0,   48,    0,   49,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,   51,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    4, 
            5,    6,    7,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,   26,    0,    0,    0,    0,    0, 
           27,   28,   29,   30,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   44,    0, 
            0,   45,    0,    0,   46,   47,    0,   48,    0,   49, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,   51,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,    4,    5,    6,    7,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
           15,   16,   17,   18,    0,    0,    0,    0,   19,   20, 
           21,   22,   23,   24,   25,    0,    0,   26,    0,    0, 
            0,    0,    0,   27,   28,    0,   30,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,   44,    0,    0,   45,    0,    0,   46,   47,    0, 
           48,    0,   49,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,   51,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  101,  102,   17,   18,    0,    0,    0, 
            0,  103,   20,   21,   22,   23,   24,   25,    0,    0, 
          106,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
          247,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  223,    0,    0,  113,    0,    0, 
           46,   47,    0,   48,    0,  248,    0,  249,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  250,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  101,  102,   17,   18, 
            0,    0,    0,    0,  103,  104,  105,   22,   23,   24, 
           25,    0,    0,  106,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,  247,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  223,    0,    0, 
          113,    0,    0,   46,   47,    0,   48,    0,  638,    0, 
          249,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          250,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,  252,  252,  252,    0,  252,    0,    0,    0,  252, 
          252,    0,    0,    0,  252,    0,  252,  252,  252,  252, 
          252,  252,  252,    0,    0,    0,    0,  252,  252,  252, 
          252,  252,  252,  252,    0,    0,  252,    0,    0,    0, 
            0,    0,    0,  252,    0,    0,  252,  252,  252,    0, 
          252,  252,  252,  252,  252,  252,  252,  252,  252,  252, 
          252,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          252,    0,    0,  252,    0,    0,  252,  252,    0,  252, 
            0,  252,    0,  252,    0,  252,    0,    0,    0,    0, 
            0,    0,    0,  252,    0,    0,    0,    0,  252,  252, 
          252,  252,  252,  252,    0,    0,    0,  252,    0,  252, 
          252,    0,  252,  252,    4,    5,    6,    0,    8,    0, 
            0,    0,    9,   10,    0,    0,    0,   11,    0,   12, 
           13,   14,  101,  102,   17,   18,    0,    0,    0,    0, 
          103,  104,  105,   22,   23,   24,   25,    0,    0,  106, 
            0,    0,    0,    0,    0,    0,   28,    0,    0,   31, 
           32,   33,    0,   34,   35,   36,   37,   38,   39,  247, 
           40,   41,   42,   43,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  223,    0,    0,  113,    0,    0,   46, 
           47,    0,   48,    0,  248,    0,    0,    0,   50,    0, 
            0,    0,    0,    0,    0,    0,  250,    0,    0,    0, 
            0,   52,   53,   54,   55,   56,   57,    0,    0,    0, 
           58,    0,   59,   60,    0,   61,   62,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,  101,  102,   17,   18,    0, 
            0,    0,    0,  103,  104,  105,   22,   23,   24,   25, 
            0,    0,  106,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,  247,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  223,    0,    0,  113, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,  249, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,  250, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  101,  102, 
           17,   18,    0,    0,    0,    0,  103,  104,  105,   22, 
           23,   24,   25,    0,    0,  106,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,  247,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  223, 
            0,    0,  113,    0,    0,   46,   47,    0,   48,    0, 
          638,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  250,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,  101,  102,   17,   18,    0,    0,    0,    0,  103, 
          104,  105,   22,   23,   24,   25,    0,    0,  106,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,  247,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  223,    0,    0,  113,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  250,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,    4,    5,    6,    0, 
            8,    0,    0,    0,    9,   10,    0,    0,    0,   11, 
            0,   12,   13,   14,  101,  102,   17,   18,    0,    0, 
            0,    0,  103,  104,  105,   22,   23,   24,   25,    0, 
            0,  106,    0,    0,    0,    0,    0,    0,   28,    0, 
            0,   31,   32,   33,    0,   34,   35,   36,   37,   38, 
           39,    0,   40,   41,   42,   43,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  223,    0,    0,  113,  447, 
            0,   46,   47,    0,   48,    0,    0,    0,    0,    0, 
           50,    0,    0,    0,    0,    0,    0,    0,  250,    0, 
            0,    0,    0,   52,   53,   54,   55,   56,   57,    0, 
            0,    0,   58,    0,   59,   60,    0,   61,   62,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,   15,   16,   17, 
           18,    0,    0,    0,    0,   19,   20,   21,   22,   23, 
           24,   25,    0,    0,  106,    0,    0,    0,    0,    0, 
            0,   28,    0,    0,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,   41,   42,   43,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  223,    0, 
            0,  113,    0,    0,   46,   47,    0,   48,    0,  572, 
            0,    0,    0,   50,    0,    0,    0,    0,    0,    0, 
            0,  250,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          101,  102,   17,   18,    0,    0,    0,    0,  103,  104, 
          105,   22,   23,   24,   25,    0,    0,  106,    0,    0, 
            0,    0,    0,    0,   28,    0,    0,   31,   32,   33, 
            0,   34,   35,   36,   37,   38,   39,    0,   40,   41, 
           42,   43,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  223,    0,    0,  113,    0,    0,   46,   47,    0, 
           48,    0,  572,    0,    0,    0,   50,    0,    0,    0, 
            0,    0,    0,    0,  250,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  101,  102,   17,   18,    0,    0,    0, 
            0,  103,  104,  105,   22,   23,   24,   25,    0,    0, 
          106,    0,    0,    0,    0,    0,    0,   28,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,   41,   42,   43,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  223,    0,    0,  113,    0,    0, 
           46,   47,    0,   48,    0,  248,    0,    0,    0,   50, 
            0,    0,    0,    0,    0,    0,    0,  250,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  101,  102,   17,   18, 
            0,    0,    0,    0,  103,  104,  105,   22,   23,   24, 
           25,    0,    0,  106,    0,    0,    0,    0,    0,    0, 
           28,    0,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,   41,   42,   43,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  223,    0,    0, 
          113,    0,    0,   46,   47,    0,   48,    0,  817,    0, 
            0,    0,   50,    0,    0,    0,    0,    0,    0,    0, 
          250,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  101, 
          102,   17,   18,    0,    0,    0,    0,  103,  104,  105, 
           22,   23,   24,   25,    0,    0,  106,    0,    0,    0, 
            0,    0,    0,   28,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,   41,   42, 
           43,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          223,    0,    0,  113,    0,    0,   46,   47,    0,   48, 
            0,  638,    0,    0,    0,   50,    0,    0,    0,    0, 
            0,    0,    0,  250,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,  537,  537,  537,    0,  537,    0, 
            0,    0,  537,  537,    0,    0,    0,  537,    0,  537, 
          537,  537,  537,  537,  537,  537,    0,    0,    0,    0, 
          537,  537,  537,  537,  537,  537,  537,    0,    0,  537, 
            0,    0,    0,    0,    0,    0,  537,    0,    0,  537, 
          537,  537,    0,  537,  537,  537,  537,  537,  537,    0, 
          537,  537,  537,  537,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,  537,    0,    0,  537,  537,    0,  537, 
          537,    0,  537,    0,    0,    0,    0,    0,  537,    0, 
            0,    0,    0,    0,    0,    0,  537,    0,    0,    0, 
            0,  537,  537,  537,  537,  537,  537,    0,    0,    0, 
          537,    0,  537,  537,    0,  537,  537,    4,    5,    6, 
            0,    8,    0,    0,    0,    9,   10,    0,    0,    0, 
           11,    0,   12,   13,   14,   15,   16,   17,   18,    0, 
            0,    0,    0,   19,   20,   21,   22,   23,   24,   25, 
            0,    0,   26,    0,    0,    0,    0,    0,    0,   28, 
            0,    0,   31,   32,   33,    0,   34,   35,   36,   37, 
           38,   39,    0,   40,   41,   42,   43,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,  223,    0,    0,  113, 
            0,    0,   46,   47,    0,   48,    0,    0,    0,    0, 
            0,   50,    0,    0,    0,    0,    0,    0,    0,   51, 
            0,    0,    0,    0,   52,   53,   54,   55,   56,   57, 
            0,    0,    0,   58,    0,   59,   60,    0,   61,   62, 
            4,    5,    6,    0,    8,    0,    0,    0,    9,   10, 
            0,    0,    0,   11,    0,   12,   13,   14,  101,  102, 
           17,   18,    0,    0,    0,    0,  103,  104,  105,   22, 
           23,   24,   25,    0,    0,  106,    0,    0,    0,    0, 
            0,    0,   28,    0,    0,   31,   32,   33,    0,   34, 
           35,   36,   37,   38,   39,    0,   40,   41,   42,   43, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  223, 
            0,    0,  113,    0,    0,   46,   47,    0,   48,    0, 
            0,    0,    0,    0,   50,    0,    0,    0,    0,    0, 
            0,    0,  250,    0,    0,    0,    0,   52,   53,   54, 
           55,   56,   57,    0,    0,    0,   58,    0,   59,   60, 
            0,   61,   62,    4,    5,    6,    0,    8,    0,    0, 
            0,    9,   10,    0,    0,    0,   11,    0,   12,   13, 
           14,   15,   16,   17,   18,    0,    0,    0,    0,   19, 
           20,   21,   22,   23,   24,   25,    0,    0,  106,    0, 
            0,    0,    0,    0,    0,   28,    0,    0,   31,   32, 
           33,    0,   34,   35,   36,   37,   38,   39,    0,   40, 
           41,   42,   43,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  223,    0,    0,  113,    0,    0,   46,   47, 
            0,   48,    0,    0,    0,    0,    0,   50,    0,    0, 
            0,    0,    0,    0,    0,  250,    0,    0,    0,    0, 
           52,   53,   54,   55,   56,   57,    0,    0,    0,   58, 
            0,   59,   60,    0,   61,   62,  537,  537,  537,    0, 
          537,    0,    0,    0,  537,  537,    0,    0,    0,  537, 
            0,  537,  537,  537,  537,  537,  537,  537,    0,    0, 
            0,    0,  537,  537,  537,  537,  537,  537,  537,    0, 
            0,  537,    0,    0,    0,    0,    0,    0,  537,    0, 
            0,  537,  537,  537,    0,  537,  537,  537,  537,  537, 
          537,    0,  537,  537,  537,  537,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,  537,    0,    0,  537,    0, 
            0,  537,  537,    0,  537,    0,    0,    0,    0,    0, 
          537,    0,    0,    0,    0,    0,    0,    0,  537,    0, 
            0,    0,    0,  537,  537,  537,  537,  537,  537,    0, 
            0,    0,  537,    0,  537,  537,    0,  537,  537,    4, 
            5,    6,    0,    8,    0,    0,    0,    9,   10,    0, 
            0,    0,   11,    0,   12,   13,   14,  101,  102,   17, 
           18,    0,    0,    0,    0,  103,  104,  105,   22,   23, 
           24,   25,    0,    0,  106,    0,    0,    0,    0,    0, 
            0,  107,    0,    0,   31,   32,   33,    0,   34,   35, 
           36,   37,   38,   39,    0,   40,    0,    0,  110,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,  294,    0, 
            0,  368,    0,    0,   46,   47,    0,   48,    0,  369, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,   52,   53,   54,   55, 
           56,   57,    0,    0,    0,   58,    0,   59,   60,    0, 
           61,   62,    4,    5,    6,    0,    8,    0,    0,    0, 
            9,   10,    0,    0,    0,   11,    0,   12,   13,   14, 
          101,  102,   17,   18,    0,    0,    0,    0,  103,  104, 
          105,   22,   23,   24,   25,    0,    0,  106,    0,    0, 
            0,    0,    0,    0,  107,    0,    0,   31,   32,   33, 
            0,  108,   35,   36,   37,  109,   39,    0,   40,    0, 
            0,  110,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,  112,    0,    0,  113,    0,    0,   46,   47,    0, 
           48,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,   52, 
           53,   54,   55,   56,   57,    0,    0,    0,   58,    0, 
           59,   60,    0,   61,   62,    4,    5,    6,    0,    8, 
            0,    0,    0,    9,   10,    0,    0,    0,   11,    0, 
           12,   13,   14,  101,  102,   17,   18,    0,    0,    0, 
            0,  103,  104,  105,   22,   23,   24,   25,    0,    0, 
          106,    0,    0,    0,    0,    0,    0,  107,    0,    0, 
           31,   32,   33,    0,   34,   35,   36,   37,   38,   39, 
            0,   40,    0,    0,  110,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  294,    0,    0,  368,    0,    0, 
           46,   47,    0,   48,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,   52,   53,   54,   55,   56,   57,    0,    0, 
            0,   58,    0,   59,   60,    0,   61,   62,    4,    5, 
            6,    0,    8,    0,    0,    0,    9,   10,    0,    0, 
            0,   11,    0,   12,   13,   14,  101,  102,   17,   18, 
            0,    0,    0,    0,  103,  104,  105,   22,   23,   24, 
           25,    0,    0,  106,    0,    0,    0,    0,    0,    0, 
          107,    0,    0,   31,   32,   33,    0,   34,   35,   36, 
           37,   38,   39,    0,   40,    0,    0,  110,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  827,    0,    0, 
          113,    0,    0,   46,   47,    0,   48,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,   52,   53,   54,   55,   56, 
           57,    0,    0,    0,   58,    0,   59,   60,    0,   61, 
           62,    4,    5,    6,    0,    8,    0,    0,    0,    9, 
           10,    0,    0,    0,   11,    0,   12,   13,   14,  101, 
          102,   17,   18,    0,    0,    0,    0,  103,  104,  105, 
           22,   23,   24,   25,    0,    0,  106,    0,    0,    0, 
            0,    0,    0,  107,    0,    0,   31,   32,   33,    0, 
           34,   35,   36,   37,   38,   39,    0,   40,    0,    0, 
          110,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
          902,    0,    0,  113,    0,    0,   46,   47,    0,   48, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,   52,   53, 
           54,   55,   56,   57,    0,    0,    0,   58,    0,   59, 
           60,    0,   61,   62,  122,  123,  124,  125,  126,  127, 
          128,  129,    0,    0,  130,  131,  132,  133,  134,    0, 
            0,  135,  136,  137,  138,  139,  140,  141,    0,    0, 
          142,  143,  144,  202,  203,  204,  205,  149,  150,  151, 
          152,  153,  154,  155,  156,  157,  158,  159,  160,  206, 
          207,  208,    0,  209,  165,  270,    0,  210,    0,    0, 
            0,  167,  168,    0,  169,  170,  171,  172,  173,  174, 
          175,    0,    0,  176,  177,    0,    0,    0,  178,  179, 
          180,  181,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,  192,  193,  194,  195,    0,    0, 
          196,   52,  122,  123,  124,  125,  126,  127,  128,  129, 
            0,    0,  130,  131,  132,  133,  134,    0,    0,  135, 
          136,  137,  138,  139,  140,  141,    0,    0,  142,  143, 
          144,  202,  203,  204,  205,  149,  150,  151,  152,  153, 
          154,  155,  156,  157,  158,  159,  160,  206,  207,  208, 
            0,  209,  165,    0,    0,  210,    0,    0,    0,  167, 
          168,    0,  169,  170,  171,  172,  173,  174,  175,    0, 
            0,  176,  177,    0,    0,    0,  178,  179,  180,  181, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,  183,  184,    0,  185,  186,  187,  188,  189, 
          190,  191,  192,  193,  194,  195,    0,    0,  196,   52, 
          122,  123,  124,  125,  126,  127,  128,  129,    0,    0, 
          130,  131,  132,  133,  134,    0,    0,  135,  136,  137, 
          138,  139,  140,  141,    0,    0,  142,  143,  144,  145, 
          146,  147,  148,  149,  150,  151,  152,  153,  154,  155, 
          156,  157,  158,  159,  160,  161,  162,  163,    0,  164, 
          165,   36,   37,  166,   39,    0,    0,  167,  168,    0, 
          169,  170,  171,  172,  173,  174,  175,    0,    0,  176, 
          177,    0,    0,    0,  178,  179,  180,  181,    0,    0, 
            0,    0,    0,  182,    0,    0,    0,    0,    0,    0, 
          183,  184,    0,  185,  186,  187,  188,  189,  190,  191, 
          192,  193,  194,  195,    0,    0,  196,  122,  123,  124, 
          125,  126,  127,  128,  129,    0,    0,  130,  131,  132, 
          133,  134,    0,    0,  135,  136,  137,  138,  139,  140, 
          141,    0,    0,  142,  143,  144,  202,  203,  204,  205, 
          149,  150,  151,  152,  153,  154,  155,  156,  157,  158, 
          159,  160,  206,  207,  208,    0,  209,  165,  303,  304, 
          210,  305,    0,    0,  167,  168,    0,  169,  170,  171, 
          172,  173,  174,  175,    0,    0,  176,  177,    0,    0, 
            0,  178,  179,  180,  181,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,  183,  184,    0, 
          185,  186,  187,  188,  189,  190,  191,  192,  193,  194, 
          195,    0,    0,  196,  122,  123,  124,  125,  126,  127, 
          128,  129,    0,    0,  130,  131,  132,  133,  134,    0, 
            0,  135,  136,  137,  138,  139,  140,  141,    0,    0, 
          142,  143,  144,  202,  203,  204,  205,  149,  150,  151, 
          152,  153,  154,  155,  156,  157,  158,  159,  160,  206, 
          207,  208,    0,  209,  165,    0,    0,  210,    0,    0, 
            0,  167,  168,    0,  169,  170,  171,  172,  173,  174, 
          175,    0,    0,  176,  177,    0,    0,    0,  178,  179, 
          180,  181,    0,    0,    0,    0,    0,    0,    0,    0, 
            0,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,  192,  193,  194,  195,  633,  559, 
          196,    0,  634,    0,    0,    0,  167,  168,    0,  169, 
          170,  171,  172,  173,  174,  175,    0,    0,  176,  177, 
            0,    0,    0,  178,  179,  180,  181,    0,    0,    0, 
            0,    0,  264,    0,    0,    0,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,  192, 
          193,  194,  195,  658,  553,  196,    0,  659,    0,    0, 
            0,  167,  168,    0,  169,  170,  171,  172,  173,  174, 
          175,    0,    0,  176,  177,    0,    0,    0,  178,  179, 
          180,  181,    0,    0,    0,    0,    0,  264,    0,    0, 
            0,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,  192,  193,  194,  195,  660,  559, 
          196,    0,  661,    0,    0,    0,  167,  168,    0,  169, 
          170,  171,  172,  173,  174,  175,    0,    0,  176,  177, 
            0,    0,    0,  178,  179,  180,  181,    0,    0,    0, 
            0,    0,  264,    0,    0,    0,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,  192, 
          193,  194,  195,  914,  553,  196,    0,  915,    0,    0, 
            0,  167,  168,    0,  169,  170,  171,  172,  173,  174, 
          175,    0,    0,  176,  177,    0,    0,    0,  178,  179, 
          180,  181,    0,    0,    0,    0,    0,  264,    0,    0, 
            0,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,  192,  193,  194,  195,  916,  559, 
          196,    0,  917,    0,    0,    0,  167,  168,    0,  169, 
          170,  171,  172,  173,  174,  175,    0,    0,  176,  177, 
            0,    0,    0,  178,  179,  180,  181,    0,    0,    0, 
            0,    0,  264,    0,    0,    0,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,  192, 
          193,  194,  195,  945,  559,  196,    0,  946,    0,    0, 
            0,  167,  168,    0,  169,  170,  171,  172,  173,  174, 
          175,    0,    0,  176,  177,    0,    0,    0,  178,  179, 
          180,  181,    0,    0,    0,    0,    0,  264,    0,    0, 
            0,    0,    0,    0,  183,  184,    0,  185,  186,  187, 
          188,  189,  190,  191,  192,  193,  194,  195,  566,  553, 
          196,    0,  567,    0,    0,    0,  167,  168,    0,  169, 
          170,  171,  172,  173,  174,  175,    0,    0,  176,  177, 
            0,    0,    0,  178,  179,  180,  181,    0,    0,    0, 
            0,    0,    0,    0,    0,    0,    0,    0,    0,  183, 
          184,    0,  185,  186,  187,  188,  189,  190,  191,  192, 
          193,  194,  195,    0,    0,  196, 
      };
   }

   private static final short[] yyCheck1() {
      return new short[] {

            6,    7,   26,    2,   28,   51,  398,   15,   16,  389, 
          317,   19,  231,   93,   27,    7,  413,   21,  256,    7, 
           10,   27,    9,   10,   11,    3,    6,   32,  362,   47, 
           48,   10,    4,    5,   10,   27,   10,   47,  289,   27, 
           10,  292,   14,  418,  280,    0,   52,   10,   47,   48, 
            0,    0,  360,  361,  388,  363,  364,   59,  112,   46, 
           10,   65,   98,  317,   98,  367,   10,   10,   59,   59, 
           10,  682,   52,  474,  408,   10,   11,   49,  386,   10, 
           59,   44,  688,  107,  391,   59,   10,   21,  422,   59, 
           11,    2,    3,   10,   10,  677,   59,  280,  406,  407, 
           10,   49,  308,   10,   44,   10,   10,   10,   10,   59, 
          690,  693,  420,   10,   10,  281,   59,   44,   10,   59, 
           10,   93,  309,  704,  111,  361,  313,   44,   59,  710, 
          775,   65,   10,  340,   61,   59,   10,  305,   10,  473, 
           10,  305,   10,  451,   61,   61,    0,   44,   10,   10, 
          868,   61,   59,  515,   59,   10,   10,  340,   10,   10, 
           10,  431,   59,  471,   10,   10,   10,   10,  325,  375, 
          376,  105,   10,   10,   10,  344,   10,   98,  361,   10, 
          581,  115,  308,  309,  220,  311,  220,  378,  379,  551, 
          497,  371,   44,  362,  464,  773,  117,   59,  234,   44, 
           44,  358,  368,  340,   59,   59,  374,   44,   59,   61, 
          374,   61,  794,  593,   59,  295,  934,  397,   61,  361, 
            2,    3,    4,    5,  604,   59,    8,    9,   10,   11, 
           61,  623,   14,   15,   16,   10,   10,   19,  269,   91, 
          271,  852,   10,  497,  850,   10,   44,   44,  893,  375, 
          376,  238,  239,  261,  372,  263,  264,  310,   45,  377, 
          866,   59,   59,   45,   46,  264,  317,   49,  846,   51, 
          372,   10,  599,  428,  306,  377,  431,  857,  310,   32, 
          267,   10,  269,  262,  263,  264,   61,   61,   32,  268, 
          269,  328,  271,   61,  621,  602,   61,  348,  335,  220, 
          487,  352,  353,  238,  239,  328,  217,  365,  635,  290, 
          291,   93,  335,  234,  282,  305,   59,  895,  337,  365, 
           59,  367,  723,  295,  267,  371,  372,  267,   44,  111, 
           59,  113,  256,  387,   61,  662,  698,   61,  325,  326, 
          327,  328,  305,  330,  331,  923,  290,  291,  602,   44, 
          281,  341,  279,  337,  362,  361,  358,  367,  340,  264, 
          337,  371,  341,  362,  269,  370,  371,  358,  344,  279, 
          264,  341,  377,    2,    3,    4,    5,    6,  341,    8, 
          388,  387,  757,  362,  374,   14,  693,  397,  362,  388, 
          325,  326,  327,  328,  474,  358,  374,  369,  397,  398, 
          408,  407,  640,  390,  414,  656,  625,  362,  305,  408, 
          428,  374,  362,  362,  422,  421,   45,  719,  329,  310, 
           49,  369,  267,  422,  341,  341,  360,  279,  280,  279, 
          264,  341,  356,  446,  341,  217,  279,  341,  341,  341, 
          446,  821,  839,  461,  341,  341,  452,  839,  279,  341, 
          449,  341,  386,  496,  446,   10,  238,  239,  446,  305, 
          447,  382,  340,  374,   93,  473,  472,  341,   45,  341, 
          262,  341,  406,  341,  473,   44,  328,  374,   10,  261, 
          341,  263,  264,  335,  113,  267,  420,  269,  340,  341, 
          401,  341,  274,  338,  281,  341,  417,  418,  341,  281, 
          880,  581,  474,  341,  279,  279,   61,   10,  507,  361, 
          341,  279,  358,  295,  279,  514,  515,  451,  737,  826, 
          378,  379,   91,  262,  263,  264,  550,   59,  374,  268, 
          269,   61,  271,  262,  263,  264,  113,  471,  449,  268, 
          269,  565,  271,  325,  326,  327,  328,  329,  330,  331, 
          884,  555,  551,  337,  267,   59,  555,  561,   61,   44, 
          358,  358,  305,  271,  568,  569,  341,  341,  310,  568, 
          569,  284,  279,  341,  882,  599,  341,  657,  263,  264, 
          362,  368,   44,  365,  269,  367,  368,  369,  217,  371, 
          372,  918,  374,  606,   44,  594,   44,  621,   10,  605, 
          606,   10,  341,  268,  269,  592,  388,  389,  390,  581, 
          609,  635,  341,  612,  606,  834,  615,  338,  606,  401, 
           91,  555,  404,  362,  623,  605,  408,  561,  671,  672, 
          412,  374,  337,  362,  568,  569,  361,   10,  662,  317, 
          422,  263,  264,  723,  317,  274,  317,   59,  341,  636, 
           59,  362,  281,   54,   55,  701,  702,  592,   10,  310, 
          594,  707,  344,  597,   44,  447,  295,  449,  372,  590, 
          372,   44,   48,  719,    2,    3,    4,    5,  677,   91, 
            8,   44,  603,  568,  569,  657,   14,  346,   61,  269, 
           44,  473,  474,  340,  693,  267,  264,  274,  341,  698, 
          329,  636,  362,   44,  281,   59,   32,   59,   44,  306, 
          279,  280,   10,   91,   61,  306,   59,   45,   91,   44, 
          433,   49,   91,   44,  279,   44,  439,  440,  337,  337, 
          773,   10,  775,  337,  337,  267,   44,   91,   61,  368, 
          369,   44,  264,  456,  338,  374,  459,  370,  371,  263, 
          337,  723,   10,  337,  377,   91,  743,  380,   10,  328, 
          389,   59,  337,  264,  736,   93,  335,  362,  814,   44, 
           10,  340,  401,   58,  337,  404,  279,  370,  371,  372, 
           59,  264,   91,  412,  377,  113,  341,  344,    2,    3, 
           44,  368,  361,   91,    8,  794,  264,  264,  337,  581, 
           14,   59,  362,  846,  847,  726,  338,   59,  743,   44, 
          592,  593,   10,  306,   44,  308,  309,  310,  311,   59, 
          449,  306,  604,  308,  309,  310,  311,  404,  264,  611, 
          264,   45,   44,   91,   44,  412,  757,   91,  341,  362, 
          839,   44,   44,   44,  306,  474,  308,  309,  310,  311, 
          893,   44,  895,   61,  636,  267,   91,  328,  267,   44, 
           44,   59,   91,   10,  335,  264,  358,  580,  362,  264, 
          310,  247,  248,  249,  264,  657,  884,  883,  264,   44, 
          923,  358,  664,  362,   10,  884,    2,    3,  601,  217, 
          862,   44,    8,   91,  918,  310,  264,   44,   10,  113, 
           44,   15,   16,  685,  686,   19,  279,  280,   44,   44, 
          262,  263,  264,  695,   61,  697,  328,  269,  700,  701, 
          702,  920,   91,  335,  930,  707,  280,   91,  340,   45, 
          264,   44,   44,   59,   44,  648,   10,  719,  370,  371, 
          372,  723,   91,  279,   91,  377,  274,   91,  882,   61, 
          328,  264,  581,  281,  736,  328,   44,  335,  740,  328, 
          271,  743,  335,  676,  593,   91,  335,  295,  341,  267, 
           44,  753,  754,  755,  328,  604,  370,  371,  372,   91, 
          344,  335,  611,  377,  340,  264,  340,   61,  361,  268, 
          269,  367,  328,  271,  344,  371,   44,  113,   44,  335, 
          362,  329,  341,  217,  358,  362,    0,  361,   58,  267, 
          358,  263,  264,   59,   10,  344,   10,   91,  731,  328, 
          802,  397,  280,   10,  264,  279,  335,  344,  657,  269, 
          328,  271,  814,  264,  611,  664,   67,  335,  414,  821, 
          368,  369,    5,   91,  279,   91,  374,  920,   10,    6, 
          832,  427,  428,  826,  688,  431,  685,  686,  866,  772, 
          274,  389,   10,   59,  777,   59,  695,  281,  697,  267, 
          328,  700,   59,  401,  328,  885,  404,  335,   71,   14, 
          862,  335,  340,  671,  412,  461,  340,  664,  464,  852, 
          449,   -1,   -1,  328,  723,   91,   44,   59,  880,  328, 
          335,  217,  884,  361,  886,   44,  335,  736,  685,  686, 
          892,  740,   -1,   61,   -1,  329,   -1,   -1,  695,   -1, 
          697,  449,   -1,  700,  753,  754,  755,   -1,   -1,   91, 
          328,   -1,  279,  280,   10,  279,  280,  335,    0,   -1, 
           -1,  267,   -1,   91,   -1,   -1,  474,  261,   10,  263, 
           -1,   -1,   91,  367,  368,  370,  371,  372,  274,  328, 
          374,   -1,  377,  740,  328,  281,  335,  279,  280,   10, 
           -1,  335,   -1,  802,   -1,  389,  753,  754,  755,  328, 
           -1,  328,   44,   59,  328,   -1,  335,  401,  335,   -1, 
          404,  335,  821,  340,  341,   -1,  572,   59,  412,   -1, 
           -1,   -1,  328,  832,   -1,  279,  317,   -1,   -1,  335, 
           -1,   -1,   -1,  329,  361,   91,  328,  361,   59,  370, 
          371,  372,   -1,  335,   -1,  802,  377,   -1,  340,  341, 
           -1,  279,  280,  862,   -1,  449,   -1,  348,  370,  371, 
          372,  352,  353,  354,  355,  377,   -1,   10,   -1,  361, 
           -1,  880,  368,  581,  328,  832,   -1,  886,  374,   -1, 
           -1,  335,  638,  892,   -1,  593,  340,  341,  262,  263, 
          264,  267,   -1,  389,  268,  269,  604,  271,   -1,   -1, 
          328,   44,  328,  611,  280,  401,   -1,  335,  404,  335, 
           -1,   -1,  340,  669,  340,   -1,  412,   -1,   61,  293, 
          294,  295,  296,  297,   -1,  267,   -1,   -1,   44,  886, 
           -1,   -1,  358,  361,   -1,  892,   -1,   -1,  280,  306, 
           -1,  308,  309,  310,  311,   -1,   -1,   -1,   91,  657, 
           -1,  279,  328,  449,   -1,   -1,  664,  665,   -1,  335, 
          279,  328,   -1,   -1,  720,   -1,   -1,  341,  335,   -1, 
           -1,   -1,  339,  340,   -1,   91,   -1,  685,  686,   -1, 
          347,  348,  349,  350,   -1,  361,  328,  695,  362,  697, 
           -1,   -1,  700,  335,   -1,   -1,  752,   -1,  340,  593, 
          328,  293,  294,  295,  296,  297,   -1,  335,   -1,  328, 
          604,  267,   -1,  341,   -1,  723,  335,  611,   -1,  361, 
          262,  263,  264,   -1,  280,  267,  268,  269,  736,  271, 
           15,   16,  740,   -1,   19,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,  753,  754,  755,  290,  291, 
           -1,  293,  294,  295,  296,  297,   41,   42,   -1,   -1, 
           -1,  817,   47,   48,   -1,   50,   51,   -1,   -1,   -1, 
          664,   -1,  328,   -1,  262,  263,  264,   -1,   -1,  335, 
          268,  269,   -1,  271,  340,  306,   -1,  308,  309,  310, 
          311,  685,  686,   -1,  802,   -1,   -1,  593,   -1,  341, 
           -1,  695,  344,  697,  346,  361,  700,  328,  604,   -1, 
           -1,   -1,   -1,  821,  335,  611,   -1,   -1,  339,  340, 
          362,   -1,   10,   -1,  832,  719,  347,  348,  349,  350, 
          688,   -1,  690,   -1,   -1,  693,  279,    0,   -1,   -1, 
           -1,   -1,  736,   -1,   -1,   -1,  740,   10,   -1,   -1, 
           -1,   -1,   -1,  341,  862,   -1,   44,   -1,   -1,  753, 
          754,  755,   -1,  279,  280,   -1,   -1,   -1,  664,   -1, 
           -1,   -1,  880,   61,  362,   -1,   -1,   -1,  886,   -1, 
           -1,   44,   -1,   -1,  892,  328,   -1,   -1,   -1,  685, 
          686,   -1,  335,   -1,   -1,   -1,   59,   -1,  341,  695, 
           -1,  697,   -1,   91,  700,    4,    5,   -1,  802,   -1, 
           -1,   -1,  328,   -1,   -1,   14,   -1,   -1,   -1,  335, 
           -1,   -1,   -1,    0,  340,   -1,   -1,  821,  262,  263, 
          264,   -1,   -1,   10,  268,  269,   -1,  271,  832,   -1, 
           -1,   -1,   41,   42,  740,  361,   -1,   -1,   47,   48, 
           49,   50,   -1,   -1,   -1,   -1,   -1,  753,  754,  755, 
           -1,   -1,  247,  248,  249,  250,   -1,   44,  306,   -1, 
          308,  309,  310,  311,   -1,   -1,  261,   -1,  263,  264, 
           -1,   58,   59,   -1,   -1,   -1,  880,  272,   -1,   -1, 
           -1,   -1,  886,   -1,   93,   -1,   -1,   -1,  892,  857, 
           -1,  339,  509,  510,   -1,   -1,  802,  341,  866,   -1, 
          868,  349,  350,  306,   -1,  308,  309,  310,  311,   -1, 
           -1,   -1,   -1,   -1,   -1,  821,   10,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  832,   -1,   -1,   -1, 
          306,   -1,  308,  309,  310,  311,  339,  332,  333,  334, 
          335,  336,  337,  338,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  339,   -1,   -1,  934,  362,   -1,   63, 
          365,  347,  367,   -1,  880,   -1,  371,  372,   -1,   10, 
          886,  279,   -1,   -1,   -1,   -1,  892,   -1,   -1,  262, 
          263,  264,   -1,  388,  267,  268,  269,   -1,  271,   -1, 
           -1,  306,  397,  308,  309,  310,  311,   -1,  281,  282, 
           -1,   -1,   -1,  408,  409,  410,  411,  290,  291,  414, 
          293,  294,  295,  296,  297,   -1,   -1,  422,   59,   -1, 
          328,   -1,  427,  428,  339,   -1,  431,  335,  247,  248, 
          249,  250,  347,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  453,  454, 
          455,   -1,   -1,  272,   -1,   -1,  461,   -1,  341,  464, 
           -1,  344,   -1,  346,   -1,  262,  263,  264,  473,   -1, 
          267,  268,  269,   -1,  271,   -1,  295,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,  290,  291,    0,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   10,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,  332,  333,  334,  335,  336,  337,  338, 
          339,  340,  341,  342,  343,  344,  345,  346,  347,  348, 
          349,  350,  351,  352,  353,  354,  355,  356,  357,   44, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
          369,  778,   -1,   -1,   59,   -1,   -1,   -1,   -1,  786, 
          787,   -1,  789,   -1,  791,  362,  793,  572,  795,  796, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,  397,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          409,  410,  411,   -1,   -1,  414,   -1,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  427,  428, 
           10,   -1,  431,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,   -1,  329,  330,   -1,   -1,  333, 
          334,   -1,   -1,  638,  453,  454,  455,   -1,   -1,   -1, 
           -1,   -1,  461,   -1,  348,  464,  350,   -1,  352,  353, 
          354,  355,  356,  357,  358,  474,  360,   -1,   -1,   59, 
           -1,   -1,   -1,   -1,  669,  306,   -1,  308,  309,  310, 
          311,  898,  899,  900,  901,   10,   -1,  904,   -1,  906, 
          907,  908,  909,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   10,   -1,   -1,  335,   -1,  701,  702,  339,  340, 
           -1,   -1,  707,  708,   -1,   -1,  347,  348,  349,  350, 
           -1,   -1,   -1,  718,  719,  720,   -1,  944,   -1,  724, 
          947,  948,  949,  950,   59,   -1,   -1,   -1,   -1,   -1, 
          957,   -1,   -1,   -1,  306,   -1,  308,  309,  310,  311, 
           59,  746,  747,  748,   -1,   -1,   -1,  752,   -1,   -1, 
           -1,   -1,   -1,  572,   -1,   -1,   -1,  262,  263,  264, 
           -1,   -1,  581,  268,  269,   -1,  271,  339,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  347,  348,  349,  350,   -1, 
          317,   -1,   -1,    0,   -1,  290,  291,   -1,  293,  294, 
          295,  296,   -1,   10,   -1,   -1,  333,  334,  803,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  814, 
           -1,  348,  817,  350,   -1,  352,  353,  354,  355,  638, 
           -1,  358,   -1,  360,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,  836,   -1,   -1,   -1,   -1,  341,   -1,  657,   -1, 
           -1,   58,   59,   -1,   61,   -1,   63,   -1,   -1,  317, 
          669,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1, 
           -1,   -1,  262,  263,  264,  333,  334,  267,  268,  269, 
           -1,  271,   -1,   -1,   91,   -1,   -1,   -1,   -1,  884, 
          348,  281,  282,   -1,  352,  353,  354,  355,   -1,  708, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,  718, 
           -1,  720,   -1,   -1,  723,  724,    0,   -1,   -1,   -1, 
          306,   -1,  308,  309,  310,  311,   10,  736,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  746,  747,  748, 
           -1,   -1,   -1,  752,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  341,   -1,  339,  344,   -1,  346,   -1,   -1,   -1, 
           44,  347,  348,  349,  350,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  362,   -1,   58,   59,   -1,   61,   -1,   63, 
           -1,  306,   -1,  308,  309,  310,  311,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  803,   -1,   -1,  306,   -1,  308, 
          309,  310,  311,  328,   -1,   -1,   -1,   91,  817,   -1, 
          335,   -1,   -1,   -1,  339,  340,   -1,   -1,   -1,  328, 
           -1,   -1,  347,  348,  349,  350,  335,  836,   -1,   -1, 
          339,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
          349,  350,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,  862,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,  279,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   59,  299,   -1,   -1,  302,  303,  304,  305,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
          337,  338,  339,  340,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   10,  373,  374,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,  279,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   59,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,  337,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,    0,   -1,   -1,  373, 
          374,  375,  376,   -1,  378,  379,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          306,   -1,  308,  309,  310,  311,   -1,   -1,   -1,   -1, 
           44,   -1,  306,   -1,  308,  309,  310,  311,  306,   -1, 
          308,  309,  310,  311,   58,   59,   -1,   61,   -1,   63, 
           -1,   -1,   -1,  339,  340,   -1,   -1,   -1,   -1,   -1, 
          328,  347,  348,  349,  350,  339,  340,  335,   -1,   -1, 
           -1,  339,  340,  347,  348,  349,  350,   91,   -1,  347, 
          348,  349,  350,   -1,   -1,   -1,  306,  307,   -1,   -1, 
          310,   -1,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,    0, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   10, 
          340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,   -1,  363,  306,   -1,  308,  309,  310,  311, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  306,   -1,  308,  309,  310,  311,   58,   59,   -1, 
           61,   -1,   63,   -1,   -1,   -1,   -1,  339,   -1,   -1, 
           -1,   -1,  317,  328,   -1,  347,  348,  349,  350,   -1, 
          335,  317,   -1,   -1,  339,  340,  322,  323,  333,  334, 
           91,   -1,  347,  348,  349,  350,   -1,  333,  334,   -1, 
           -1,   -1,   -1,  348,   -1,  350,   10,  352,  353,  354, 
          355,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   59,  280,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,  305,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,  340,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,  361,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   10,  373, 
          374,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   59,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,   -1,  364,  365,  366,  367,  368,  369,    0, 
           -1,   -1,  373,  374,  375,  376,   -1,  378,  379,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  306,   -1,  308,  309,  310,  311,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  328,   -1,   -1,   58,   59,   -1, 
           61,  335,   63,   -1,   -1,  339,  340,   -1,   -1,   -1, 
           -1,   -1,   -1,  347,  348,  349,  350,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1, 
          314,  315,   -1,  317,  318,  319,  320,  321,  322,  323, 
           -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332,  333, 
          334,   -1,    0,   -1,   -1,   -1,  340,   -1,   -1,   -1, 
           -1,   -1,   10,  347,  348,   -1,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,   -1,   -1,  363, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,   -1,   -1,   -1,   44,  333,  334,   -1, 
           -1,   -1,   -1,   -1,  306,   -1,  308,  309,  310,  311, 
           58,   59,  348,   -1,  350,   63,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   -1,  328,   -1,   -1,   -1, 
           -1,   -1,   -1,  335,   -1,   -1,   -1,  339,  340,   -1, 
           -1,   -1,   -1,   91,   -1,  347,  348,  349,  350,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1, 
          261,  262,  263,  264,  265,  266,  267,  268,  269,  270, 
          271,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
          281,  282,  283,  284,  285,  286,  287,  288,  289,  290, 
          291,  292,  293,  294,  295,  296,  297,   10,  299,   -1, 
           -1,  302,  303,  304,  305,  306,  307,  308,  309,  310, 
          311,  312,  313,  314,  315,  316,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,  336,   -1,  338,  339,  340, 
          341,  342,  343,  344,  345,  346,  347,  348,  349,  350, 
          351,  352,  353,  354,  355,  356,  357,  358,  359,  360, 
          361,  362,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,  374,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   -1,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,    0,   -1,   -1,  373,  374,  375,  376,   -1, 
          378,  379,   10,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261,   -1, 
           58,   59,  265,  266,   -1,   63,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   91,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   10,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   44, 
          373,   -1,  375,  376,   -1,  378,  379,   -1,  306,  307, 
           -1,   -1,  310,   58,   59,   -1,  314,  315,   63,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   91,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,   -1,  363,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  257, 
          258,  259,   -1,  261,  262,  263,  264,  265,  266,  267, 
          268,  269,  270,  271,  272,  273,  274,  275,  276,  277, 
          278,   -1,  280,  281,  282,  283,  284,  285,  286,  287, 
          288,  289,  290,  291,  292,  293,  294,  295,  296,  297, 
           -1,  299,   44,   -1,  302,  303,  304,  305,  306,  307, 
          308,  309,  310,  311,  312,  313,  314,  315,  316,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,  336,   -1, 
          338,  339,  340,  341,  342,  343,  344,  345,  346,  347, 
          348,  349,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  361,  362,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,  374,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,  280,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   -1,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,  361,  362,   -1,  364, 
          365,  366,  367,  368,  369,    0,   -1,   -1,  373,  374, 
          375,  376,   -1,  378,  379,   10,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   44, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   58,   59,   -1,   61,  299,   63,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   10,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  306,  307, 
           -1,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   44,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   59,   -1,  347, 
          348,   63,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,   -1,  363,  317,  318,  319,  320, 
          321,  322,  323,  324,   -1,  326,  327,   -1,   -1,   91, 
           -1,   -1,  333,  334,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  257,  258,  259,   -1,  261,  262,  263,  264, 
          265,  266,  267,  268,  269,  270,  271,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,  281,  282,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,   10,  299,   -1,   -1,  302,  303,  304, 
          305,  306,  307,  308,  309,  310,  311,  312,  313,  314, 
          315,  316,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,  336,   -1,  338,  339,  340,  341,  342,  343,  344, 
          345,  346,  347,  348,  349,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,  362,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,  374, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
          262,  263,  264,  265,  266,  267,  268,  269,  270,  271, 
          272,  273,  274,  275,  276,  277,  278,   -1,  280,  281, 
          282,  283,  284,  285,  286,  287,  288,  289,  290,  291, 
          292,  293,  294,  295,  296,  297,   -1,  299,   -1,   -1, 
          302,  303,  304,   63,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,  336,   -1,  338,  339,   -1,  341, 
          342,  343,  344,  345,  346,  347,  348,  349,  350,  351, 
          352,  353,  354,  355,  356,  357,  358,  359,  360,  361, 
          362,   -1,  364,  365,  366,  367,  368,  369,    0,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,   -1,   -1,   59,  265,  266, 
           -1,   63,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   91, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1, 
      };
   }

   private static final short[] yyCheck2() {
      return new short[] {

           -1,   -1,   -1,   -1,  336,   -1,   10,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           44,  373,  297,  375,  376,   -1,  378,  379,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,   63, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,   -1,  329,  330,   -1,   -1,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   91,   -1,   -1, 
           -1,   -1,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,   -1,  360,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
          267,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,  280,  281,  282,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   59,   63,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,  338,  339,   -1,  341,  342,  343,  344,  345,  346, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,  361,  362,   -1,  364,  365,  366, 
          367,  368,  369,   63,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,  281,  282,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,  317,  318,  319,  320,  321,  322,  323, 
          324,  325,  326,  327,  328,  329,  330,   -1,   -1,  333, 
          334,  335,  336,   -1,  338,  339,   -1,  341,  342,  343, 
          344,  345,  346,  347,  348,  349,  350,  351,  352,  353, 
          354,  355,  356,  357,  358,  359,  360,    0,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   10,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   59,   -1,   61,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,  341,   -1,   -1,  344,  348, 
          346,  350,   -1,  352,  353,  354,  355,  356,  357,  358, 
           -1,  360,   -1,   -1,   -1,   -1,  362,  297,   -1,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   59, 
          360,   61,   -1,   63,   -1,   -1,   -1,  306,  307,   -1, 
           -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317,  318, 
          319,  320,  321,  322,  323,   -1,   -1,  326,  327,   -1, 
           -1,   91,  331,  332,  333,  334,   -1,   -1,   -1,   -1, 
           -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348, 
           -1,  350,  351,  352,  353,  354,  355,  356,  357,  358, 
          359,  360,   -1,    0,  363,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,  257,  258,  259,   -1,  261,  262, 
          263,  264,  265,  266,   -1,  268,  269,  270,  271,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,   -1,  299,   -1,   -1,  302, 
          303,  304,   59,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,  336,   -1,   -1,  339,  340,  341,  342, 
          343,   -1,  345,   -1,  347,  348,  349,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  361,  362, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,   -1,  339, 
          340,  341,  342,  343,   -1,  345,   -1,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
            0,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
           10,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   59, 
           -1,   61,   -1,   63,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,   -1,   -1, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,   -1,   -1,  341,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,  257, 
          258,  259,   -1,  261,   -1,  362,   -1,  265,  266,   -1, 
           -1,   -1,  270,    0,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   10,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,   -1,   44,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   61,  333,   63,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   91,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   10,  257,  258,  259, 
           -1,  261,  262,  263,  264,  265,  266,   -1,  268,  269, 
          270,  271,  272,  273,  274,  275,  276,  277,  278,   -1, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,   -1,  299, 
           -1,   -1,  302,  303,  304,   59,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,  336,   -1,   -1,  339, 
          340,  341,  342,  343,   -1,  345,   -1,  347,  348,  349, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,  361,  362,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,  262,  263,  264,  265,  266, 
           -1,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,   -1,  299,   -1,   -1,  302,  303,  304,   44,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,  336, 
           -1,   -1,  339,  340,  341,  342,  343,   -1,  345,   -1, 
          347,  348,  349,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,  362,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,  262,  263, 
          264,  265,  266,  267,  268,  269,  270,  271,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,  281,   -1,  283, 
          284,  285,  286,  287,  288,  289,  290,  291,  292,  293, 
          294,  295,  296,  297,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,  328,   -1,   -1,   -1,   -1,   -1, 
           -1,  335,  336,   10,   -1,  339,   -1,  341,  342,  343, 
           -1,  345,   -1,  347,   -1,  349,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,  362,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   44,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   91,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,    0,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   10,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,   -1,   91,   -1,   -1,   -1,  680, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  690, 
           -1,   -1,  693,   -1,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   58,   59,   -1,   61, 
           -1,   63,   -1,  280,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   91, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,  361,  362,  262,  263,  264,   -1, 
           -1,  267,  268,  269,  855,  271,  857,  374,  859,   -1, 
           -1,   -1,  863,   -1,  280,  281,  282,  868,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   44,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
           -1,   -1,  338,   91,  925,  341,   -1,   -1,  344,   -1, 
          346,  932,  348,  934,  350,  936,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,  361,  362,   -1,   -1,   -1, 
           -1,   -1,  953,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
            0,  333,  334,  335,   -1,  337,  338,   -1,   -1,  341, 
           10,   -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   -1,  360,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,   61,   -1,   63,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  280,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   91,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,    0,  333,  334,  335,   -1,   -1, 
          338,   -1,   -1,  341,   10,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,  361,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          306,  307,   58,   59,  310,   61,   -1,   63,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,   -1,   -1,   -1,  340,   91,   -1,   -1,   -1,   -1, 
           -1,  347,  348,   -1,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,   -1,   -1,  363,    0,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   44,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   -1,   -1,  338,   91, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   58,   59,   -1, 
           -1,   -1,   63,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,   -1,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,    0,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,  374,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   44,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   58,   59,  305,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,  328,  329,  330,   -1, 
           -1,  333,  334,  335,   91,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   44,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   -1,   -1,  338,   91,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
            0,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   58,   59, 
           -1,   -1,   -1,   63,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,  374,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           58,   59,  305,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  317,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,  328,  329,  330,   -1,   -1, 
          333,  334,  335,   91,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,    0,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,  374,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   44,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   58,   59,   -1,   -1, 
           -1,   63,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,  348,    0, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,   10, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,    0,  333,  334,  335,   -1,   -1, 
          338,   -1,   -1,  341,   10,   -1,  344,   -1,  346,   -1, 
          348,   -1,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   44,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,  348,    0,  350,   -1, 
          352,  353,  354,  355,  356,  357,  358,   10,  360,   -1, 
          362,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   44,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,   -1,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   -1,  360, 
           -1,  362,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   10,  374,   -1,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   44,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           58,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  348,    0,  350,   -1,  352,  353,  354,  355, 
          356,  357,  358,   10,  360,   -1,  362,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   63,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321,  322, 
          323,  324,  325,  326,  327,   -1,  329,  330,   -1,    0, 
          333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341,   10, 
           -1,  344,   -1,  346,   -1,  348,   -1,  350,   -1,  352, 
          353,  354,  355,  356,  357,  358,   -1,  360,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   44,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   -1, 
          348,    0,  350,   -1,  352,  353,  354,  355,  356,  357, 
          358,   10,  360,   -1,  362,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   44,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   58, 
           59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,  333,  334,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,    0,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,  374,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   44,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   58,   59,  305,   -1,   -1,   63,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   44,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338, 
            0,   -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1, 
           10,  350,   -1,   -1,   -1,  354,  355,  356,  357,  358, 
           -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  374,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   44,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   58,   59, 
           -1,   -1,   -1,   63,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,   -1,  329,  330,   -1,   -1,  333,  334,   -1, 
           -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,   -1,    0,  350,   -1,   -1,   -1,  354,  355, 
          356,  357,  358,   10,  360,   -1,  362,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,  374,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   -1,   -1,   -1,   44,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   -1,   -1, 
           -1,   58,   59,  305,   -1,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320,  321, 
          322,  323,  324,  325,  326,  327,   -1,  329,  330,   -1, 
           -1,  333,  334,   -1,   -1,   -1,  338,   -1,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,   -1,  350,   -1, 
           -1,   -1,   -1,   -1,  356,  357,  358,   -1,  360,   -1, 
          362,    0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,  374,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,  282,   -1,   -1,   44,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   58, 
           59,   -1,   -1,   -1,   63,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,   -1,  329, 
          330,   -1,   -1,  333,  334,   -1,   -1,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1,    0, 
          350,   -1,   -1,   -1,   -1,   -1,  356,  357,  358,   10, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   44,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   58,   59,   -1, 
           -1,   -1,   63,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,   -1,  329,  330,   -1,   -1,   -1,   -1,    0,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   10,  346, 
           -1,   -1,   -1,  350,   -1,   -1,   -1,   -1,   -1,  356, 
          357,  358,   -1,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           -1,   -1,   44,  262,  263,  264,   -1,   -1,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   58,   59,   -1,   -1, 
           -1,   63,  281,  282,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  318, 
          319,  320,  321,  322,  323,  324,  325,  326,  327,   -1, 
          329,  330,   -1,   -1,   -1,   -1,   -1,   -1,    0,  338, 
           -1,   -1,  341,   -1,   -1,  344,   -1,  346,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357,  358, 
           -1,  360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,  374,  267,  268,  269,   -1, 
          271,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   58,   59,   -1,  290, 
          291,   63,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346, 
      };
   }

   private static final short[] yyCheck3() {
      return new short[] {

           -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1,  356, 
          357,  358,   10,  360,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,  374,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   44,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           58,   59,   -1,   -1,   -1,   63,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   63,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
          338,   -1,   -1,  341,   -1,   -1,  344,   10,  346,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357, 
           -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   58,   59,   -1,   -1,   -1, 
           63,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
           -1,  329,  330,   -1,   -1,   -1,   -1,   -1,   -1,    0, 
          338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  356,  357, 
           -1,  262,  263,  264,  362,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
          281,  282,   -1,   44,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   58,   59,   -1, 
           -1,   -1,   63,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  356,  357,    0,   -1,   -1, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   58,   59,   -1,   -1,   -1, 
           63,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  324,  325,   -1,   -1,   -1,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1, 
           -1,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   58,   59,   -1,   -1,   -1,   63,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
            0,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  324,  325,   -1,   -1,   -1,  329,  330, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,   -1,   -1,  344,   44,  346,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59, 
           -1,  362,   -1,   63,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268,  269,   -1,  271,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281,  282, 
           10,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1, 
           -1,  324,  325,   -1,   -1,   -1,  329,  330,   58,   59, 
           -1,   -1,   -1,   63,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   -1,  346,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,  362, 
           -1,  267,  268,  269,   -1,  271,   -1,    0,   -1,   -1, 
           -1,  374,   -1,   -1,   -1,  281,  282,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,   -1,   -1,   -1,   -1,  324,  325, 
           -1,   -1,   -1,  329,  330,   58,   59,   -1,   -1,   -1, 
           63,   -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1, 
          346,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,    0,   -1,   -1,  362,   -1,   -1,   -1, 
           -1,  281,  282,   10,   -1,   -1,   -1,   -1,  374,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,    0,   -1,   -1,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   10,   -1,   -1,  324,  325,   -1,   -1,   -1,  329, 
          330,   58,   59,   -1,   -1,   -1,   63,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   44,   -1,  267,  268,  269, 
           -1,  271,  362,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           59,  281,  282,   10,  374,   -1,   -1,   -1,   -1,   -1, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,   -1,   10,  324,  325,   -1,   -1,   -1,  329, 
          330,   58,   59,   -1,   -1,   -1,   63,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,  262, 
          263,  264,  362,   -1,  267,  268,  269,   -1,  271,   -1, 
           -1,   58,   59,   -1,  374,   -1,   63,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   -1,    0,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   10,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  324,  325,   -1,   -1,   -1,  329,  330,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,  344,   44,  346,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   58,   59,   -1,  362, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,  262,  263,  264,   -1,   -1,  305,  268, 
          269,   -1,  271,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,  325,   -1, 
           -1,   -1,  329,  330,  293,  294,  295,  296,  297,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   44,   -1, 
          267,  268,  269,   -1,  271,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   58,   59,  281,  282,   -1,  374,   -1,   -1, 
           -1,   -1,  341,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,  262,  263,  264,  305,    0, 
          267,  268,  269,  362,  271,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,  338,   -1,   -1,  341,   -1,   -1,  344,  305,  346, 
           -1,   -1,   -1,   44,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  362,   -1,   58,   59,   -1, 
            0,   -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1, 
           10,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,  281, 
          282,   -1,   -1,   -1,   44,   -1,   -1,  374,  290,  291, 
           -1,  293,  294,  295,  296,  297,   -1,   -1,   58,   59, 
           -1,   -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  338,    0,   -1,  341, 
           -1,   -1,  344,   -1,  346,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1, 
          362,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,  374,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   44,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   58,   59,   -1,   -1,  305, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  338,   10,   -1,  341,   -1,   -1,  344,   -1, 
          346,  262,  263,  264,   -1,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,   44,  374,  290, 
          291,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   58,   59,   -1,  305,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,  338,   -1,   -1, 
          341,  281,  282,  344,   -1,  346,   -1,   -1,   -1,   -1, 
          290,  291,    0,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,  362,   10,   -1,   -1,  305,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  374,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   44,   -1,  338,   -1, 
           -1,  341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1, 
           58,   59,   -1,    0,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,  362,   10,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,  374,   -1,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,   -1,   -1,   44,   -1,   -1, 
           -1,   -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   58,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,    0, 
           -1,  344,   -1,  346,   -1,  262,  263,  264,   -1,   10, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1, 
           -1,  374,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   44,   -1,   -1,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   58,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  362,   10,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  262,  263,  264,  374,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  281,  282,   -1,   -1,   -1,   -1,   -1, 
           44,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,    0,   58,   59,   -1,  305,   -1,   -1, 
           -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
          338,   -1,   -1,  341,  281,  282,  344,   44,  346,   -1, 
           -1,   -1,   -1,  290,  291,    0,  293,  294,  295,  296, 
          297,   -1,   59,   -1,  362,   10,   -1,   -1,  305,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  374,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
           -1,  338,   -1,   -1,  341,   -1,   -1,  344,   -1,  346, 
           -1,  262,  263,  264,   59,   -1,  267,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
          281,  282,   -1,   -1,   -1,   -1,   -1,  374,   -1,  290, 
          291,    0,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,  305,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   44,   10,  338,   -1,   -1, 
          341,   -1,   -1,  344,   -1,  346,   -1,   -1,   -1,   58, 
           59,   44,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263, 
          264,  362,   -1,  267,  268,  269,   59,  271,   -1,   -1, 
           44,   -1,   -1,  374,   -1,   -1,   -1,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   58,   59,  290,  291,   -1,  293, 
          294,  295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  305,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   -1, 
          267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1,   -1, 
           -1,   10,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1, 
          344,   -1,  346,   -1,   -1,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  262,  263,  264, 
          374,   -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1, 
           59,   -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1, 
           -1,  338,   -1,   -1,  341,  290,  291,   -1,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          305,   -1,   91,   -1,   -1,  362,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  338,   -1,   -1,  341,   -1,   -1,  344, 
           -1,  346,   -1,  262,  263,  264,   -1,   10,  267,  268, 
          269,   -1,  271,   -1,   -1,   -1,   -1,  362,   -1,  262, 
          263,  264,  281,  282,  267,  268,  269,   -1,  271,  374, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  262,  263, 
          264,   -1,   -1,  267,  268,  269,  305,  271,   -1,   -1, 
          293,  294,  295,  296,  297,   -1,   59,  281,  282,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  290,  291,   -1,  293, 
          294,  295,  296,   -1,   -1,   -1,   -1,   -1,   -1,  338, 
           -1,  305,  341,   -1,   -1,  344,   -1,  346,   91,   -1, 
           -1,   -1,   -1,   -1,   -1,  338,   -1,   -1,  341,   -1, 
           -1,   -1,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  338,  374,   -1,  341,   -1,  362, 
          344,   -1,  346,   -1,   -1,   -1,   -1,  256,  257,  258, 
          259,  260,  261,  262,  263,  264,  265,  266,  362,   10, 
          269,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
          374,  280,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,   -1,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   59,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  328, 
           -1,   -1,   -1,   -1,   -1,   -1,  335,  336,   -1,   -1, 
          339,  340,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           91,   -1,  351,   -1,   -1,   -1,   -1,  356,   -1,   -1, 
          359,   -1,  361,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   10,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,  339,  340,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   91,   -1,  351,   -1, 
           -1,   -1,   -1,  356,   -1,   -1,  359,   -1,  361,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,  260, 
          261,  262,  263,  264,  265,  266,   -1,   10,  269,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,  280, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  328,   -1,   -1, 
           -1,   -1,   -1,   -1,  335,  336,   -1,   -1,  339,  340, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   91,   -1, 
          351,   -1,   -1,   -1,   -1,  356,   -1,   -1,  359,   -1, 
          361,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,   -1, 
           -1,  256,  257,  258,  259,  260,  261,  262,  263,  264, 
          265,  266,   -1,   10,  269,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  328,   -1,   -1,   -1,   -1,   -1,   -1, 
          335,  336,   -1,   -1,  339,  340,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,  356,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  256,  257,  258,  259,  260,  261,  262, 
          263,  264,  265,  266,   -1,   10,  269,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   59,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  328,   -1,   -1,   -1,   -1, 
           -1,   -1,  335,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,  356,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,   -1,   -1,  256, 
          257,  258,  259,  260,  261,  262,  263,  264,  265,  266, 
           -1,  268,  269,  270,  271,  272,  273,  274,  275,  276, 
          277,  278,   10,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,  298,  299,   -1,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  256,  257,  258,  259,  260,  261,   -1,   -1,  264, 
          265,  266,   -1,   -1,   -1,  270,   10,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   59,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   10,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,   -1,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,   -1,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,    0,  362,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   10,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,   -1,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   44,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   59,   -1,   61,  299,   63,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,   91,  268,  269,   -1,  271,   -1, 
           -1,   -1,  336,   -1,    0,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   10,   -1,   -1,  351,   -1,   -1, 
          293,  294,  295,  296,  297,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,   -1,   -1,   44,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   63,  341,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  362, 
           -1,   -1,   -1,   -1,   -1,   91,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
            0,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           10,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,   -1,   44,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  262,  263,  264,   -1,   59, 
           -1,  268,  269,   63,  271,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,  280,  345,   -1,  347,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   91,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,    0,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   10,  360,  361,  362,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   44,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   59,   -1,   -1,   -1,   63,   -1,   -1,   -1,   -1, 
           -1,  317,  318,  319,  320,  321,  322,  323,  324,  325, 
          326,  327,  328,  329,  330,   -1,   -1,  333,  334,  335, 
           -1,   -1,   -1,   91,   -1,  341,   -1,   -1,   -1,   -1, 
           -1,   -1,  348,   -1,  350,    0,  352,  353,  354,  355, 
          356,  357,  358,   -1,  360,   10,  362,   -1,   -1,   -1, 
           -1,   -1,  262,  263,  264,   -1,   -1,  267,  268,  269, 
           -1,  271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  281,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   44, 
          290,  291,   -1,  293,  294,  295,  296,  297,   -1,   -1, 
           -1,   -1,   -1,   -1,   59,   -1,   61,   -1,   63,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319, 
          320,  321,  322,  323,  324,  325,  326,  327,  328,  329, 
          330,   -1,   -1,  333,  334,  335,   91,   -1,   -1,   -1, 
           -1,  341,   -1,   -1,   -1,   -1,   -1,   -1,  348,   -1, 
          350,   -1,  352,  353,  354,  355,  356,  357,  358,    0, 
          360,   -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   10, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   44,  262,  263,  264,   -1,   -1,  267, 
          268,  269,   -1,  271,   -1,   -1,   -1,   -1,   59,   -1, 
           61,   -1,   63,  281,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  290,  291,   -1,  293,  294,  295,  296,  297, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           91,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  317, 
          318,  319,  320,  321,  322,  323,  324,  325,  326,  327, 
          328,  329,  330,   -1,   -1,  333,  334,  335,   -1,   -1, 
           -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,   -1, 
          348,   -1,  350,    0,  352,  353,  354,  355,  356,  357, 
          358,   -1,  360,   10,  362,   -1,   -1,  262,  263,  264, 
           -1,   -1,   -1,  268,  269,   -1,  271,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  290,  291,   44,  293,  294, 
          295,  296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   59,   -1,   61,   -1,   63,   -1,   -1,   -1, 
           -1,   -1,  317,  318,  319,  320,  321,  322,  323,  324, 
          325,  326,  327,  328,  329,  330,   -1,   -1,  333,  334, 
          335,   -1,  337,   -1,   91,   -1,  341,   -1,   -1,   -1, 
           -1,   -1,   -1,  348,   -1,  350,   -1,  352,  353,  354, 
          355,  356,  357,  358,    0,  360,   -1,  362,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,   -1,   -1,   -1,   -1, 
           -1,  262,  263,  264,   -1,   -1,   -1,  268,  269,   -1, 
          271,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,  290, 
          291,   -1,  293,  294,  295,  296,  297,   10,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  317,  318,  319,  320, 
          321,  322,  323,  324,  325,  326,  327,  328,  329,  330, 
           -1,   -1,  333,  334,  335,   -1,   -1,   -1,   -1,   -1, 
          341,   -1,   -1,   -1,   -1,   -1,   59,  348,    0,  350, 
           -1,  352,  353,  354,  355,  356,  357,  358,   10,  360, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,    0,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,  262,  263,  264,   -1,   -1, 
           -1,  268,  269,   -1,  271,   -1,   -1,   59,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  290,  291,   -1,  293,  294,  295,  296, 
          297,   -1,   -1,   -1,   -1,   -1,   -1,    0,   -1,   -1, 
           -1,   -1,   -1,   59,   -1,   -1,   -1,   10,   -1,   -1, 
          317,  318,  319,  320,  321,  322,  323,  324,  325,  326, 
          327,  328,  329,  330,   -1,   -1,  333,  334,  335,   -1, 
           -1,   -1,   -1,   -1,  341,   -1,   -1,   -1,   -1,   -1, 
           -1,  348,   -1,  350,   -1,  352,  353,  354,  355,  356, 
          357,  358,   -1,  360,    0,  362,   59,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   10,   -1,  262,  263,  264,   -1, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,  282,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   59,  267,  268,  269,   -1,  271,   -1, 
           -1,   -1,   -1,   -1,   -1,    0,   -1,   -1,  281,  282, 
           -1,   -1,   -1,   -1,   -1,   10,   -1,  290,  291,   -1, 
          293,  294,  295,  296,  297,  341,   -1,   -1,  344,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  362,   -1,   -1,   44, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   59,   -1,   -1,   -1,  341,  281, 
          282,  344,   -1,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,  262,  263,  264,  362, 
           -1,  267,  268,  269,   -1,  271,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  281,   -1,   -1,   59,   -1, 
           -1,   -1,   -1,   -1,  290,  291,   -1,  293,  294,  295, 
          296,  297,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,   -1,  344,   -1,   -1,   -1,   -1,   -1,   -1,  262, 
          263,  264,   -1,   -1,  267,  268, 
      };
   }

   private static final short[] yyCheck4() {
      return new short[] {

          269,   -1,  271,   -1,  362,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  281,   -1,   -1,   -1,   -1,   -1,   -1,  341, 
           -1,  290,  291,   -1,  293,  294,  295,  296,  297,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          262,  263,  264,   -1,   -1,  267,  268,  269,   -1,  271, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  281, 
           -1,   -1,  341,   -1,   -1,   -1,   -1,   -1,  290,  291, 
           -1,  293,  294,  295,  296,  297,   59,   -1,   -1,   -1, 
          306,  307,   -1,  362,  310,   -1,   -1,   -1,  314,  315, 
           -1,  317,  318,  319,  320,  321,  322,  323,   -1,   -1, 
          326,  327,   -1,   -1,   -1,  331,  332,  333,  334,   -1, 
           -1,  262,  263,  264,  340,   -1,  267,  268,  269,  341, 
          271,  347,  348,   -1,  350,  351,  352,  353,  354,  355, 
          356,  357,  358,  359,  360,   -1,   -1,  363,   -1,   -1, 
          362,   -1,  293,  294,  295,  296,  297,   -1,   -1,   -1, 
          257,  258,  259,  260,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,  338,   -1,   -1, 
          341,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,  362,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,   -1,  257,  258,  259,  260,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,  298,  299,   -1,  301,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  256,  257,  258, 
          259,  260,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,  298, 
          299,  300,  301,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  256,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  256,  257,  258,  259,  260, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,  298,  299,   -1, 
          301,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,  260,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
          298,  299,  300,  301,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,  260,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,  298,  299,   -1,  301,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
          312,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,  349,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,  312,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
          349,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,  312,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,  349,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,  312, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342, 
          343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,  312,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,  349, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,  312,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
          347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,  312,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,  340, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,  314,  315,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,  314, 
          315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,  347,   -1,   -1,   -1,  351, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,  314,  315,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,  347,   -1, 
           -1,   -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          359,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,  314,  315, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,  347,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,   -1,  261,   -1, 
           -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272, 
          273,  274,  275,  276,  277,  278,   -1,   -1,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,   -1,   -1,  292, 
           -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302, 
          303,  304,   -1,  306,  307,  308,  309,  310,  311,   -1, 
          313,  314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,  336,   -1,   -1,  339,  340,   -1,  342, 
          343,   -1,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1, 
           -1,  364,  365,  366,  367,  368,  369,   -1,   -1,   -1, 
          373,   -1,  375,  376,   -1,  378,  379,  257,  258,  259, 
           -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1, 
          270,   -1,  272,  273,  274,  275,  276,  277,  278,   -1, 
           -1,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
           -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299, 
           -1,   -1,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,  313,  314,  315,  316,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339, 
           -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1, 
           -1,  351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359, 
           -1,   -1,   -1,   -1,  364,  365,  366,  367,  368,  369, 
           -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378,  379, 
          257,  258,  259,   -1,  261,   -1,   -1,   -1,  265,  266, 
           -1,   -1,   -1,  270,   -1,  272,  273,  274,  275,  276, 
          277,  278,   -1,   -1,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1, 
           -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,  313,  314,  315,  316, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336, 
           -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1, 
           -1,   -1,   -1,   -1,  351,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  359,   -1,   -1,   -1,   -1,  364,  365,  366, 
          367,  368,  369,   -1,   -1,   -1,  373,   -1,  375,  376, 
           -1,  378,  379,  257,  258,  259,   -1,  261,   -1,   -1, 
           -1,  265,  266,   -1,   -1,   -1,  270,   -1,  272,  273, 
          274,  275,  276,  277,  278,   -1,   -1,   -1,   -1,  283, 
          284,  285,  286,  287,  288,  289,   -1,   -1,  292,   -1, 
           -1,   -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303, 
          304,   -1,  306,  307,  308,  309,  310,  311,   -1,  313, 
          314,  315,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343, 
           -1,  345,   -1,   -1,   -1,   -1,   -1,  351,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  359,   -1,   -1,   -1,   -1, 
          364,  365,  366,  367,  368,  369,   -1,   -1,   -1,  373, 
           -1,  375,  376,   -1,  378,  379,  257,  258,  259,   -1, 
          261,   -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270, 
           -1,  272,  273,  274,  275,  276,  277,  278,   -1,   -1, 
           -1,   -1,  283,  284,  285,  286,  287,  288,  289,   -1, 
           -1,  292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1, 
           -1,  302,  303,  304,   -1,  306,  307,  308,  309,  310, 
          311,   -1,  313,  314,  315,  316,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1, 
           -1,  342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1, 
          351,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  359,   -1, 
           -1,   -1,   -1,  364,  365,  366,  367,  368,  369,   -1, 
           -1,   -1,  373,   -1,  375,  376,   -1,  378,  379,  257, 
          258,  259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1, 
           -1,   -1,  270,   -1,  272,  273,  274,  275,  276,  277, 
          278,   -1,   -1,   -1,   -1,  283,  284,  285,  286,  287, 
          288,  289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1, 
           -1,  299,   -1,   -1,  302,  303,  304,   -1,  306,  307, 
          308,  309,  310,  311,   -1,  313,   -1,   -1,  316,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1, 
           -1,  339,   -1,   -1,  342,  343,   -1,  345,   -1,  347, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367, 
          368,  369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1, 
          378,  379,  257,  258,  259,   -1,  261,   -1,   -1,   -1, 
          265,  266,   -1,   -1,   -1,  270,   -1,  272,  273,  274, 
          275,  276,  277,  278,   -1,   -1,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,   -1,   -1,  292,   -1,   -1, 
           -1,   -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304, 
           -1,  306,  307,  308,  309,  310,  311,   -1,  313,   -1, 
           -1,  316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,  336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1, 
          345,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364, 
          365,  366,  367,  368,  369,   -1,   -1,   -1,  373,   -1, 
          375,  376,   -1,  378,  379,  257,  258,  259,   -1,  261, 
           -1,   -1,   -1,  265,  266,   -1,   -1,   -1,  270,   -1, 
          272,  273,  274,  275,  276,  277,  278,   -1,   -1,   -1, 
           -1,  283,  284,  285,  286,  287,  288,  289,   -1,   -1, 
          292,   -1,   -1,   -1,   -1,   -1,   -1,  299,   -1,   -1, 
          302,  303,  304,   -1,  306,  307,  308,  309,  310,  311, 
           -1,  313,   -1,   -1,  316,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  336,   -1,   -1,  339,   -1,   -1, 
          342,  343,   -1,  345,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  364,  365,  366,  367,  368,  369,   -1,   -1, 
           -1,  373,   -1,  375,  376,   -1,  378,  379,  257,  258, 
          259,   -1,  261,   -1,   -1,   -1,  265,  266,   -1,   -1, 
           -1,  270,   -1,  272,  273,  274,  275,  276,  277,  278, 
           -1,   -1,   -1,   -1,  283,  284,  285,  286,  287,  288, 
          289,   -1,   -1,  292,   -1,   -1,   -1,   -1,   -1,   -1, 
          299,   -1,   -1,  302,  303,  304,   -1,  306,  307,  308, 
          309,  310,  311,   -1,  313,   -1,   -1,  316,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  336,   -1,   -1, 
          339,   -1,   -1,  342,  343,   -1,  345,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,  364,  365,  366,  367,  368, 
          369,   -1,   -1,   -1,  373,   -1,  375,  376,   -1,  378, 
          379,  257,  258,  259,   -1,  261,   -1,   -1,   -1,  265, 
          266,   -1,   -1,   -1,  270,   -1,  272,  273,  274,  275, 
          276,  277,  278,   -1,   -1,   -1,   -1,  283,  284,  285, 
          286,  287,  288,  289,   -1,   -1,  292,   -1,   -1,   -1, 
           -1,   -1,   -1,  299,   -1,   -1,  302,  303,  304,   -1, 
          306,  307,  308,  309,  310,  311,   -1,  313,   -1,   -1, 
          316,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
          336,   -1,   -1,  339,   -1,   -1,  342,  343,   -1,  345, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  364,  365, 
          366,  367,  368,  369,   -1,   -1,   -1,  373,   -1,  375, 
          376,   -1,  378,  379,  257,  258,  259,  260,  261,  262, 
          263,  264,   -1,   -1,  267,  268,  269,  270,  271,   -1, 
           -1,  274,  275,  276,  277,  278,  279,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,  298,  299,  300,  301,  302, 
          303,  304,   -1,  306,  307,  308,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,   -1,   -1, 
          363,  364,  257,  258,  259,  260,  261,  262,  263,  264, 
           -1,   -1,  267,  268,  269,  270,  271,   -1,   -1,  274, 
          275,  276,  277,  278,  279,  280,   -1,   -1,  283,  284, 
          285,  286,  287,  288,  289,  290,  291,  292,  293,  294, 
          295,  296,  297,  298,  299,  300,  301,  302,  303,  304, 
           -1,  306,  307,   -1,   -1,  310,   -1,   -1,   -1,  314, 
          315,   -1,  317,  318,  319,  320,  321,  322,  323,   -1, 
           -1,  326,  327,   -1,   -1,   -1,  331,  332,  333,  334, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,  347,  348,   -1,  350,  351,  352,  353,  354, 
          355,  356,  357,  358,  359,  360,   -1,   -1,  363,  364, 
          257,  258,  259,  260,  261,  262,  263,  264,   -1,   -1, 
          267,  268,  269,  270,  271,   -1,   -1,  274,  275,  276, 
          277,  278,  279,  280,   -1,   -1,  283,  284,  285,  286, 
          287,  288,  289,  290,  291,  292,  293,  294,  295,  296, 
          297,  298,  299,  300,  301,  302,  303,  304,   -1,  306, 
          307,  308,  309,  310,  311,   -1,   -1,  314,  315,   -1, 
          317,  318,  319,  320,  321,  322,  323,   -1,   -1,  326, 
          327,   -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1, 
           -1,   -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1, 
          347,  348,   -1,  350,  351,  352,  353,  354,  355,  356, 
          357,  358,  359,  360,   -1,   -1,  363,  257,  258,  259, 
          260,  261,  262,  263,  264,   -1,   -1,  267,  268,  269, 
          270,  271,   -1,   -1,  274,  275,  276,  277,  278,  279, 
          280,   -1,   -1,  283,  284,  285,  286,  287,  288,  289, 
          290,  291,  292,  293,  294,  295,  296,  297,  298,  299, 
          300,  301,  302,  303,  304,   -1,  306,  307,  308,  309, 
          310,  311,   -1,   -1,  314,  315,   -1,  317,  318,  319, 
          320,  321,  322,  323,   -1,   -1,  326,  327,   -1,   -1, 
           -1,  331,  332,  333,  334,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,  347,  348,   -1, 
          350,  351,  352,  353,  354,  355,  356,  357,  358,  359, 
          360,   -1,   -1,  363,  257,  258,  259,  260,  261,  262, 
          263,  264,   -1,   -1,  267,  268,  269,  270,  271,   -1, 
           -1,  274,  275,  276,  277,  278,  279,  280,   -1,   -1, 
          283,  284,  285,  286,  287,  288,  289,  290,  291,  292, 
          293,  294,  295,  296,  297,  298,  299,  300,  301,  302, 
          303,  304,   -1,  306,  307,   -1,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,  340,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,  306,  307,  363,   -1,  310,   -1,   -1, 
           -1,  314,  315,   -1,  317,  318,  319,  320,  321,  322, 
          323,   -1,   -1,  326,  327,   -1,   -1,   -1,  331,  332, 
          333,  334,   -1,   -1,   -1,   -1,   -1,  340,   -1,   -1, 
           -1,   -1,   -1,   -1,  347,  348,   -1,  350,  351,  352, 
          353,  354,  355,  356,  357,  358,  359,  360,  306,  307, 
          363,   -1,  310,   -1,   -1,   -1,  314,  315,   -1,  317, 
          318,  319,  320,  321,  322,  323,   -1,   -1,  326,  327, 
           -1,   -1,   -1,  331,  332,  333,  334,   -1,   -1,   -1, 
           -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  347, 
          348,   -1,  350,  351,  352,  353,  354,  355,  356,  357, 
          358,  359,  360,   -1,   -1,  363, 
      };
   }

}
