/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONPathFilter;
import com.alibaba.fastjson2.JSONPathFunction;
import com.alibaba.fastjson2.JSONPathMulti;
import com.alibaba.fastjson2.JSONPathParser;
import com.alibaba.fastjson2.JSONPathSegment;
import com.alibaba.fastjson2.JSONPathSegmentIndex;
import com.alibaba.fastjson2.JSONPathSegmentName;
import com.alibaba.fastjson2.JSONPathSingle;
import com.alibaba.fastjson2.JSONPathSingleIndex;
import com.alibaba.fastjson2.JSONPathSingleName;
import com.alibaba.fastjson2.JSONPathTwoSegment;
import com.alibaba.fastjson2.JSONPathTyped;
import com.alibaba.fastjson2.JSONPathTypedMulti;
import com.alibaba.fastjson2.JSONPathTypedMultiIndexes;
import com.alibaba.fastjson2.JSONPathTypedMultiNames;
import com.alibaba.fastjson2.JSONPathTypedMultiNamesPrefixIndex1;
import com.alibaba.fastjson2.JSONPathTypedMultiNamesPrefixName1;
import com.alibaba.fastjson2.JSONPathTypedMultiNamesPrefixName2;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class JSONPath {
    static final JSONReader.Context PARSE_CONTEXT = JSONFactory.createReadContext();
    JSONReader.Context readerContext;
    JSONWriter.Context writerContext;
    final String path;
    final long features;

    protected JSONPath(String path, Feature ... features) {
        this.path = path;
        long featuresValue = 0L;
        for (Feature feature : features) {
            featuresValue |= feature.mask;
        }
        this.features = featuresValue;
    }

    protected JSONPath(String path, long features) {
        this.path = path;
        this.features = features;
    }

    public abstract JSONPath getParent();

    public boolean endsWithFilter() {
        return false;
    }

    public boolean isPrevious() {
        return false;
    }

    public final String toString() {
        return this.path;
    }

    public static Object extract(String json, String path) {
        JSONReader jsonReader = JSONReader.of(json);
        JSONPath jsonPath = JSONPath.of(path);
        return jsonPath.extract(jsonReader);
    }

    public static Object extract(String json, String path, Feature ... features) {
        JSONReader jsonReader = JSONReader.of(json);
        JSONPath jsonPath = JSONPath.of(path, features);
        return jsonPath.extract(jsonReader);
    }

    public static Object eval(String str, String path) {
        return JSONPath.extract(str, path);
    }

    public static Object eval(Object rootObject, String path) {
        return JSONPath.of(path).eval(rootObject);
    }

    public static String set(String json, String path, Object value) {
        Object object = JSON.parse(json);
        JSONPath.of(path).set(object, value);
        return JSON.toJSONString(object);
    }

    public static boolean contains(Object rootObject, String path) {
        if (rootObject == null) {
            return false;
        }
        JSONPath jsonPath = JSONPath.of(path);
        return jsonPath.contains(rootObject);
    }

    public static Object set(Object rootObject, String path, Object value) {
        JSONPath.of(path).set(rootObject, value);
        return rootObject;
    }

    public static Object setCallback(Object rootObject, String path, Function callback) {
        JSONPath.of(path).setCallback(rootObject, callback);
        return rootObject;
    }

    public static Object setCallback(Object rootObject, String path, BiFunction callback) {
        JSONPath.of(path).setCallback(rootObject, callback);
        return rootObject;
    }

    public static String remove(String json, String path) {
        Object object = JSON.parse(json);
        JSONPath.of(path).remove(object);
        return JSON.toJSONString(object);
    }

    public static void remove(Object rootObject, String path) {
        JSONPath.of(path).remove(rootObject);
    }

    public static Map<String, Object> paths(Object javaObject) {
        IdentityHashMap<Object, String> values = new IdentityHashMap<Object, String>();
        LinkedHashMap<String, Object> paths = new LinkedHashMap<String, Object>();
        RootPath.INSTANCE.paths(values, paths, "$", javaObject);
        return paths;
    }

    void paths(Map<Object, String> values, Map paths, String parent, Object javaObject) {
        if (javaObject == null) {
            return;
        }
        String p = values.put(javaObject, parent);
        if (p != null) {
            boolean basicType;
            Class<?> type = javaObject.getClass();
            boolean bl = basicType = type == String.class || type == Boolean.class || type == Character.class || type == UUID.class || javaObject instanceof Enum || javaObject instanceof Number || javaObject instanceof Date;
            if (!basicType) {
                return;
            }
        }
        paths.put(parent, javaObject);
        if (javaObject instanceof Map) {
            Map map = (Map)javaObject;
            for (Map.Entry entryObj : map.entrySet()) {
                Map.Entry entry = entryObj;
                Object key = entry.getKey();
                if (!(key instanceof String)) continue;
                String strKey = (String)key;
                boolean escape = strKey.isEmpty();
                if (!escape) {
                    char c0 = strKey.charAt(0);
                    boolean bl = escape = !(c0 >= 'a' && c0 <= 'z' || c0 >= 'A' && c0 <= 'Z' || c0 == '_');
                    if (!escape) {
                        for (int i = 1; i < strKey.length(); ++i) {
                            char ch = strKey.charAt(i);
                            boolean bl2 = escape = !(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '_');
                            if (escape) break;
                        }
                    }
                }
                String path = escape ? parent + '[' + JSON.toJSONString((Object)strKey, JSONWriter.Feature.UseSingleQuotes) + ']' : parent + "." + strKey;
                this.paths(values, paths, path, entry.getValue());
            }
            return;
        }
        if (javaObject instanceof Collection) {
            Collection collection = (Collection)javaObject;
            int i = 0;
            for (Object item : collection) {
                String path = parent + "[" + i + "]";
                this.paths(values, paths, path, item);
                ++i;
            }
            return;
        }
        Class<?> clazz = javaObject.getClass();
        if (clazz.isArray()) {
            int len = Array.getLength(javaObject);
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(javaObject, i);
                String path = parent + "[" + i + "]";
                this.paths(values, paths, path, item);
            }
            return;
        }
        if (ObjectWriterProvider.isPrimitiveOrEnum(clazz)) {
            return;
        }
        ObjectWriter<?> serializer = this.getWriterContext().getObjectWriter(clazz);
        if (serializer instanceof ObjectWriterAdapter) {
            ObjectWriterAdapter javaBeanSerializer = (ObjectWriterAdapter)serializer;
            try {
                Map<String, Object> fieldValues = javaBeanSerializer.toMap(javaObject);
                for (Map.Entry<String, Object> entry : fieldValues.entrySet()) {
                    String key = entry.getKey();
                    if (key == null) continue;
                    String path = parent + "." + key;
                    this.paths(values, paths, path, entry.getValue());
                }
            }
            catch (Exception e) {
                throw new JSONException("toJSON error", e);
            }
        }
    }

    public abstract boolean isRef();

    public void arrayAdd(Object root, Object ... values) {
        Object result = this.eval(root);
        if (result == null) {
            this.set(root, JSONArray.of(values));
            return;
        }
        if (result instanceof Collection) {
            Collection collection = (Collection)result;
            collection.addAll(Arrays.asList(values));
        }
    }

    public abstract boolean contains(Object var1);

    public abstract Object eval(Object var1);

    protected JSONReader.Context createContext() {
        return JSONFactory.createReadContext();
    }

    public Object extract(String jsonStr) {
        if (jsonStr == null) {
            return null;
        }
        try (JSONReader jsonReader = JSONReader.of(jsonStr, this.createContext());){
            Object object = this.extract(jsonReader);
            return object;
        }
    }

    public Object extract(byte[] jsonBytes) {
        if (jsonBytes == null) {
            return null;
        }
        try (JSONReader jsonReader = JSONReader.of(jsonBytes, this.createContext());){
            Object object = this.extract(jsonReader);
            return object;
        }
    }

    public Object extract(byte[] jsonBytes, int off, int len, Charset charset) {
        if (jsonBytes == null) {
            return null;
        }
        try (JSONReader jsonReader = JSONReader.of(jsonBytes, off, len, charset, this.createContext());){
            Object object = this.extract(jsonReader);
            return object;
        }
    }

    public abstract Object extract(JSONReader var1);

    public abstract String extractScalar(JSONReader var1);

    public JSONReader.Context getReaderContext() {
        if (this.readerContext == null) {
            this.readerContext = JSONFactory.createReadContext();
        }
        return this.readerContext;
    }

    public JSONPath setReaderContext(JSONReader.Context context) {
        this.readerContext = context;
        return this;
    }

    public JSONWriter.Context getWriterContext() {
        if (this.writerContext == null) {
            this.writerContext = JSONFactory.createWriteContext();
        }
        return this.writerContext;
    }

    public JSONPath setWriterContext(JSONWriter.Context writerContext) {
        this.writerContext = writerContext;
        return this;
    }

    public abstract void set(Object var1, Object var2);

    public abstract void set(Object var1, Object var2, JSONReader.Feature ... var3);

    public void setCallback(Object object, Function callback) {
        this.setCallback(object, new JSONPathFunction.BiFunctionAdapter(callback));
    }

    public abstract void setCallback(Object var1, BiFunction var2);

    public abstract void setInt(Object var1, int var2);

    public abstract void setLong(Object var1, long var2);

    public abstract boolean remove(Object var1);

    public void extract(JSONReader jsonReader, ValueConsumer consumer) {
        Object object = this.extract(jsonReader);
        if (object == null) {
            consumer.acceptNull();
            return;
        }
        if (object instanceof Number) {
            consumer.accept((Number)object);
            return;
        }
        if (object instanceof String) {
            consumer.accept((String)object);
            return;
        }
        if (object instanceof Boolean) {
            consumer.accept((Boolean)object);
            return;
        }
        if (object instanceof Map) {
            consumer.accept((Map)object);
            return;
        }
        if (object instanceof List) {
            consumer.accept((List)object);
            return;
        }
        throw new JSONException("TODO : " + object.getClass());
    }

    public void extractScalar(JSONReader jsonReader, ValueConsumer consumer) {
        String object = this.extractScalar(jsonReader);
        if (object == null) {
            consumer.acceptNull();
            return;
        }
        String str = object.toString();
        consumer.accept(str);
    }

    public Long extractInt64(JSONReader jsonReader) {
        long value = this.extractInt64Value(jsonReader);
        if (jsonReader.wasNull) {
            return null;
        }
        return value;
    }

    public long extractInt64Value(JSONReader jsonReader) {
        Object object = this.extract(jsonReader);
        if (object == null) {
            jsonReader.wasNull = true;
            return 0L;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(object.getClass(), Long.TYPE);
        if (typeConvert == null) {
            throw new JSONException("can not convert to long : " + object);
        }
        Object converted = typeConvert.apply(object);
        return (Long)converted;
    }

    public Integer extractInt32(JSONReader jsonReader) {
        int intValue = this.extractInt32Value(jsonReader);
        if (jsonReader.wasNull) {
            return null;
        }
        return intValue;
    }

    public int extractInt32Value(JSONReader jsonReader) {
        Object object = this.extract(jsonReader);
        if (object == null) {
            jsonReader.wasNull = true;
            return 0;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(object.getClass(), Integer.TYPE);
        if (typeConvert == null) {
            throw new JSONException("can not convert to int : " + object);
        }
        return (Integer)typeConvert.apply(object);
    }

    @Deprecated
    public static JSONPath compile(String path) {
        return JSONPath.of(path);
    }

    public static JSONPath compile(String strPath, Class objectClass) {
        JSONPath path = JSONPath.of(strPath);
        JSONFactory.JSONPathCompiler compiler = JSONFactory.getDefaultJSONPathCompiler();
        return compiler.compile(objectClass, path);
    }

    static JSONPathSingle of(JSONPathSegment segment) {
        String prefix = segment instanceof JSONPathSegment.MultiIndexSegment || segment instanceof JSONPathSegmentIndex ? "$" : "$.";
        String path = prefix + segment.toString();
        if (segment instanceof JSONPathSegmentName) {
            return new JSONPathSingleName(path, (JSONPathSegmentName)segment, new Feature[0]);
        }
        return new JSONPathSingle(segment, path, new Feature[0]);
    }

    public static JSONPath of(String path) {
        if ("#-1".equals(path)) {
            return PreviousPath.INSTANCE;
        }
        return new JSONPathParser(path).parse(new Feature[0]);
    }

    public static JSONPath of(String path, Type type) {
        JSONPath jsonPath = JSONPath.of(path);
        return JSONPathTyped.of(jsonPath, type);
    }

    public static JSONPath of(String path, Type type, Feature ... features) {
        JSONPath jsonPath = JSONPath.of(path, features);
        return JSONPathTyped.of(jsonPath, type);
    }

    public static JSONPath of(String[] paths, Type[] types) {
        return JSONPath.of(paths, types, null, null, (ZoneId)null, new JSONReader.Feature[0]);
    }

    public static JSONPath of(String[] paths, Type[] types, JSONReader.Feature ... features) {
        return JSONPath.of(paths, types, null, null, null, features);
    }

    public static JSONPath of(String[] paths, Type[] types, String[] formats, long[] pathFeatures, ZoneId zoneId, JSONReader.Feature ... features) {
        JSONPathSegment first0;
        if (paths.length == 0) {
            throw new JSONException("illegal paths, not support 0 length");
        }
        if (types == null) {
            types = new Type[paths.length];
            Arrays.fill(types, Object.class);
        }
        if (types.length != paths.length) {
            throw new JSONException("types.length not equals paths.length");
        }
        JSONPath[] jsonPaths = new JSONPath[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            jsonPaths[i] = JSONPath.of(paths[i]);
        }
        boolean allSingleName = true;
        boolean allSinglePositiveIndex = true;
        boolean allTwoName = true;
        boolean allTwoIndexPositive = true;
        boolean allThreeName = true;
        boolean sameMultiLength = true;
        JSONPathMulti firstMulti = null;
        for (int i = 0; i < jsonPaths.length; ++i) {
            JSONPathTwoSegment two;
            JSONPath path = jsonPaths[i];
            if (i == 0) {
                if (path instanceof JSONPathMulti) {
                    firstMulti = (JSONPathMulti)path;
                } else {
                    sameMultiLength = false;
                }
            } else if (sameMultiLength && path instanceof JSONPathMulti && ((JSONPathMulti)path).segments.size() != firstMulti.segments.size()) {
                sameMultiLength = false;
            }
            if (allSingleName && !(path instanceof JSONPathSingleName)) {
                allSingleName = false;
            }
            if (allSinglePositiveIndex && (!(path instanceof JSONPathSingleIndex) || ((JSONPathSingleIndex)path).index < 0)) {
                allSinglePositiveIndex = false;
            }
            if (allTwoName) {
                if (path instanceof JSONPathTwoSegment) {
                    two = (JSONPathTwoSegment)path;
                    if (!(two.second instanceof JSONPathSegmentName)) {
                        allTwoName = false;
                    }
                } else {
                    allTwoName = false;
                }
            }
            if (allTwoIndexPositive) {
                if (path instanceof JSONPathTwoSegment) {
                    two = (JSONPathTwoSegment)path;
                    if (!(two.second instanceof JSONPathSegmentIndex) || ((JSONPathSegmentIndex)two.second).index < 0) {
                        allTwoIndexPositive = false;
                    }
                } else {
                    allTwoIndexPositive = false;
                }
            }
            if (!allThreeName) continue;
            if (path instanceof JSONPathMulti) {
                JSONPathMulti multi = (JSONPathMulti)path;
                if (multi.segments.size() == 3) {
                    JSONPathSegment three = multi.segments.get(2);
                    if (!(multi.segments.get(0) instanceof JSONPathSegment.AllSegment) && !(multi.segments.get(1) instanceof JSONPathSegment.AllSegment) && three instanceof JSONPathSegmentName) continue;
                    allThreeName = false;
                    continue;
                }
                allThreeName = false;
                continue;
            }
            allThreeName = false;
        }
        long featuresValue = JSONReader.Feature.of(features);
        if (allSingleName) {
            return new JSONPathTypedMultiNames(jsonPaths, null, jsonPaths, types, formats, pathFeatures, zoneId, featuresValue);
        }
        if (allSinglePositiveIndex) {
            return new JSONPathTypedMultiIndexes(jsonPaths, null, jsonPaths, types, formats, pathFeatures, zoneId, featuresValue);
        }
        if (allTwoName || allTwoIndexPositive) {
            boolean samePrefix = true;
            first0 = ((JSONPathTwoSegment)jsonPaths[0]).first;
            for (int i = 1; i < jsonPaths.length; ++i) {
                JSONPathTwoSegment two = (JSONPathTwoSegment)jsonPaths[i];
                if (first0.equals(two.first)) continue;
                samePrefix = false;
                break;
            }
            if (samePrefix) {
                JSONPathSegmentName name;
                JSONPathSegment name2;
                JSONPathTwoSegment two;
                JSONPath firstPath = jsonPaths[0];
                if (allTwoName) {
                    JSONPathSingle prefix;
                    JSONPath[] names = new JSONPathSingleName[jsonPaths.length];
                    for (int i = 0; i < jsonPaths.length; ++i) {
                        two = (JSONPathTwoSegment)jsonPaths[i];
                        name2 = (JSONPathSegmentName)two.second;
                        names[i] = new JSONPathSingleName("$." + name2, (JSONPathSegmentName)name2, new Feature[0]);
                    }
                    String prefixPath = firstPath.path.substring(0, firstPath.path.length() - names[0].name.length() - 1);
                    if (first0 instanceof JSONPathSegmentName) {
                        name = (JSONPathSegmentName)first0;
                        prefix = new JSONPathSingleName(prefixPath, name, new Feature[0]);
                        return new JSONPathTypedMultiNamesPrefixName1(jsonPaths, prefix, names, types, formats, pathFeatures, zoneId, featuresValue);
                    }
                    if (first0 instanceof JSONPathSegmentIndex) {
                        JSONPathSegmentIndex first0Index = (JSONPathSegmentIndex)first0;
                        if (first0Index.index >= 0) {
                            prefix = new JSONPathSingleIndex(prefixPath, first0Index, new Feature[0]);
                            return new JSONPathTypedMultiNamesPrefixIndex1(jsonPaths, (JSONPathSingleIndex)prefix, names, types, formats, pathFeatures, zoneId, featuresValue);
                        }
                    }
                } else {
                    JSONPath[] indexes = new JSONPathSingleIndex[jsonPaths.length];
                    for (int i = 0; i < jsonPaths.length; ++i) {
                        two = (JSONPathTwoSegment)jsonPaths[i];
                        name2 = (JSONPathSegmentIndex)two.second;
                        indexes[i] = new JSONPathSingleIndex("$" + name2, (JSONPathSegmentIndex)name2, new Feature[0]);
                    }
                    JSONPathSingle prefix = null;
                    if (first0 instanceof JSONPathSegmentName) {
                        name = (JSONPathSegmentName)first0;
                        prefix = new JSONPathSingleName("$." + name.name, name, new Feature[0]);
                    } else if (first0 instanceof JSONPathSegmentIndex) {
                        JSONPathSegmentIndex index = (JSONPathSegmentIndex)first0;
                        prefix = new JSONPathSingleIndex("$[" + index.index + "]", index, new Feature[0]);
                    }
                    if (prefix != null) {
                        return new JSONPathTypedMultiIndexes(jsonPaths, prefix, indexes, types, formats, pathFeatures, zoneId, featuresValue);
                    }
                }
            }
        } else if (allThreeName) {
            boolean samePrefix = true;
            first0 = ((JSONPathMulti)jsonPaths[0]).segments.get(0);
            JSONPathSegment first1 = ((JSONPathMulti)jsonPaths[0]).segments.get(1);
            for (int i = 1; i < jsonPaths.length; ++i) {
                JSONPathMulti multi = (JSONPathMulti)jsonPaths[i];
                if (!first0.equals(multi.segments.get(0))) {
                    samePrefix = false;
                    break;
                }
                if (first1.equals(multi.segments.get(1))) continue;
                samePrefix = false;
                break;
            }
            if (samePrefix) {
                JSONPath[] names = new JSONPathSingleName[jsonPaths.length];
                for (int i = 0; i < jsonPaths.length; ++i) {
                    JSONPathMulti multi = (JSONPathMulti)jsonPaths[i];
                    JSONPathSegmentName name = (JSONPathSegmentName)multi.segments.get(2);
                    names[i] = new JSONPathSingleName("$." + name, name, new Feature[0]);
                }
                JSONPath firstPath = jsonPaths[0];
                String prefixPath = firstPath.path.substring(0, firstPath.path.length() - names[0].name.length() - 1);
                JSONPathTwoSegment prefix = new JSONPathTwoSegment(prefixPath, first0, first1, new Feature[0]);
                if (first0 instanceof JSONPathSegmentName && first1 instanceof JSONPathSegmentName) {
                    return new JSONPathTypedMultiNamesPrefixName2(jsonPaths, prefix, names, types, formats, pathFeatures, zoneId, featuresValue);
                }
                return new JSONPathTypedMultiNames(jsonPaths, prefix, names, types, formats, pathFeatures, zoneId, featuresValue);
            }
        }
        if (sameMultiLength && paths.length > 1) {
            int i;
            boolean samePrefix = true;
            boolean sameType = true;
            int lastIndex = firstMulti.segments.size() - 1;
            JSONPathSegment lastSegment = firstMulti.segments.get(lastIndex);
            for (i = 0; i < lastIndex; ++i) {
                JSONPathSegment segment = firstMulti.segments.get(i);
                for (int j = 1; j < paths.length; ++j) {
                    JSONPathSegment segment1;
                    JSONPath jsonPath = jsonPaths[j];
                    if (jsonPath instanceof JSONPathMulti) {
                        JSONPathMulti path = (JSONPathMulti)jsonPath;
                        segment1 = path.segments.get(i);
                    } else {
                        segment1 = jsonPath instanceof JSONPathSingleName ? ((JSONPathSingleName)jsonPath).segment : (jsonPath instanceof JSONPathSingleIndex ? ((JSONPathSingleIndex)jsonPath).segment : null);
                    }
                    if (segment.equals(segment1)) continue;
                    samePrefix = false;
                    break;
                }
                if (!samePrefix) break;
            }
            if (samePrefix) {
                for (i = 1; i < paths.length; ++i) {
                    JSONPathMulti path = (JSONPathMulti)jsonPaths[i];
                    if (lastSegment.getClass().equals(path.segments.get(lastIndex).getClass())) continue;
                    sameType = false;
                    break;
                }
                if (sameType) {
                    List<JSONPathSegment> prefixSegments = firstMulti.segments.subList(0, lastIndex - 1);
                    String prefixPath = null;
                    int dotIndex = firstMulti.path.lastIndexOf(46);
                    if (dotIndex != -1) {
                        prefixPath = firstMulti.path.substring(0, dotIndex - 1);
                    }
                    if (prefixPath != null) {
                        JSONPathMulti prefix = new JSONPathMulti(prefixPath, prefixSegments, new Feature[0]);
                        if (lastSegment instanceof JSONPathSegmentIndex) {
                            JSONPath[] indexPaths = new JSONPath[paths.length];
                            for (int i2 = 0; i2 < jsonPaths.length; ++i2) {
                                JSONPathMulti path = (JSONPathMulti)jsonPaths[i2];
                                JSONPathSegmentIndex lastSegmentIndex = (JSONPathSegmentIndex)path.segments.get(lastIndex);
                                indexPaths[i2] = new JSONPathSingleIndex(lastSegmentIndex.toString(), lastSegmentIndex, new Feature[0]);
                            }
                            return new JSONPathTypedMultiIndexes(jsonPaths, prefix, indexPaths, types, formats, pathFeatures, zoneId, featuresValue);
                        }
                    }
                }
            }
        }
        return new JSONPathTypedMulti(jsonPaths, types, formats, pathFeatures, zoneId, featuresValue);
    }

    public static JSONPath of(String path, Feature ... features) {
        if ("#-1".equals(path)) {
            return PreviousPath.INSTANCE;
        }
        return new JSONPathParser(path).parse(features);
    }

    static JSONPathFilter.Operator parseOperator(JSONReader jsonReader) {
        JSONPathFilter.Operator operator;
        switch (jsonReader.ch) {
            case '<': {
                jsonReader.next();
                if (jsonReader.ch == '=') {
                    jsonReader.next();
                    operator = JSONPathFilter.Operator.LE;
                    break;
                }
                if (jsonReader.ch == '>') {
                    jsonReader.next();
                    operator = JSONPathFilter.Operator.NE;
                    break;
                }
                operator = JSONPathFilter.Operator.LT;
                break;
            }
            case '=': {
                jsonReader.next();
                if (jsonReader.ch == '~') {
                    jsonReader.nextWithoutComment();
                    operator = JSONPathFilter.Operator.REG_MATCH;
                    break;
                }
                if (jsonReader.ch == '=') {
                    jsonReader.next();
                    operator = JSONPathFilter.Operator.EQ;
                    break;
                }
                operator = JSONPathFilter.Operator.EQ;
                break;
            }
            case '!': {
                jsonReader.next();
                if (jsonReader.ch == '=') {
                    jsonReader.next();
                    operator = JSONPathFilter.Operator.NE;
                    break;
                }
                throw new JSONException("not support operator : !" + jsonReader.ch);
            }
            case '>': {
                jsonReader.next();
                if (jsonReader.ch == '=') {
                    jsonReader.next();
                    operator = JSONPathFilter.Operator.GE;
                    break;
                }
                operator = JSONPathFilter.Operator.GT;
                break;
            }
            case 'L': 
            case 'l': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if ("like".equalsIgnoreCase(fieldName)) {
                    operator = JSONPathFilter.Operator.LIKE;
                    break;
                }
                throw new JSONException("not support operator : " + fieldName);
            }
            case 'N': 
            case 'n': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if ("nin".equalsIgnoreCase(fieldName)) {
                    operator = JSONPathFilter.Operator.NOT_IN;
                    break;
                }
                if (!"not".equalsIgnoreCase(fieldName)) {
                    throw new JSONException("not support operator : " + fieldName);
                }
                jsonReader.readFieldNameHashCodeUnquote();
                fieldName = jsonReader.getFieldName();
                if ("like".equalsIgnoreCase(fieldName)) {
                    operator = JSONPathFilter.Operator.NOT_LIKE;
                    break;
                }
                if ("rlike".equalsIgnoreCase(fieldName)) {
                    operator = JSONPathFilter.Operator.NOT_RLIKE;
                    break;
                }
                if ("in".equalsIgnoreCase(fieldName)) {
                    operator = JSONPathFilter.Operator.NOT_IN;
                    break;
                }
                if ("between".equalsIgnoreCase(fieldName)) {
                    operator = JSONPathFilter.Operator.NOT_BETWEEN;
                    break;
                }
                throw new JSONException("not support operator : " + fieldName);
            }
            case 'I': 
            case 'i': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if ("in".equalsIgnoreCase(fieldName)) {
                    operator = JSONPathFilter.Operator.IN;
                    break;
                }
                if ("is".equalsIgnoreCase(fieldName)) {
                    operator = JSONPathFilter.Operator.EQ;
                    break;
                }
                throw new JSONException("not support operator : " + fieldName);
            }
            case 'R': 
            case 'r': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if ("rlike".equalsIgnoreCase(fieldName)) {
                    operator = JSONPathFilter.Operator.RLIKE;
                    break;
                }
                throw new JSONException("not support operator : " + fieldName);
            }
            case 'B': 
            case 'b': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if ("between".equalsIgnoreCase(fieldName)) {
                    operator = JSONPathFilter.Operator.BETWEEN;
                    break;
                }
                throw new JSONException("not support operator : " + fieldName);
            }
            case 'S': 
            case 's': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if ("starts".equalsIgnoreCase(fieldName)) {
                    jsonReader.readFieldNameHashCodeUnquote();
                    fieldName = jsonReader.getFieldName();
                    if (!"with".equalsIgnoreCase(fieldName)) {
                        throw new JSONException("not support operator : " + fieldName);
                    }
                } else if (!"startsWith".equalsIgnoreCase(fieldName)) {
                    throw new JSONException("not support operator : " + fieldName);
                }
                operator = JSONPathFilter.Operator.STARTS_WITH;
                break;
            }
            case 'E': 
            case 'e': {
                jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = jsonReader.getFieldName();
                if ("ends".equalsIgnoreCase(fieldName)) {
                    jsonReader.readFieldNameHashCodeUnquote();
                    fieldName = jsonReader.getFieldName();
                    if (!"with".equalsIgnoreCase(fieldName)) {
                        throw new JSONException("not support operator : " + fieldName);
                    }
                } else if (!"endsWith".equalsIgnoreCase(fieldName)) {
                    throw new JSONException("not support operator : " + fieldName);
                }
                operator = JSONPathFilter.Operator.ENDS_WITH;
                break;
            }
            default: {
                jsonReader.readFieldNameHashCodeUnquote();
                throw new JSONException("not support operator : " + jsonReader.getFieldName());
            }
        }
        return operator;
    }

    public static enum Feature {
        AlwaysReturnList(1L),
        NullOnError(2L),
        KeepNullValue(4L);

        public final long mask;

        private Feature(long mask) {
            this.mask = mask;
        }
    }

    static final class RootPath
    extends JSONPath {
        static final RootPath INSTANCE = new RootPath();

        private RootPath() {
            super("$", new Feature[0]);
        }

        @Override
        public boolean isRef() {
            return true;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public Object eval(Object object) {
            return object;
        }

        @Override
        public Object extract(JSONReader jsonReader) {
            if (jsonReader == null) {
                return null;
            }
            return jsonReader.readAny();
        }

        @Override
        public String extractScalar(JSONReader jsonReader) {
            Object any = jsonReader.readAny();
            return JSON.toJSONString(any);
        }

        @Override
        public void set(Object object, Object value) {
            throw new JSONException("unsupported operation");
        }

        @Override
        public void set(Object object, Object value, JSONReader.Feature ... readerFeatures) {
            throw new JSONException("unsupported operation");
        }

        @Override
        public void setCallback(Object object, BiFunction callback) {
            throw new JSONException("unsupported operation");
        }

        @Override
        public void setInt(Object object, int value) {
            throw new JSONException("unsupported operation");
        }

        @Override
        public void setLong(Object object, long value) {
            throw new JSONException("unsupported operation");
        }

        @Override
        public boolean remove(Object object) {
            return false;
        }

        @Override
        public JSONPath getParent() {
            return null;
        }
    }

    static final class PreviousPath
    extends JSONPath {
        static final PreviousPath INSTANCE = new PreviousPath("#-1");

        PreviousPath(String path) {
            super(path, new Feature[0]);
        }

        @Override
        public boolean isRef() {
            throw new JSONException("unsupported operation");
        }

        @Override
        public boolean isPrevious() {
            return true;
        }

        @Override
        public boolean contains(Object rootObject) {
            throw new JSONException("unsupported operation");
        }

        @Override
        public Object eval(Object rootObject) {
            throw new JSONException("unsupported operation");
        }

        @Override
        public Object extract(JSONReader jsonReader) {
            throw new JSONException("unsupported operation");
        }

        @Override
        public String extractScalar(JSONReader jsonReader) {
            throw new JSONException("unsupported operation");
        }

        @Override
        public void set(Object rootObject, Object value) {
            throw new JSONException("unsupported operation");
        }

        @Override
        public void set(Object rootObject, Object value, JSONReader.Feature ... readerFeatures) {
            throw new JSONException("unsupported operation");
        }

        @Override
        public void setCallback(Object rootObject, BiFunction callback) {
            throw new JSONException("unsupported operation");
        }

        @Override
        public JSONPath getParent() {
            throw new JSONException("unsupported operation");
        }

        @Override
        public void setInt(Object rootObject, int value) {
            throw new JSONException("unsupported operation");
        }

        @Override
        public void setLong(Object rootObject, long value) {
            throw new JSONException("unsupported operation");
        }

        @Override
        public boolean remove(Object rootObject) {
            throw new JSONException("unsupported operation");
        }
    }

    static class Sequence {
        final List values;

        public Sequence(List values) {
            this.values = values;
        }
    }

    static final class Context {
        final JSONPath path;
        final Context parent;
        final JSONPathSegment current;
        final JSONPathSegment next;
        final long readerFeatures;
        Object root;
        Object value;
        boolean eval;

        Context(JSONPath path, Context parent, JSONPathSegment current, JSONPathSegment next, long readerFeatures) {
            this.path = path;
            this.current = current;
            this.next = next;
            this.parent = parent;
            this.readerFeatures = readerFeatures;
        }
    }
}

