/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.profiling.core.tests.stubs2;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.profiling.core.instrumented.EdgeStateValue;
import org.eclipse.tracecompass.analysis.profiling.core.instrumented.InstrumentedCallStackAnalysis;
import org.eclipse.tracecompass.analysis.profiling.core.tests.stubs2.CallStackProviderStub;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.tests.shared.utils.StateIntervalStub;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CallStackAnalysisStub
extends InstrumentedCallStackAnalysis {
    public static final String ID = "org.eclipse.tracecompass.analysis.profiling.core.tests.stub";

    protected @NonNull ITmfStateProvider createStateProvider() {
        ITmfTrace trace = this.getTrace();
        if (trace == null) {
            throw new IllegalArgumentException();
        }
        return new CallStackProviderStub(trace);
    }

    public List<String[]> getPatterns() {
        return super.getPatterns();
    }

    public List<ITmfStateInterval> getLinks(long start, long end, IProgressMonitor monitor) {
        ITmfTrace trace = Objects.requireNonNull(this.getTrace());
        String hostId = trace.getHostId();
        HostThread tid2 = new HostThread(hostId, Integer.valueOf(2));
        HostThread tid3 = new HostThread(hostId, Integer.valueOf(3));
        HostThread tid6 = new HostThread(hostId, Integer.valueOf(6));
        HostThread tid7 = new HostThread(hostId, Integer.valueOf(7));
        List<StateIntervalStub> intervals = List.of(new StateIntervalStub(1, 2, (ITmfStateValue)new EdgeStateValue(1, tid2, tid2)), new StateIntervalStub(4, 6, (ITmfStateValue)new EdgeStateValue(2, tid2, tid3)), new StateIntervalStub(5, 8, (ITmfStateValue)new EdgeStateValue(3, tid3, tid6)), new StateIntervalStub(5, 9, (ITmfStateValue)new EdgeStateValue(4, tid6, tid7)), new StateIntervalStub(9, 11, (ITmfStateValue)new EdgeStateValue(5, tid6, tid6)));
        return intervals.stream().filter(i -> i.getStartTime() >= start && i.getStartTime() <= end || i.getEndTime() >= start && i.getEndTime() <= end).collect(Collectors.toList());
    }
}

