/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.report.table;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.visualization.eval.IEvaluationResult;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.guideline.GuidelineSelectionChangedEvent;
import org.eclipse.actf.visualization.eval.guideline.IGuidelineData;
import org.eclipse.actf.visualization.eval.guideline.IGuidelineSlectionChangedListener;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetSourceInfo;
import org.eclipse.actf.visualization.eval.problem.IProblemConst;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.ui.report.ReportMessageDialog;
import org.eclipse.actf.visualization.internal.ui.report.action.ClearSelectionAction;
import org.eclipse.actf.visualization.internal.ui.report.action.CopyAction;
import org.eclipse.actf.visualization.internal.ui.report.action.GuidelineSubMenu;
import org.eclipse.actf.visualization.internal.ui.report.action.ShowDescriptionAction;
import org.eclipse.actf.visualization.internal.ui.report.action.SrcHighlightAction;
import org.eclipse.actf.visualization.internal.ui.report.action.TechniquesSubMenu;
import org.eclipse.actf.visualization.internal.ui.report.srcviewer.SrcViewerForPT;
import org.eclipse.actf.visualization.internal.ui.report.table.ResultTableFilter;
import org.eclipse.actf.visualization.ui.IVisualizationView;
import org.eclipse.actf.visualization.ui.report.table.IResultTableSorter;
import org.eclipse.actf.visualization.ui.report.table.ResultTableSorter;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ResultTableViewer
implements IGuidelineSlectionChangedListener {
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
    private int mode = 0;
    private Table table;
    private ViewerSorter tableSorter = new ResultTableSorter();
    private ResultTableFilter tableFilter;
    private TableViewer tableViewer;
    private SrcViewerForPT srcViewerForPT;
    private int curMode = -1;
    private File currentSoruceFile;
    private SrcHighlightAction srcHighlightAction;
    private boolean isShowAllGuidelineItems = false;
    private Shell shell;

    public ResultTableViewer(Composite composite) {
        this.shell = composite.getShell();
        this.tableViewer = new TableViewer(composite, 67586);
        this.table = this.tableViewer.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.srcViewerForPT = SrcViewerForPT.initSrcViewerForPT(composite.getShell());
        this.initColumns();
        this.changeColumnLayout();
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableFilter = new ResultTableFilter();
        this.tableViewer.addFilter((ViewerFilter)this.tableFilter);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new ClearSelectionAction(this.tableViewer));
        menuManager.add((IContributionItem)new GuidelineSubMenu(this));
        menuManager.add((IContributionItem)new TechniquesSubMenu(this));
        this.srcHighlightAction = new SrcHighlightAction(this);
        this.srcHighlightAction.setEnabled(false);
        menuManager.add((IAction)this.srcHighlightAction);
        menuManager.add((IAction)new CopyAction(this));
        menuManager.add((IAction)new ShowDescriptionAction(this.tableViewer));
        this.table.setMenu(menuManager.createContextMenu((Control)this.table));
        this.guidelineHolder.addGuidelineSelectionChangedListener((IGuidelineSlectionChangedListener)this);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ISelection iSelection = selectionChangedEvent.getSelection();
                if (ResultTableViewer.this.srcViewerForPT != null && iSelection instanceof IStructuredSelection) {
                    ArrayList<HighlightTargetSourceInfo> arrayList = new ArrayList<HighlightTargetSourceInfo>();
                    for (IProblemItem iProblemItem : (IStructuredSelection)iSelection) {
                        arrayList.addAll(Arrays.asList(iProblemItem.getHighlightTargetSoruceInfo()));
                    }
                    HighlightTargetSourceInfo[] highlightTargetSourceInfoArray = new HighlightTargetSourceInfo[arrayList.size()];
                    arrayList.toArray(highlightTargetSourceInfoArray);
                    ResultTableViewer.this.srcViewerForPT.highlightSrcViewer(highlightTargetSourceInfoArray, ResultTableViewer.this.getCurrentSoruceFile());
                }
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ISelection iSelection = doubleClickEvent.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    for (IProblemItem iProblemItem : (IStructuredSelection)iSelection) {
                        ReportMessageDialog.openReportMEssageDialog(ResultTableViewer.this.shell, iProblemItem);
                    }
                }
            }
        });
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    private void changeColumnLayout() {
        this.srcViewerForPT.setSrcChanged(true);
        switch (this.mode) {
            case 1: {
                this.initLVMode();
                break;
            }
            default: {
                this.initDefaultMode();
            }
        }
    }

    public void refresh() {
        this.tableViewer.refresh();
    }

    private void initColumns() {
        int n = 4 + this.guidelineHolder.getGuidelineData().length + this.guidelineHolder.getMetricsNames().length;
        int n2 = 10 + this.guidelineHolder.getGuidelineData().length;
        if (n2 > n) {
            n = n2;
        }
        int n3 = 0;
        while (n3 < n) {
            TableColumn tableColumn = new TableColumn(this.table, 16384);
            tableColumn.addSelectionListener((SelectionListener)new ColumnSelectionAdapter(n3));
            ++n3;
        }
    }

    private void initDefaultMode() {
        TableColumn[] tableColumnArray = this.table.getColumns();
        int n = 0;
        int n2 = 0;
        while (n2 < tableColumnArray.length) {
            tableColumnArray[n2].setImage(null);
            tableColumnArray[n2].setResizable(true);
            ++n2;
        }
        tableColumnArray[n].setText(IProblemConst.TITLE_HIGHLIGHT);
        tableColumnArray[n].setWidth(25);
        ++n;
        String[] stringArray = this.guidelineHolder.getLocalizedMetricsNames();
        boolean[] blArray = this.guidelineHolder.getMatchedMetrics();
        int n3 = 0;
        while (n3 < stringArray.length) {
            tableColumnArray[n].setText(stringArray[n3]);
            if (blArray[n3]) {
                tableColumnArray[n].setWidth(55);
            } else {
                tableColumnArray[n].setWidth(0);
                tableColumnArray[n].setResizable(false);
            }
            ++n;
            ++n3;
        }
        IGuidelineData[] iGuidelineDataArray = this.guidelineHolder.getGuidelineData();
        int n4 = 0;
        while (n4 < iGuidelineDataArray.length) {
            tableColumnArray[n].setText(iGuidelineDataArray[n4].getGuidelineName());
            if (iGuidelineDataArray[n4].isMatched()) {
                tableColumnArray[n].setWidth(80);
            } else {
                tableColumnArray[n].setWidth(0);
                tableColumnArray[n].setResizable(false);
            }
            ++n;
            ++n4;
        }
        tableColumnArray[n].setText(IProblemConst.TITLE_TECHNIQUS);
        tableColumnArray[n].setWidth(65);
        tableColumnArray[++n].setText(IProblemConst.TITLE_LINE);
        tableColumnArray[n].setWidth(60);
        tableColumnArray[++n].setText(IProblemConst.TITLE_DESCRIPTION);
        tableColumnArray[n].setWidth(1000);
        n4 = ++n;
        while (n4 < tableColumnArray.length) {
            tableColumnArray[n4].setWidth(0);
            tableColumnArray[n4].setResizable(false);
            ++n4;
        }
    }

    private void initLVMode() {
        TableColumn[] tableColumnArray = this.table.getColumns();
        int n = 0;
        int n2 = 0;
        while (n2 < tableColumnArray.length) {
            tableColumnArray[n2].setImage(null);
            tableColumnArray[n2].setResizable(true);
            ++n2;
        }
        tableColumnArray[n].setText(IProblemConst.TITLE_ICON);
        tableColumnArray[n].setWidth(45);
        ++n;
        IGuidelineData[] iGuidelineDataArray = this.guidelineHolder.getGuidelineData();
        int n3 = 0;
        while (n3 < iGuidelineDataArray.length) {
            tableColumnArray[n].setText(iGuidelineDataArray[n3].getGuidelineName());
            if (iGuidelineDataArray[n3].isMatched()) {
                tableColumnArray[n].setWidth(70);
            } else {
                tableColumnArray[n].setWidth(0);
                tableColumnArray[n].setResizable(false);
            }
            ++n;
            ++n3;
        }
        tableColumnArray[n].setText(IProblemConst.TITLE_SEVERITY);
        tableColumnArray[n].setWidth(55);
        tableColumnArray[++n].setText(IProblemConst.TITLE_FORECOLOR);
        tableColumnArray[n].setWidth(70);
        tableColumnArray[++n].setText(IProblemConst.TITLE_BACKCOLOR);
        tableColumnArray[n].setWidth(70);
        tableColumnArray[++n].setText(IProblemConst.TITLE_X);
        tableColumnArray[n].setWidth(50);
        tableColumnArray[++n].setText(IProblemConst.TITLE_Y);
        tableColumnArray[n].setWidth(50);
        tableColumnArray[++n].setText(IProblemConst.TITLE_AREA);
        tableColumnArray[n].setWidth(50);
        tableColumnArray[++n].setText(IProblemConst.TITLE_TECHNIQUS);
        tableColumnArray[n].setWidth(60);
        tableColumnArray[++n].setText(IProblemConst.TITLE_DESCRIPTION);
        tableColumnArray[n].setWidth(1000);
        n3 = ++n;
        while (n3 < tableColumnArray.length) {
            tableColumnArray[n3].setWidth(0);
            tableColumnArray[n3].setResizable(false);
            ++n3;
        }
    }

    public void changeFilterType(int n) {
        this.tableFilter.setSeverity(n);
        this.refresh();
    }

    public void selectionChanged(GuidelineSelectionChangedEvent guidelineSelectionChangedEvent) {
        this.changeColumnLayout();
        this.refresh();
    }

    public void setResult(IVisualizationView iVisualizationView, IEvaluationResult iEvaluationResult) {
        if (iVisualizationView != null) {
            this.mode = iVisualizationView.getResultTableMode();
            this.currentSoruceFile = iEvaluationResult.getSourceFile();
            this.isShowAllGuidelineItems = iEvaluationResult.isShowAllGuidelineItems();
            this.tableSorter = iVisualizationView.getTableSorter();
            if (this.curMode != iVisualizationView.getResultTableMode()) {
                this.tableViewer.setInput(new Vector());
                this.changeColumnLayout();
            }
            this.tableViewer.setLabelProvider(iVisualizationView.getLabelProvider());
            this.tableViewer.setSorter(this.tableSorter);
            this.tableViewer.setInput((Object)iEvaluationResult.getProblemList());
            this.srcViewerForPT.setSrcChanged(true);
            this.srcViewerForPT.updateSrcViewer(iEvaluationResult.getSourceFile());
            this.srcHighlightAction.setEnabled(iEvaluationResult.getSourceFile() != null);
        }
    }

    public File getCurrentSoruceFile() {
        return this.currentSoruceFile;
    }

    public boolean isShowAllGuidelineItems() {
        return this.isShowAllGuidelineItems;
    }

    public void setModelService(IModelService iModelService) {
    }

    private class ColumnSelectionAdapter
    extends SelectionAdapter {
        private int column;

        public ColumnSelectionAdapter(int n) {
            this.column = n;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            ResultTableViewer.this.tableViewer.setSelection(null);
            if (ResultTableViewer.this.tableSorter instanceof IResultTableSorter) {
                ((IResultTableSorter)ResultTableViewer.this.tableSorter).setCurColumn(this.column);
            }
            ResultTableViewer.this.tableViewer.refresh();
        }
    }
}

