/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.ChunkListener;

public class ChunkDecoder
extends FilterInputStream {
    static final Logger LOGGER = Logger.getLogger(ChunkDecoder.class);
    public static final char CR = '\r';
    public static final char LF = '\n';
    public static final char SP = ' ';
    public static final char HT = '\t';
    public static final int EOF = -1;
    private int fChunkSize = 0;
    private int fNumChunk = 0;
    private int fReadBytes = 0;
    private long fLastReadTime = 0L;
    private ChunkListener fChunkListener = null;

    public ChunkDecoder(InputStream inputStream) {
        super(inputStream);
    }

    public void setChunkListener(ChunkListener chunkListener) {
        if (this.fChunkListener != null && chunkListener != null) {
            throw new IllegalStateException("ChunkListener is already set: " + this.fChunkListener);
        }
        this.fChunkListener = chunkListener;
    }

    public int getChunkSize() {
        if (this.fReadBytes == 0) {
            throw new IllegalStateException("ChunkSize is unknown");
        }
        return this.fChunkSize;
    }

    /*
     * Unable to fully structure code
     */
    private int getAvailableInput(long var1_1) throws IOException, TimeoutException {
        while (true) {
            try {
                var3_2 = this.in.read();
            }
            catch (SocketTimeoutException v0) {
                if (var1_1 <= 0L) continue;
                if (this.fLastReadTime == 0L) {
                    this.fLastReadTime = System.currentTimeMillis();
                }
                if (System.currentTimeMillis() - this.fLastReadTime > var1_1) ** break;
                continue;
                this.fLastReadTime = System.currentTimeMillis();
                throw new TimeoutException("HTTPReader.getAvailableInput");
            }
            break;
        }
        this.fLastReadTime = System.currentTimeMillis();
        return var3_2;
    }

    private int getAvailableInput(long l, byte[] byArray, int n, int n2) throws IOException, TimeoutException {
        int n3;
        int n4;
        if (n2 <= 0) {
            return 0;
        }
        int n5 = 0;
        while ((n4 = this.in.available()) <= 0) {
            if (n4 < 0) {
                return -1;
            }
            try {
                n3 = this.in.read();
                byArray[n++] = (byte)n3;
                n5 = 1;
                --n2;
                n4 = this.in.available();
                break;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                if (l <= 0L) continue;
                if (this.fLastReadTime == 0L) {
                    this.fLastReadTime = System.currentTimeMillis();
                }
                if (System.currentTimeMillis() - this.fLastReadTime <= l) continue;
                this.fLastReadTime = System.currentTimeMillis();
                throw new TimeoutException();
            }
        }
        if (n4 == 0) {
            return n5;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        n3 = this.in.read(byArray, n, n2);
        this.fLastReadTime = System.currentTimeMillis();
        return n3 + n5;
    }

    private String readChunkSizeLine(long l) throws IOException, TimeoutException {
        int n = this.getAvailableInput(l);
        if (n == -1) {
            return null;
        }
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (n != -1) {
            switch (n) {
                case 13: {
                    bl = true;
                    break;
                }
                case 10: {
                    if (bl) {
                        bl2 = true;
                        break;
                    }
                }
                case 9: 
                case 32: 
                case 59: {
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                    stringBuffer.append((char)n);
                }
            }
            if (bl2) {
                if (stringBuffer.length() > 0) break;
                bl = false;
                bl2 = false;
            }
            n = this.getAvailableInput(l);
        }
        return stringBuffer.toString();
    }

    private void readChunkSize(long l) throws IOException, TimeoutException {
        String string = this.readChunkSizeLine(l);
        ++this.fNumChunk;
        if (string == null || string.length() == 0) {
            this.fChunkSize = -1;
        } else {
            string = string.trim();
            try {
                this.fChunkSize = Integer.parseInt(string, 16);
                if (this.fChunkListener != null) {
                    this.fChunkListener.newChankRead(this.fNumChunk, this.fChunkSize);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.fChunkSize = -1;
                throw new IOException("Invalid chunk size line: '" + string + "'");
            }
        }
    }

    public int read(long l) throws IOException, TimeoutException {
        if (this.fReadBytes == this.fChunkSize) {
            this.fReadBytes = 0;
            this.readChunkSize(l);
        }
        if (this.fChunkSize == -1 || this.fChunkSize == 0) {
            this.fChunkSize = -1;
            return -1;
        }
        int n = this.getAvailableInput(l);
        ++this.fReadBytes;
        return n;
    }

    public int read() throws IOException {
        try {
            return this.read(0L);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException("Impossible exception");
        }
    }

    public int read(long l, byte[] byArray, int n, int n2) throws IOException, TimeoutException {
        if (this.fReadBytes == this.fChunkSize) {
            this.fReadBytes = 0;
            this.readChunkSize(l);
        }
        if (this.fChunkSize == -1 || this.fChunkSize == 0) {
            this.fChunkSize = -1;
            return -1;
        }
        int n3 = this.fChunkSize - this.fReadBytes;
        if (n2 > n3) {
            n2 = n3;
        }
        int n4 = this.getAvailableInput(l, byArray, n, n2);
        this.fReadBytes += n4;
        return n4;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            return this.read(0L, byArray, n, n2);
        }
        catch (TimeoutException timeoutException) {
            throw new RuntimeException("Impossible exception");
        }
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int available() throws IOException {
        int n;
        int n2 = this.in.available();
        if (n2 <= 0) {
            return n2;
        }
        if (this.fReadBytes == this.fChunkSize) {
            this.fReadBytes = 0;
            try {
                this.readChunkSize(1L);
            }
            catch (TimeoutException timeoutException) {
                return 0;
            }
        }
        if (this.fChunkSize == -1 || this.fChunkSize == 0) {
            this.fChunkSize = -1;
            return 0;
        }
        n2 = this.in.available();
        return n2 < (n = this.fChunkSize - this.fReadBytes) ? n2 : n;
    }

    public long skip(long l) throws IOException {
        long l2 = 0L;
        while (l2 < l) {
            int n = this.read();
            if (n < 0) {
                return l2;
            }
            ++l2;
        }
        return l;
    }

    public synchronized void mark(int n) {
    }

    public synchronized void reset() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }
}

