/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.internal.service;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.diff.EMFCompareDiffMessages;
import org.eclipse.emf.compare.diff.metamodel.AbstractDiffExtension;

public class DiffExtensionDescriptor {
    protected final String diffextensionClassName;
    protected final IConfigurationElement element;
    protected final String fileExtension;
    private AbstractDiffExtension diffExtension;

    public DiffExtensionDescriptor(IConfigurationElement configuration) {
        this.element = configuration;
        this.fileExtension = this.getAttribute("fileExtension", "*");
        this.diffextensionClassName = this.getAttribute("extensionClass", null);
    }

    public String getdDiffExtensionClassName() {
        return this.diffextensionClassName;
    }

    public AbstractDiffExtension getDiffExtensionInstance() {
        if (this.diffExtension == null) {
            try {
                this.diffExtension = (AbstractDiffExtension)this.element.createExecutableExtension("extensionClass");
            }
            catch (CoreException e) {
                EMFComparePlugin.log((Exception)((Object)e), (boolean)false);
            }
        }
        return this.diffExtension;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    private String getAttribute(String name, String defaultValue) {
        String value = this.element.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException(EMFCompareDiffMessages.getString("Descriptor.MissingAttribute", name));
    }
}

