/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.io.File;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swtchart.extensions.barcharts.IBarSeriesSettings;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.MappedSeriesSettings;
import org.eclipse.swtchart.extensions.core.MappingsKey;
import org.eclipse.swtchart.extensions.core.MappingsListUI;
import org.eclipse.swtchart.extensions.core.MappingsSupport;
import org.eclipse.swtchart.extensions.core.MappingsType;
import org.eclipse.swtchart.extensions.core.Messages;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.core.SeriesMapper;
import org.eclipse.swtchart.extensions.dialogs.AbstractSeriesSettingsDialog;
import org.eclipse.swtchart.extensions.dialogs.BarSeriesSettingsDialog;
import org.eclipse.swtchart.extensions.dialogs.CircularSeriesSettingsDialog;
import org.eclipse.swtchart.extensions.dialogs.CreateSeriesMappingDialog;
import org.eclipse.swtchart.extensions.dialogs.LineSeriesSettingsDialog;
import org.eclipse.swtchart.extensions.dialogs.ScatterSeriesSettingsDialog;
import org.eclipse.swtchart.extensions.internal.mappings.MappingsIO;
import org.eclipse.swtchart.extensions.linecharts.ILineSeriesSettings;
import org.eclipse.swtchart.extensions.piecharts.ICircularSeriesSettings;
import org.eclipse.swtchart.extensions.scattercharts.IScatterSeriesSettings;

public class MappingsDialog
extends Dialog {
    private AtomicReference<MappingsListUI> listControl = new AtomicReference();
    private AtomicReference<Label> toolbarInfoControl = new AtomicReference();
    private IPreferenceStore preferenceStore = ResourceSupport.getPreferenceStore();

    public MappingsDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(MappedSeriesSettings.DESCRIPTION);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return new Point(600, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createToolbarMain(composite);
        this.createMappingsList(composite);
        this.createToolbarInfo(composite);
        this.updateInput();
        this.updateToolbarInfo("");
        return composite;
    }

    private void createMappingsList(Composite parent) {
        final MappingsListUI mappingsListUI = new MappingsListUI(parent, 68354);
        Table table = mappingsListUI.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object object = mappingsListUI.getStructuredSelection().getFirstElement();
                if (object instanceof MappedSeriesSettings) {
                    MappedSeriesSettings mappedSeriesSettings = (MappedSeriesSettings)object;
                    ISeriesSettings seriesSettings = mappedSeriesSettings.getSeriesSettings();
                    Shell shell = e.display.getActiveShell();
                    AbstractSeriesSettingsDialog settingsDialog = null;
                    if (seriesSettings instanceof IBarSeriesSettings) {
                        IBarSeriesSettings settings = (IBarSeriesSettings)seriesSettings;
                        settingsDialog = new BarSeriesSettingsDialog(shell, settings);
                    } else if (seriesSettings instanceof ICircularSeriesSettings) {
                        ICircularSeriesSettings settings = (ICircularSeriesSettings)seriesSettings;
                        settingsDialog = new CircularSeriesSettingsDialog(shell, settings);
                    } else if (seriesSettings instanceof ILineSeriesSettings) {
                        ILineSeriesSettings settings = (ILineSeriesSettings)seriesSettings;
                        settingsDialog = new LineSeriesSettingsDialog(shell, settings);
                    } else if (seriesSettings instanceof IScatterSeriesSettings) {
                        IScatterSeriesSettings settings = (IScatterSeriesSettings)seriesSettings;
                        settingsDialog = new ScatterSeriesSettingsDialog(shell, settings);
                    }
                    if (settingsDialog != null) {
                        settingsDialog.open();
                    }
                }
            }
        });
        this.listControl.set(mappingsListUI);
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(6, false));
        this.createButtonAdd(composite);
        this.createButtonDelete(composite);
        this.createButtonDeleteAll(composite);
        this.createButtonImport(composite);
        this.createButtonExport(composite);
        this.createButtonSave(composite);
    }

    private void createToolbarInfo(Composite parent) {
        Label label = new Label(parent, 0);
        label.setLayoutData((Object)new GridData(768));
        this.toolbarInfoControl.set(label);
    }

    private Button createButtonAdd(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText(Messages.getString("ADD_MAPPING"));
        button.setImage(ResourceSupport.getImage("add.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateSeriesMappingDialog dialog = new CreateSeriesMappingDialog(e.display.getActiveShell());
                if (dialog.open() == 0) {
                    MappingsType mappingsType = dialog.getMappingsType();
                    String id = dialog.getRegularExpression();
                    ISeriesSettings seriesSettings = MappingsSupport.createSeriesSettings(mappingsType);
                    if (seriesSettings != null) {
                        seriesSettings.setDescription(dialog.getDescription());
                        SeriesMapper.put(new MappingsKey(mappingsType, id), seriesSettings);
                        MappingsDialog.this.updateInput();
                        MappingsDialog.this.updateToolbarInfo(Messages.getString("NEW_MAPPING_ADDED"));
                    }
                }
            }
        });
        return button;
    }

    private Button createButtonDelete(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText(Messages.getString("DELETE_SELECTED_MAPPING"));
        button.setImage(ResourceSupport.getImage("delete.png"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(e.display.getActiveShell(), 196);
                messageBox.setText(MappedSeriesSettings.DESCRIPTION);
                messageBox.setMessage(Messages.getString("REALLY_DELETE_SELECTED_MAPPING"));
                int decision = messageBox.open();
                if (64 == decision) {
                    for (Object object : MappingsDialog.this.listControl.get().getStructuredSelection()) {
                        if (!(object instanceof MappedSeriesSettings)) continue;
                        MappedSeriesSettings mappedSeriesSettings = (MappedSeriesSettings)object;
                        MappingsKey mappingsKey = new MappingsKey(mappedSeriesSettings.getMappingsType(), mappedSeriesSettings.getIdentifier());
                        SeriesMapper.remove(mappingsKey);
                    }
                    MappingsDialog.this.updateInput();
                    MappingsDialog.this.updateToolbarInfo(Messages.getString("SELECTED_MAPPING_DELETED"));
                }
            }
        });
        return button;
    }

    private Button createButtonDeleteAll(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText(Messages.getString("DELETE_ALL_MAPPINGS"));
        button.setImage(ResourceSupport.getImage("deleteAll.png"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messageBox = new MessageBox(e.display.getActiveShell(), 196);
                messageBox.setText(MappedSeriesSettings.DESCRIPTION);
                messageBox.setMessage(Messages.getString("REALLY_DELETE_ALL_MAPPINGS"));
                int decision = messageBox.open();
                if (64 == decision) {
                    SeriesMapper.clear();
                    MappingsDialog.this.updateInput();
                    MappingsDialog.this.updateToolbarInfo(Messages.getString("ALL_MAPPINGS_DELETED"));
                }
            }
        });
        return button;
    }

    private Button createButtonImport(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText(Messages.getString("IMPORT"));
        button.setImage(ResourceSupport.getImage("import.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.display.getActiveShell(), 8);
                fileDialog.setText(MappedSeriesSettings.DESCRIPTION);
                fileDialog.setFilterExtensions(new String[]{"*.mss"});
                fileDialog.setFilterNames(new String[]{MappedSeriesSettings.FILTER_NAME});
                fileDialog.setFilterPath(MappingsDialog.this.preferenceStore.getString("pathMappingsImport"));
                String path = fileDialog.open();
                if (path != null) {
                    MappingsDialog.this.preferenceStore.setValue("pathMappingsImport", fileDialog.getFilterPath());
                    ResourceSupport.savePreferenceStore();
                    File file = new File(path);
                    Map<MappingsKey, ISeriesSettings> mappings = MappingsIO.importSettings(file);
                    for (Map.Entry<MappingsKey, ISeriesSettings> mapping : mappings.entrySet()) {
                        SeriesMapper.put(mapping.getKey(), mapping.getValue());
                    }
                    MappingsDialog.this.updateInput();
                    MappingsDialog.this.updateToolbarInfo(Messages.getString("MAPPINGS_IMPORTED"));
                }
            }
        });
        return button;
    }

    private Button createButtonExport(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText(Messages.getString("EXPORT"));
        button.setImage(ResourceSupport.getImage("export.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(e.display.getActiveShell(), 8192);
                fileDialog.setOverwrite(true);
                fileDialog.setText(MappedSeriesSettings.DESCRIPTION);
                fileDialog.setFilterExtensions(new String[]{"*.mss"});
                fileDialog.setFilterNames(new String[]{MappedSeriesSettings.FILTER_NAME});
                fileDialog.setFileName(MappedSeriesSettings.FILE_NAME);
                fileDialog.setFilterPath(MappingsDialog.this.preferenceStore.getString("pathMappingsExport"));
                String path = fileDialog.open();
                if (path != null) {
                    MappingsDialog.this.preferenceStore.setValue("pathMappingsExport", fileDialog.getFilterPath());
                    ResourceSupport.savePreferenceStore();
                    File file = new File(path);
                    MappingsIO.exportSettings(file, SeriesMapper.getMappings());
                    MappingsDialog.this.updateToolbarInfo(Messages.getString("MAPPINGS_EXPORTED"));
                }
            }
        });
        return button;
    }

    private Button createButtonSave(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText(Messages.getString("SAVE_MAPPINGS"));
        button.setImage(ResourceSupport.getImage("save.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MappingsIO.persistsSettings(SeriesMapper.getMappings());
                MappingsDialog.this.updateToolbarInfo(Messages.getString("MAPPINGS_SAVED"));
            }
        });
        return button;
    }

    private void updateToolbarInfo(String message) {
        this.toolbarInfoControl.get().setText(message);
    }

    private void updateInput() {
        this.listControl.get().setInput(SeriesMapper.getMappings());
    }
}

