/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.abstractviewers;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.linuxtools.dataviewers.STDataViewersActivator;
import org.eclipse.ui.PlatformUI;

public class STDataViewersImages {
    private static ImageRegistry imageRegistry;
    private static HashMap<String, ImageDescriptor> imageDescriptors;
    private static URL ICON_BASE_URL;
    public static final String IMG_EXPORT = "export.gif";
    public static final String IMG_EDIT_PROPERTIES = "prop_edt.gif";
    public static final String IMG_EXPANDALL = "expand_all.gif";
    public static final String IMG_COLLAPSEALL = "collapse_all.gif";
    public static final String IMG_SORT = "sort.gif";

    private static void declareImages() {
        STDataViewersImages.declareRegistryImage(IMG_EXPORT, IMG_EXPORT);
        STDataViewersImages.declareRegistryImage(IMG_EDIT_PROPERTIES, IMG_EDIT_PROPERTIES);
        STDataViewersImages.declareRegistryImage("IMG_OBJS_INFO_TSK", "info_obj.gif");
        STDataViewersImages.declareRegistryImage("IMG_TOOL_FORWARD", "forward_nav.gif");
        STDataViewersImages.declareRegistryImage("IMG_TOOL_BACK", "backward_nav.gif");
        STDataViewersImages.declareRegistryImage(IMG_EXPANDALL, IMG_EXPANDALL);
        STDataViewersImages.declareRegistryImage(IMG_COLLAPSEALL, IMG_COLLAPSEALL);
        STDataViewersImages.declareRegistryImage(IMG_SORT, IMG_SORT);
    }

    private static void declareRegistryImage(String key, URL path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        desc = ImageDescriptor.createFromURL((URL)path);
        imageRegistry.put(key, desc);
        imageDescriptors.put(key, desc);
    }

    private static void declareRegistryImage(String key, String path) {
        try {
            URL url = STDataViewersImages.makeIconFileURL(path);
            STDataViewersImages.declareRegistryImage(key, url);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public static ImageRegistry initializeImageRegistry() {
        imageDescriptors = new HashMap(30);
        STDataViewersImages.declareImages();
        return imageRegistry;
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        if (imageDescriptors == null) {
            STDataViewersImages.initializeImageRegistry();
        }
        return imageDescriptors.get(key);
    }

    private static URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        return new URL(ICON_BASE_URL, iconPath);
    }

    static {
        ICON_BASE_URL = null;
        String pathSuffix = "icons/";
        STDataViewersActivator activator = STDataViewersActivator.getDefault();
        ICON_BASE_URL = activator.getBundle().getEntry(pathSuffix);
        imageRegistry = activator.getImageRegistry();
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry(PlatformUI.getWorkbench().getDisplay());
        }
    }
}

