/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.resource.containers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.resource.containers.IAllContainersState;

public class FlatResourceSetBasedAllContainersState
extends AdapterImpl
implements IAllContainersState {
    private static final String HANDLE = "all";
    private ResourceSet resourceSet;

    public static String getHandle() {
        return HANDLE;
    }

    public FlatResourceSetBasedAllContainersState(ResourceSet rs) {
        this.resourceSet = rs;
    }

    public boolean equals(Object arg0) {
        if (arg0 == null || arg0.getClass() != this.getClass()) {
            return false;
        }
        FlatResourceSetBasedAllContainersState other = (FlatResourceSetBasedAllContainersState)arg0;
        return other.resourceSet == this.resourceSet;
    }

    @Override
    public Collection<URI> getContainedURIs(String containerHandle) {
        if (!HANDLE.equals(containerHandle)) {
            return Collections.emptySet();
        }
        if (this.resourceSet instanceof XtextResourceSet) {
            XtextResourceSet xtextResourceSet = (XtextResourceSet)this.resourceSet;
            return Lists.newArrayList(xtextResourceSet.getNormalizationMap().values());
        }
        ArrayList uris = Lists.newArrayListWithCapacity((int)this.resourceSet.getResources().size());
        URIConverter uriConverter = this.resourceSet.getURIConverter();
        for (Resource r : this.resourceSet.getResources()) {
            uris.add(uriConverter.normalize(r.getURI()));
        }
        return uris;
    }

    @Override
    public String getContainerHandle(URI uri) {
        return HANDLE;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    @Override
    public List<String> getVisibleContainerHandles(String handle) {
        return Collections.singletonList(HANDLE);
    }

    public int hashCode() {
        return this.resourceSet == null ? 0 : this.resourceSet.hashCode();
    }

    public boolean isAdapterForType(Object type) {
        return IAllContainersState.class == type || FlatResourceSetBasedAllContainersState.class == type;
    }

    @Override
    public boolean isEmpty(String containerHandle) {
        return !HANDLE.equals(containerHandle);
    }
}

