/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.xtext.formatting2.debug.TokenAccessToString;
import org.eclipse.xtext.formatting2.internal.AbstractTextSegment;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.internal.NodeHidden;

public class HiddenRegion
extends AbstractTextSegment
implements IHiddenRegion {
    List<NodeHidden> hiddens = Lists.newArrayList();
    private ISemanticRegion next;
    private ISemanticRegion previous;
    private final ITextRegionAccess tokenAccess;

    protected HiddenRegion(ITextRegionAccess tokenAccess) {
        this.tokenAccess = tokenAccess;
    }

    @Override
    public boolean containsComment() {
        for (IHiddenRegionPart iHiddenRegionPart : this.hiddens) {
            if (!(iHiddenRegionPart instanceof IComment)) continue;
            return true;
        }
        return false;
    }

    public int getLength() {
        if (this.hiddens.isEmpty()) {
            return 0;
        }
        int start = this.hiddens.get(0).getNode().getOffset();
        int end = this.hiddens.get(this.hiddens.size() - 1).getNode().getEndOffset();
        return end - start;
    }

    @Override
    public IHiddenRegion getNextHiddenRegion() {
        return this.next == null ? null : this.next.getNextHiddenRegion();
    }

    @Override
    public ISemanticRegion getNextSemanticRegion() {
        return this.next;
    }

    public int getOffset() {
        if (this.hiddens.isEmpty()) {
            if (this.previous != null) {
                return this.previous.getOffset() + this.previous.getLength();
            }
            return 0;
        }
        return this.hiddens.get(0).getOffset();
    }

    @Override
    public List<IHiddenRegionPart> getParts() {
        return ImmutableList.copyOf(this.hiddens);
    }

    @Override
    public IHiddenRegion getPreviousHiddenRegion() {
        return this.previous == null ? null : this.previous.getPreviousHiddenRegion();
    }

    @Override
    public ISemanticRegion getPreviousSemanticRegion() {
        return this.previous;
    }

    @Override
    public ITextRegionAccess getTextRegionAccess() {
        return this.tokenAccess;
    }

    @Override
    public boolean isUndefined() {
        return false;
    }

    protected void setNext(ISemanticRegion next) {
        this.next = next;
    }

    protected void setPrevious(ISemanticRegion previous) {
        this.previous = previous;
    }

    public String toString() {
        return new TokenAccessToString().withOrigin(this).hightlightOrigin().toString();
    }
}

