/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.mobile;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import javafx.scene.shape.Rectangle;
import org.eclipse.fx.ui.mobile.Card;
import org.eclipse.fx.ui.mobile.TransitionType;
import org.eclipse.fx.ui.mobile.animations.TransitionDelegate;

public class Deck
extends Region {
    private ObservableList<Card> cards = FXCollections.observableArrayList();
    private BorderPane contenArea = new BorderPane();

    public Deck() {
        this.getChildren().add((Object)this.contenArea);
        this.cards.addListener(new InvalidationListener(){

            public void invalidated(Observable observable) {
                Deck.this.contenArea.setCenter((Node)Deck.this.cards.get(0));
                Deck.this.cards.removeListener((InvalidationListener)this);
            }
        });
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.contenArea.resizeRelocate(this.getInsets().getLeft(), this.getInsets().getTop(), this.getWidth() - this.getInsets().getLeft(), this.getHeight() - this.getInsets().getTop());
        this.contenArea.setClip((Node)new Rectangle(this.getWidth() - this.getInsets().getLeft(), this.getHeight() - this.getInsets().getTop()));
    }

    public ObservableList<Card> getCards() {
        return this.cards;
    }

    public void moveTo(String name, TransitionType animation) {
        this.moveTo(name, animation.getDelegate());
    }

    public void moveTo(String name, TransitionDelegate delegate) {
        for (Card c : this.cards) {
            if (!name.equals(c.getName())) continue;
            if (this.contenArea.getCenter() == c) break;
            if (delegate != null) {
                delegate.transitionTo(this.contenArea, (Card)this.contenArea.getCenter(), c);
                break;
            }
            this.contenArea.setCenter((Node)c);
            break;
        }
    }
}

