/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.shoal.ha.cache.interceptor;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.shoal.ha.cache.api.DataStoreAlreadyClosedException;
import org.glassfish.shoal.ha.cache.api.DataStoreContext;
import org.glassfish.shoal.ha.cache.api.DataStoreException;
import org.glassfish.shoal.ha.cache.command.Command;
import org.glassfish.shoal.ha.cache.interceptor.CommandCollector;
import org.glassfish.shoal.ha.cache.interceptor.ReplicationFramePayloadCommand;
import org.glassfish.shoal.ha.cache.store.backing.commands.NoOpCommand;
import org.glassfish.shoal.ha.cache.util.ASyncReplicationManager;

public class ReplicationCommandTransmitterWithList<K, V>
implements Runnable,
CommandCollector<K, V> {
    private static final Logger _logger = Logger.getLogger("org.glassfish.shoal.ha.cache.interceptor.transmit");
    private DataStoreContext<K, V> dsc;
    private volatile String targetName;
    private ScheduledFuture future;
    private static final String TRANSMITTER_FREQUECNCY_PROP_NAME = "org.glassfish.shoal.cache.transmitter.frequency.in.millis";
    private static final String MAX_BATCH_SIZE_PROP_NAME = "org.glassfish.shoal.cache.transmitter.max.batch.size";
    private static int TRANSMITTER_FREQUECNCY_IN_MILLIS = 100;
    private int MAX_BATCH_SIZE = 20;
    private AtomicReference<BatchedCommandListDataFrame> mapRef;
    ASyncReplicationManager asyncReplicationManager = ASyncReplicationManager._getInstance();
    private volatile long timeStamp = System.currentTimeMillis();
    ThreadPoolExecutor executor;
    private AtomicBoolean openStatus = new AtomicBoolean(true);
    private AtomicInteger activeBatchCount = new AtomicInteger(1);
    private CountDownLatch latch = new CountDownLatch(1);

    @Override
    public void initialize(String targetName, DataStoreContext<K, V> rsInfo) {
        this.executor = ASyncReplicationManager._getInstance().getExecutorService();
        this.targetName = targetName;
        this.dsc = rsInfo;
        try {
            TRANSMITTER_FREQUECNCY_IN_MILLIS = Integer.getInteger(System.getProperty(TRANSMITTER_FREQUECNCY_PROP_NAME, "" + TRANSMITTER_FREQUECNCY_IN_MILLIS));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.MAX_BATCH_SIZE = Integer.getInteger(System.getProperty(MAX_BATCH_SIZE_PROP_NAME, "" + this.MAX_BATCH_SIZE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        BatchedCommandListDataFrame batch = new BatchedCommandListDataFrame(this.openStatus.get());
        this.mapRef = new AtomicReference<BatchedCommandListDataFrame>(batch);
        this.future = this.asyncReplicationManager.getScheduledThreadPoolExecutor().scheduleAtFixedRate(this, TRANSMITTER_FREQUECNCY_IN_MILLIS, TRANSMITTER_FREQUECNCY_IN_MILLIS, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        try {
            if (this.openStatus.compareAndSet(true, false)) {
                this.future.cancel(false);
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "(ReplicationCommandTransmitterWithList) BEGIN Flushing all batched data upon shutdown..." + this.activeBatchCount.get() + " to be flushed...");
                }
                BatchedCommandListDataFrame closedBatch = new BatchedCommandListDataFrame(false);
                BatchedCommandListDataFrame batch = this.mapRef.getAndSet(closedBatch);
                this.asyncReplicationManager.getExecutorService().submit(batch);
                this.dsc.getDataStoreMBean().incrementBatchSentCount();
                for (int loopCount = 0; loopCount < 5; ++loopCount) {
                    if (this.activeBatchCount.get() <= 0) continue;
                    try {
                        this.latch.await(5L, TimeUnit.SECONDS);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "(ReplicationCommandTransmitterWithList) DONE Flushing all batched data upon shutdown...");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void addCommand(Command<K, V> cmd) throws DataStoreException {
        boolean done = false;
        while (!done) {
            BatchedCommandListDataFrame batch = this.mapRef.get();
            done = batch.addCommand(cmd);
            if (done) continue;
            BatchedCommandListDataFrame frame = new BatchedCommandListDataFrame(this.openStatus.get());
            frame.addCommand(cmd);
            done = this.mapRef.compareAndSet(batch, frame);
            if (!done || !frame.isValidBatch()) continue;
            this.activeBatchCount.incrementAndGet();
        }
    }

    @Override
    public void removeCommand(Command<K, V> cmd) throws DataStoreException {
        this.addCommand(cmd);
    }

    @Override
    public void run() {
        try {
            this.dsc.acquireReadLock();
            BatchedCommandListDataFrame batch = this.mapRef.get();
            if (batch.isTimeToFlush(this.timeStamp) || !this.openStatus.get()) {
                NoOpCommand noop = new NoOpCommand();
                while (batch.addCommand(noop)) {
                }
            }
            this.timeStamp = batch.getBatchCreationTime();
        }
        catch (DataStoreAlreadyClosedException batch) {
        }
        catch (DataStoreException dsEx) {
            _logger.log(Level.WARNING, "Error during flush...");
        }
        finally {
            this.dsc.releaseReadLock();
        }
    }

    private class BatchedCommandListDataFrame
    implements Runnable {
        private AtomicInteger current = new AtomicInteger(-1);
        private ConcurrentLinkedQueue<Command> list = new ConcurrentLinkedQueue();
        private long batchCreationTime = System.currentTimeMillis();
        private boolean validBatch;

        BatchedCommandListDataFrame(boolean valid) {
            this.validBatch = valid;
        }

        private boolean isValidBatch() {
            return this.validBatch;
        }

        public boolean addCommand(Command cmd) throws DataStoreException {
            if (!this.validBatch) {
                throw new DataStoreAlreadyClosedException("Cannot add a command to a Batch after the DataStore has been closed");
            }
            int value = this.current.incrementAndGet();
            if (value < ReplicationCommandTransmitterWithList.this.MAX_BATCH_SIZE) {
                this.list.add(cmd);
                if (this.list.size() == ReplicationCommandTransmitterWithList.this.MAX_BATCH_SIZE) {
                    ReplicationCommandTransmitterWithList.this.asyncReplicationManager.getExecutorService().submit(this);
                }
            }
            return value < ReplicationCommandTransmitterWithList.this.MAX_BATCH_SIZE;
        }

        boolean isTimeToFlush(long timeStamp) {
            return this.batchCreationTime == timeStamp && this.list.size() > 0;
        }

        long getBatchCreationTime() {
            return this.batchCreationTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ReplicationFramePayloadCommand rfCmd = new ReplicationFramePayloadCommand();
            rfCmd.setTargetInstance(ReplicationCommandTransmitterWithList.this.targetName);
            try {
                int size = this.list.size();
                for (int i = 0; i < size; ++i) {
                    Command cmd = this.list.poll();
                    if (cmd.getOpcode() == 102) continue;
                    rfCmd.addComamnd(cmd);
                }
                ReplicationCommandTransmitterWithList.this.dsc.getCommandManager().execute(rfCmd);
            }
            catch (IOException ioEx) {
                _logger.log(Level.WARNING, "Batch operation (ASyncCommandList failed...", ioEx);
            }
            finally {
                if (this.validBatch && ReplicationCommandTransmitterWithList.this.activeBatchCount.decrementAndGet() <= 0 && !ReplicationCommandTransmitterWithList.this.openStatus.get()) {
                    ReplicationCommandTransmitterWithList.this.latch.countDown();
                }
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "(ReplicationCommandTransmitterWithList) Completed one batch. Still " + ReplicationCommandTransmitterWithList.this.activeBatchCount.get() + " to be flushed...");
                }
            }
        }
    }
}

