/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CloseListener;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.GenericCloseListener;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.http.Cookie;
import org.glassfish.grizzly.http.Cookies;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.io.InputBuffer;
import org.glassfish.grizzly.http.io.NIOOutputStream;
import org.glassfish.grizzly.http.io.NIOWriter;
import org.glassfish.grizzly.http.io.OutputBuffer;
import org.glassfish.grizzly.http.server.ErrorPageGenerator;
import org.glassfish.grizzly.http.server.HttpServerFilter;
import org.glassfish.grizzly.http.server.HttpServerProbeNotifier;
import org.glassfish.grizzly.http.server.NIOOutputStreamImpl;
import org.glassfish.grizzly.http.server.NIOWriterImpl;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Session;
import org.glassfish.grizzly.http.server.SuspendContext;
import org.glassfish.grizzly.http.server.SuspendStatus;
import org.glassfish.grizzly.http.server.TimeoutHandler;
import org.glassfish.grizzly.http.server.io.ServerOutputBuffer;
import org.glassfish.grizzly.http.server.util.HtmlHelper;
import org.glassfish.grizzly.http.util.CharChunk;
import org.glassfish.grizzly.http.util.Constants;
import org.glassfish.grizzly.http.util.ContentType;
import org.glassfish.grizzly.http.util.CookieSerializerUtils;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HeaderValue;
import org.glassfish.grizzly.http.util.HttpDateFormat;
import org.glassfish.grizzly.http.util.HttpRequestURIDecoder;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.http.util.UEncoder;
import org.glassfish.grizzly.localization.LogMessages;
import org.glassfish.grizzly.utils.DelayedExecutor;

public class Response {
    private static final Logger LOGGER = Grizzly.logger(Response.class);
    private boolean cacheEnabled = false;
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();
    private static final String HTTP_RESPONSE_DATE_HEADER = "EEE, dd MMM yyyy HH:mm:ss zzz";
    protected DateTimeFormatter format = null;
    protected static final String info = "org.glassfish.grizzly.http.server.Response/2.0";
    protected Request request = null;
    protected HttpResponsePacket response;
    protected FilterChainContext ctx;
    protected HttpContext httpContext;
    protected final ServerOutputBuffer outputBuffer = new ServerOutputBuffer();
    private final NIOOutputStreamImpl outputStream = new NIOOutputStreamImpl();
    private final NIOWriterImpl writer = new NIOWriterImpl();
    protected boolean appCommitted = false;
    protected boolean error = false;
    protected boolean usingOutputStream = false;
    protected boolean usingWriter = false;
    protected final UEncoder urlEncoder = new UEncoder();
    protected final CharChunk redirectURLCC = new CharChunk();
    protected DelayedExecutor.DelayQueue<SuspendTimeout> delayQueue;
    SuspendState suspendState = SuspendState.NONE;
    private final SuspendedContextImpl suspendedContext = new SuspendedContextImpl();
    private SuspendStatus suspendStatus;
    private boolean sendFileEnabled;
    private ErrorPageGenerator errorPageGenerator;

    static DelayedExecutor.DelayQueue<SuspendTimeout> createDelayQueue(DelayedExecutor delayedExecutor) {
        return delayedExecutor.createDelayQueue(new DelayQueueWorker(), new DelayQueueResolver());
    }

    protected Response() {
        this.urlEncoder.addSafeCharacter('/');
    }

    public void initialize(Request request, HttpResponsePacket response, FilterChainContext ctx, DelayedExecutor.DelayQueue<SuspendTimeout> delayQueue, HttpServerFilter serverFilter) {
        this.request = request;
        this.response = response;
        this.sendFileEnabled = serverFilter != null && serverFilter.getConfiguration().isSendFileEnabled();
        this.outputBuffer.initialize(this, ctx);
        this.ctx = ctx;
        this.httpContext = HttpContext.get(ctx);
        this.delayQueue = delayQueue;
    }

    SuspendStatus initSuspendStatus() {
        this.suspendStatus = SuspendStatus.create();
        return this.suspendStatus;
    }

    public Request getRequest() {
        return this.request;
    }

    public HttpResponsePacket getResponse() {
        return this.response;
    }

    protected void recycle() {
        this.delayQueue = null;
        this.outputBuffer.recycle();
        this.outputStream.recycle();
        this.writer.recycle();
        this.usingOutputStream = false;
        this.usingWriter = false;
        this.appCommitted = false;
        this.error = false;
        this.errorPageGenerator = null;
        this.request = null;
        this.response.recycle();
        this.sendFileEnabled = false;
        this.response = null;
        this.ctx = null;
        this.suspendState = SuspendState.NONE;
        this.cacheEnabled = false;
    }

    public void setTrailers(Supplier<Map<String, String>> trailerSupplier) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response has already been committed.");
        }
        Protocol protocol = this.request.getProtocol();
        if (protocol.equals((Object)Protocol.HTTP_0_9) || protocol.equals((Object)Protocol.HTTP_1_0)) {
            throw new IllegalStateException("Trailers not supported by response protocol version " + String.valueOf((Object)protocol));
        }
        if (protocol.equals((Object)Protocol.HTTP_1_1)) {
            if (!this.response.isChunkingAllowed()) {
                throw new IllegalStateException("Chunked transfer-encoding disabled.");
            }
            this.response.setChunked(true);
        }
        this.outputBuffer.setTrailers(trailerSupplier);
    }

    public Supplier<Map<String, String>> getTrailers() {
        return this.outputBuffer.getTrailers();
    }

    public String encodeURL(String url) {
        String absolute = this.toAbsolute(url, false);
        if (this.isEncodeable(absolute)) {
            if (url.equalsIgnoreCase("")) {
                url = absolute;
            }
            return this.toEncoded(url, this.request.getSession().getIdInternal());
        }
        return url;
    }

    public String encodeRedirectURL(String url) {
        if (this.isEncodeable(this.toAbsolute(url, false))) {
            return this.toEncoded(url, this.request.getSession().getIdInternal());
        }
        return url;
    }

    protected boolean isEncodeable(String location) {
        if (location == null) {
            return false;
        }
        if (location.startsWith("#")) {
            return false;
        }
        Session session = this.request.getSession(false);
        return session != null && !this.request.isRequestedSessionIdFromCookie() && Response.doIsEncodeable(this.request, session, location);
    }

    private static boolean doIsEncodeable(Request request, Session session, String location) {
        int urlPort;
        URL url;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException e) {
            return false;
        }
        if (!request.getScheme().equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        if (!request.getServerName().equalsIgnoreCase(url.getHost())) {
            return false;
        }
        int serverPort = request.getServerPort();
        if (serverPort == -1) {
            serverPort = "https".equals(request.getScheme()) ? 443 : 80;
        }
        if ((urlPort = url.getPort()) == -1) {
            urlPort = "https".equals(url.getProtocol()) ? 443 : 80;
        }
        if (serverPort != urlPort) {
            return false;
        }
        String contextPath = "/";
        String file = url.getFile();
        if (file == null || !file.startsWith(contextPath)) {
            return false;
        }
        return !file.contains(";jsessionid=" + session.getIdInternal());
    }

    public String getInfo() {
        return info;
    }

    public void setError() {
        this.error = true;
    }

    public boolean isError() {
        return this.error;
    }

    public ErrorPageGenerator getErrorPageGenerator() {
        return this.errorPageGenerator;
    }

    public void setErrorPageGenerator(ErrorPageGenerator errorPageGenerator) {
        this.errorPageGenerator = errorPageGenerator;
    }

    public void setDetailMessage(String message) {
        this.checkResponse();
        this.response.setReasonPhrase(message);
    }

    public String getDetailMessage() {
        this.checkResponse();
        return this.response.getReasonPhrase();
    }

    public void finish() {
        block4: {
            try {
                this.outputBuffer.endRequest();
            }
            catch (IOException e) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, LogMessages.WARNING_GRIZZLY_HTTP_SERVER_RESPONSE_FINISH_ERROR(), e);
                }
            }
            catch (Throwable t) {
                if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                LOGGER.log(Level.WARNING, LogMessages.WARNING_GRIZZLY_HTTP_SERVER_RESPONSE_FINISH_ERROR(), t);
            }
        }
    }

    public int getContentLength() {
        this.checkResponse();
        return (int)this.response.getContentLength();
    }

    public long getContentLengthLong() {
        this.checkResponse();
        return this.response.getContentLength();
    }

    public String getContentType() {
        this.checkResponse();
        return this.response.getContentType();
    }

    public int getBufferSize() {
        return this.outputBuffer.getBufferSize();
    }

    public String getCharacterEncoding() {
        this.checkResponse();
        String characterEncoding = this.response.getCharacterEncoding();
        if (characterEncoding == null) {
            return Constants.DEFAULT_HTTP_CHARACTER_ENCODING;
        }
        return characterEncoding;
    }

    public void setCharacterEncoding(String charset) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.response.setCharacterEncoding(charset);
    }

    public NIOOutputStream createOutputStream() {
        this.outputStream.setOutputBuffer(this.outputBuffer);
        return this.outputStream;
    }

    public NIOOutputStream getNIOOutputStream() {
        if (this.usingWriter) {
            throw new IllegalStateException("Illegal attempt to call getOutputStream() after getWriter() has already been called.");
        }
        this.usingOutputStream = true;
        this.outputStream.setOutputBuffer(this.outputBuffer);
        return this.outputStream;
    }

    public OutputStream getOutputStream() {
        return this.getNIOOutputStream();
    }

    public Locale getLocale() {
        this.checkResponse();
        Locale locale = this.response.getLocale();
        if (locale == null) {
            locale = DEFAULT_LOCALE;
            this.response.setLocale(locale);
        }
        return locale;
    }

    public Writer getWriter() {
        return this.getNIOWriter();
    }

    public NIOWriter getNIOWriter() {
        if (this.usingOutputStream) {
            throw new IllegalStateException("Illegal attempt to call getWriter() after getOutputStream() has already been called.");
        }
        this.setCharacterEncoding(this.getCharacterEncoding());
        this.usingWriter = true;
        this.outputBuffer.prepareCharacterEncoder();
        this.writer.setOutputBuffer(this.outputBuffer);
        return this.writer;
    }

    public boolean isCommitted() {
        this.checkResponse();
        return this.response.isCommitted();
    }

    public void flush() throws IOException {
        this.outputBuffer.flush();
    }

    public OutputBuffer getOutputBuffer() {
        return this.outputBuffer;
    }

    public void reset() {
        this.checkResponse();
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.getHeaders().clear();
        this.response.setContentLanguage(null);
        if (this.response.getContentLength() > 0L) {
            this.response.setContentLengthLong(-1L);
        }
        this.response.setCharacterEncoding(null);
        this.response.setStatus(null);
        this.response.setContentType((String)null);
        this.response.setLocale(null);
        this.outputBuffer.reset();
        this.usingWriter = false;
        this.usingOutputStream = false;
    }

    public void resetBuffer() {
        this.resetBuffer(false);
    }

    public void resetBuffer(boolean resetWriterStreamFlags) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Cannot reset buffer after response has been committed.");
        }
        this.outputBuffer.reset();
        if (resetWriterStreamFlags) {
            this.usingOutputStream = false;
            this.usingWriter = false;
        }
    }

    public void setBufferSize(int size) {
        if (this.isCommitted()) {
            throw new IllegalStateException("Unable to change buffer size as the response has been committed");
        }
        this.outputBuffer.setBufferSize(size);
    }

    public void setContentLengthLong(long length) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (this.usingWriter) {
            return;
        }
        this.response.setContentLengthLong(length);
    }

    public void setContentLength(int length) {
        this.setContentLengthLong(length);
    }

    public void setContentType(String type) {
        int index;
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (this.usingWriter && type != null && (index = type.indexOf(";")) != -1) {
            type = type.substring(0, index);
        }
        this.response.setContentType(type);
    }

    public void setContentType(ContentType type) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        if (type == null) {
            this.response.setContentType((String)null);
            return;
        }
        if (!this.usingWriter) {
            this.response.setContentType(type);
        } else {
            this.response.setContentType(type.getMimeType());
        }
    }

    public void setLocale(Locale locale) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        this.response.setLocale(locale);
    }

    public Cookie[] getCookies() {
        Cookies cookies = new Cookies();
        cookies.setHeaders(this.response.getHeaders(), false);
        return cookies.get();
    }

    public String getHeader(String name) {
        this.checkResponse();
        return this.response.getHeader(name);
    }

    public String[] getHeaderNames() {
        this.checkResponse();
        MimeHeaders headers = this.response.getHeaders();
        int n = headers.size();
        String[] result = new String[n];
        for (int i = 0; i < n; ++i) {
            result[i] = headers.getName(i).toString();
        }
        return result;
    }

    public String[] getHeaderValues(String name) {
        this.checkResponse();
        LinkedList<String> result = new LinkedList<String>();
        for (String headerValue : this.response.getHeaders().values(name)) {
            result.add(headerValue);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getMessage() {
        this.checkResponse();
        return this.response.getReasonPhrase();
    }

    public int getStatus() {
        this.checkResponse();
        return this.response.getStatus();
    }

    public void reset(int status, String message) {
        this.reset();
        this.setStatus(status, message);
    }

    public void addCookie(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        CookieSerializerUtils.serializeServerCookie(sb, cookie);
        this.addHeader(Header.SetCookie, sb.toString());
    }

    protected void addSessionCookieInternal(Cookie cookie) {
        if (this.isCommitted()) {
            return;
        }
        String name = cookie.getName();
        String headername = Header.SetCookie.toString();
        String startsWith = name + "=";
        StringBuilder sb = new StringBuilder();
        CookieSerializerUtils.serializeServerCookie(sb, cookie);
        String cookieString = sb.toString();
        boolean set = false;
        MimeHeaders headers = this.response.getHeaders();
        int n = headers.size();
        for (int i = 0; i < n; ++i) {
            if (!headers.getName(i).toString().equals(headername) || !headers.getValue(i).toString().startsWith(startsWith)) continue;
            headers.getValue(i).setString(cookieString);
            set = true;
        }
        if (!set) {
            this.addHeader(headername, cookieString);
        }
    }

    protected void removeSessionCookies() {
        String sessionCookieName = this.request.getSessionCookieName();
        Object pattern = sessionCookieName != null ? "^" + sessionCookieName + "(?:SSO)?=.*" : "^JSESSIONID(?:SSO)?=.*";
        this.response.getHeaders().removeHeaderMatches(Header.SetCookie, (String)pattern);
    }

    public void addDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.format == null) {
            this.format = DateTimeFormatter.ofPattern(HTTP_RESPONSE_DATE_HEADER, Locale.US).withZone(ZoneId.of("GMT"));
        }
        this.addHeader(name, HttpDateFormat.formatDate(value, this.format));
    }

    public void addDateHeader(Header header, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.format == null) {
            this.format = DateTimeFormatter.ofPattern(HTTP_RESPONSE_DATE_HEADER, Locale.US).withZone(ZoneId.of("GMT"));
        }
        this.addHeader(header, HttpDateFormat.formatDate(value, this.format));
    }

    public void addHeader(String name, String value) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        this.response.addHeader(name, value);
    }

    public void addHeader(String name, HeaderValue value) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        this.response.addHeader(name, value);
    }

    public void addHeader(Header header, String value) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        this.response.addHeader(header, value);
    }

    public void addHeader(Header header, HeaderValue value) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        this.response.addHeader(header, value);
    }

    public void addIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.addHeader(name, "" + value);
    }

    public void addIntHeader(Header header, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.addHeader(header, Integer.toString(value));
    }

    public boolean containsHeader(String name) {
        this.checkResponse();
        return this.response.containsHeader(name);
    }

    public boolean containsHeader(Header header) {
        this.checkResponse();
        return this.response.containsHeader(header);
    }

    public void sendAcknowledgement() throws IOException {
        if (this.isCommitted() || !this.request.requiresAcknowledgement()) {
            return;
        }
        this.response.setAcknowledgement(true);
        this.outputBuffer.acknowledge();
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        this.checkResponse();
        if (this.isCommitted()) {
            throw new IllegalStateException("Illegal attempt to call sendError() after the response has been committed.");
        }
        this.setError();
        this.response.getHeaders().removeHeader(Header.TransferEncoding);
        this.response.setContentLanguage(null);
        this.response.setContentLengthLong(-1L);
        this.response.setChunked(false);
        this.response.setCharacterEncoding(null);
        this.response.setContentType((String)null);
        this.response.setLocale(null);
        this.outputBuffer.reset();
        this.usingWriter = false;
        this.usingOutputStream = false;
        this.setStatus(status, message);
        String nonNullMsg = message;
        if (nonNullMsg == null) {
            HttpStatus httpStatus = HttpStatus.getHttpStatus(status);
            nonNullMsg = httpStatus != null && httpStatus.getReasonPhrase() != null ? httpStatus.getReasonPhrase() : "Unknown Error";
        }
        HtmlHelper.sendErrorPage(this.request, this, this.getErrorPageGenerator(), status, nonNullMsg, nonNullMsg, null);
        this.finish();
    }

    public void sendRedirect(String location) throws IOException {
        this.sendRedirect(location, 302, this.appCommitted);
    }

    public void sendRedirect(String location, int sc, boolean clearBuffer) throws IOException {
        if (this.isCommitted()) {
            throw new IllegalStateException("Illegal attempt to redirect the response as the response has been committed.");
        }
        this.resetBuffer();
        try {
            String absolute = this.toAbsolute(location, true);
            this.setStatus(HttpStatus.getHttpStatus(sc));
            this.setHeader(Header.Location, absolute);
            this.setContentType("text/html");
            this.setLocale(Locale.getDefault());
            String filteredMsg = Response.filter(absolute);
            StringBuilder sb = new StringBuilder(150 + absolute.length());
            sb.append("<html>\r\n");
            sb.append("<head><title>Document moved</title></head>\r\n");
            sb.append("<body><h1>Document moved</h1>\r\n");
            sb.append("This document has moved <a href=\"");
            sb.append(filteredMsg);
            sb.append("\">here</a>.<p>\r\n");
            sb.append("</body>\r\n");
            sb.append("</html>\r\n");
            try {
                this.getWriter().write(sb.toString());
                this.getWriter().flush();
            }
            catch (IllegalStateException ise1) {
                try {
                    this.getOutputStream().write(sb.toString().getBytes(Constants.DEFAULT_HTTP_CHARSET));
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }
        catch (IllegalArgumentException e) {
            this.sendError(404);
        }
        this.finish();
    }

    public void setDateHeader(String name, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.format == null) {
            this.format = DateTimeFormatter.ofPattern(HTTP_RESPONSE_DATE_HEADER, Locale.US).withZone(ZoneId.of("GMT"));
        }
        this.setHeader(name, HttpDateFormat.formatDate(value, this.format));
    }

    public void setDateHeader(Header header, long value) {
        if (this.isCommitted()) {
            return;
        }
        if (this.format == null) {
            this.format = DateTimeFormatter.ofPattern(HTTP_RESPONSE_DATE_HEADER, Locale.US).withZone(ZoneId.of("GMT"));
        }
        this.setHeader(header, HttpDateFormat.formatDate(value, this.format));
    }

    public void setHeader(String name, String value) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        this.response.setHeader(name, value);
    }

    public void setHeader(String name, HeaderValue value) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        this.response.setHeader(name, value);
    }

    public void setHeader(Header header, String value) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        this.response.setHeader(header, value);
    }

    public void setHeader(Header header, HeaderValue value) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        this.response.setHeader(header, value);
    }

    public void setIntHeader(String name, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.setHeader(name, "" + value);
    }

    public void setIntHeader(Header header, int value) {
        if (this.isCommitted()) {
            return;
        }
        this.setHeader(header, Integer.toString(value));
    }

    public void setStatus(int status) {
        this.setStatus(status, null);
    }

    public void setStatus(int status, String message) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        this.response.setStatus(status);
        this.response.setReasonPhrase(message);
    }

    public void setStatus(HttpStatus status) {
        this.checkResponse();
        if (this.isCommitted()) {
            return;
        }
        status.setValues(this.response);
    }

    protected String toAbsolute(String location, boolean normalize) {
        if (location == null) {
            return null;
        }
        boolean leadingSlash = location.startsWith("/");
        if (leadingSlash || !location.contains("://")) {
            String scheme = this.request.getScheme();
            String name = this.request.getServerName();
            int port = this.request.getServerPort();
            this.redirectURLCC.recycle();
            CharChunk cc = this.redirectURLCC;
            try {
                cc.append(scheme, 0, scheme.length());
                cc.append("://", 0, 3);
                cc.append(name, 0, name.length());
                if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
                    cc.append(':');
                    String portS = "" + port;
                    cc.append(portS, 0, portS.length());
                }
                if (!leadingSlash) {
                    String relativePath = this.request.getDecodedRequestURI();
                    int pos = relativePath.lastIndexOf(47);
                    relativePath = relativePath.substring(0, pos);
                    String encodedURI = this.urlEncoder.encodeURL(relativePath);
                    cc.append(encodedURI, 0, encodedURI.length());
                    cc.append('/');
                }
                cc.append(location, 0, location.length());
            }
            catch (IOException e) {
                throw new IllegalArgumentException(location, e);
            }
            if (normalize) {
                HttpRequestURIDecoder.normalizeChars(cc);
            }
            return cc.toString();
        }
        return location;
    }

    public static String filter(String message) {
        if (message == null) {
            return null;
        }
        char[] content = new char[message.length()];
        message.getChars(0, message.length(), content, 0);
        StringBuilder result = new StringBuilder(content.length + 50);
        block6: for (int i = 0; i < content.length; ++i) {
            switch (content[i]) {
                case '<': {
                    result.append("&lt;");
                    continue block6;
                }
                case '>': {
                    result.append("&gt;");
                    continue block6;
                }
                case '&': {
                    result.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block6;
                }
                default: {
                    result.append(content[i]);
                }
            }
        }
        return result.toString();
    }

    protected String toEncoded(String url, String sessionId) {
        String jrouteId;
        StringBuilder sb;
        int pound;
        if (url == null || sessionId == null) {
            return url;
        }
        String path = url;
        String query = "";
        String anchor = "";
        int question = url.indexOf(63);
        if (question >= 0) {
            path = url.substring(0, question);
            query = url.substring(question);
        }
        if ((pound = path.indexOf(35)) >= 0) {
            anchor = path.substring(pound);
            path = path.substring(0, pound);
        }
        if ((sb = new StringBuilder(path)).length() > 0) {
            sb.append(";jsessionid=");
            sb.append(sessionId);
        }
        if ((jrouteId = this.request.getHeader("proxy-jroute")) != null) {
            sb.append(":");
            sb.append(jrouteId);
        }
        sb.append(anchor);
        sb.append(query);
        return sb.toString();
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public SuspendContext getSuspendContext() {
        return this.suspendedContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        SuspendState state;
        this.checkResponse();
        SuspendedContextImpl suspendedContextImpl = this.suspendedContext;
        synchronized (suspendedContextImpl) {
            state = this.suspendState;
        }
        return state == SuspendState.SUSPENDED || state == SuspendState.RESUMING || state == SuspendState.CANCELLING;
    }

    public void suspend() {
        this.suspend(-1L, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public void suspend(long timeout, TimeUnit timeunit) {
        this.suspend(timeout, timeunit, null);
    }

    public void suspend(long timeout, TimeUnit timeunit, CompletionHandler<Response> completionHandler) {
        this.suspend(timeout, timeunit, completionHandler, null);
    }

    public void suspend(long timeout, TimeUnit timeunit, CompletionHandler<Response> completionHandler, TimeoutHandler timeoutHandler) {
        this.checkResponse();
        if (this.suspendState != SuspendState.NONE) {
            throw new IllegalStateException("Already Suspended");
        }
        this.suspendState = SuspendState.SUSPENDED;
        this.suspendStatus.suspend();
        this.suspendedContext.init(completionHandler, timeoutHandler);
        HttpServerProbeNotifier.notifyRequestSuspend(this.request.httpServerFilter, this.ctx.getConnection(), this.request);
        this.httpContext.getCloseable().addCloseListener(this.suspendedContext.closeListener);
        if (timeout > 0L) {
            long timeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeunit);
            this.delayQueue.add(this.suspendedContext.suspendTimeout, timeoutMillis, TimeUnit.MILLISECONDS);
            this.suspendedContext.suspendTimeout.delayMillis = timeoutMillis;
        }
    }

    public void resume() {
        this.checkResponse();
        this.suspendedContext.markResumed();
        this.ctx.resume();
    }

    @Deprecated
    public void cancel() {
        this.checkResponse();
        this.suspendedContext.markCancelled();
        this.ctx.resume();
    }

    final void checkResponse() {
        if (this.response == null) {
            throw new IllegalStateException("Internal org.glassfish.grizzly.http.server.Response has not been set");
        }
    }

    public boolean isSendFileEnabled() {
        return this.sendFileEnabled;
    }

    private static class DelayQueueWorker
    implements DelayedExecutor.Worker<SuspendTimeout> {
        private DelayQueueWorker() {
        }

        @Override
        public boolean doWork(SuspendTimeout element) {
            return element.onTimeout();
        }
    }

    private static class DelayQueueResolver
    implements DelayedExecutor.Resolver<SuspendTimeout> {
        private DelayQueueResolver() {
        }

        @Override
        public boolean removeTimeout(SuspendTimeout element) {
            if (element.timeoutTimeMillis != -1L) {
                element.timeoutTimeMillis = -1L;
                return true;
            }
            return false;
        }

        @Override
        public long getTimeoutMillis(SuspendTimeout element) {
            return element.timeoutTimeMillis;
        }

        @Override
        public void setTimeoutMillis(SuspendTimeout element, long timeoutMillis) {
            element.timeoutTimeMillis = timeoutMillis;
        }
    }

    static enum SuspendState {
        NONE,
        SUSPENDED,
        RESUMING,
        RESUMED,
        CANCELLING,
        CANCELLED;

    }

    public final class SuspendedContextImpl
    implements SuspendContext {
        private int modCount;
        CompletionHandler<Response> completionHandler;
        SuspendTimeout suspendTimeout;
        private CloseListener closeListener;

        public synchronized boolean markResumed() {
            ++this.modCount;
            if (Response.this.suspendState != SuspendState.SUSPENDED) {
                if (Response.this.suspendState == SuspendState.CANCELLED || Response.this.suspendState == SuspendState.CANCELLING) {
                    return false;
                }
                throw new IllegalStateException("Not Suspended");
            }
            Response.this.suspendState = SuspendState.RESUMING;
            Response.this.httpContext.getCloseable().removeCloseListener(this.closeListener);
            if (this.completionHandler != null) {
                this.completionHandler.completed(Response.this);
            }
            this.reset();
            Response.this.suspendState = SuspendState.RESUMED;
            HttpServerProbeNotifier.notifyRequestResume(Response.this.request.httpServerFilter, Response.this.ctx.getConnection(), Response.this.request);
            return true;
        }

        protected synchronized boolean markCancelled(int expectedModCount) {
            if (this.modCount != expectedModCount) {
                return false;
            }
            ++this.modCount;
            if (Response.this.suspendState != SuspendState.SUSPENDED) {
                throw new IllegalStateException("Not Suspended");
            }
            Response.this.suspendState = SuspendState.CANCELLING;
            Response.this.httpContext.getCloseable().removeCloseListener(this.closeListener);
            if (this.completionHandler != null) {
                this.completionHandler.cancelled();
            }
            Response.this.suspendState = SuspendState.CANCELLED;
            this.reset();
            HttpServerProbeNotifier.notifyRequestCancel(Response.this.request.httpServerFilter, Response.this.ctx.getConnection(), Response.this.request);
            InputBuffer inputBuffer = Response.this.request.getInputBuffer();
            if (!inputBuffer.isFinished()) {
                inputBuffer.terminate();
            }
            return true;
        }

        @Deprecated
        public synchronized void markCancelled() {
            this.markCancelled(this.modCount);
        }

        private void init(CompletionHandler<Response> completionHandler, TimeoutHandler timeoutHandler) {
            this.completionHandler = completionHandler;
            this.suspendTimeout = new SuspendTimeout(this.modCount, timeoutHandler);
            this.closeListener = new SuspendCloseListener(this.modCount);
        }

        void reset() {
            this.suspendTimeout.reset();
            this.suspendTimeout = null;
            this.completionHandler = null;
            this.closeListener = null;
        }

        @Override
        public CompletionHandler<Response> getCompletionHandler() {
            return this.completionHandler;
        }

        @Override
        public TimeoutHandler getTimeoutHandler() {
            return this.suspendTimeout.timeoutHandler;
        }

        @Override
        public long getTimeout(TimeUnit timeunit) {
            return this.suspendTimeout.getTimeout(timeunit);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTimeout(long timeout, TimeUnit timeunit) {
            SuspendedContextImpl suspendedContextImpl = Response.this.suspendedContext;
            synchronized (suspendedContextImpl) {
                if (Response.this.suspendState != SuspendState.SUSPENDED || this.suspendTimeout == null) {
                    return;
                }
                this.suspendTimeout.setTimeout(timeout, timeunit);
            }
        }

        @Override
        public boolean isSuspended() {
            return Response.this.isSuspended();
        }

        public SuspendStatus getSuspendStatus() {
            return Response.this.suspendStatus;
        }

        private class SuspendCloseListener
        implements GenericCloseListener {
            private final int expectedModCount;

            public SuspendCloseListener(int expectedModCount) {
                this.expectedModCount = expectedModCount;
            }

            @Override
            public void onClosed(Closeable connection, CloseType closeType) throws IOException {
                Response.this.checkResponse();
                if (Response.this.suspendedContext.markCancelled(this.expectedModCount)) {
                    Response.this.ctx.completeAndRelease();
                }
            }
        }
    }

    protected class SuspendTimeout {
        private final int expectedModCount;
        TimeoutHandler timeoutHandler;
        long delayMillis;
        volatile long timeoutTimeMillis;

        private SuspendTimeout(int modCount, TimeoutHandler timeoutHandler) {
            this.expectedModCount = modCount;
            this.timeoutHandler = timeoutHandler;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean onTimeout() {
            this.timeoutTimeMillis = -1L;
            TimeoutHandler localTimeoutHandler = this.timeoutHandler;
            if (localTimeoutHandler != null && !localTimeoutHandler.onTimeout(Response.this)) return false;
            HttpServerProbeNotifier.notifyRequestTimeout(Response.this.request.httpServerFilter, Response.this.ctx.getConnection(), Response.this.request);
            try {
                Response.this.checkResponse();
                if (!Response.this.suspendedContext.markCancelled(this.expectedModCount)) return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }

        private long getTimeout(TimeUnit timeunit) {
            if (this.delayMillis > 0L) {
                return timeunit.convert(this.delayMillis, TimeUnit.MILLISECONDS);
            }
            return this.delayMillis;
        }

        private void setTimeout(long timeout, TimeUnit timeunit) {
            this.delayMillis = timeout > 0L ? TimeUnit.MILLISECONDS.convert(timeout, timeunit) : -1L;
            Response.this.delayQueue.add(this, this.delayMillis, TimeUnit.MILLISECONDS);
        }

        private void reset() {
            this.timeoutTimeMillis = -1L;
            this.timeoutHandler = null;
        }
    }
}

