/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.mail.annotation.handler;

import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.mail.MailSessionDefinition;
import jakarta.mail.MailSessionDefinitions;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.resources.mail.annotation.handler.MailSessionDefinitionHandler;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=MailSessionDefinitions.class)
public class MailSessionDefinitionsHandler
extends AbstractResourceHandler {
    private static final LocalStringManagerImpl I18N = new LocalStringManagerImpl(MailSessionDefinitionsHandler.class);

    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        MailSessionDefinitions defns = (MailSessionDefinitions)ainfo.getAnnotation();
        MailSessionDefinition[] values = defns.value();
        HashSet<String> duplicates = new HashSet<String>();
        if (values != null && values.length > 0) {
            for (MailSessionDefinition defn : values) {
                String defnName = ResourceDescriptor.getJavaComponentJndiName((String)defn.name());
                if (duplicates.contains(defnName)) {
                    String localString = I18N.getLocalString("enterprise.deployment.annotation.handlers.mailsessiondefinitionsduplicates", "@MailSessionDefinitions cannot have multiple definitions with same name : ''{0}''", new Object[]{defnName});
                    throw new IllegalStateException(localString);
                }
                duplicates.add(defnName);
                MailSessionDefinitionHandler handler = new MailSessionDefinitionHandler();
                handler.processAnnotation(defn, ainfo, rcContexts);
            }
            duplicates.clear();
        }
        return this.getDefaultProcessedResult();
    }

    public Class<? extends Annotation>[] getTypeDependencies() {
        return this.getEjbAndWebAnnotationTypes();
    }
}

