# ventas-devtools

Devtools for ventas. Meant to be used for ventas "core" development but also for developing plugins, themes, etc.

__You shouldn't be using this directly.__ This is a dependency of ventas (in the dev profile), and of the projects generated with the leiningen template.

The only namespace meant to be used is `ventas-devtools.repl`, which is summarized below:

- `init`

  Starts ventas. This should be used whenever starting a development session.
  
- `r`

  Reloads the backend namespaces that have changed, and restarts whatever states need to be restarted.
  Accepts any number of arguments representing states you wish to refresh no matter what.
  List of possible arguments:
  - `figwheel`
  - `sass`
  - `db`
  - `indexer`
  - `server`
  - `config`
  - `kafka`
  
- `set-theme!`
 
  Sets the theme to be used for Figwheel

- `cljs-repl`
  
  Starts a CLJS REPL connected to the browser.
  
- `init-aliases`

  (Already called when using `init` or `r`)
  Aliases common ventas namespaces such as `ventas.database.entity => entity`
  Useful when you change to whatever namespace, go back to `repl`, and want your aliases back.

- `reset`

  Like `r` but does a hard reset (unmounts all states and mounts them again)
  
- `run-tests`

  Runs the ventas tests
  

  
  