/*
 * Decompiled with CFR 0.152.
 */
package io.riemann.dropwizard;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.hibernate.validator.constraints.NotEmpty;

public class RiemannDropwizardConfig {
    @NotEmpty
    private String host;
    private int port = 5556;
    @NotEmpty
    private String prefix;
    @Max(value=3600L)
    @Min(value=10L)
    private int pollingInterval = 30;
    private List<String> tags = Collections.emptyList();

    public static RiemannDropwizardConfigBuilder builder() {
        return new RiemannDropwizardConfigBuilder();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setPollingInterval(int pollingInterval) {
        this.pollingInterval = pollingInterval;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RiemannDropwizardConfig)) {
            return false;
        }
        RiemannDropwizardConfig other = (RiemannDropwizardConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        String this$prefix = this.getPrefix();
        String other$prefix = other.getPrefix();
        if (this$prefix == null ? other$prefix != null : !this$prefix.equals(other$prefix)) {
            return false;
        }
        if (this.getPollingInterval() != other.getPollingInterval()) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RiemannDropwizardConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        result = result * 59 + this.getPort();
        String $prefix = this.getPrefix();
        result = result * 59 + ($prefix == null ? 43 : $prefix.hashCode());
        result = result * 59 + this.getPollingInterval();
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    public String toString() {
        return "RiemannDropwizardConfig(host=" + this.getHost() + ", port=" + this.getPort() + ", prefix=" + this.getPrefix() + ", pollingInterval=" + this.getPollingInterval() + ", tags=" + this.getTags() + ")";
    }

    @ConstructorProperties(value={"host", "port", "prefix", "pollingInterval", "tags"})
    public RiemannDropwizardConfig(String host, int port, String prefix, int pollingInterval, List<String> tags) {
        this.host = host;
        this.port = port;
        this.prefix = prefix;
        this.pollingInterval = pollingInterval;
        this.tags = tags;
    }

    public RiemannDropwizardConfig() {
    }

    public static class RiemannDropwizardConfigBuilder {
        private String host;
        private int port;
        private String prefix;
        private int pollingInterval;
        private ArrayList<String> tags;

        RiemannDropwizardConfigBuilder() {
        }

        public RiemannDropwizardConfigBuilder host(String host) {
            this.host = host;
            return this;
        }

        public RiemannDropwizardConfigBuilder port(int port) {
            this.port = port;
            return this;
        }

        public RiemannDropwizardConfigBuilder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public RiemannDropwizardConfigBuilder pollingInterval(int pollingInterval) {
            this.pollingInterval = pollingInterval;
            return this;
        }

        public RiemannDropwizardConfigBuilder tag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.add(tag);
            return this;
        }

        public RiemannDropwizardConfigBuilder tags(Collection<? extends String> tags) {
            if (this.tags == null) {
                this.tags = new ArrayList();
            }
            this.tags.addAll(tags);
            return this;
        }

        public RiemannDropwizardConfigBuilder clearTags() {
            if (this.tags != null) {
                this.tags.clear();
            }
            return this;
        }

        public RiemannDropwizardConfig build() {
            List<String> tags;
            switch (this.tags == null ? 0 : this.tags.size()) {
                case 0: {
                    tags = Collections.emptyList();
                    break;
                }
                case 1: {
                    tags = Collections.singletonList(this.tags.get(0));
                    break;
                }
                default: {
                    tags = Collections.unmodifiableList(new ArrayList<String>(this.tags));
                }
            }
            return new RiemannDropwizardConfig(this.host, this.port, this.prefix, this.pollingInterval, tags);
        }

        public String toString() {
            return "RiemannDropwizardConfig.RiemannDropwizardConfigBuilder(host=" + this.host + ", port=" + this.port + ", prefix=" + this.prefix + ", pollingInterval=" + this.pollingInterval + ", tags=" + this.tags + ")";
        }
    }
}

