#!/bin/sh
set -e

PREFIX=${PREFIX:-/opt/{{name}}}

stop_and_disable_systemd_service_maybe() {
	service="$1"
	if [ -e /etc/systemd/system/${service}.service ]; then
		systemctl disable "$service" || true
		if systemctl -q is-active "$service"; then
			systemctl stop "$service" || true
		fi
	fi
}

cd /

# stop_and_disable_systemd_service_maybe {{name}}

if [ -d "$PREFIX" ]; then
	find "$PREFIX" -regex '^.*\(__pycache__\|\.py[co]\)$' -delete || true
	rmdir --ignore-fail-on-non-empty "$PREFIX" || true
fi
