# python

[![Clojars Project](https://img.shields.io/clojars/v/python/lein-template.svg)](https://clojars.org/python/lein-template)

A Leiningen template for standard python project.

Features:

 * auto bootstrap virtualenv, only python is needed
 * auto generated setup.py file
 * integrated pylint, pycodestyle, pytest for testing
 * integrated [wells](https://pypi.org/project/wells/) utility lib.
   * support reading application configs from environment variable and config files
   * integrated logging configuration
 * auto create deb package for distribution
   * create offline wheelhouse for fast production release
 * ready to be deployed via docker and kubernetes
 * auto create git repo, with .gitignore file
 * allow you to install git hooks easily

## Usage

This project is tested and works in debian based system. CentOS is not tested and may not run well.

[Install lein](https://leiningen.org/#install) if you don't have it already.

To create a new python project in a new dir `foo`, run

    lein new python foo

To run tests in the new project:

    cd foo
    make test

Check README-dev.rst in the generated project for more information on usage.

Dependencies for the generated python project:

    make - used as a build tool.
    fpm - used to create deb package.


## License

Copyright © 2014-2019 Yuanle Song <sylecn@gmail.com>

This project is licensed under the Apache License 2.0.
