(ns prisma.plugins.manager
  (:require [prisma.plugins.funnel :as funnel]
            [prisma.plugins :as plugins]))


(def registered-plugins (atom {}))

(defn ^:export register-plugin
  ([new-plugin]
   (register-plugin "global" new-plugin))
  ([company-name new-plugin]
   (swap! registered-plugins update-in [company-name]
          (fn [plugins]
            (->> plugins
                 ;;if plugin was already loaded for company, overwrite it
                 (filter (fn [p]
                           (not= (plugins/plugin-id p)
                                 (plugins/plugin-id new-plugin))))
                 (cons new-plugin))))))


(defn ^:export get-plugins
  ([]
   (get-plugins nil))
  ([company]
   (let [plugins @registered-plugins]
     (concat (get plugins "global")
             (get plugins company)))))

(defn reset-plugins
  []
  (reset! registered-plugins {}))


(defn get-funnel-plugin
  ([step-type]
   (get-funnel-plugin nil step-type))
  ([company step-type]
   (->> (get-plugins company)
        (filter (fn [plugin]
                  (satisfies? funnel/IFunnel plugin)))
        (filter #(= step-type (funnel/funnel-type %)))
        first)))
