/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.remoting.cli.examples;

import java.util.ArrayList;
import org.rhq.core.domain.criteria.ResourceCriteria;
import org.rhq.core.domain.resource.InventoryStatus;
import org.rhq.core.domain.resource.Resource;
import org.rhq.core.domain.resource.group.ResourceGroup;
import org.rhq.core.domain.util.PageList;
import org.rhq.enterprise.clientapi.RemoteClient;

public class ResourceDiscovery {
    private final RemoteClient client;

    public ResourceDiscovery(RemoteClient client) {
        this.client = client;
    }

    public Resource[] discoveryQueue() {
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterInventoryStatus(InventoryStatus.NEW);
        PageList list = this.client.getResourceManager().findResourcesByCriteria(this.client.getSubject(), criteria);
        return list.getValues().toArray(new Resource[0]);
    }

    public void importAllResources() {
        Resource[] resources = this.discoveryQueue();
        int[] ids = new int[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            ids[i] = resources[i].getId();
        }
        this.client.getDiscoveryBoss().importResources(this.client.getSubject(), ids);
    }

    public void importResources(Resource[] resources) {
        if (resources.length == 0) {
            return;
        }
        Integer[] ids = new Integer[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            ids[i] = resources[i].getId();
        }
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterInventoryStatus(InventoryStatus.NEW);
        criteria.fetchParentResource(true);
        criteria.addFilterIds(ids);
        ArrayList<Integer> importIds = new ArrayList<Integer>();
        PageList list = this.client.getResourceManager().findResourcesByCriteria(this.client.getSubject(), criteria);
        if (list.isEmpty()) {
            return;
        }
        for (Resource resource : list.getValues()) {
            Resource parent = resource.getParentResource();
            if (parent != null && parent.getInventoryStatus() == InventoryStatus.NEW && !importIds.contains(parent.getId())) {
                importIds.add(parent.getId());
            }
            importIds.add(resource.getId());
        }
        int[] submitIds = new int[importIds.size()];
        for (int i = 0; i < importIds.size(); ++i) {
            submitIds[i] = (Integer)importIds.get(i);
        }
        this.client.getDiscoveryBoss().importResources(this.client.getSubject(), submitIds);
    }

    public Resource[] findResources(String resourceTypeName) {
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.setStrict(true);
        criteria.addFilterInventoryStatus(InventoryStatus.COMMITTED);
        criteria.addFilterResourceTypeName(resourceTypeName);
        PageList resources = this.client.getResourceManager().findResourcesByCriteria(this.client.getSubject(), criteria);
        return (Resource[])resources.toArray((Object[])new Resource[0]);
    }

    public Resource[] findResources(Integer ... ids) {
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterInventoryStatus(InventoryStatus.COMMITTED);
        criteria.addFilterIds(ids);
        PageList resources = this.client.getResourceManager().findResourcesByCriteria(this.client.getSubject(), criteria);
        return (Resource[])resources.toArray((Object[])new Resource[0]);
    }

    public Resource[] findResourcesForGroup(ResourceGroup group) {
        ResourceCriteria criteria = new ResourceCriteria();
        criteria.addFilterInventoryStatus(InventoryStatus.COMMITTED);
        criteria.addFilterExplicitGroupIds(new Integer[]{group.getId()});
        PageList resources = this.client.getResourceManager().findResourcesByCriteria(this.client.getSubject(), criteria);
        return (Resource[])resources.toArray((Object[])new Resource[0]);
    }
}

