/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.api;

public class DataSource {
    public static final int TYPE_COUNTER = 0;
    public static final int TYPE_GAUGE = 1;
    public static final int TYPE_DERIVE = 2;
    public static final int TYPE_ABSOLUTE = 3;
    static final String COUNTER = "COUNTER";
    static final String GAUGE = "GAUGE";
    static final String DERIVE = "DERIVE";
    static final String ABSOLUTE = "ABSOLUTE";
    static final String NAN = "U";
    private static final String[] TYPES = new String[]{"COUNTER", "GAUGE", "DERIVE", "ABSOLUTE"};
    String _name;
    int _type;
    double _min;
    double _max;

    public DataSource(String string, int n, double d, double d2) {
        this._name = string;
        this._type = 1;
        if (n == 0) {
            this._type = 0;
        } else if (n == 2) {
            this._type = 2;
        } else if (n == 3) {
            this._type = 3;
        }
        this._min = d;
        this._max = d2;
    }

    private DataSource() {
        this._type = 1;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public int getType() {
        return this._type;
    }

    public void setType(int n) {
        this._type = n;
    }

    public double getMin() {
        return this._min;
    }

    public void setMin(double d) {
        this._min = d;
    }

    public double getMax() {
        return this._max;
    }

    public void setMax(double d) {
        this._max = d;
    }

    static double toDouble(String string) {
        if (string.equals(NAN)) {
            return Double.NaN;
        }
        return Double.parseDouble(string);
    }

    private String asString(double d) {
        if (Double.isNaN(d)) {
            return NAN;
        }
        return String.valueOf(d);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._name).append(':');
        stringBuffer.append(TYPES[this._type]).append(':');
        stringBuffer.append(this.asString(this._min)).append(':');
        stringBuffer.append(this.asString(this._max));
        return stringBuffer.toString();
    }

    public static DataSource parseDataSource(String string) {
        String[] stringArray;
        int n = string.length();
        DataSource dataSource = new DataSource();
        if (string.charAt(n - 1) == ',') {
            string = string.substring(0, n - 1);
        }
        if ((stringArray = string.split(":")).length != 4) {
            return null;
        }
        dataSource._name = stringArray[0];
        dataSource._type = stringArray[1].equals(GAUGE) ? 1 : 0;
        dataSource._min = DataSource.toDouble(stringArray[2]);
        dataSource._max = DataSource.toDouble(stringArray[3]);
        return dataSource;
    }
}

