/*
 * Decompiled with CFR 0.152.
 */
package org.collectd.api;

import java.util.ArrayList;
import java.util.List;
import org.collectd.api.DataSource;

public class DataSet {
    private String _type;
    private List<DataSource> _ds;

    private DataSet() {
        this._type = null;
        this._ds = new ArrayList<DataSource>();
    }

    public DataSet(String string) {
        this._type = string;
        this._ds = new ArrayList<DataSource>();
    }

    public DataSet(String string, DataSource dataSource) {
        this._type = string;
        this._ds = new ArrayList<DataSource>();
        this._ds.add(dataSource);
    }

    public DataSet(String string, List<DataSource> list) {
        this._type = string;
        this._ds = list;
    }

    public void setType(String string) {
        this._type = string;
    }

    public String getType() {
        return this._type;
    }

    public void addDataSource(DataSource dataSource) {
        this._ds.add(dataSource);
    }

    public List<DataSource> getDataSources() {
        return this._ds;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._type);
        for (int i = 0; i < this._ds.size(); ++i) {
            if (i == 0) {
                stringBuffer.append("\t");
            } else {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this._ds.get(i).toString());
        }
        return stringBuffer.toString();
    }

    public static DataSet parseDataSet(String string) {
        DataSource dataSource;
        int n;
        DataSet dataSet = new DataSet();
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        if (string.charAt(0) == '#') {
            return null;
        }
        String[] stringArray = string.split("\\s+");
        if (stringArray.length < 2) {
            return null;
        }
        dataSet._type = stringArray[0];
        for (n = 1; n < stringArray.length && (dataSource = DataSource.parseDataSource(stringArray[n])) != null; ++n) {
            dataSet._ds.add(dataSource);
        }
        if (n < stringArray.length) {
            return null;
        }
        return dataSet;
    }
}

