/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database;

import com.systinet.uddi.database.DatabaseCoreBundle;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.DefaultQuoter;
import com.systinet.uddi.database.Quoter;

public class QuoterManager
implements Quoter {
    private Quoter quoteDriver = null;
    private boolean initialized = false;
    private int errorCode;
    private String errorMessage;

    public void init(String quoterClassName) throws DatabaseCoreException {
        this.initialized = false;
        if (quoterClassName == null) {
            this.quoteDriver = new DefaultQuoter();
        } else {
            try {
                this.quoteDriver = (Quoter)Class.forName(quoterClassName).newInstance();
            }
            catch (ClassNotFoundException e) {
                this.errorCode = 12051;
                this.errorMessage = DatabaseCoreBundle.getString("ERROR_12051_ComponentNotFound_P1", quoterClassName);
                throw new DatabaseCoreException(this.errorCode, this.errorMessage, e);
            }
            catch (InstantiationException e) {
                this.errorCode = 12052;
                this.errorMessage = DatabaseCoreBundle.getString("ERROR_12052_ComponentInstantiation_P1", quoterClassName);
                throw new DatabaseCoreException(this.errorCode, this.errorMessage, e);
            }
            catch (IllegalAccessException e) {
                this.errorCode = 12053;
                this.errorMessage = DatabaseCoreBundle.getString("ERROR_12053_ComponentIllegalAccess_P1", quoterClassName);
                throw new DatabaseCoreException(this.errorCode, this.errorMessage, e);
            }
        }
        this.initialized = true;
    }

    public String quote(String s, boolean unicode) throws DatabaseCoreException {
        if (!this.initialized) {
            throw new DatabaseCoreException(this.errorCode, this.errorMessage);
        }
        return this.quoteDriver.quote(s, unicode);
    }
}

