/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database;

import com.idoox.debug.Category;
import com.systinet.uddi.database.DatabaseCoreBundle;
import com.systinet.uddi.database.DatabaseCoreException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

class CheckStatements {
    private HashMap hm;
    private int maxStatements = 0;
    private static Category log = Category.getCategory((String)"database_core.com.systinet.uddi.database.CheckStatements");
    private boolean check = true;

    public CheckStatements() {
        this.hm = new HashMap();
    }

    public void addStatement(Statement stmt) {
        if (this.check) {
            DatabaseCoreException e = new DatabaseCoreException(12061, DatabaseCoreBundle.getString("ERROR_12061_UnclosedStatement"));
            if (this.hm.containsKey(stmt)) {
                log.debug("Statement " + stmt + " already exists in database.");
            } else {
                this.hm.put(stmt, e);
                if (this.maxStatements < this.hm.size()) {
                    this.maxStatements = this.hm.size();
                    log.debug("Maximum concurrent opened statements: " + this.maxStatements);
                }
            }
        }
    }

    public void removeStatement(Statement stmt) {
        Exception e;
        if (this.check && (e = (Exception)this.hm.remove(stmt)) == null) {
            log.debug("STATEMENT WAS NOT FOUND IN THE REGISTRY.");
        }
    }

    public void checkUnclosedStatements() throws DatabaseCoreException {
        if (this.check) {
            if (this.hm.isEmpty()) {
                log.debug("OK. No statements unclosed.");
            } else {
                Set set = this.hm.keySet();
                Iterator iter = set.iterator();
                if (iter.hasNext()) {
                    Statement stmt = (Statement)iter.next();
                    Exception e = (Exception)this.hm.get(stmt);
                    String message = DatabaseCoreBundle.getString("ERROR_12035_StatementNotFound");
                    log.error(message, (Throwable)e);
                    throw new DatabaseCoreException(12035, message, e);
                }
                this.hm.clear();
            }
        }
    }
}

