/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence.query;

import com.systinet.persistence.query.PersistentField;
import com.systinet.persistence.query.PersistentFieldCollection;
import com.systinet.persistence.query.PersistentFieldFilter;
import java.lang.reflect.Field;

public final class PersistentFieldFilterImpl {
    public static final PersistentFieldFilter ACCEPT_ALL = new AcceptAllFilter();
    public static final PersistentFieldFilter DECLINE_ALL = new DeclineAllFilter();

    public static PersistentFieldFilter getPositiveFilter(PersistentFieldCollection pfs) {
        return new PositiveFilter(pfs);
    }

    public static PersistentFieldFilter getPositiveFilter(Class clazz, String[] fieldNames) {
        return PersistentFieldFilterImpl.getPositiveFilter(new PersistentFieldCollection(clazz, fieldNames));
    }

    public static PersistentFieldFilter getNegativeFilter(PersistentFieldCollection pfs) {
        return new NegativeFilter(pfs);
    }

    public static PersistentFieldFilter getNegativeFilter(Class clazz, String[] fieldNames) {
        return PersistentFieldFilterImpl.getNegativeFilter(new PersistentFieldCollection(clazz, fieldNames));
    }

    private PersistentFieldFilterImpl() {
    }

    private static class DeclineAllFilter
    implements PersistentFieldFilter {
        private DeclineAllFilter() {
        }

        public boolean checkField(PersistentField persField) {
            return false;
        }

        public boolean checkField(Field field) {
            return false;
        }

        public boolean checkField(Class clazz, String fieldName) {
            return false;
        }
    }

    private static class AcceptAllFilter
    implements PersistentFieldFilter {
        private AcceptAllFilter() {
        }

        public boolean checkField(PersistentField persField) {
            return true;
        }

        public boolean checkField(Field field) {
            return true;
        }

        public boolean checkField(Class clazz, String fieldName) {
            return true;
        }
    }

    private static class NegativeFilter
    implements PersistentFieldFilter {
        private PersistentFieldCollection pfs;

        NegativeFilter(PersistentFieldCollection pfs) {
            this.pfs = pfs;
        }

        public boolean checkField(PersistentField persField) {
            return !this.pfs.contains(persField);
        }

        public boolean checkField(Field field) {
            return !this.pfs.contains(field);
        }

        public boolean checkField(Class clazz, String fieldName) {
            return !this.pfs.contains(clazz, fieldName);
        }
    }

    private static class PositiveFilter
    implements PersistentFieldFilter {
        private PersistentFieldCollection pfs;

        PositiveFilter(PersistentFieldCollection pfs) {
            this.pfs = pfs;
        }

        public boolean checkField(PersistentField persField) {
            return this.pfs.contains(persField);
        }

        public boolean checkField(Field field) {
            return this.pfs.contains(field);
        }

        public boolean checkField(Class clazz, String fieldName) {
            return this.pfs.contains(clazz, fieldName);
        }
    }
}

