/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence.query;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Expression {
    public Expression and(Expression rhs) {
        if (rhs == this) {
            return this;
        }
        return new LogicBinaryExpression(LogicBinaryOperator.AND, this, rhs);
    }

    public Expression or(Expression rhs) {
        if (rhs == this) {
            return this;
        }
        return new LogicBinaryExpression(LogicBinaryOperator.OR, this, rhs);
    }

    public Expression not() {
        return new LogicUnaryExpression(LogicUnaryOperator.NOT, this);
    }

    abstract String toSql();

    public String toString() {
        return this.toSql();
    }

    abstract PreparedSql toPreparedSql();

    abstract Set usedClasses();

    static class PreparedSql {
        String sqlScript;
        List constants;

        PreparedSql(String sqlScript, List constants) {
            this.sqlScript = sqlScript;
            this.constants = constants;
        }

        public String toString() {
            return "SQL: \"" + this.sqlScript + "\", params=" + this.constants;
        }
    }

    private static class LogicUnaryExpression
    extends Expression {
        private LogicUnaryOperator operator;
        private Expression expr;

        public LogicUnaryExpression(LogicUnaryOperator operator, Expression expr) {
            this.operator = operator;
            this.expr = expr;
        }

        String toSql() {
            return this.operator + "(" + this.expr.toSql() + ")";
        }

        PreparedSql toPreparedSql() {
            PreparedSql eps = this.expr.toPreparedSql();
            return new PreparedSql(this.operator + "(" + eps.sqlScript + ")", eps.constants);
        }

        Set usedClasses() {
            return this.expr.usedClasses();
        }
    }

    private static class LogicBinaryExpression
    extends Expression {
        private LogicBinaryOperator operator;
        private Expression lhs;
        private Expression rhs;

        LogicBinaryExpression(LogicBinaryOperator operator, Expression lhs, Expression rhs) {
            this.operator = operator;
            this.lhs = lhs;
            this.rhs = rhs;
        }

        String toSql() {
            return "(" + this.lhs.toSql() + " " + this.operator + " " + this.rhs.toSql() + ")";
        }

        PreparedSql toPreparedSql() {
            PreparedSql lhsPSql = this.lhs.toPreparedSql();
            PreparedSql rhsPSql = this.rhs.toPreparedSql();
            int neededSize = lhsPSql.constants.size() + rhsPSql.constants.size();
            ArrayList resConsts = new ArrayList(neededSize);
            resConsts.addAll(lhsPSql.constants);
            resConsts.addAll(rhsPSql.constants);
            return new PreparedSql("(" + lhsPSql.sqlScript + " " + this.operator + " " + rhsPSql.sqlScript + ")", resConsts);
        }

        Set usedClasses() {
            Set lhsClasses = this.lhs.usedClasses();
            Set rhsClasses = this.rhs.usedClasses();
            int neededSize = lhsClasses.size() + rhsClasses.size();
            HashSet result = new HashSet(neededSize * 4 / 3 + 1);
            result.addAll(lhsClasses);
            result.addAll(rhsClasses);
            return result;
        }
    }

    static class LogicUnaryOperator {
        public static final LogicUnaryOperator NOT = new LogicUnaryOperator("NOT");
        private final String opName;

        private LogicUnaryOperator(String name) {
            this.opName = name;
        }

        public String toString() {
            return this.opName;
        }
    }

    static class LogicBinaryOperator {
        public static final LogicBinaryOperator AND = new LogicBinaryOperator("AND");
        public static final LogicBinaryOperator OR = new LogicBinaryOperator("OR");
        private final String opName;

        private LogicBinaryOperator(String name) {
            this.opName = name;
        }

        public String toString() {
            return this.opName;
        }
    }
}

