/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence.query;

import com.systinet.persistence.ClassParser;
import com.systinet.persistence.PersistenceDbCoreException;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.PersistenceManager;
import com.systinet.persistence.PersistenceSqlException;
import com.systinet.persistence.query.Expression;
import com.systinet.persistence.query.Query;
import com.systinet.uddi.database.ConnectionMonitor;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.TransactionManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;

public class DeleteQuery {
    private Expression condition;
    private Class usedClass;
    private Expression.PreparedSql prepSql;

    public DeleteQuery(Expression condition) {
        this.condition = condition;
        Set usedClasses = condition.usedClasses();
        if (usedClasses.size() != 1) {
            throw new IllegalArgumentException("Condition must use exactly 1 class");
        }
        this.usedClass = (Class)usedClasses.iterator().next();
        this.prepSql = this.toSql();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int execute() throws PersistenceException {
        try {
            PersistenceManager persMgr = PersistenceManager.getInstance();
            TransactionManager txMgr = persMgr.getDatabase().getTransactionManager();
            boolean ok = false;
            try {
                int affectedRows;
                block9: {
                    txMgr.beginReadWrite();
                    ConnectionMonitor conn = txMgr.getConnection();
                    PreparedStatement pstmt = null;
                    affectedRows = 0;
                    try {
                        pstmt = conn.prepareStatement(this.prepSql.sqlScript);
                        Query.setConstantsInPrepStmt(this.prepSql.constants, pstmt);
                        affectedRows = pstmt.executeUpdate();
                        Object var8_9 = null;
                        if (pstmt == null) break block9;
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (pstmt != null) {
                            conn.close(pstmt);
                        }
                        throw throwable;
                    }
                    conn.close(pstmt);
                }
                txMgr.commit();
                ok = true;
                int n = affectedRows;
                Object var10_13 = null;
                if (ok) return n;
                txMgr.rollback();
                return n;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                if (!ok) {
                    txMgr.rollback();
                }
                throw throwable;
            }
        }
        catch (DatabaseCoreException e) {
            throw new PersistenceDbCoreException(e);
        }
        catch (SQLException e) {
            throw new PersistenceSqlException(e);
        }
    }

    private Expression.PreparedSql toSql() {
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM ");
        sb.append(ClassParser.getTableNameFor(this.usedClass));
        sb.append(" WHERE ");
        Expression.PreparedSql prepSql = this.condition.toPreparedSql();
        List constants = prepSql.constants;
        sb.append(prepSql.sqlScript);
        return new Expression.PreparedSql(sb.toString(), constants);
    }

    public String toString() {
        return this.prepSql.toString();
    }
}

