/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database.oracle;

import com.idoox.debug.Category;
import com.systinet.uddi.database.ConfigurableDriver;
import com.systinet.uddi.database.DatabaseCoreBundle;
import com.systinet.uddi.database.DatabaseCoreException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;

public class Driver
extends ConfigurableDriver {
    private static Category log = Category.getCategory((String)"database_core.com.systinet.uddi.database.oracle.Driver");
    protected static final String jdbcDriverClassName = "oracle.jdbc.driver.OracleDriver";
    protected static final String jdbcDriverName = "oracle:thin";
    private static Object jdbcDriver = null;
    private static final String ORACLE_DUMMY_QUERY = "SELECT 1 FROM dual";

    public synchronized void init(String hostName, int port, String dbName, String user, String password) throws DatabaseCoreException {
        super.init(hostName, port, dbName, user, password);
        try {
            if (jdbcDriver == null) {
                jdbcDriver = Class.forName(jdbcDriverClassName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseCoreException(12001, DatabaseCoreBundle.getString("ERROR_12001_JdbcDriverNotFound_P2", new String[]{"Oracle", jdbcDriverClassName}), e);
        }
    }

    public Connection getConnection() throws SQLException {
        String connectionAddress = "jdbc:oracle:thin:@" + this.hostName + ":" + this.port + ":" + this.dbName;
        log.debug(connectionAddress + " user:" + this.user + " password:" + this.password);
        Properties properties = new Properties();
        ((Hashtable)properties).put("user", this.user);
        if (this.password != null) {
            ((Hashtable)properties).put("password", this.password);
        }
        ((Hashtable)properties).put("charSet", "UTF8");
        Connection conn = DriverManager.getConnection(connectionAddress, properties);
        return conn;
    }

    public String getDummyQuery() {
        return ORACLE_DUMMY_QUERY;
    }
}

