/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database;

import com.idoox.debug.Category;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class PreparedStatementCache {
    private static Category log = Category.getCategory((String)"database_core.com.systinet.uddi.database.PreparedStatementCache");
    private final int capacity;
    private int size;
    private Map connToPstmts;
    private Set usedPstmt;

    PreparedStatementCache(int capacity) {
        this.capacity = capacity;
        this.connToPstmts = new HashMap();
        this.usedPstmt = new HashSet();
        this.size = 0;
    }

    synchronized void destroy() {
        Iterator mapI = this.connToPstmts.values().iterator();
        while (mapI.hasNext()) {
            Map wrMap = (Map)mapI.next();
            Iterator wrI = wrMap.values().iterator();
            while (wrI.hasNext()) {
                PreparedStatementWrapper cwr = (PreparedStatementWrapper)wrI.next();
                try {
                    cwr.destroy();
                }
                catch (SQLException e) {
                    log.error("Cannot close prepared statement", (Throwable)e);
                }
            }
            wrMap.clear();
        }
        this.connToPstmts.clear();
        Iterator upstI = this.usedPstmt.iterator();
        while (upstI.hasNext()) {
            PreparedStatementWrapper cwr = (PreparedStatementWrapper)upstI.next();
            try {
                cwr.destroy();
            }
            catch (SQLException e) {
                log.error("Cannot close prepared statement", (Throwable)e);
            }
        }
        this.usedPstmt.clear();
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    synchronized PreparedStatement getPreparedStatement(Connection conn, String sql) throws SQLException {
        PreparedStatementWrapper pstmtWrapper = this.removePsmtmWrapper(conn, sql);
        if (pstmtWrapper == null) {
            PreparedStatement newPstmt = conn.prepareStatement(sql);
            pstmtWrapper = new PreparedStatementWrapper(conn, sql, newPstmt);
        }
        this.usedPstmt.add(pstmtWrapper);
        return pstmtWrapper;
    }

    synchronized void closeConnection(Connection conn) throws SQLException {
        Map toPstmts = (Map)this.connToPstmts.remove(conn);
        if (toPstmts == null) {
            return;
        }
        Iterator pstmtIter = toPstmts.values().iterator();
        while (pstmtIter.hasNext()) {
            PreparedStatementWrapper pstmtWrapper = (PreparedStatementWrapper)pstmtIter.next();
            pstmtWrapper.destroy();
        }
    }

    private synchronized void releasePrepareStatement(PreparedStatementWrapper pstmtWrapper) throws SQLException {
        this.usedPstmt.remove(pstmtWrapper);
        this.insertPstmtInfo(pstmtWrapper);
    }

    private void insertPstmtInfo(PreparedStatementWrapper pstmtWrapper) throws SQLException {
        if (pstmtWrapper.conn == null) {
            return;
        }
        if (pstmtWrapper.wrappedPstmt.getClass().getName().equals("oracle.jdbc.driver.T4CPreparedStatement")) {
            pstmtWrapper.destroy();
            return;
        }
        if (this.size < this.capacity) {
            ++this.size;
            HashMap<String, PreparedStatementWrapper> mapForConn = (HashMap<String, PreparedStatementWrapper>)this.connToPstmts.get(pstmtWrapper.conn);
            if (mapForConn == null) {
                mapForConn = new HashMap<String, PreparedStatementWrapper>();
                this.connToPstmts.put(pstmtWrapper.conn, mapForConn);
            }
            if (mapForConn.containsKey(pstmtWrapper.sql)) {
                pstmtWrapper.destroy();
            } else {
                mapForConn.put(pstmtWrapper.sql, pstmtWrapper);
            }
        } else {
            pstmtWrapper.destroy();
        }
    }

    private PreparedStatementWrapper removePsmtmWrapper(Connection forConn, String forSql) {
        Map mapForConn = (Map)this.connToPstmts.get(forConn);
        if (mapForConn == null) {
            return null;
        }
        return (PreparedStatementWrapper)mapForConn.remove(forSql);
    }

    private final class PreparedStatementWrapper
    implements PreparedStatement {
        private Connection conn;
        private String sql;
        private PreparedStatement wrappedPstmt;
        private ResultSet lastResultSet;
        private boolean resetMaxRows;

        PreparedStatementWrapper(Connection conn, String sql, PreparedStatement wrappedPstmt) {
            if (wrappedPstmt == null) {
                throw new NullPointerException("Parameter wrappedPstmt is null");
            }
            if (conn == null) {
                throw new NullPointerException("Parameter conn is null");
            }
            if (sql == null) {
                throw new NullPointerException("Parameter sql is null");
            }
            this.conn = conn;
            this.sql = sql;
            this.wrappedPstmt = wrappedPstmt;
            this.lastResultSet = null;
        }

        void destroy() throws SQLException {
            if (this.wrappedPstmt != null) {
                this.wrappedPstmt.close();
            }
            this.conn = null;
            this.sql = null;
            this.lastResultSet = null;
        }

        public ResultSet executeQuery() throws SQLException {
            this.lastResultSet = this.wrappedPstmt.executeQuery();
            return this.lastResultSet;
        }

        public int executeUpdate() throws SQLException {
            return this.wrappedPstmt.executeUpdate();
        }

        public void setNull(int parameterIndex, int sqlType) throws SQLException {
            this.wrappedPstmt.setNull(parameterIndex, sqlType);
        }

        public void setBoolean(int parameterIndex, boolean x) throws SQLException {
            this.wrappedPstmt.setBoolean(parameterIndex, x);
        }

        public void setByte(int parameterIndex, byte x) throws SQLException {
            this.wrappedPstmt.setByte(parameterIndex, x);
        }

        public void setShort(int parameterIndex, short x) throws SQLException {
            this.wrappedPstmt.setShort(parameterIndex, x);
        }

        public void setInt(int parameterIndex, int x) throws SQLException {
            this.wrappedPstmt.setInt(parameterIndex, x);
        }

        public void setLong(int parameterIndex, long x) throws SQLException {
            this.wrappedPstmt.setLong(parameterIndex, x);
        }

        public void setFloat(int parameterIndex, float x) throws SQLException {
            this.wrappedPstmt.setFloat(parameterIndex, x);
        }

        public void setDouble(int parameterIndex, double x) throws SQLException {
            this.wrappedPstmt.setDouble(parameterIndex, x);
        }

        public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
            this.wrappedPstmt.setBigDecimal(parameterIndex, x);
        }

        public void setString(int parameterIndex, String x) throws SQLException {
            this.wrappedPstmt.setString(parameterIndex, x);
        }

        public void setBytes(int parameterIndex, byte[] x) throws SQLException {
            this.wrappedPstmt.setBytes(parameterIndex, x);
        }

        public void setDate(int parameterIndex, Date x) throws SQLException {
            this.wrappedPstmt.setDate(parameterIndex, x);
        }

        public void setTime(int parameterIndex, Time x) throws SQLException {
            this.wrappedPstmt.setTime(parameterIndex, x);
        }

        public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
            this.wrappedPstmt.setTimestamp(parameterIndex, x);
        }

        public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
            this.wrappedPstmt.setAsciiStream(parameterIndex, x, length);
        }

        public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
            this.wrappedPstmt.setUnicodeStream(parameterIndex, x, length);
        }

        public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
            this.wrappedPstmt.setBinaryStream(parameterIndex, x, length);
        }

        public void clearParameters() throws SQLException {
            this.wrappedPstmt.clearParameters();
        }

        public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
            this.wrappedPstmt.setObject(parameterIndex, x, targetSqlType, scale);
        }

        public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
            this.wrappedPstmt.setObject(parameterIndex, x, targetSqlType);
        }

        public void setObject(int parameterIndex, Object x) throws SQLException {
            this.wrappedPstmt.setObject(parameterIndex, x);
        }

        public boolean execute() throws SQLException {
            return this.wrappedPstmt.execute();
        }

        public void addBatch() throws SQLException {
            this.wrappedPstmt.addBatch();
        }

        public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
            this.wrappedPstmt.setCharacterStream(parameterIndex, reader, length);
        }

        public void setRef(int i, Ref x) throws SQLException {
            this.wrappedPstmt.setRef(i, x);
        }

        public void setBlob(int i, Blob x) throws SQLException {
            this.wrappedPstmt.setBlob(i, x);
        }

        public void setClob(int i, Clob x) throws SQLException {
            this.wrappedPstmt.setClob(i, x);
        }

        public void setArray(int i, Array x) throws SQLException {
            this.wrappedPstmt.setArray(i, x);
        }

        public ResultSetMetaData getMetaData() throws SQLException {
            return this.wrappedPstmt.getMetaData();
        }

        public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
            this.wrappedPstmt.setDate(parameterIndex, x, cal);
        }

        public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
            this.wrappedPstmt.setTime(parameterIndex, x, cal);
        }

        public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
            this.wrappedPstmt.setTimestamp(parameterIndex, x, cal);
        }

        public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
            this.wrappedPstmt.setNull(paramIndex, sqlType, typeName);
        }

        public ResultSet executeQuery(String sql) throws SQLException {
            this.lastResultSet = this.wrappedPstmt.executeQuery(sql);
            return this.lastResultSet;
        }

        public int executeUpdate(String sql) throws SQLException {
            return this.wrappedPstmt.executeUpdate(sql);
        }

        public void close() throws SQLException {
            if (this.lastResultSet != null) {
                this.lastResultSet.close();
                this.lastResultSet = null;
            }
            if (this.resetMaxRows) {
                this.resetMaxRows = false;
                this.wrappedPstmt.setMaxRows(0);
            }
            this.clearParameters();
            PreparedStatementCache.this.releasePrepareStatement(this);
        }

        public int getMaxFieldSize() throws SQLException {
            return this.wrappedPstmt.getMaxFieldSize();
        }

        public void setMaxFieldSize(int max) throws SQLException {
            this.wrappedPstmt.setMaxFieldSize(max);
        }

        public int getMaxRows() throws SQLException {
            return this.wrappedPstmt.getMaxRows();
        }

        public void setMaxRows(int max) throws SQLException {
            this.resetMaxRows = true;
            this.wrappedPstmt.setMaxRows(max);
        }

        public void setEscapeProcessing(boolean enable) throws SQLException {
            this.wrappedPstmt.setEscapeProcessing(enable);
        }

        public int getQueryTimeout() throws SQLException {
            return this.wrappedPstmt.getQueryTimeout();
        }

        public void setQueryTimeout(int seconds) throws SQLException {
            this.wrappedPstmt.setQueryTimeout(seconds);
        }

        public void cancel() throws SQLException {
            this.wrappedPstmt.cancel();
        }

        public SQLWarning getWarnings() throws SQLException {
            return this.wrappedPstmt.getWarnings();
        }

        public void clearWarnings() throws SQLException {
            this.wrappedPstmt.clearWarnings();
        }

        public void setCursorName(String name) throws SQLException {
            this.wrappedPstmt.setCursorName(name);
        }

        public boolean execute(String sql) throws SQLException {
            return this.wrappedPstmt.execute(sql);
        }

        public ResultSet getResultSet() throws SQLException {
            this.lastResultSet = this.wrappedPstmt.getResultSet();
            return this.lastResultSet;
        }

        public int getUpdateCount() throws SQLException {
            return this.wrappedPstmt.getUpdateCount();
        }

        public boolean getMoreResults() throws SQLException {
            return this.wrappedPstmt.getMoreResults();
        }

        public void setFetchDirection(int direction) throws SQLException {
            this.wrappedPstmt.setFetchDirection(direction);
        }

        public int getFetchDirection() throws SQLException {
            return this.wrappedPstmt.getFetchDirection();
        }

        public void setFetchSize(int rows) throws SQLException {
            this.wrappedPstmt.setFetchSize(rows);
        }

        public int getFetchSize() throws SQLException {
            return this.wrappedPstmt.getFetchSize();
        }

        public int getResultSetConcurrency() throws SQLException {
            return this.wrappedPstmt.getResultSetConcurrency();
        }

        public int getResultSetType() throws SQLException {
            return this.wrappedPstmt.getResultSetType();
        }

        public void addBatch(String sql) throws SQLException {
            this.wrappedPstmt.addBatch(sql);
        }

        public void clearBatch() throws SQLException {
            this.wrappedPstmt.clearBatch();
        }

        public int[] executeBatch() throws SQLException {
            return this.wrappedPstmt.executeBatch();
        }

        public Connection getConnection() throws SQLException {
            throw new UnsupportedOperationException("getConnection is forbidden");
        }
    }
}

