/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database;

import com.idoox.debug.Category;
import com.systinet.uddi.database.ApiManager;
import com.systinet.uddi.database.ConnectionMonitor;
import com.systinet.uddi.database.Database;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.Quoter;
import com.systinet.uddi.database.TransactionManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseApi {
    private ApiManager apiManager;
    private TransactionManager tm;
    private Quoter qm;
    private static Category log = Category.getCategory((String)"database_core.com.systinet.uddi.database.DatabaseApi");

    public void init(ApiManager apiManager) throws DatabaseCoreException {
        this.apiManager = apiManager;
        Database database = apiManager.getDatabase();
        this.tm = database.getTransactionManager();
        this.qm = database.getQuoter();
    }

    protected ApiManager getApiManager() {
        return this.apiManager;
    }

    protected void beginReadOnly() throws DatabaseCoreException {
        this.tm.beginReadOnly();
    }

    protected void end() throws DatabaseCoreException {
        this.tm.end();
    }

    protected void beginReadWrite() throws DatabaseCoreException {
        this.tm.beginReadWrite();
    }

    protected void commit() throws SQLException, DatabaseCoreException {
        this.tm.commit();
    }

    protected void rollback() throws DatabaseCoreException {
        this.tm.rollback();
    }

    protected ConnectionMonitor getConnection() throws DatabaseCoreException {
        return this.tm.getConnection();
    }

    protected long getTransactionId() throws DatabaseCoreException {
        return this.tm.getTransactionId();
    }

    protected String quote(String s) throws DatabaseCoreException {
        return this.qm.quote(s, false);
    }

    protected String quote(String s, boolean unicode) throws DatabaseCoreException {
        return this.qm.quote(s, unicode);
    }

    protected void close(Statement stmt) throws DatabaseCoreException {
        try {
            if (stmt != null) {
                this.tm.getConnection().close(stmt);
            }
        }
        catch (SQLException e) {
            log.debug("CloseStatement()", (Throwable)e);
        }
    }

    protected String getString(ResultSet rs, int index) throws SQLException {
        String value = rs.getString(index);
        if (rs.wasNull()) {
            return null;
        }
        return value;
    }

    protected String getString(ResultSet rs, String columnName) throws SQLException {
        String value = rs.getString(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return value;
    }
}

