/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database;

import com.systinet.uddi.database.ConnectionInitializer;
import com.systinet.uddi.database.DatabaseCoreBundle;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.DefaultConnectionInitializer;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionInitializerManager
implements ConnectionInitializer {
    private ConnectionInitializer connectionInit = null;
    private boolean initialized = false;
    private int errorCode;
    private String errorMessage;

    public void init(String connectionInitializerClassName) throws DatabaseCoreException {
        this.initialized = false;
        if (connectionInitializerClassName == null) {
            this.connectionInit = new DefaultConnectionInitializer();
        } else {
            try {
                this.connectionInit = (ConnectionInitializer)Class.forName(connectionInitializerClassName).newInstance();
            }
            catch (ClassNotFoundException e) {
                this.errorCode = 12051;
                this.errorMessage = DatabaseCoreBundle.getString("ERROR_12051_ComponentNotFound_P1", connectionInitializerClassName);
                throw new DatabaseCoreException(this.errorCode, this.errorMessage, e);
            }
            catch (InstantiationException e) {
                this.errorCode = 12052;
                this.errorMessage = DatabaseCoreBundle.getString("ERROR_12052_ComponentInstantiation_P1", connectionInitializerClassName);
                throw new DatabaseCoreException(this.errorCode, this.errorMessage, e);
            }
            catch (IllegalAccessException e) {
                this.errorCode = 12053;
                this.errorMessage = DatabaseCoreBundle.getString("ERROR_12053_ComponentIllegalAccess_P1", connectionInitializerClassName);
                throw new DatabaseCoreException(this.errorCode, this.errorMessage, e);
            }
        }
        this.initialized = true;
    }

    public void initConnection(Connection connection) throws SQLException, DatabaseCoreException {
        if (!this.initialized) {
            throw new DatabaseCoreException(this.errorCode, this.errorMessage);
        }
        this.connectionInit.initConnection(connection);
    }
}

